/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import java.util.Iterator;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataLeaf;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;

class PageScanCursor
implements Cursor {
    private PageDataLeaf current;
    private int idx;
    private Row row;
    private final boolean multiVersion;
    private final Session session;
    private Iterator<Row> delta;

    PageScanCursor(Session session, PageDataLeaf pageDataLeaf, int n, boolean bl) {
        this.current = pageDataLeaf;
        this.idx = n;
        this.multiVersion = bl;
        this.session = session;
        if (bl) {
            this.delta = pageDataLeaf.index.getDelta();
        }
    }

    public Row get() {
        return this.row;
    }

    public int getPos() {
        return this.row.getPos();
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public boolean next() throws SQLException {
        if (!this.multiVersion) {
            return this.nextRow();
        }
        while (true) {
            if (this.delta != null) {
                if (!this.delta.hasNext()) {
                    this.delta = null;
                    this.row = null;
                    continue;
                }
                this.row = this.delta.next();
                if (this.row.isDeleted() && this.row.getSessionId() != this.session.getId()) break;
                continue;
            }
            this.nextRow();
            if (this.row == null || this.row.getSessionId() == 0 || this.row.getSessionId() == this.session.getId()) break;
        }
        return this.row != null;
    }

    private boolean nextRow() throws SQLException {
        if (this.idx >= this.current.getEntryCount()) {
            this.current = this.current.getNextPage();
            this.idx = 0;
            if (this.current == null) {
                this.row = null;
                return false;
            }
        }
        this.row = this.current.getRowAt(this.idx);
        ++this.idx;
        return true;
    }

    public boolean previous() {
        throw Message.throwInternalError();
    }
}

