/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.result.SearchRow;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;

public class Row
extends Record
implements SearchRow {
    public static final int MEMORY_CALCULATE = -1;
    private final Value[] data;
    private final int memory;
    private int version;

    public Row(Value[] valueArray, int n) {
        this.data = valueArray;
        this.memory = n;
    }

    public void setPosAndVersion(SearchRow searchRow) {
        this.setPos(searchRow.getPos());
        this.setVersion(searchRow.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public Value getValue(int n) {
        return this.data[n];
    }

    public void write(DataPage dataPage) throws SQLException {
        dataPage.writeInt(this.data.length);
        for (Value value : this.data) {
            dataPage.writeValue(value);
        }
    }

    public int getByteCount(DataPage dataPage) throws SQLException {
        int n = this.data.length;
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            Value value = this.data[i];
            n2 += dataPage.getValueLen(value);
        }
        return n2;
    }

    public void setValue(int n, Value value) {
        this.data[n] = value;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public int getMemorySize() {
        if (this.memory != -1) {
            return this.blockCount * 16 + this.memory * 4;
        }
        int n = this.blockCount * 8;
        for (int i = 0; this.data != null && i < this.data.length; ++i) {
            n += this.data[i].getMemory();
        }
        return n;
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("( /* pos:");
        statementBuilder.append(this.getPos());
        if (this.version != 0) {
            statementBuilder.append(" v:" + this.version);
        }
        if (this.isDeleted()) {
            statementBuilder.append(" deleted");
        }
        statementBuilder.append(" */ ");
        if (this.data != null) {
            for (Value value : this.data) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(value == null ? "null" : value.getTraceSQL());
            }
        }
        return statementBuilder.append(')').toString();
    }
}

