/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.attribute.number;

import org.odftoolkit.odfdom.OdfAttribute;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;

public class NumberDecimalPlacesAttribute
extends OdfAttribute {
    public static final OdfName ATTRIBUTE_NAME = OdfName.get(OdfNamespace.get(OdfNamespaceNames.NUMBER), "decimal-places");

    public NumberDecimalPlacesAttribute(OdfFileDom ownerDocument) {
        super(ownerDocument, ATTRIBUTE_NAME);
    }

    public OdfName getOdfName() {
        return ATTRIBUTE_NAME;
    }

    public String getName() {
        return ATTRIBUTE_NAME.getLocalName();
    }

    public void setIntValue(int value) {
        super.setValue(String.valueOf(value));
    }

    public int getIntValue() {
        String value = super.getValue();
        return Integer.parseInt(value);
    }

    public void setValue(String attrValue) {
        super.setValue(Integer.toString(Integer.parseInt(attrValue)));
    }

    public String getValue() {
        try {
            return String.valueOf(Integer.parseInt(super.getValue()));
        }
        catch (IllegalArgumentException e) {
            throw new NumberFormatException("the value of number:decimal-places is not valid");
        }
    }

    public String getDefault() {
        return null;
    }

    public boolean hasDefault() {
        return false;
    }

    public boolean isId() {
        return false;
    }
}

