/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.logging;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.firebirdsql.logging.Logger;

public class Log4jLogger
extends Logger {
    private static boolean loggingAvailable = true;
    private final Category log;

    protected Log4jLogger(String name) {
        if (loggingAvailable) {
            Category myLog = null;
            try {
                myLog = Category.getInstance((String)name);
            }
            catch (Throwable t) {
                loggingAvailable = false;
            }
            this.log = myLog;
        } else {
            this.log = null;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.DEBUG);
    }

    @Override
    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log.log(Priority.DEBUG, message);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.log.log(Priority.DEBUG, message, t);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.debug(message, t);
    }

    @Override
    public void trace(Object message) {
        this.debug(message);
    }

    @Override
    public boolean isInfoEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.INFO);
    }

    @Override
    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log.log(Priority.INFO, message);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.log.log(Priority.INFO, message, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.WARN);
    }

    @Override
    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.log.log(Priority.WARN, message);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.log.log(Priority.WARN, message, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.ERROR);
    }

    @Override
    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.log.log(Priority.ERROR, message);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.log.log(Priority.ERROR, message, t);
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return loggingAvailable && this.log.isEnabledFor(Priority.FATAL);
    }

    @Override
    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.log.log(Priority.FATAL, message);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.log.log(Priority.FATAL, message, t);
        }
    }
}

