/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;

public final class DocletSpecific {
    private static final String SELECT_PACKAGE = "org.opengion";
    private static final boolean NOT_PRIVATE = false;
    private static final String ENCODE = "UTF-8";
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String OG_REV = "og.rev";
    private static final String OG_GROUP = "og.group";
    private static final String DOC_VERSION = "version";
    private static final String DOC_AUTHOR = "author";
    private static final String DOC_SINCE = "since";
    private static final String DOC_PARAM = "param";
    private static final String DOC_RETURN = "return";
    private static final String CONSTRUCTOR = "\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf";
    private static final String METHOD = "\u30e1\u30bd\u30c3\u30c9";
    private static final Set<String> methodSet = new HashSet<String>();
    private static int debugLevel = 0;
    private static Pattern PTN = Pattern.compile("[\\w\\s]+");

    private DocletSpecific() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        String string3 = DocletUtil.getOption("-debugLevel", rootDoc.options());
        if (string3 != null) {
            debugLevel = Integer.parseInt(string3);
        }
        try (DocletTagWriter docletTagWriter = null;){
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <version>", string, "</version>");
            docletTagWriter.printTag("  <description></description>");
            DocletSpecific.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            String string = classDoc.name();
            String string2 = classDoc.qualifiedName();
            String string3 = (classDoc.modifiers() + (classDoc.isClass() ? " class" : "")).trim();
            Type type = classDoc.superclassType();
            String string4 = type == null ? "" : type.qualifiedTypeName();
            Type[] typeArray = classDoc.interfaceTypes();
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int j = 0; j < typeArray.length; ++j) {
                stringBuilder.append(typeArray[j].qualifiedTypeName()).append(",");
            }
            if (typeArray.length > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            String string5 = stringBuilder.toString();
            Tag[] tagArray = classDoc.firstSentenceTags();
            Tag[] tagArray2 = classDoc.inlineTags();
            Tag[] tagArray3 = classDoc.tags(OG_FOR_SMPL);
            Tag[] tagArray4 = classDoc.tags(OG_REV);
            Tag[] tagArray5 = classDoc.tags(DOC_VERSION);
            Tag[] tagArray6 = classDoc.tags(DOC_AUTHOR);
            Tag[] tagArray7 = classDoc.tags(DOC_SINCE);
            Tag[] tagArray8 = classDoc.tags(OG_GROUP);
            docletTagWriter.printTag("<classDoc>");
            docletTagWriter.printTag("  <fullName>", string2, "</fullName>");
            docletTagWriter.printTag("  <modifiers>", string3, "</modifiers>");
            docletTagWriter.printTag("  <className>", string, "</className>");
            docletTagWriter.printTag("  <superClass>", string4, "</superClass>");
            docletTagWriter.printTag("  <interface>", string5, "</interface>");
            docletTagWriter.printTag("  <createVer>", tagArray5, "</createVer>");
            docletTagWriter.printTag("  <author>", tagArray6, "</author>");
            docletTagWriter.printTag("  <since>", tagArray7, "</since>");
            docletTagWriter.printTag("  <description>", tagArray, "</description>");
            docletTagWriter.printTag("  <contents>", tagArray2, "</contents>");
            docletTagWriter.printTag("  <classGroup>");
            docletTagWriter.printCSVTag(tagArray8);
            docletTagWriter.printTag("</classGroup>");
            docletTagWriter.printTag("  <formSample>", tagArray3, "</formSample>");
            docletTagWriter.printTag("  <history>", tagArray4, "</history>");
            if (debugLevel >= 2 && (tagArray2.length == 0 || tagArray.length == 0) && string4.length() == 0) {
                System.err.println("\u8b66\u544a2:\u30b3\u30e1\u30f3\u30c8C=\t" + classDoc.position());
            }
            int n = 0;
            while (true) {
                ConstructorDoc[] constructorDocArray = classDoc.constructors(false);
                for (int j = 0; j < constructorDocArray.length; ++j) {
                    if (!DocletSpecific.isAction((ExecutableMemberDoc)constructorDocArray[j], n)) continue;
                    if (n < 2) {
                        DocletSpecific.checkTag((ExecutableMemberDoc)constructorDocArray[j]);
                    }
                    DocletSpecific.menberTag((ExecutableMemberDoc)constructorDocArray[j], CONSTRUCTOR, docletTagWriter, n);
                }
                MethodDoc[] methodDocArray = classDoc.methods(false);
                for (int j = 0; j < methodDocArray.length; ++j) {
                    if (!DocletSpecific.isAction((ExecutableMemberDoc)methodDocArray[j], n)) continue;
                    if (n < 2) {
                        DocletSpecific.checkTag((ExecutableMemberDoc)methodDocArray[j]);
                    }
                    DocletSpecific.menberTag((ExecutableMemberDoc)methodDocArray[j], METHOD, docletTagWriter, n);
                }
                Type type2 = classDoc.superclassType();
                if (type2 == null || "java.lang.Object".equals(string2 = (classDoc = type2.asClassDoc()).qualifiedName()) || classDoc.isEnum()) break;
                if (string2.startsWith(SELECT_PACKAGE)) {
                    n = 1;
                    continue;
                }
                n = 2;
            }
            docletTagWriter.printTag("  </classDoc>");
        }
    }

    private static boolean isAction(ExecutableMemberDoc executableMemberDoc, int n) {
        String string = executableMemberDoc.name();
        boolean bl = !methodSet.add(executableMemberDoc.toString()) || n > 0 && executableMemberDoc.isPrivate() || string.charAt(0) == '<';
        return !bl;
    }

    private static void checkTag(ExecutableMemberDoc executableMemberDoc) {
        String string;
        Tag[] tagArray;
        Object object;
        Tag[] tagArray2;
        Type type;
        String string2;
        Type type2 = executableMemberDoc.containingClass().superclassType();
        String string3 = string2 = type2 == null ? "" : type2.qualifiedTypeName();
        if ("java.lang.Enum".equals(string2)) {
            return;
        }
        SourcePosition sourcePosition = executableMemberDoc.position();
        String string4 = null;
        if (executableMemberDoc instanceof MethodDoc) {
            AnnotationDesc[] annotationDescArray;
            type = ((MethodDoc)executableMemberDoc).returnType();
            tagArray2 = type.typeName();
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(executableMemberDoc.modifiers()).append(" ").append((String)tagArray2);
            if (type.dimension() != null) {
                stringBuilder.append(type.dimension());
            }
            string4 = stringBuilder.toString();
            object = "=\t" + sourcePosition + "\t" + string4;
            tagArray = executableMemberDoc.tags(DOC_RETURN);
            if (tagArray.length > 0) {
                string = tagArray[0].text().trim();
                object = (String)object + "\t" + string;
                if (debugLevel >= 1 && "void".equals(tagArray2)) {
                    System.err.println("\u8b66\u544a1:RTN\u30b3\u30e1\u30f3\u30c8\u4e0d\u8981" + (String)object);
                }
                if (debugLevel >= 2 && PTN.matcher(string).matches()) {
                    System.err.println("\u8b66\u544a2:RTN\u672a\u89e3\u8aac" + (String)object);
                }
                if (debugLevel >= 2 && string.equals(tagArray2)) {
                    System.err.println("\u8b66\u544a2:RTN\u4e00\u81f4" + (String)object);
                }
                if (debugLevel >= 2 && (string.indexOf("[]") >= 0 || string.indexOf(60) >= 0)) {
                    System.err.println("\u8b66\u544a2:RTN\u914d\u5217" + (String)object);
                }
                if (debugLevel >= 3 && (string.indexOf((String)tagArray2 + " ") >= 0 || string.indexOf((String)tagArray2 + "\t") >= 0)) {
                    System.err.println("\u8b66\u544a3:RTN\u30bf\u30a4\u30d7" + (String)object);
                }
                int n = string.indexOf(32);
                if (debugLevel >= 3 && n > 0) {
                    boolean bl = true;
                    for (int i = 0; i < n; ++i) {
                        char c = string.charAt(i);
                        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '[' || c == ']') continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        System.err.println("\u8b66\u544a3:RTN\u5024" + (String)object);
                    }
                }
            } else if (debugLevel >= 1 && !"void".equals(tagArray2)) {
                System.err.println("\u8b66\u544a1:RTN\u30b3\u30e1\u30f3\u30c8\u306a\u3057" + (String)object);
            }
            string = ((MethodDoc)executableMemberDoc).overriddenMethod();
            if (debugLevel >= 3 && string != null && (annotationDescArray = executableMemberDoc.annotations()).length == 0) {
                System.err.println("\u8b66\u544a3:@Override\u306a\u3057" + (String)object);
            }
        }
        type = executableMemberDoc.parameters();
        tagArray2 = executableMemberDoc.tags(DOC_PARAM);
        if (debugLevel >= 1 && tagArray2.length != ((Type)type).length) {
            System.err.println("\u8b66\u544a1:PRM\u500b\u6570\u9055\u3044=\t" + sourcePosition);
        }
        for (int i = 0; i < ((Type)type).length; ++i) {
            object = type[i].type().typeName();
            tagArray = type[i].name();
            if (tagArray2.length <= i) continue;
            string = tagArray2[i].text().trim();
            String string5 = string.replaceAll((String)tagArray, "").trim();
            String string6 = string5.replaceAll((String)object, "").replaceAll("\\[\\]", "").trim();
            String string7 = "=\t" + sourcePosition + "\t" + string;
            if (debugLevel >= 1 && string.indexOf((String)tagArray) < 0) {
                System.err.println("\u8b66\u544a1:PRM\u5f15\u6570\u540d" + string7);
            }
            if (debugLevel >= 2 && tagArray.length() == 1) {
                System.err.println("\u8b66\u544a2:PRM\u77ed\u3044" + string7);
            }
            if (debugLevel >= 2 && (PTN.matcher(string5).matches() || string6.length() == 0)) {
                System.err.println("\u8b66\u544a2:PRM\u672a\u89e3\u8aac" + string7);
            }
            if (debugLevel >= 2 && (string.indexOf("[]") >= 0 || string.indexOf(60) >= 0)) {
                System.err.println("\u8b66\u544a2:PRM\u914d\u5217" + string7);
            }
            if (debugLevel < 3 || string5.indexOf((String)object + " ") < 0 && string5.indexOf((String)object + "\t") < 0) continue;
            System.err.println("\u8b66\u544a3:PRM\u30bf\u30a4\u30d7" + string7);
        }
        Tag[] tagArray3 = executableMemberDoc.firstSentenceTags();
        object = executableMemberDoc.inlineTags();
        if (!(((Tag[])object).length != 0 && tagArray3.length != 0 || !(executableMemberDoc instanceof MethodDoc) || executableMemberDoc.isSynthetic() || executableMemberDoc.isNative() || debugLevel < 2)) {
            System.err.println("\u8b66\u544a2:\u30b3\u30e1\u30f3\u30c8M=\t" + sourcePosition + "\t" + executableMemberDoc.name());
        }
    }

    private static void menberTag(ExecutableMemberDoc executableMemberDoc, String string, DocletTagWriter docletTagWriter, int n) {
        Tag[] tagArray;
        Tag[] tagArray2;
        String string2;
        StringBuilder stringBuilder;
        Object object;
        if (executableMemberDoc instanceof MethodDoc) {
            object = ((MethodDoc)executableMemberDoc).returnType();
            stringBuilder = new StringBuilder(200);
            stringBuilder.append(executableMemberDoc.modifiers());
            stringBuilder.append(" ").append(object.typeName());
            if (object.dimension() != null) {
                stringBuilder.append(object.dimension());
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = executableMemberDoc.modifiers();
        }
        object = executableMemberDoc.name();
        stringBuilder = new StringBuilder(200);
        stringBuilder.append((String)object).append("(");
        Parameter[] parameterArray = executableMemberDoc.parameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            tagArray2 = parameterArray[i].type();
            tagArray = parameterArray[i].name();
            stringBuilder.append(tagArray2.typeName()).append(tagArray2.dimension()).append(" ").append((String)tagArray).append(",");
        }
        if (parameterArray.length > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(")");
        String string3 = stringBuilder.toString();
        tagArray2 = executableMemberDoc.firstSentenceTags();
        tagArray = executableMemberDoc.inlineTags();
        Tag[] tagArray3 = executableMemberDoc.tags();
        Tag[] tagArray4 = executableMemberDoc.tags(OG_REV);
        String string4 = String.valueOf(n);
        String string5 = n == 0 ? "" : executableMemberDoc.containingClass().qualifiedName();
        String string6 = String.valueOf(executableMemberDoc.position().line());
        docletTagWriter.printTag("  <menber>");
        docletTagWriter.printTag("    <type>", string, "</type>");
        docletTagWriter.printTag(new String[]{"    <name>", object, "</name>"});
        docletTagWriter.printTag("    <modifiers>", string2, "</modifiers>");
        docletTagWriter.printTag("    <signature>", string3, "</signature>");
        docletTagWriter.printTag("    <position>", string6, "</position>");
        docletTagWriter.printTag("    <extendClass>", string5, "</extendClass>");
        docletTagWriter.printTag("    <extendFlag>", string4, "</extendFlag>");
        docletTagWriter.printTag("    <description>", tagArray2, "</description>");
        docletTagWriter.printTag("    <contents>", tagArray, "</contents>");
        docletTagWriter.printTag("    <tagText>");
        docletTagWriter.printTagsInfo(tagArray3);
        docletTagWriter.printTag("    </tagText>");
        docletTagWriter.printTag("    <history>", tagArray4, "</history>");
        docletTagWriter.printTag("  </menber>");
    }

    public static int optionLength(String string) {
        if (string.equalsIgnoreCase("-version")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-outfile")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-debugLevel")) {
            return 2;
        }
        return 0;
    }
}

