/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opengion.fukurou.db.DBSimpleTable;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Cleanable;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.UserSummary;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBEditConfigManager;
import org.opengion.hayabusa.resource.DataRole;
import org.opengion.hayabusa.resource.FavoriteGUIData;
import org.opengion.hayabusa.resource.GUIAccessCount;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.RoleMode;
import org.opengion.hayabusa.resource.UserAccessTable;

public class UserInfo
implements UserSummary,
Cleanable {
    private static final long serialVersionUID = 4000L;
    private static final String QUERY_PARAM = HybsSystem.sys("USER_PARAMETER_SQL");
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String YOYAKU = "|JNAME|ID|INFO|LANG|ROLES|IPADDRESS|LOGINTIME|LASTACCESS|YMD|YMDH|LASTGAMENNM";
    private final boolean useAccessTable = HybsSystem.sysBool("USE_ACCESS_TOKEI_TABLE");
    private final String userID;
    private String lang;
    private final String jname;
    private final String roles;
    private final String droles;
    private final String ipAddress;
    private final long loginTime;
    private final Map<String, String> attribute;
    private final RoleMode roleMode;
    private final DataRole dataRole;
    private final int hashcode;
    private Map<String, GUIInfo> guiMap;
    private boolean isInfoSet = false;
    private long usedTime = 0L;
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private final Object guiLock = new Object();
    private final String systemId;
    private Map<String, FavoriteGUIData> favoriteGuiMap = null;
    private Set<String> forbidAddrSet = null;
    private final DBEditConfigManager editMgr = new DBEditConfigManager();
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private static final String QUERY_GE20 = "select PARAM_ID,PARAM from GE20 where SYSTEM_ID = ? and USERID in ( ?, '*' ) and ROLES in ( ?, '*' ) and FGJ = '1' order by USERID,ROLES";
    private static final String QUERY_GE20_KEY = "select KBSET from GE20 where SYSTEM_ID = ? and USERID = ? and ROLES = ? and PARAM_ID = ? and FGJ = '1'";
    private GUIInfo lastGuiInfo = null;
    private static final int C_SYSTEM_ID = 0;
    private static final int C_USERID = 1;
    private static final int C_USERADRS = 2;
    private static final int C_HOSTADRS = 3;
    private static final int C_GUIKEY = 4;
    private static final int C_DYLOGIN = 5;
    private static final int C_DYLOGOUT = 6;
    private static final int C_USED_TIME = 7;
    private static final int C_CNT_ACCESS = 8;
    private static final int C_CNT_ERROR = 9;
    private static final int C_CNT_READ = 10;
    private static final int C_CNT_WRITE = 11;
    private static final int C_TM_TOTAL_QUERY = 12;
    private static final int C_TM_MAX_QUERY = 13;
    private static final int C_MAX_QUERY = 14;
    private static final int C_FGJ = 15;
    private static final int C_DYSET = 16;
    private static final int C_DYUPD = 17;
    private static final int C_USRSET = 18;
    private static final int C_USRUPD = 19;
    private static final int C_PGUPD = 20;
    private static final int C_GE20_SYSTEM_ID = 0;
    private static final int C_GE20_USERID = 1;
    private static final int C_GE20_ROLES = 2;
    private static final int C_GE20_PARAM_ID = 3;
    private static final int C_GE20_PARAM = 4;
    private static final int C_GE20_KBSET = 5;
    private static final int C_GE20_FGJ = 6;
    private static final int C_GE20_DYSET = 7;
    private static final int C_GE20_DYUPD = 8;
    private static final int C_GE20_USRSET = 9;
    private static final int C_GE20_USRUPD = 10;
    private static final int C_GE20_PGUPD = 11;
    private static final int GE20_KBSET_READONLY = 1;
    private static final int GE20_KBSET_WRITABLE = 2;
    private static final String GE20_ROLES = "*";

    public UserInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, ApplicationInfo applicationInfo) {
        this.userID = string;
        this.lang = string2;
        this.jname = string3;
        this.roles = string4;
        this.droles = string5;
        this.systemId = string6;
        this.roleMode = RoleMode.newInstance(string4);
        this.dataRole = DataRole.newInstance(string5, string6, applicationInfo);
        this.ipAddress = string7;
        this.appInfo = applicationInfo;
        this.usedTime = this.loginTime = System.currentTimeMillis();
        this.attribute = new HashMap<String, String>();
        this.hashcode = (int)(this.loginTime ^ this.loginTime >>> 32);
        boolean bl = HybsSystem.sysBool("USE_USER_IDNO_C_SAPLESS");
        String string8 = string.length() > 5 && bl ? string.substring(1) : string;
        this.attribute.put("IDNO", string8);
        this.initLoad();
        this.dbLoad();
        this.makeEditConfigMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String string) {
        String string2 = null;
        if (string != null) {
            Map<String, String> map = this.paramMap;
            synchronized (map) {
                string2 = this.paramMap.get(string);
            }
            if (string2 == null) {
                string2 = HybsSystem.sys(string);
            }
        }
        return string2;
    }

    @Override
    public long getLoginTime() {
        return this.loginTime;
    }

    @Override
    public String getIPAddress() {
        return this.ipAddress;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    @Override
    public String getJname() {
        return this.jname;
    }

    @Override
    public String getRoles() {
        return this.roles;
    }

    public RoleMode getRoleMode() {
        return this.roleMode;
    }

    @Override
    public String getInfo() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(this.userID).append(" \uff1a ");
        stringBuilder.append(this.jname).append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    public void setAttribute(String string, String string2, boolean bl) {
        this.setAttribute(string, string2, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttribute(String string, String string2, boolean bl, boolean bl2) {
        if (string != null && YOYAKU.indexOf("|" + string + "|") < 0) {
            Map<String, String> map = this.attribute;
            synchronized (map) {
                this.attribute.put(string, string2);
            }
            if (bl) {
                this.savePermanently(string, string2, bl2);
            }
        } else {
            String string3 = "\u5c5e\u6027\u6587\u5b57\u5217\u30ad\u30fc\u304c\u4e0d\u6b63\u3067\u3059\u3002 key=[" + string + "]" + HybsSystem.CR + "null \u307e\u305f\u306f\u4e88\u7d04\u8a9e(" + YOYAKU + ") \u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.equalsIgnoreCase("JNAME")) {
            string2 = this.jname;
        } else if (string.equalsIgnoreCase("ID")) {
            string2 = this.userID;
        } else if (string.equalsIgnoreCase("INFO")) {
            string2 = this.getInfo();
        } else if (string.equalsIgnoreCase("LANG")) {
            string2 = this.lang;
        } else if (string.equalsIgnoreCase("ROLE")) {
            string2 = this.roles;
        } else if (string.equalsIgnoreCase("ROLES")) {
            string2 = this.roles;
        } else if (string.equalsIgnoreCase("DROLES")) {
            string2 = this.droles;
        } else if (string.equalsIgnoreCase("IPADDRESS")) {
            string2 = this.ipAddress;
        } else if (string.equalsIgnoreCase("LOGINTIME")) {
            string2 = HybsSystem.getDate(this.loginTime);
        } else if (string.equalsIgnoreCase("LASTACCESS")) {
            if (this.appInfo != null) {
                string2 = this.appInfo.getGamenId();
            }
        } else if (string.equalsIgnoreCase("YMD")) {
            string2 = HybsSystem.getDate("yyyyMMdd");
        } else if (string.equalsIgnoreCase("LASTGAMENNM")) {
            if (this.appInfo != null && this.appInfo.getGamenId() != null && this.getGUIInfo(this.appInfo.getGamenId()) != null) {
                string2 = this.getGUIInfo(this.appInfo.getGamenId()).getName();
            }
        } else if (string.equalsIgnoreCase("YMDH")) {
            string2 = HybsSystem.getDate("yyyyMMddHHmmss");
        } else {
            Map<String, String> map = this.attribute;
            synchronized (map) {
                string2 = this.attribute.get(string);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HybsEntry[] getEntrys() {
        ArrayList<HybsEntry> arrayList = new ArrayList<HybsEntry>();
        arrayList.add(new HybsEntry("JNAME", this.getAttribute("JNAME"), "\u30e6\u30fc\u30b6\u30fc\u65e5\u672c\u8a9e\u540d\u79f0"));
        arrayList.add(new HybsEntry("ID", this.getAttribute("ID"), "\u30e6\u30fc\u30b6\u30fc\uff29\uff24"));
        arrayList.add(new HybsEntry("IDNO", this.getAttribute("IDNO"), "USER.ID \u304c\uff15Byte\u4ee5\u4e0a\u306e\u6642\u306e\u307f\u5148\u982d\uff11\u6587\u5b57\u3092\u9664\u3044\u305f\u30e6\u30fc\u30b6\u30fc\uff29\uff24"));
        arrayList.add(new HybsEntry("INFO", this.getAttribute("INFO"), "\u30e6\u30fc\u30b6\u30fc\u60c5\u5831(\u30e6\u30fc\u30b6\u30fcID\uff1a\u65e5\u672c\u8a9e\u540d\u79f0)"));
        arrayList.add(new HybsEntry("LANG", this.getAttribute("LANG"), "\u8a00\u8a9e"));
        arrayList.add(new HybsEntry("ROLES", this.getAttribute("ROLES"), "\u30ed\u30fc\u30eb\u30ba"));
        arrayList.add(new HybsEntry("IPADDRESS", this.getAttribute("IPADDRESS"), "IP\u30a2\u30c9\u30ec\u30b9"));
        arrayList.add(new HybsEntry("LOGINTIME", this.getAttribute("LOGINTIME"), "\u30ed\u30b0\u30a4\u30f3\u6642\u523b"));
        arrayList.add(new HybsEntry("LASTACCESS", this.getAttribute("LASTACCESS"), "\u6700\u7d42\u30a2\u30af\u30bb\u30b9\u753b\u9762ID"));
        arrayList.add(new HybsEntry("LASTGAMENNM", this.getAttribute("LASTGAMENNM"), "\u6700\u7d42\u30a2\u30af\u30bb\u30b9\u753b\u9762\u540d"));
        arrayList.add(new HybsEntry("YMD", this.getAttribute("YMD"), "\u3000\uff18byte \u306e\u4eca\u65e5\u306e\u30b7\u30b9\u30c6\u30e0\u65e5\u4ed8"));
        arrayList.add(new HybsEntry("YMDH", this.getAttribute("YMDH"), "\uff11\uff14byte \u306e\u4eca\u65e5\u306e\u30b7\u30b9\u30c6\u30e0\u65e5\u6642"));
        Map<String, String> map = this.attribute;
        synchronized (map) {
            Object[] objectArray = this.attribute.keySet().toArray(new String[this.attribute.size()]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(new HybsEntry((String)objectArray[i], this.getAttribute((String)objectArray[i])));
            }
        }
        return arrayList.toArray(new HybsEntry[arrayList.size()]);
    }

    public void removeAttribute(String string, boolean bl) {
        this.removeAttribute(string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttribute(String string, boolean bl, boolean bl2) {
        Map<String, String> map = this.attribute;
        synchronized (map) {
            this.attribute.remove(string);
        }
        if (bl) {
            this.deletePermanently(string, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGUIMap(Map<String, GUIInfo> map, Set<String> set) {
        if (map != null) {
            Object object = this.guiLock;
            synchronized (object) {
                this.guiMap = map;
                this.forbidAddrSet = set;
                this.favoriteGuiMap = UserAccessTable.makeAccessDB(this.guiMap, this.systemId, this.userID, this.lang);
                this.isInfoSet = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUIInfo getGUIInfo(String string) {
        Object object = this.guiLock;
        synchronized (object) {
            return this.guiMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUIInfo[] getGUIInfos() {
        Object object = this.guiLock;
        synchronized (object) {
            return this.guiMap.values().toArray(new GUIInfo[this.guiMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidAddr(String string) {
        Object object = this.guiLock;
        synchronized (object) {
            return this.forbidAddrSet == null || !this.forbidAddrSet.contains(string);
        }
    }

    public Map<String, FavoriteGUIData> getFavoriteMap() {
        return this.favoriteGuiMap;
    }

    public boolean isGUIInfoSet() {
        return this.isInfoSet;
    }

    public byte getAccessBitMode(RoleMode roleMode) {
        return this.roleMode.getAccessBitMode(roleMode);
    }

    public boolean isAccess(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return this.roleMode.getAccessBitMode(RoleMode.newInstance(string)) > 0;
    }

    public void clear() {
        if (this.useAccessTable && this.isInfoSet) {
            this.saveGUIAccessInfo();
        }
        this.initLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLoad() {
        if (QUERY_PARAM != null && QUERY_PARAM.length() > 0) {
            String[] stringArray = new String[]{this.systemId, this.userID};
            if (this.appInfo != null) {
                this.appInfo.setModuleInfo("UserInfo", null, "initLoad");
            }
            String[][] stringArray2 = DBUtil.dbExecute((String)QUERY_PARAM, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            Map<String, String> map = this.paramMap;
            synchronized (map) {
                this.paramMap.clear();
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string = stringArray2[i][0];
                    String string2 = stringArray2[i][1];
                    if (string2 != null && string2.length() == 0) continue;
                    this.paramMap.put(string, string2);
                }
            }
        }
    }

    private void dbLoad() {
        String[] stringArray = new String[]{this.systemId, this.userID, this.roles};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY_GE20, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        for (int i = 0; i < stringArray2.length; ++i) {
            this.setAttribute(stringArray2[i][0], stringArray2[i][1], false);
        }
    }

    private void makeEditConfigMap() {
        String[] stringArray = this.attribute.keySet().toArray(new String[0]);
        String[][] stringArray2 = DBEditConfig.getKeySet(stringArray);
        if (stringArray2 != null) {
            for (String[] stringArray3 : stringArray2) {
                String string = stringArray3[0];
                String string2 = stringArray3[1];
                String[] stringArray4 = DBEditConfig.getEditKeys(string, string2);
                String[] stringArray5 = new String[stringArray4.length];
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray5[i] = this.attribute.get(stringArray4[i]);
                }
                this.editMgr.addEditConfig(string, string2, new DBEditConfig(stringArray5));
            }
        }
    }

    public DBEditConfig[] getEditConfigs(String string) {
        return this.editMgr.getEditConfigs(string);
    }

    public DBEditConfig getEditConfig(String string, String string2) {
        if (string2 != null) {
            String string3 = this.getSelectedEdit(string);
            if (!string2.equals(string3)) {
                this.setSelectedEdit(string, string2);
            }
        } else {
            this.setSelectedEdit(string, null);
        }
        return this.editMgr.getEditConfig(string, string2);
    }

    public void addEditConfig(String string, String string2, DBEditConfig dBEditConfig) {
        if (dBEditConfig == null) {
            return;
        }
        boolean bl = dBEditConfig.isCommon();
        String[] stringArray = DBEditConfig.getEditKeys(string, string2);
        String[] stringArray2 = dBEditConfig.getEditVals();
        if (!bl && this.isExistValue(stringArray[0], GE20_ROLES, GE20_ROLES)) {
            String string3 = "\u540c\u3058\u7de8\u96c6\u540d\u3067\u5171\u901a\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u500b\u5225\u7de8\u96c6\u3092\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string3);
        }
        if (bl && this.isExistValue(stringArray[0], this.userID, GE20_ROLES)) {
            String string4 = "\u540c\u3058\u7de8\u96c6\u540d\u3067\u500b\u5225\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u5171\u901a\u7de8\u96c6\u3092\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string4);
        }
        this.editMgr.addEditConfig(string, string2, dBEditConfig);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i] != null && stringArray2[i].length() > 0) {
                this.setAttribute(stringArray[i], stringArray2[i], true, bl);
                continue;
            }
            this.removeAttribute(stringArray[i], true, bl);
        }
    }

    public void deleteEditConfig(String string, String string2) {
        String string3;
        DBEditConfig dBEditConfig = this.editMgr.deleteEditConfig(string, string2);
        if (dBEditConfig != null) {
            boolean bl = dBEditConfig.isCommon();
            String[] stringArray = DBEditConfig.getEditKeys(string, string2);
            if (!this.isExistValue(stringArray[0], bl ? GE20_ROLES : this.userID, GE20_ROLES)) {
                String string4 = "\u30a8\u30c7\u30a3\u30c3\u30c8\u8a2d\u5b9a\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
                throw new HybsSystemException(string4);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.removeAttribute(stringArray[i], true, bl);
            }
        }
        if (string2 != null && !string2.equals(string3 = this.getSelectedEdit(string))) {
            this.setSelectedEdit(string, null);
        }
    }

    public void setSelectedEdit(String string, String string2) {
        this.setAttribute("EDIT_NAME_SELECTED_" + string, string2, true);
    }

    public String getSelectedEdit(String string) {
        return this.getAttribute("EDIT_NAME_SELECTED_" + string);
    }

    public ApplicationInfo getApplicationInfo(String string, String string2) {
        if (this.appInfo != null) {
            this.appInfo.setModuleInfo(string, null, string2);
        }
        return this.appInfo;
    }

    @Override
    public int compareTo(UserSummary userSummary) {
        int n = this.userID.compareTo(userSummary.getUserID());
        if (n == 0) {
            n = (int)(this.loginTime - userSummary.getLoginTime());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof UserInfo) {
            return this.userID.equals(((UserInfo)object).getUserID()) && this.loginTime == ((UserInfo)object).getLoginTime();
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("userID   :").append(this.userID).append(HybsSystem.CR);
        stringBuilder.append("lang     :").append(this.lang).append(HybsSystem.CR);
        stringBuilder.append("jname    :").append(this.jname).append(HybsSystem.CR);
        stringBuilder.append("roles    :").append(this.roles).append(HybsSystem.CR);
        stringBuilder.append("IPAddress:").append(this.ipAddress).append(HybsSystem.CR);
        stringBuilder.append("loginTime:").append(this.loginTime).append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGUIAccessInfo() {
        GUIInfo[] gUIInfoArray;
        Object object = this.guiLock;
        synchronized (object) {
            gUIInfoArray = this.getGUIInfos();
            this.guiMap = null;
            this.isInfoSet = false;
        }
        long l = System.currentTimeMillis();
        String[] stringArray = new String[]{"SYSTEM_ID", "USERID", "USERADRS", "HOSTADRS", "GUIKEY", "DYLOGIN", "DYLOGOUT", "USED_TIME", "CNT_ACCESS", "CNT_ERROR", "CNT_READ", "CNT_WRITE", "TM_TOTAL_QUERY", "TM_MAX_QUERY", "MAX_QUERY", "FGJ", "DYSET", "DYUPD", "USRSET", "USRUPD", "PGUPD"};
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = HybsSystem.sys("SYSTEM_ID");
        stringArray2[1] = this.userID;
        stringArray2[2] = this.ipAddress;
        stringArray2[3] = HybsSystem.sys("HOST_ADRS");
        stringArray2[4] = "";
        stringArray2[5] = HybsSystem.getDate(this.loginTime, "yyyyMMddHHmmss");
        stringArray2[6] = HybsSystem.getDate("yyyyMMddHHmmss");
        stringArray2[7] = String.valueOf(Math.round((double)(l - this.usedTime) / 1000.0));
        stringArray2[8] = "0";
        stringArray2[9] = "0";
        stringArray2[10] = "0";
        stringArray2[11] = "0";
        stringArray2[12] = "0";
        stringArray2[13] = "0";
        stringArray2[14] = "";
        stringArray2[15] = "1";
        stringArray2[16] = HybsSystem.getDate("yyyyMMddHHmmss");
        stringArray2[17] = HybsSystem.getDate("yyyyMMddHHmmss");
        stringArray2[18] = "userInfo";
        stringArray2[19] = "userInfo";
        stringArray2[20] = "userInfo";
        this.usedTime = l;
        DBSimpleTable dBSimpleTable = new DBSimpleTable(stringArray);
        this.getApplicationInfo("UserInfo", "saveGUI");
        dBSimpleTable.setApplicationInfo(this.appInfo);
        dBSimpleTable.setTable("GE15");
        boolean bl = false;
        try {
            dBSimpleTable.startInsert();
            dBSimpleTable.execute(stringArray2);
            if (gUIInfoArray != null) {
                stringArray2[7] = "0";
                String string = HybsSystem.getDate("yyyyMMddHHmmss");
                for (int i = 0; i < gUIInfoArray.length; ++i) {
                    GUIAccessCount gUIAccessCount = gUIInfoArray[i].getGUIAccessCount();
                    int n = gUIAccessCount.getAccessCount();
                    if (n <= 0) continue;
                    stringArray2[4] = gUIAccessCount.getKey();
                    stringArray2[8] = String.valueOf(n);
                    stringArray2[9] = String.valueOf(gUIAccessCount.getErrorCount());
                    stringArray2[10] = String.valueOf(gUIAccessCount.getReadCount());
                    stringArray2[11] = String.valueOf(gUIAccessCount.getWriteCount());
                    stringArray2[12] = String.valueOf(gUIAccessCount.getQueryTime());
                    stringArray2[13] = String.valueOf(gUIAccessCount.getMaxQueryTime());
                    stringArray2[14] = gUIAccessCount.getMaxQuery();
                    dBSimpleTable.execute(stringArray2);
                    String string2 = gUIInfoArray[i].getNextGuiKeys();
                    UserAccessTable.updateLastAccessTime(this.systemId, this.userID, gUIAccessCount.getKey(), string, string2);
                }
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            LogWriter.log((String)("  userID=[" + this.userID + "] \u30a2\u30af\u30bb\u30b9\u7d71\u8a08\u30c6\u30fc\u30d6\u30eb\u767b\u9332\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f"));
            LogWriter.log((String)sQLException.getMessage());
        }
        finally {
            int n = dBSimpleTable.close(bl);
            System.out.println();
            System.out.println("  userID=[" + this.userID + "] \u30a2\u30af\u30bb\u30b9\u7d71\u8a08\u30c6\u30fc\u30d6\u30eb\u306b\u3001[" + n + "]\u4ef6\u3001\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002");
        }
    }

    private void savePermanently(String string, String string2, boolean bl) {
        String[] stringArray = new String[]{"SYSTEM_ID", "USERID", "ROLES", "PARAM_ID", "PARAM", "KBSET", "FGJ", "DYSET", "DYUPD", "USRSET", "USRUPD", "PGUPD"};
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = HybsSystem.sys("SYSTEM_ID");
        stringArray2[1] = bl ? GE20_ROLES : this.userID;
        stringArray2[2] = GE20_ROLES;
        stringArray2[3] = string;
        stringArray2[4] = string2;
        stringArray2[5] = String.valueOf(2);
        stringArray2[6] = "1";
        stringArray2[7] = HybsSystem.getDate("yyyyMMddHHmmss");
        stringArray2[8] = HybsSystem.getDate("yyyyMMddHHmmss");
        stringArray2[9] = this.userID;
        stringArray2[10] = this.userID;
        stringArray2[11] = "UserInfo";
        this.getApplicationInfo("UserInfo", "registValueToDB");
        DBSimpleTable dBSimpleTable = new DBSimpleTable(stringArray);
        dBSimpleTable.setApplicationInfo(this.appInfo);
        dBSimpleTable.setTable("GE20");
        boolean bl2 = false;
        try {
            if (this.isExistValue(string, bl ? GE20_ROLES : this.userID, GE20_ROLES)) {
                String string3 = "SYSTEM_ID = [SYSTEM_ID] and USERID = [USERID] and ROLES = [ROLES] and PARAM_ID = [PARAM_ID] and FGJ='1'";
                dBSimpleTable.setWhere(string3);
                dBSimpleTable.startUpdate();
            } else {
                dBSimpleTable.startInsert();
            }
            dBSimpleTable.execute(stringArray2);
            bl2 = true;
        }
        catch (SQLException sQLException) {
            throw new HybsSystemException("\u30e6\u30fc\u30b6\u30fc\u6c38\u7d9a\u5316\u60c5\u5831\u8a2d\u5b9a\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", sQLException);
        }
        finally {
            dBSimpleTable.close(bl2);
        }
    }

    private void deletePermanently(String string, boolean bl) {
        String[] stringArray = new String[]{"SYSTEM_ID", "USERID", "ROLES", "PARAM_ID"};
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = HybsSystem.sys("SYSTEM_ID");
        stringArray2[1] = bl ? GE20_ROLES : this.userID;
        stringArray2[2] = GE20_ROLES;
        stringArray2[3] = string;
        this.getApplicationInfo("UserInfo", "deleteValueFromDB");
        DBSimpleTable dBSimpleTable = new DBSimpleTable(stringArray);
        dBSimpleTable.setApplicationInfo(this.appInfo);
        dBSimpleTable.setTable("GE20");
        boolean bl2 = false;
        try {
            String string2 = "SYSTEM_ID = [SYSTEM_ID] and USERID = [USERID] and ROLES = [ROLES] and PARAM_ID = [PARAM_ID] and FGJ='1'";
            dBSimpleTable.setWhere(string2);
            dBSimpleTable.startDelete();
            dBSimpleTable.execute(stringArray2);
            bl2 = true;
        }
        catch (SQLException sQLException) {
            throw new HybsSystemException("\u30e6\u30fc\u30b6\u30fc\u6c38\u7d9a\u5316\u60c5\u5831\u524a\u9664\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", sQLException);
        }
        finally {
            dBSimpleTable.close(bl2);
        }
    }

    private boolean isExistValue(String string, String string2, String string3) {
        String[] stringArray = new String[]{HybsSystem.sys("SYSTEM_ID"), string2, string3, string};
        this.getApplicationInfo("UserInfo", "isExistValue");
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY_GE20_KEY, (String[])stringArray, (ApplicationInfo)this.appInfo);
        if (stringArray2 == null || stringArray2.length == 0) {
            return false;
        }
        if (stringArray2[0].length > 0) {
            if (String.valueOf(1).equals(stringArray2[0][0])) {
                throw new HybsSystemException("\u8aad\u307f\u53d6\u308a\u5c02\u7528\u60c5\u5831\u306e\u305f\u3081\u3001\u66f8\u304d\u8fbc\u307f\u3067\u304d\u307e\u305b\u3093");
            }
            return true;
        }
        throw new HybsSystemException("\u6c38\u7d9a\u5316\u60c5\u5831\u691c\u7d22\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
    }

    public String getDataCondition(String string) {
        return this.dataRole.getCondition(string);
    }

    public void setAccessGui(GUIInfo gUIInfo) {
        if (this.lastGuiInfo != null && gUIInfo != null) {
            this.lastGuiInfo.setNextGuiKey(gUIInfo.getKey());
        }
        this.lastGuiInfo = gUIInfo;
    }
}

