/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import org.firebirdsql.gds.ClassFactory;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.impl.jni.NativeGDSImpl;

public class NativeGDSFactoryPlugin
implements GDSFactoryPlugin {
    private static final String[] TYPE_ALIASES = new String[]{"TYPE2"};
    private static final String[] JDBC_PROTOCOLS = new String[]{"jdbc:firebirdsql:native:"};
    private static GDS gds;

    @Override
    public String getPluginName() {
        return "JNI-based GDS implementation.";
    }

    @Override
    public String getTypeName() {
        return "NATIVE";
    }

    @Override
    public String[] getTypeAliases() {
        return TYPE_ALIASES;
    }

    @Override
    public Class getConnectionClass() {
        return ClassFactory.get("org.firebirdsql.jdbc.FBConnection");
    }

    @Override
    public String[] getSupportedProtocols() {
        return JDBC_PROTOCOLS;
    }

    @Override
    public GDS getGDS() {
        if (gds == null) {
            gds = new NativeGDSImpl();
        }
        return gds;
    }

    @Override
    public String getDatabasePath(String server, Integer port, String path) throws GDSException {
        if (server == null) {
            throw new GDSException("Server name/address is required for pure Java implementation.");
        }
        if (path == null) {
            throw new GDSException("Database name/path is required.");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(server);
        if (port != null) {
            sb.append("/").append(port);
        }
        sb.append(":").append(path);
        return sb.toString();
    }

    @Override
    public String getDatabasePath(String jdbcUrl) throws GDSException {
        String[] protocols = this.getSupportedProtocols();
        for (int i = 0; i < protocols.length; ++i) {
            if (!jdbcUrl.startsWith(protocols[i])) continue;
            return jdbcUrl.substring(protocols[i].length());
        }
        throw new IllegalArgumentException("Incorrect JDBC protocol handling: " + jdbcUrl);
    }

    @Override
    public String getDefaultProtocol() {
        return this.getSupportedProtocols()[0];
    }

    public int hashCode() {
        return this.getTypeName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof NativeGDSFactoryPlugin;
    }
}

