/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.firebirdsql.jdbc.FBSQLException;

public class SimpleDataSource
implements DataSource {
    private ConnectionPoolDataSource pool;
    private int timeout;
    private PrintWriter log;

    public SimpleDataSource(ConnectionPoolDataSource pool) {
        this.pool = pool;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.pool.getPooledConnection().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.pool.getPooledConnection(username, password).getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.log = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.timeout = seconds;
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        return arg0 != null && arg0.isAssignableFrom(SimpleDataSource.class);
    }

    public Object unwrap(Class arg0) throws SQLException {
        if (!this.isWrapperFor(arg0)) {
            throw new FBSQLException("No compatible class found.");
        }
        return this;
    }
}

