/**************************************************************************/
/* GF45 ( 受注テーブルサンプル )                                          */
/*                                                                        */
/* Created : 2012/06/01 18:24:19                                          */
/**************************************************************************/
CREATE TABLE GF45 (
   NOORDER  VARCHAR2(10)                 NOT NULL      /* 0   受注番号     */
 , KNORDER  NUMBER(9)                                  /* 1   受注金額     */
 , KNJISK   NUMBER(9)                                  /* 2   実績金額     */
 , KNMIKM   NUMBER(9)                                  /* 3   見込金額     */
 , SUORDER  NUMBER(9)                                  /* 4   受注数       */
 , PN       VARCHAR2(11)                               /* 5   品番         */
 , PHOTO    VARCHAR2(100)                              /* 6   写真         */
 , SINTYOKU NUMBER(5,2)                                /* 7   進捗         */
 , NMCUST   VARCHAR2(100)                              /* 8   納入先       */
 , DYORDER  VARCHAR2(8)                                /* 9   受注日       */
 , DYNOKI   VARCHAR2(8)                                /* 10  納期         */
 , UNIQ     NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ      VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET    VARCHAR2(14)                               /* 820 登録日時     */
 , PGSET    VARCHAR2(10)                               /* 830 作成PG       */
 , PGPSET   VARCHAR2(10)                               /* 840 作成親PG     */
 , USRSET   VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD    VARCHAR2(14)                               /* 860 更新日時     */
 , PGUPD    VARCHAR2(10)                               /* 870 更新PG       */
 , PGPUPD   VARCHAR2(10)                               /* 880 更新親PG     */
 , USRUPD   VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF45S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF45T00 
BEFORE INSERT ON GF45
FOR EACH ROW 
BEGIN 
SELECT GF45S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

