<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT04"
	title	= "プロジェクトリソース登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "PRJCODE"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select A.PRJCODE,B.NAME_JA AS PRJ_NAME,A.RESOURCE_ID,A.SEQ,
				A.FUNC,A.FGJ
		from GF65 A,GF62 B
	</jsp:text>
	<og:where>
		<og:and value = "A.FGJ         in  ('0','1')"         />
		<og:and value = "A.FGJ         = B.FGJ(+) "           />
		<og:and value = "A.PRJCODE     like '{@PRJCODE}%'"    />
		<og:and value = "A.PRJCODE     = B.PRJCODE(+)"        />
		<og:and value = "A.FUNC    = '{@FUNC}'"       />
		<og:and value = "A.RESOURCE_ID = '{@RESOURCE_ID}'"    />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}" 
				defaultVal = "A.PRJCODE,A.SEQ" />
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
<br />
</og:writeCheck>

<og:columnEditor column="RESOURCE_ID" editor="DBMENU">
	<jsp:text>
		select RESOURCE_ID,NAME_JA from GF63 
		where fgj in ('0','1') 
		group by RESOURCE_ID,NAME_JA order by 1
	</jsp:text>
</og:columnEditor>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}"  />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
