<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2050"
	title	= "定義ファイル取込"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<og:entry command="{@command}" >
	<og:columnSet command="COPY"   columnId="SYSTEM_ID"  action="NULLSET" value="{@MEM.SYSTEM_ID}"   />
	<og:columnSet command="COPY"   columnId="CLM"        action="NULLSET" value="{@MEM.CLM}"         />
	<og:columnSet command="MODIFY" columnId="USE_LENGTH" action="TBLSET"  value="[MAX_LENGTH]"       />
</og:entry>

<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="ENTRY" />
	<og:submit  action="RESET" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,FGJ"
	noWritable		= "{@noWritable}"
	columnWritable	= "{@columnWritable}"
	columnBulkSet	= "*"
	checked			= "{@checked}"
	startNo			= "{@startNo}"
	pageSize		= "{@pageSize}"
/>

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
