<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6170"
	title	= "Ajaxツリーメニュー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 子データを取得します。 -->
<og:query command="{@command}" debug="false" maxRowCount="0" scope="request" tableId="dummy">
	<jsp:text>
		select	COALESCE({@LVL},0) + 1 LVL
			,	A.MGR,A.JOB,A.EMPNO,A.ENAME
			,	A.SAL,A.COMM,A.HIREDATE,A.DEPTNO,B.DNAME,B.LOC
		from EMP A inner join DEPT B
		on	A.DEPTNO = B.DEPTNO
		where A.MGR = {@EMPNO}
	</jsp:text>
</og:query>

<!-- 子データのDBTableModelを元のDBTableModelに結合します。結合場所は、最終行です。 -->
<og:tableMerge
	action				= "UNION_ALL"
	slaveScope			= "request"
	slaveTableId		= "dummy"
/>

<!-- 子データのHTMLを元のHTMLに結合するため、差分でViewを表示します。 -->
<!-- viewで出力されるカラム数及びカラムの順番は、元のviewと一致している必要があります -->
<og:view
	viewFormType	= "HTMLAjaxTreeTable"
	command			= "{@command}"
	useParam		= "true">
	<og:ajaxTreeParam
		childSearchKeys	= "EMPNO"
		childSearchJsp	= "getChildRow.jsp"
		childViewStartNo= "{@DB.MASTER_COUNT}"
		levelClm		= "LVL"
		imgCollapsed	= "collapsed.gif"
		imgExpanded		= "expanded.gif"
		imgNoSub		= "nosub.gif"
	/>
</og:view>

</jsp:root>
