/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.io;

import java.io.PrintWriter;

import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;

/**
 * プロパティファイル形式(エンジン専用特殊形式)の書き出しクラスです。
 * Ver4 では、プロパティファイル形式をサポートしていません。
 *
 * DefaultTableWriter を継承していますので，ラベル，名前，データの出力部のみ
 * オーバーライドして，プロパティーファイルの出力機能を実現しています。
 *
 * @og.group ファイル出力
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class TableWriter_Properties extends TableWriter_Default {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	private static final String  headerSequence = "NL-D";	// ヘッダー項目の並び順

//	/**
//	 * デフォルトコンストラクター
//	 *
//	 */
//	public TableWriter_Properties() {
//		super();
//	}

	/**
	 * DBTableModel から データを作成して,PrintWriter に書き出します。
	 *
	 * @og.rev 3.1.1.0 (2003/03/28) 同期メソッド(synchronized付き)を非同期に変更する。
	 * @og.rev 3.5.4.3 (2004/01/05) 引数に PrintWriter を受け取るように変更します。
	 *
	 * @param	writer PrintWriterオブジェクト
	 */
	@Override
	public void writeDBTable( final PrintWriter writer )  {
		setHeaderSequence( headerSequence );
		super.writeDBTable( writer );
	}

	/**
	 * PrintWriter に DBTableModelのテーブル情報を書き込みます。
	 * このクラスでは，データを ダブルコーテーション(")で囲みます。
	 * PrintWriter に DBTableModelのテーブル情報を書き込みます。
	 *
	 * @og.rev 2.3.1.2 (2003/01/28) データ出力時に、改行が余分に出される箇所を修正。
	 * @og.rev 3.1.1.0 (2003/03/28) 同期メソッド(synchronized付き)を非同期に変更する。
	 *
	 * @param	table  DBTableModelオブジェクト
	 * @param	writer PrintWriterオブジェクト
	 */
	@Override
	protected void writeData( final DBTableModel table,final PrintWriter writer ) {
		if( numberOfColumns < 2 ) {
			String errMsg = "Properties では、最低、キーと値の２つ以上のカラムが必要です。"
						+ " numberOfColumns=[" + numberOfColumns + "]" ;
			throw new HybsSystemException( errMsg );
		}

		int numberOfRows =  table.getRowCount();
		String separator = getSeparator();

		for( int row=0; row<numberOfRows; row++ ) {
			writer.print( table.getValue(row,clmNo[0]) );
			writer.print( "=" );
			writer.print( table.getValue(row,clmNo[1]) );

			for( int i=2; i<numberOfColumns; i++ ) {
				int clm = clmNo[i];
				writer.print( separator );
				writer.print( table.getValue(row,clm) );
			}
			writer.println();
		}
	}
}
