<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:aaa="http://java.sun.com/xml/ns/j2ee" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:template match="/">
    <xsl:apply-templates select="aaa:taglib" />
  </xsl:template>

  <xsl:template match="aaa:taglib">
    <xsl:variable name="version" select="aaa:tlib-version" />
    <xsl:variable name="prefix"  select="aaa:short-name" />
    <ROWSET tableName="GF21">
      <EXEC_SQL>delete from GF21 where VERNO = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="aaa:tag">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="aaa:tag" />
          </xsl:attribute>
          <VERNO><xsl:value-of select="$version" /></VERNO>
          <PRE_FIX><xsl:value-of select="$prefix" /></PRE_FIX>
          <TAGNAME><xsl:value-of select="aaa:name" /></TAGNAME>
          <SEQ><xsl:number level="any" format="1" count="aaa:tag" /></SEQ>
          <TAGCLASS><xsl:value-of select="aaa:tag-class" /></TAGCLASS>
          <TEICLASS><xsl:value-of select="aaa:tei-class" /></TEICLASS>
          <BODYCONTENT>
            <xsl:variable name="bodyCtxt" select="aaa:body-content"/>
            <xsl:if test="$bodyCtxt='JSP'"         >1</xsl:if>
            <xsl:if test="$bodyCtxt='empty'"       >2</xsl:if>
            <xsl:if test="$bodyCtxt='tagdependent'">3</xsl:if>
          </BODYCONTENT>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
