/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.wire;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.wire.Xdrable;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class XdrOutputStream {
    private static final int BUF_SIZE = Short.MAX_VALUE;
    private static Logger log = LoggerFactory.getLogger(XdrOutputStream.class, false);
    private static byte[] textPad = new byte[Short.MAX_VALUE];
    private static byte[] zero = new XSQLVAR().encodeInt(0);
    private static byte[] minusOne = new XSQLVAR().encodeInt(-1);
    private byte[] buf = new byte[Short.MAX_VALUE];
    private int count;
    private OutputStream out = null;

    protected XdrOutputStream() {
    }

    public XdrOutputStream(OutputStream out) {
        this.out = out;
        this.count = 0;
        Arrays.fill(textPad, (byte)32);
    }

    public void writeBuffer(byte[] buffer) throws IOException {
        if (buffer == null) {
            this.writeInt(0);
        } else {
            int len = buffer.length;
            this.writeInt(len);
            this.write(buffer, len, 4 - len & 3);
        }
    }

    public void writeBlobBuffer(byte[] buffer) throws IOException {
        int len = buffer.length;
        if (log != null && log.isDebugEnabled()) {
            log.debug("writeBlobBuffer len: " + len);
        }
        if (len > Short.MAX_VALUE) {
            throw new IOException("");
        }
        this.writeInt(len + 2);
        this.writeInt(len + 2);
        this.checkBufferSize(2);
        this.buf[this.count++] = (byte)(len >> 0 & 0xFF);
        this.buf[this.count++] = (byte)(len >> 8 & 0xFF);
        this.write(buffer, len, 4 - len + 2 & 3);
    }

    public void writeString(String s) throws IOException {
        byte[] buffer = s.getBytes();
        this.writeBuffer(buffer);
    }

    public void writeString(String s, String encoding) throws IOException {
        if (encoding != null) {
            this.writeBuffer(s.getBytes(encoding));
        } else {
            this.writeBuffer(s.getBytes());
        }
    }

    public void writeSet(int type, byte[] s) throws IOException {
        if (s == null) {
            this.writeInt(1);
            this.checkBufferSize(1);
            this.buf[this.count++] = (byte)type;
        } else {
            int len = s.length;
            this.writeInt(len + 1);
            this.checkBufferSize(1);
            this.buf[this.count++] = (byte)type;
            this.write(s, len, 4 - (len + 1) & 3);
        }
    }

    public void writeTyped(int type, Xdrable item) throws IOException {
        int size;
        if (item == null) {
            this.writeInt(1);
            this.checkBufferSize(1);
            this.buf[this.count++] = (byte)type;
            size = 1;
        } else {
            size = item.getLength() + 1;
            this.writeInt(size);
            this.checkBufferSize(1);
            this.buf[this.count++] = (byte)type;
            item.write(this);
        }
        this.count += 4 - size & 3;
    }

    public void writeSQLData(XSQLDA xsqlda) throws IOException {
        for (int i = 0; i < xsqlda.sqld; ++i) {
            XSQLVAR xsqlvar = xsqlda.sqlvar[i];
            if (log != null && log.isDebugEnabled()) {
                if (this.out == null) {
                    log.debug("db.out null in writeSQLDatum");
                }
                if (xsqlvar.sqldata == null) {
                    log.debug("sqldata null in writeSQLDatum: " + xsqlvar);
                }
                if (xsqlvar.sqldata == null) {
                    log.debug("sqldata still null in writeSQLDatum: " + xsqlvar);
                }
            }
            int len = xsqlda.ioLength[i];
            byte[] buffer = xsqlvar.sqldata;
            int tempType = xsqlvar.sqltype & 0xFFFFFFFE;
            if (tempType == 32766) {
                this.write(xsqlvar.sqldata != null ? zero : minusOne, 4, 0);
                continue;
            }
            if (len == 0) {
                if (buffer != null) {
                    len = buffer.length;
                    this.writeInt(len);
                    this.write(buffer, len, 4 - len & 3);
                    this.write(zero, 4, 0);
                    continue;
                }
                this.writeInt(0);
                this.write(minusOne, 4, 0);
                continue;
            }
            if (len < 0) {
                if (buffer != null) {
                    this.write(buffer, -len, 0);
                    this.write(zero, 4, 0);
                    continue;
                }
                this.write(textPad, -len, 0);
                this.write(minusOne, 4, 0);
                continue;
            }
            --len;
            if (buffer != null) {
                int buflen = buffer.length;
                if (buflen >= len) {
                    this.write(buffer, len, 4 - len & 3);
                } else {
                    this.write(buffer, buflen, 0);
                    this.write(textPad, len - buflen, 4 - len & 3);
                }
                this.write(zero, 4, 0);
                continue;
            }
            this.write(textPad, len, 4 - len & 3);
            this.write(minusOne, 4, 0);
        }
    }

    public void writeLong(long v) throws IOException {
        this.checkBufferSize(8);
        this.buf[this.count++] = (byte)(v >>> 56 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 48 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 40 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 32 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 24 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 16 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 8 & 0xFFL);
        this.buf[this.count++] = (byte)(v >>> 0 & 0xFFL);
    }

    public void writeInt(int v) throws IOException {
        this.checkBufferSize(4);
        this.buf[this.count++] = (byte)(v >>> 24);
        this.buf[this.count++] = (byte)(v >>> 16);
        this.buf[this.count++] = (byte)(v >>> 8);
        this.buf[this.count++] = (byte)(v >>> 0);
    }

    public void write(byte[] b, int len, int pad) throws IOException {
        if (len > 256 || this.count + len >= Short.MAX_VALUE) {
            if (this.count > 0) {
                this.out.write(this.buf, 0, this.count);
            }
            this.out.write(b, 0, len);
            this.out.write(textPad, 0, pad);
            this.count = 0;
        } else {
            this.checkBufferSize(len + pad);
            System.arraycopy(b, 0, this.buf, this.count, len);
            this.count += len;
            System.arraycopy(textPad, 0, this.buf, this.count, pad);
            this.count += pad;
        }
    }

    public void write(int b) throws IOException {
        this.checkBufferSize(1);
        this.buf[this.count++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, b.length, 0);
    }

    public void flush() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
        }
        this.count = 0;
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.out.close();
        }
        finally {
            this.buf = null;
            this.out = null;
        }
    }

    private void checkBufferSize(int countToWrite) throws IOException {
        if (Short.MAX_VALUE - this.count <= countToWrite) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }
}

