/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.firebirdsql.jdbc.StoredProcedureMetaData;

class DefaultCallableStatementMetaData
implements StoredProcedureMetaData {
    Set selectableProcedureNames = new HashSet();

    public DefaultCallableStatementMetaData(Connection connection) throws SQLException {
        this.loadSelectableProcedureNames(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSelectableProcedureNames(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sql = "SELECT RDB$PROCEDURE_NAME FROM RDB$PROCEDURES WHERE RDB$PROCEDURE_TYPE = 1";
            try (ResultSet resultSet = stmt.executeQuery(sql);){
                while (resultSet.next()) {
                    this.selectableProcedureNames.add(resultSet.getString(1).trim().toUpperCase());
                }
            }
        }
    }

    @Override
    public boolean canGetSelectableInformation() {
        return true;
    }

    @Override
    public boolean isSelectable(String procedureName) throws SQLException {
        boolean value = this.selectableProcedureNames.contains(procedureName.toUpperCase());
        return value;
    }
}

