/*
 * OpenI2CRADIO
 * Menu sub-routines: Memory Freq.
 * Copyright (C) 2013-08-14 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "power.h"
#include "commondef.h"
#include "eeprom.h"
#include "backlight.h"
#include "rencoder.h"

void call_freqbank(unsigned int num)
{
    unsigned char _fm;
    unsigned char _band;
    unsigned char _userband;
    unsigned int bank = num / USER_MEMORY_NUM;
    unsigned int n = num % USER_MEMORY_NUM;

    if(num >= (USER_MEMORY_NUM * USER_MEMORY_BANKS)) return;

    if(bank != setup.pagenum){ // Swap memory
//        save_frequencies();
        load_frequencies(bank, 0x00);
    }

    _fm = freqset.memoryfreqs[n].fm;
    _userband = freqset.memoryfreqs[n].band;
    _band = _userband & 0x1f;
    _userband = _userband >> 5;
    if(_fm) { // AM
        setup.fmband = _band;
        setup.fm_userbandnum = _userband;
    } else {
        setup.amband = _band;
        setup.am_userbandnum = _userband;
    }
    setup.memorynum = num;
    akc6955_chg_fm(_fm, freqset.memoryfreqs[n].freq);
}


void set_freqbank(unsigned int num)
{
    unsigned char _fm;
    unsigned char _band;
    unsigned char _userband;
    unsigned int _freq;
    unsigned int bank = num / USER_MEMORY_NUM;
    unsigned int n = num % USER_MEMORY_NUM;

    if(num >= (USER_MEMORY_NUM * USER_MEMORY_BANKS)) return;

     if(bank != setup.pagenum){ // Save now bank, and load using bank
        save_frequencies();
        load_frequencies(bank, 0x00);
    }

    _fm = setup.fm;
    _freq = setup.amfreq;
    _userband = setup.am_userbandnum;
    _band = setup.amband;
    if(_fm){
        _userband = setup.fm_userbandnum;
        _band = setup.fmband;
        _freq = setup.fmfreq;
    }
    freqset.memoryfreqs[n].fm = _fm;
    freqset.memoryfreqs[n].band = (_userband << 5) | (_band & 0x1f);
    freqset.memoryfreqs[n].freq = _freq;

    save_frequencies();
}


void on_call_userfreq(void)
{
    unsigned long val = USER_MEMORY_NUM * USER_MEMORY_BANKS;
    _CLS();
//    _LOCATE(0,0);
    printstr("Mem: 000-");
    print_numeric_nosupress(val - 1, 3);
    val = read_numeric(val, 3, 4, 1);
    if(val >= 0x80000000) return;
    call_freqbank(val);
}

void on_set_userfreq(void)
{
    unsigned long val = USER_MEMORY_NUM * USER_MEMORY_BANKS;
    unsigned char n;
    unsigned char c;
    _CLS();
//    _LOCATE(0,0);
    printstr("Set Mem: 000-");
    print_numeric_nosupress(val - 1, 3);
    val = read_numeric(val, 3, 4, 1);
    if(val >= 0x80000000) return;
    _HOME();
//    _LOCATE(0,0);
    printstr("OK? A=OK        ");
    c = pollkey_single();
    if(c != charcode_a) return;
    set_freqbank(val);
//    save_eeprom();
}

static void disp_updown_lcd(void)
{
      //         _LOCATE(0,0);
       printstr("CH:");
       print_numeric_nosupress(setup.memorynum, 3);
       printstr(" HELP=F");
       update_status();
       print_freq(1);
       _HOME();

}

static unsigned char renc_updown_userfreq(unsigned char dispf)
{
    unsigned int count;
    count = renc_count;

    if((renc_dir == RENC_NONE) || (count == 0)) return dispf;
    if(renc_dir == RENC_RIGHT) {
        setup.memorynum += count;
    } else if(renc_dir == RENC_LEFT) {
        setup.memorynum = (setup.memorynum +
                USER_MEMORY_NUM * USER_MEMORY_BANKS) - count;
    } else {
        return dispf;
    }
    setup.memorynum = setup.memorynum  % (USER_MEMORY_NUM * USER_MEMORY_BANKS);
    rencoder_start();
    call_freqbank(setup.memorynum);
    backlight_reset(charcode_f);
    dispf = backlight_dec(0x00);
    disp_updown_lcd();
    return dispf;
}

void on_updown_userfreq(void)
{
    unsigned int _freq;
    unsigned char _fm;
    unsigned char _band;
    unsigned char _userband;
    unsigned char c;
    unsigned char dispf = 0xff;
    unsigned int _ui_idle = setup.ui_idlecount / 23;
    unsigned char _ui_pad = setup.ui_idlecount % 23;
    unsigned char changef = 0x00;
    
    if(_ui_idle == 0) _ui_idle = 1;
    _fm = setup.fm;
    _freq = setup.amfreq;
    _userband = setup.am_userbandnum;
    _band = setup.amband;
    if(_fm){
        _userband = setup.fm_userbandnum;
        _band = setup.fmband;
        _freq = setup.fmfreq;
    }

    _CLS();
    do {
       dispf = renc_updown_userfreq(dispf);
       if(dispf != 0)  {
           disp_updown_lcd();
       }
       c = pollkey_single_timeout(_ui_idle, 1); // 23*41 = 943ms
       backlight_reset(c);
       dispf = backlight_dec(dispf);


       switch(c) {
           case charcode_7: // UP 1CH
                setup.memorynum++;
                changef = 0xff;
                break;
           case charcode_1: // Down 1CH
                changef = 0xff;
               setup.memorynum = setup.memorynum + (USER_MEMORY_NUM * USER_MEMORY_BANKS) - 1;
               break;
           case charcode_9: // Up CH FAST
                changef = 0xff;
               setup.memorynum += 100;
               break;
           case charcode_3: // Down CH FAST
               changef = 0xff;
               setup.memorynum = setup.memorynum + (USER_MEMORY_NUM * USER_MEMORY_BANKS) - 100;
               break;
           case charcode_8: // Up CH MID
               changef = 0xff;
               setup.memorynum += USER_MEMORY_NUM;
               break;
           case charcode_2: // Down CH MID
               changef = 0xff;
               setup.memorynum = setup.memorynum + (USER_MEMORY_NUM * USER_MEMORY_BANKS) - USER_MEMORY_NUM;
               break;
            case charcode_5: // Recall
               changef = 0xff;
               break;
            case charcode_d: // Reset
               if(_fm) { // AM
                    setup.fmband = _band;
                    setup.fm_userbandnum = _userband;
                    setup.fmfreq = _freq;
               } else {
                    setup.amband = _band;
                    setup.am_userbandnum = _userband;
                    setup.amfreq = _freq;
               }
               akc6955_chg_fm(_fm, _freq);
               break;
           case charcode_4:
               on_call_userfreq();
               break;
           case charcode_6:
               on_set_userfreq();
               break;
           case charcode_a:
                goto _l0;
                break;
           case charcode_f:
               userfreq_help();
               _CLS();
               break;
           case charcode_e: // Set Light
               if(dispf == 0x00){
                   dispf = 0xff;
               } else {
                   dispf = 0x00;
               }
               break;
           default:
               break;
           }

          setup.memorynum = setup.memorynum % (USER_MEMORY_NUM * USER_MEMORY_BANKS);
           if(changef != 0) {
                call_freqbank(setup.memorynum);
           }
           if(_ui_pad != 0) idle_time_ms(_ui_pad); // Pad 9ms, 1Loop = 1000ms.
           changef = 0;
    } while(1);
_l0:
    _CLS();

}