/*
 * OpenI2CRADIO
 * Menu sub-routines / Scan.
 * Copyright (C) 2013-09-11 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include "menu.h"
#include "menu_memoryfreq.h"
#include "power.h"
#include "commondef.h"
#include "backlight.h"

void scan_start(void)
{
    unsigned char c;
    unsigned char cc;
    _CLS();
    scanflag = 0;

    do {
        do {
            c = pollkey_single_timeout(20, 0) ; // 23*20 = 460ms
            update_status();
            cc = ' ';
            if((akc6955_chk_donescan() == 0) && (scanflag != 0)){
                cc = '>';
            }
            _PUTCHAR(cc);
            _LOCATE_0_0();
            printstr("Scan A/4/6/F");
            print_freq(1);
            _HOME();
	    if(chk_powerbutton() != 0) shutdown(1); // 48ms for Checking power-button.
        } while(c == charcode_null);

         switch(c){
           case charcode_6:
               scanflag = 0xff;
               akc6955_do_scan(0xff);
               break;
           case charcode_4:
               scanflag = 0xff;
               akc6955_do_scan(0);
               break;
           case charcode_a:
               akc6955_abort_scan();
               goto _l0;
               break;
           case charcode_f:
               goto _l0;
               break;
           default:
               break;
       }
    } while(1);
_l0:
    _CLS();
}
