/*
 * OpenI2CRADIO
 * Menu sub-routines.
 * Copyright (C) 2013-06-21 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#ifndef MENU_H
#define	MENU_H

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"

#ifdef	__cplusplus
extern "C" {
#endif
#define USER_BAND_NUM 4
    typedef struct {
        unsigned char mode3k; // mode3k if am
        unsigned char start;
        unsigned char stop;
        unsigned int freq;
    } _userband_t;
    /*
     * main.c
     */
    extern unsigned int amfreq;
    extern unsigned int fmfreq;
    extern unsigned int amfreq_bank[AKC6955_BAND_AMEND];
    extern unsigned int fmfreq_bank[AKC6955_BAND_FMEND];
    extern unsigned char amband;
    extern unsigned char fmband;
    extern unsigned char fm;
    extern unsigned char am_mode3k;
    extern unsigned char am_userbandnum;
    extern unsigned char fm_userbandnum;
    extern unsigned char threshold;
    extern unsigned char lowboost;
    extern unsigned char stereo;
    extern _userband_t am_usrbands[USER_BAND_NUM];
    extern _userband_t fm_usrbands[USER_BAND_NUM];
    extern banddesc am_userband_freq[USER_BAND_NUM];
    extern banddesc fm_userband_freq[USER_BAND_NUM];
    extern unsigned char volume;
    extern unsigned char prevolume;
    extern unsigned char fmbandwidth;

    extern int backlight_long;
    extern unsigned int ui_idlecount;


    extern unsigned char stereoflag;
    extern unsigned char tuneflag;
    extern unsigned char cnrlevel;
    extern int diffstat;
    extern unsigned int batlevel_6955;
    extern unsigned int battlevel;

    extern int recv_signal;
    extern int backlight_counter;
    extern unsigned char backlight_level;
    extern unsigned char pollkeybuf[33];
    extern unsigned char scanflag;

    extern void update_display(void);
    extern void update_status(void);
    extern void save_eeprom(void);
    extern unsigned char load_eeprom(void);
    extern void check_eeprom(void);

    extern void setfreq_updown(unsigned char ctlword);
    extern void setdefault(void);

    /*
     * menu.c
     */
    extern void main_menu(void);
    extern void input_userband(void);
    extern void set_userband(void);
    extern void call_userband(unsigned char num);
    extern void setband_direct(void);
    extern void setfreq_direct(void);
    extern void set_stereo(void);

    extern void scan_start(void);
    extern void set_volume(void);
    extern void toggle_amfm(void);

    extern unsigned char printhelp_2lines(char *l1, char *l2);
    extern void setup_menu(void);
    extern void updown_help(void);
    extern void mainmenu_help(void);
    extern void print_freq(unsigned char y);
    extern void setup_akc6955(void);
    extern void setdefault(void);
    extern void valinit(void);

#ifdef	__cplusplus
}
#endif

#endif	/* MENU_H */

