/*
 * OpenI2CRADIO
 * UI->LCD->Display status.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#endif
#include <signal.h>

#include "commondef.h"
#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"


void print_freq(unsigned char y)
{
    int freq;
    int freq_lo;
    int freq_hi;
    _LOCATE(0,y);
    if(fm != 0){ // FM
        if(fmband < AKC6955_BAND_TV1) {
            printstr("FM");
            _PUTCHAR('1' + (fmband & 7));
            printstr("  ");
        } else if(fmband < AKC6955_BAND_FMUSER){
            printstr("TV");
            _PUTCHAR('1' + fmband - AKC6955_BAND_TV1);
            printstr("  ");
        } else { // USER
            printstr("FMU");
            _PUTCHAR('0' + fm_userbandnum);
            _PUTCHAR(' ');
        }
    } else { // AM
        if(amband == AKC6955_BAND_LW) {
            printstr("LW");
        } else if(amband <AKC6955_BAND_SW1) { //MW
            printstr("MW");
            _PUTCHAR('1' + amband - AKC6955_BAND_MW1);
            printstr("  ");
        } else if(amband <AKC6955_BAND_SW10) { //MW
            printstr("SW");
            _PUTCHAR('1' + amband - AKC6955_BAND_SW1);
            printstr("  ");
        } else if(amband < AKC6955_BAND_AMUSER) { //MW
            printstr("SW1");
            _PUTCHAR('0' + amband - AKC6955_BAND_SW10);
            _PUTCHAR(' ');
        } else if(amband == AKC6955_BAND_MW4){
            printstr("MW4  ");
        } else {
            printstr("AMU");
            _PUTCHAR('0' + am_userbandnum);
            _PUTCHAR(' ');
        }
     }
//     _LOCATE(15-5 ,1);
     _LOCATE(16-3-8, y);
     if(fm != 0){
         if(stereoflag != 0){
             printstr("ST");
         } else {
             printstr("  ");
         }
         freq = fmfreq + diffstat / 100;
         freq_lo = freq % 100;
         freq_hi = freq / 100;
         print_numeric_nosupress(freq_hi, 3);
         _PUTCHAR('.');
         print_numeric_nosupress(freq_lo, 2);
     } else {
         freq = amfreq + diffstat / 10;
         printstr("   ");
         print_numeric_nosupress(freq, 5);
     }
     // Signal
     _LOCATE(16-3, y);
     if(fm != 0){
         printstr("MHz");
     } else {
         printstr("KHz");
     }
}

void update_display(void)
{

    unsigned int vol;
    int lv;
//    _HOME();
    _LOCATE(0,0);
    printstr("S");
    if(recv_signal < 0){
        _PUTCHAR('-');
        lv = - recv_signal;
        print_numeric_nosupress(lv / 20, 1);
    } else {
        lv = recv_signal;
        print_numeric_nosupress(lv / 20, 1); // MAX=123
        _PUTCHAR(' ');
    }
    if(fm == 0){
        set_amlamp(1);
        set_fmlamp(0);
    } else {
        set_amlamp(0);
        set_fmlamp(1);
    }
     // vol = volume * 1.5 + prevolume * 3.5[dB]
     if(volume > 24) {
         vol = volume - 24;
         vol = (vol * 3 + prevolume * 7) / 2;
         printstr("V:");
         print_numeric_nosupress(vol,2);
     } else {
         printstr("MUTE");
     }

     _LOCATE(16-5,0);
     print_numeric_nosupress(battlevel / 100, 1);
     _PUTCHAR('.');
     print_numeric_nosupress(battlevel % 100, 2);
     _PUTCHAR('V');
     print_freq(1);
//    _PUTCHAR(' ');
    _HOME();
}
