/****************************************************************************************
 * Copyright (c) 2010, Takaya Kakizaki(kacky)
 * All rights reserved.

 \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B

 E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB

 EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB

 Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁAI[v̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB


 {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸A
 ƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B
 쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩
 iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔ
 i֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳Ȃj
 ڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B

 ****************************************************************************************/
#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <float.h>
#include <time.h>
#include "MIPIface.h"
#include "AILib.h"
#include "MahjongScoreAI.h"

//#define AIDUMP
#ifdef AIDUMP
//#define AIDUMP_1
//#define AIDUMP_2
//#define AIDUMP_3
//#define AIDUMP_STAT
//#define AIDUMP_POINT
//#define AIDUMP_PARAM
#define AIDUMP_COMMAND
//#define AIDUMP_STACKTRACE
#endif

/*typedef struct {
	double sc;
	double sc1;
	double sc2;
	double scc;
	int no;
	} HAIPOINT;*/

static const int param_size[] = {
	9,
};

typedef enum {
	AI_DECISION_AGARI1,
	AI_DECISION_AGARI2,
	AI_DECISION_ORI,
} AI_DECISION;

#define MAHJONGAI( method ) MahjongAI##method
#define PLAYERNAME( method ) "KING" #method


#define MAHJONGAITYPE MAHJONGAI(Type4)
#define AINAME PLAYERNAME(Type4)

MAHJONGAITYPE ai;
MahjongAIKikenhai kikenhai;


class MahjongAI {
public:
	UINT InterfaceFunc(UINT message, UINT param1, UINT param2);

#ifdef AIDUMP
	FILE *fp;
#endif
protected:
	MahjongAIState state;
	int machi[34];
	int menzen;
	int nakiok_flag;
	int sthai;
	int doranum;
	double tehai_score;
	int tenpai_flag;
	int jun;
	int kyokustate;
	HAIPOINT hp[14];
	int *resultBuf;
	int current_p;
	int size_p;
	AI_DECISION decision;

	int tehai2Array(int *p);
	void initParam(void);
	void destroyParam(void);
	int getParam(int index);
	void printResult(int result);
	int search(int obj, int start, int mask);
	void set_machi(void);
	void set_Tehai(int);
	int select_Score(double scc_max);
	UINT sutehai_sub(int tsumohai);
	int calc_sutehai(void);
	int calc_sutehai_easy(void);
	int nakability(int hai, int chii_flag);
	UINT koe_req(int no, int hai);
	UINT on_start_kyoku(int k, int c);
	UINT on_end_kyoku(UINT reason, LONG* inc_sc);
	UINT on_action(int player, int taishou, UINT action);
	UINT on_start_game(void);
	UINT on_end_game(int rank, LONG score);
	UINT on_exchange(UINT state, UINT option);
	void sendComment(int index);
};
enum {
	AI_KYOKUSTS_TSUMO,
	AI_KYOKUSTS_RON,
	AI_KYOKUSTS_TEKIAGARI,
	AI_KYOKUSTS_FURIKOMI,
	AI_KYOKUSTS_NORMAL,
};

enum {
	AI_MESSAGE_TSUMOLITTLE = 0,
	AI_MESSAGE_TSUMOMIDDLE,
	AI_MESSAGE_TSUMOBIG,
	AI_MESSAGE_RONLITTLE,
	AI_MESSAGE_RONMIDDLE,
	AI_MESSAGE_RONBIG,
	AI_MESSAGE_TEKIAGARILITTLE,
	AI_MESSAGE_TEKIAGARIMIDDLE,
	AI_MESSAGE_TEKIAGARIBIG,
	AI_MESSAGE_FURIKOMILITTLE,
	AI_MESSAGE_FURIKOMIMIDDLE,
	AI_MESSAGE_FURIKOMIBIG,
	AI_MESSAGE_TII,
	AI_MESSAGE_PON,
	AI_MESSAGE_RIICHI,
	AI_MESSAGE_TSUYOGARI,
};


static const TCHAR *message_table[] = {
	TEXT("݂Ă낱ȃP`Ȃ̂ł͂ȂI"),
	TEXT("l悤ȃZt͂͂III"),
	TEXT("͂`ɂȂ̂"),
	TEXT("{ڂɎʂ̂ȁc"),
	TEXT("܂Ȃǂ̓Gł͂ȂI"),
	TEXT("ljIII"),
	TEXT("tbc͂͂₭Ȃ悤"),
	TEXT("cɂ܂̎OIȂ΂̎ǑĂ낤"),
	TEXT("c͂̂̃PVEł͂ȂȁBȂc"),
	TEXT("܂Ƃɂ͒vIȈႢ邻͗~]cOII"),
	TEXT("IIoAoJ"),
	TEXT("ć̖cƂǂꂭ炢"),
	TEXT("Ȃc܂ď߂Ă͂Ȃ"),
	TEXT("Ȃc܂ď߂Ă͂Ȃ"),
	TEXT("{ڂɎʂ̂ȁc"),
	TEXT("͂Ĕ̂DȂ񂾁I"),
};

static const TCHAR * num_table[] = {
	TEXT(""),
	TEXT(""),
	TEXT("O"),
	TEXT("l"),
	TEXT(""),
	TEXT("Z"),
	TEXT(""),
	TEXT(""),
	TEXT(""),
};

static void printStackTrace(const char *trace, ...){
	va_list list;
	FILE *file = NULL;

	va_start(list, trace);

	file = fopen(TEXT("./stacktrace.txt"), "a");
	vfprintf(file, trace, list);
	fclose(file);

	va_end(list);
}

static const TCHAR * type_table[] = {
	TEXT(""),
	TEXT(""),
	TEXT(""),
	TEXT(""),
	TEXT(""),
	TEXT(""),
	TEXT("k"),
	TEXT(""),
	TEXT(""),
	TEXT(""),
};


static void sethaitext(TCHAR *p, int no)
{
	if (no < 27){
		sprintf(p, "%s%s", num_table[no % 9], type_table[no / 9]);
	}
	else{
		sprintf(p, "%s", type_table[no - 27 + 3]);
	}
}

static int compare_hp(const HAIPOINT *a, const HAIPOINT *b)
{
	double res = a->sc - b->sc;
	if (res < 0){
		return 1;
	}
	else if (res > 0){
		return -1;
	}
	else{
		return 0;
	}
}


TCHAR player_name[] = TEXT(AINAME);

UINT(WINAPI *MJSendMessage)(MahjongAI*, UINT, UINT, UINT);

static int debug_count = 0;

static int compare_int(const int *a, const int *b)
{
	return *a - *b;
}

#define PARAM_MAX (sizeof(param_size)/sizeof(int))

void MahjongAI::initParam(void)
{
	int siz = 1, i;

	for (i = 0; i < PARAM_MAX; i++){
		siz *= param_size[i];
	}

	resultBuf = (int*)malloc(siz*sizeof(int));
	memset(resultBuf, 0x00, siz*sizeof(int));
	current_p = 0;
	size_p = siz;
}

void MahjongAI::destroyParam(void)
{
	if (resultBuf) free(resultBuf);
}

int MahjongAI::getParam(int index)
{
	int i, p = current_p;
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START getParam\n");
#endif

	for (i = 0; i < index; i++){
		p /= param_size[i];
	}

#ifdef AIDUMP_STACKTRACE
	printStackTrace("END getParam\n");
#endif
	return p % param_size[index];
}

void MahjongAI::printResult(int result)
{
	int i;
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START printResult\n");
#endif
	resultBuf[current_p] += 3 - result;
#ifdef AIDUMP_PARAM
	fclose(fp);
	fp = fopen(TEXT("./AIDUMP_COMMAND.csv"),TEXT("w"));
	for(i=0;i<size_p;i++){
		fprintf(fp,"%d,",resultBuf[i]);
	}
	fprintf(fp,"\n");
#endif
	current_p++;
	if (current_p == size_p) current_p = 0;

#ifdef AIDUMP_STACKTRACE
	printStackTrace("END printResult\n");
#endif
}

void MahjongAI::sendComment(int index)
{
	time_t tim = time(NULL);

	if ((tim % 3) == 0){
		MJSendMessage(this, MJMI_FUKIDASHI, (UINT)message_table[index], 0);
	}
}


// v̒Cӂ̔vÄʒuԂ
int MahjongAI::search(int obj, int start, int mask)
{
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START search\n");
#endif
	while (start < (int)state.tehai.tehai_max){
		if (!(mask&(1 << start)) && (int)state.tehai.tehai[start] == obj) break;
		start++;
	}
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END search\n");
#endif
	return start < (int)state.tehai.tehai_max ? start : -1;
}

// v𒲂ׁAzmachiɓB
// ܂Ă邩ǂׂtenpai_flagZbgB
void MahjongAI::set_machi(void)
{
	int i, j, cnt;
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START set_machi\n");
#endif
	(*MJSendMessage)(this, MJMI_GETMACHI, 0, (UINT)machi);
	tenpai_flag = 0;
	for (i = 0; i < 34; i++){
		if (machi[i]) {
			cnt = 0;
			for (j = 0; j < (int)state.tehai.tehai_max; j++) if ((int)state.tehai.tehai[j] == i) cnt++;
			if (cnt + (*MJSendMessage)(this, MJMI_GETVISIBLEHAIS, i, 0) < 4){
				tenpai_flag = 1;
				return;
			}
			tenpai_flag = -1;
		}
	}
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END set_machi\n");
#endif
}

#include "MJ0.h"


// v̕ϐtehaite_cntZbg
void MahjongAI::set_Tehai(int tsumohai)
{
	int i;
	MJ0PARAM param[4];
	MJITehai mjtehai[4];
	MJIKawahai kawahai[4][20];
	UINT dora[8];
	double mentsu1[27 + 34];
	double mentsu2[27 + 34];
	double mentsu3[27 + 34];
	int doralen;

	state.tsumohai = tsumohai;

#ifdef AIDUMP_STACKTRACE
	printStackTrace("START set_Tehai\n");
#endif
	param[0].pTehai = (MJITehai1 *)&mjtehai[0];
	param[1].pTehai = (MJITehai1 *)&mjtehai[1];
	param[2].pTehai = (MJITehai1 *)&mjtehai[2];
	param[3].pTehai = (MJITehai1 *)&mjtehai[3];
	(*MJSendMessage)(this, MJMI_GETTEHAI, 0, (UINT)&mjtehai[0]);
	(*MJSendMessage)(this, MJMI_GETTEHAI, 1, (UINT)&mjtehai[1]);
	(*MJSendMessage)(this, MJMI_GETTEHAI, 2, (UINT)&mjtehai[2]);
	(*MJSendMessage)(this, MJMI_GETTEHAI, 3, (UINT)&mjtehai[3]);
	param[0].pKawahai = &kawahai[0][0];
	param[1].pKawahai = &kawahai[1][0];
	param[2].pKawahai = &kawahai[2][0];
	param[3].pKawahai = &kawahai[3][0];
	param[0].kawalength = (*MJSendMessage)(this, MJMI_GETKAWAEX, (20 << 16) + 0, (UINT)&kawahai[0][0]);
	param[1].kawalength = (*MJSendMessage)(this, MJMI_GETKAWAEX, (20 << 16) + 1, (UINT)&kawahai[1][0]);
	param[2].kawalength = (*MJSendMessage)(this, MJMI_GETKAWAEX, (20 << 16) + 2, (UINT)&kawahai[2][0]);
	param[3].kawalength = (*MJSendMessage)(this, MJMI_GETKAWAEX, (20 << 16) + 3, (UINT)&kawahai[3][0]);

	doralen = (*MJSendMessage)(this, MJMI_GETDORA, (UINT)dora, 0);

#ifdef AIDUMP_STACKTRACE
	printStackTrace("START MJ0\n");
#endif
	MJ0(&param[0], (int*)dora, doralen, state.nokori, state.kikenhai, mentsu1, mentsu2, mentsu3);
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END MJ0\n");
#endif

#ifdef AIDUMP_1
	fprintf(fp,TEXT("<NOKORI>"));

	for(i=0;i<34;i++){
		fprintf(fp,TEXT("[%.1f]"),nokori[i]);
	}

	fprintf(fp,TEXT("</NOKORI>"));
#endif

	(*MJSendMessage)(this, MJMI_GETTEHAI, 0, (UINT)&state.tehai);
#ifdef AIDUMP_COMMAND
	fprintf(fp, TEXT("GET TEHAI\n"));
#endif
	for (i = 0; i < 34; i++) state.te_cnt[i] = 0;
	for (i = 0; i < (int)state.tehai.tehai_max; i++) state.te_cnt[state.tehai.tehai[i]]++;

	doranum = 0;
	for (i = 0; i < doralen; i++){
		doranum += state.te_cnt[dora[i]];
	}
#ifdef AIDUMP_STACKTRACE
	int j;
	printStackTrace("END set_Tehai\n");
	for(i=0;i<(int)tehai.tehai_max;i++) printStackTrace("%d ",tehai.tehai[i]);
	printStackTrace("\n");
	for(i=0;i<doralen;i++) printStackTrace("%d ",dora[i]);
	printStackTrace("\n");
	for(i=0;i<4;i++){
		for(j=0;j<param[i].kawalength;j++){
			printStackTrace("%d ",param[i].pKawahai[j]);
		}
		printStackTrace("\n");
	}
#endif
}


// ̂Ĕv̏
// tsumohai : Ăv
UINT MahjongAI::sutehai_sub(int tsumohai)
{
	int mc[34];
	UINT kawa[30];
	int mcount, mpoint;
	UINT rchk = MJPIR_SUTEHAI;
	int i, j, hai, del_hai, hai_remain, tmp, furiten, kazu;
	int mhai, hais;
	MJITehai tmphai;
	unsigned int seed;

	//  srands(fobO₷邽)
#if 0
	seed = 0xDEADBEEF;
#else
	seed = (unsigned int)time(NULL);
#endif

#ifdef AIDUMP_STACKTRACE
	printStackTrace("START sutehai_sub %d\n",seed);
#endif

	srand(seed);
	debug_count = 0;

	// ݂̎v̏ԂZbg
	if (!state.reach_flag[0])set_Tehai(tsumohai);

	// ݂̑҂v擾
	set_machi();

	// cꍇ́ucv
	if (tsumohai >= 0 && tsumohai < 34) if (machi[tsumohai]) return MJPIR_TSUMO;

	// [`Ăꍇ́uc؂v
	if (state.reach_flag[0]) return MJPIR_SUTEHAI | 13;

	// vŗꍇ͗
	tmp = (*MJSendMessage)(this, MJMI_KKHAIABILITY, 0, 0);

#ifdef AIDUMP_COMMAND
	fprintf(fp, TEXT("KKHAIABILITY %u\n"), tmp);
#endif

	if (tmp) return MJPIR_NAGASHI;

	// cĂvȂA̔v
	if (tsumohai >= 0 && tsumohai < 34) state.te_cnt[tsumohai]++;

	// ̂Ăv߂
	hai = calc_sutehai();
	if (hai < (int)state.tehai.tehai_max) del_hai = state.tehai.tehai[hai]; else del_hai = tsumohai;

#ifdef AIDUMP_POINT
	fprintf(fp,"\n");
#endif

	if (machi[hai]){
	}
	// OŁAepꍇ̓[`悤ȂH
	if (menzen){
		mcount = 0;
		mpoint = 0;
		furiten = 0;
		hais = 0;

		memcpy(&tmphai, &state.tehai, sizeof(tmphai));
		state.te_cnt[del_hai]--;
		tmphai.tehai_max = 0;
		for (i = 0; i < 34; i++){
			for (j = 0; j < state.te_cnt[i]; j++){
				tmphai.tehai[tmphai.tehai_max++] = i;
			}
		}
		state.te_cnt[del_hai]++;

		hai_remain = (*MJSendMessage)(this, MJMI_GETHAIREMAIN, 0, 0);
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("GETHAIREMAIN %u\n"), hai_remain);
#endif
		tenpai_flag = (*MJSendMessage)(this, MJMI_GETMACHI, (UINT)&tmphai, (UINT)mc);
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("GETMACHI %u\n"), tenpai_flag);
#endif
		for (i = 0; i < 34; i++){
			if (mc[i]){
				mcount++;
				tmp = (*MJSendMessage)(this, MJMI_GETVISIBLEHAIS, i, 0);
#ifdef AIDUMP_COMMAND
				fprintf(fp, TEXT("GETVISIBLEHAIS %u\n"), tmp);
#endif
				if (state.te_cnt[i] + tmp < 4 && hai_remain>60){ rchk = MJPIR_REACH; break; }
				hais += 4 - (state.te_cnt[i] + tmp);
				mpoint += (*MJSendMessage)(this, MJMI_GETAGARITEN, (UINT)&tmphai, i);
				mhai = i;
				if (!furiten){
					kazu = (*MJSendMessage)(this, MJMI_GETKAWA, (30 << 16), (UINT)kawa);

					for (j = 0; j < kazu; j++){
						if (mc[kawa[j]]){
							furiten = 1;
							break;
						}
					}
				}

			}
		}

		TCHAR comment[256];
		if (mcount > 0) mpoint /= mcount;

		if (furiten){
			if ((mpoint > 2000 || doranum >= 2) && hais > 4){
				rchk = MJPIR_REACH;
			}
		}
		else{
			if (((mpoint > 1300 && mhai >= 27 && mhai <= 30 && mhai != 27 + state.kaze && mhai != 27 + state.kyoku / 4) || hais > getParam(0))){
				rchk = MJPIR_REACH;
			}

			if ((mpoint > 2000 || doranum >= 2) && hais > 2){
				rchk = MJPIR_REACH;
			}
		}

#ifdef _DEBUG
		sprintf(comment,"mpoint %d,mcount %d,hais %d",mpoint,mcount,hais);

		MJSendMessage(this,MJMI_FUKIDASHI,(UINT)comment,0);
#endif
	}

	// etÕZbg
	if (rchk == MJPIR_REACH){
#ifdef AIDUMP_2
		TCHAR haitext[10];
		TCHAR haitext2[10];
		TCHAR haitext3[10];
		int j;
		fprintf(fp,"<TEHAI>");
		for(i=0;i<34;i++){
			for(j=0;j<te_cnt[i];j++){
				fprintf(fp,"%d ",i);
			}
		}
		fprintf(fp,"</TEHAI>");

		for(i=0;i<14;i++){
			sethaitext(haitext,hp[i].no);

			fprintf(fp,"<SCORE>%s:%.1f,%.1f,%.1f</SCORE>\n",
				haitext,hp[i].sc1,hp[i].sc2,hp[i].scc);
		}

#endif
		state.reach_flag[0] = 1;
	}
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END sutehai_sub\n");
#endif
	return hai | rchk;
}





int MahjongAI::select_Score(double scc_max)
{
	int i;
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START select_Score\n");
#endif

	int rnum = 0;
	int shanten = 0;
	TENPAI_LIST list;

	/* Ve𐔂 */
	shanten = search_tenpai((int*)state.tehai.tehai, state.tehai.tehai_max, NULL, &list, 1, 6);

	if (shanten != 0){
		shanten = list.shanten;
	}
	else{
		shanten = 4;
	}


	/* I邩U߂邩̔f */
	for (i = 1; i < 4; i++){
		if (state.reach_flag[i]) rnum++;
	}


	if (rnum > 0 && rnum + shanten > 2){
		decision = AI_DECISION_ORI;
	}
	else{
		decision = AI_DECISION_AGARI1;
	}



#ifdef AIDUMP_STACKTRACE
	printStackTrace("END select_Score\n");
#endif

	return decision;
}

// ̂Ăv߂
int MahjongAI::calc_sutehai(void)
{
	int i, ret;

	// ̂ĂvĂ݂āAƂ]l̍̂Ƃ
	double sc_max = -DBL_MAX;
	int sh;
	double sc, scc, scc_max = -DBL_MAX;
	int index = 0;
	TCHAR haitext[10];
	TCHAR haitext2[10];
	TCHAR haitext3[10];
	TCHAR comment[512];
	HAIPOINT hp1[14], hp2[14];
	int size1, size2;
	int decision;

#ifdef AIDUMP_STACKTRACE
	printStackTrace("START calc_sutehai\n");
#endif
	memset(hp1, 0, sizeof(hp1));
	memset(hp2, 0, sizeof(hp2));

#ifdef AIDUMP_1
	int j;
	fprintf(fp,"<CALC><TEHAI>");
	for(i=0;i<34;i++){
		for(j=0;j<te_cnt[i];j++){
			fprintf(fp,"%d ",i);
		}
	}
	fprintf(fp,"</TEHAI>");

#endif

	scc_max = ai.evalSutehai(state, hp1, size1);
	kikenhai.evalSutehai(state, hp2, size2);

	decision = select_Score(scc_max);

	if (decision == AI_DECISION_AGARI1){
		memcpy(hp, hp1, sizeof(hp1));
	}
	else{
		memcpy(hp, hp2, sizeof(hp2));
	}

	qsort(hp, size1, sizeof(HAIPOINT), (int(*)(const void*, const void*))compare_hp);

#ifdef _DEBUG
	{
		int max1=-1,max2=-1,max3=-1;
		double maxd1=0,maxd2=0,maxd3=0;
		for(i=0;i<34;i++){
			if(maxd1 < state.nokori[i]){
				maxd3 = maxd2;
				maxd2 = maxd1;
				max3 = max2;
				max2 = max1;
				maxd1 = state.nokori[i];
				max1 = i;
			}else if(maxd2 < state.nokori[i]){
				maxd3 = maxd2;
				max3 = max2;
				maxd2 = state.nokori[i];
				max2 = i;
			}else if(maxd3 < state.nokori[i]){
				maxd3 = state.nokori[i];
				max3 = i;
			}
		}
		sethaitext(haitext,max1);
		sethaitext(haitext2,max2);
		sethaitext(haitext3,max3);

		sprintf(comment,"%s:%.1f %s:%.1f %s:%.1f",
			haitext,maxd1,
			haitext2,maxd2,
			haitext3,maxd3);

		MJSendMessage(this,MJMI_FUKIDASHI,(UINT)comment,0);

	}

	sethaitext(haitext,hp[0].no);
	sethaitext(haitext2,hp[1].no);
	sethaitext(haitext3,hp[2].no);

	sprintf(comment,"%s:%.1f,%.1f\n%s:%.1f,%.1f\n%s:%.1f,%.1f",
		haitext,hp1[0].sc,hp2[0].sc,
		haitext2,hp1[1].sc,hp2[1].sc,
		haitext3,hp1[2].sc,hp2[2].sc);

	MJSendMessage(this,MJMI_FUKIDASHI,(UINT)comment,0);


#endif	

	tehai_score = hp[0].sc;
	ret = search(hp[0].no, 0, 0);
#ifdef AIDUMP_1
	fprintf(fp,"</CALC>");
	fprintf(fp,"<MAX>%d</MAX>",hp1[0].no);
	fprintf(fp,"<RET>%d</RET>",ret);
#endif

#ifdef AIDUMP_STACKTRACE
	printStackTrace("END calc_sutehai\n");
#endif
	return ret >= 0 ? ret : 13;
}

// ̂Ăv߂
int MahjongAI::calc_sutehai_easy(void)
{
	int i, sh;
	HAIPOINT hp[14];
	int size;

	memset(hp, 0, sizeof(hp));
	// ̂ĂvĂ݂āAƂ]l̍̂Ƃ
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START calc_sutehai_easy\n");
#endif
	ai.evalSutehai(state, hp, size);

	qsort(hp, size, sizeof(HAIPOINT), (int(*)(const void*, const void*))compare_hp);
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END calc_sutehai_easy\n");
#endif
	sh = search(hp[0].no, 0, 0);
	return sh;
}


// Ƃł邩ǂׂ
// hai : Ώۂ̔v
// chii_flag : `[ɂĂ`FbN邩ǂ
// return : ȉ̒l̘_a
//		 1 : |ł
//		 2 : Jł
//		 4 : `[Pijł
//		 8 : `[QiEjł
//		16 : `[Rijł
//		32 : ł
int MahjongAI::nakability(int hai, int chii_flag)
{
	int x, i, ret = 0, kazu, furiten;
	UINT kawa[30];
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START nakability\n");
#endif

	if (machi[hai]){
		kazu = (*MJSendMessage)(this, MJMI_GETKAWA, (30 << 16), (UINT)kawa);
		furiten = 0;

		for (i = 0; i < kazu; i++){
			if (machi[kawa[i]]){
				furiten = 1;
				break;
			}
		}

		if (furiten){
#ifdef _DEBUG
			(*MJSendMessage)(this,MJMI_FUKIDASHI,(UINT)TEXT("te"),0);
#endif
		}
		else{
			ret |= 32;
		}
	}
	if (state.reach_flag[0]) return ret;
	if ((*MJSendMessage)(this, MJMI_GETHAIREMAIN, 0, 0) == 0) return ret;
	if ((x = search(hai, 0, 0)) >= 0){
		if (x < (int)state.tehai.tehai_max - 1){
			if ((int)state.tehai.tehai[x + 1] == hai){
				ret |= 1;
				if (x < (int)state.tehai.tehai_max - 2){
					if ((int)state.tehai.tehai[x + 2] == hai) ret |= 2;
				}
			}
		}
	}
	if (chii_flag){
		if (hai < 27){
			kazu = hai % 9;
			if (kazu > 1){
				if (state.te_cnt[hai - 2] > 0 && state.te_cnt[hai - 1] > 0) ret |= 8;
			}
			if (kazu < 7){
				if (state.te_cnt[hai + 2] > 0 && state.te_cnt[hai + 1] > 0) ret |= 4;
			}
			if (kazu > 0 && kazu < 8){
				if (state.te_cnt[hai - 1] > 0 && state.te_cnt[hai + 1] > 0) ret |= 16;
			}
		}
	}
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END nakability\n");
#endif
	return ret;
}

int MahjongAI::tehai2Array(int *p)
{
	int size = 0;
	int i, j;
#ifdef AIDUMP_STACKTRACE
	printStackTrace("START tehai2Array\n");
#endif

	for (i = 0; i < 34; i++){
		for (j = 0; j < state.te_cnt[i]; j++){
			p[size++] = i;
		}
	}

#ifdef AIDUMP_STACKTRACE
	printStackTrace("END tehai2Array\n");
#endif
	return size;
}

// Ƃ̎̂Ĕvɑ΂ANV߂
// no : ꂪ̂Ă
// hai : ̂Ă
// return : ANV
UINT MahjongAI::koe_req(int no, int hai)
{
	int chii_flag;
	int naki_ok;
	int hanpai;
	UINT tmp;
	UINT dora[8];
	int doralen;
	int doraflag;
	int i;
	int tmptehai[14];
	int tehaisize;
	int prevshanten;
	int nextshanten;
	TENPAI_LIST list;
	int sthai;

#ifdef AIDUMP_STACKTRACE
	printStackTrace("START koe_req\n");
#endif
	doralen = (*MJSendMessage)(this, MJMI_GETDORA, (UINT)dora, 0);
	set_Tehai(-1);
	set_machi();
	chii_flag = (no == 3);
	naki_ok = nakability(hai, chii_flag);
	if (!naki_ok) return 0;
	if (naki_ok & 32){
		tmp = (*MJSendMessage)(this, MJMI_GETAGARITEN, 0, hai);
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("GETAGARITEN %u\n"), tmp);
#endif
		if (tmp > 0) {
			return MJPIR_RON;
		}
	}

	/* epC܂̓IĂ΂͖Ȃ */
	if (tenpai_flag == 1 || decision == AI_DECISION_ORI) return 0;
	sthai = -1;

	hanpai = 0;
	for (i = 27; i < 34; i++){
		if ((state.te_cnt[i] >= 3) && (i >= 31 || i - 27 == state.cha || i - 27 == state.kaze)){
			hanpai++;
		}
	}

	tehaisize = tehai2Array(tmptehai);
	/* Ve𐔂 */
	prevshanten = search_tenpai(tmptehai, tehaisize, NULL, &list, 1, 6);

	if (prevshanten != 0){
		prevshanten = list.shanten;
	}
	else{
		prevshanten = 6;
	}

	if (naki_ok & 1){
		if (menzen == 0){
			if (state.te_cnt[hai] == 2){
				state.te_cnt[hai] -= 2;
				sthai = calc_sutehai_easy();
				state.te_cnt[sthai]--;
				tehaisize = tehai2Array(tmptehai);
				state.te_cnt[sthai]++;
				state.te_cnt[hai] += 2;
				/* Ve𐔂 */
				nextshanten = search_tenpai(tmptehai, tehaisize, NULL, &list, 1, 6);

				if (nextshanten != 0){
					nextshanten = list.shanten;
				}
				else{
					nextshanten = 6;
				}

				if (nextshanten < prevshanten) return MJPIR_PON;
			}

		}
		if (hai >= 27){

			if (state.te_cnt[hai] == 2){
				if ((doranum >= 2) && (hai >= 31 || hai - 27 == state.cha || hai - 27 == state.kaze)){
					return MJPIR_PON;
				}
			}
		}
		else {
			doraflag = 0;

			for (i = 0; i < doralen; i++){
				if (dora[i] == hai){
					doraflag = 1;
					break;
				}
			}

			if (hanpai > 0 && doraflag >= 0){
				return MJPIR_PON;
			}

		}
	}

	if (naki_ok & 4){
		state.te_cnt[hai + 1]--;
		state.te_cnt[hai + 2]--;
		sthai = calc_sutehai_easy();
		state.te_cnt[sthai]--;
		tehaisize = tehai2Array(tmptehai);
		state.te_cnt[sthai]++;
		state.te_cnt[hai + 1]++;
		state.te_cnt[hai + 2]++;
		/* Ve𐔂 */
		nextshanten = search_tenpai(tmptehai, tehaisize, NULL, &list, 1, 6);

		if (nextshanten != 0){
			nextshanten = list.shanten;
		}
		else{
			nextshanten = 6;
		}

		if (nextshanten < prevshanten && (menzen == 0 || hanpai)) return MJPIR_CHII1;
	}
	if (naki_ok & 8){
		state.te_cnt[hai - 1]--;
		state.te_cnt[hai - 2]--;
		sthai = calc_sutehai_easy();
		state.te_cnt[sthai]--;
		tehaisize = tehai2Array(tmptehai);
		state.te_cnt[sthai]++;
		state.te_cnt[hai - 1]++;
		state.te_cnt[hai - 2]++;
		/* Ve𐔂 */
		nextshanten = search_tenpai(tmptehai, tehaisize, NULL, &list, 1, 6);

		if (nextshanten != 0){
			nextshanten = list.shanten;
		}
		else{
			nextshanten = 6;
		}

		if (nextshanten < prevshanten && (menzen == 0 || hanpai)) return MJPIR_CHII2;
	}
	if (naki_ok & 16){
		state.te_cnt[hai + 1]--;
		state.te_cnt[hai - 1]--;
		sthai = calc_sutehai_easy();
		state.te_cnt[sthai]--;
		tehaisize = tehai2Array(tmptehai);
		state.te_cnt[sthai]++;
		state.te_cnt[hai + 1]++;
		state.te_cnt[hai - 1]++;
		/* Ve𐔂 */
#ifdef AIDUMP_STACKTRACE
		printStackTrace("START search_tenpai\n");
#endif
		nextshanten = search_tenpai(tmptehai, tehaisize, NULL, &list, 1, 6);
#ifdef AIDUMP_STACKTRACE
		printStackTrace("END search_tenpai\n");
#endif

		if (nextshanten != 0){
			nextshanten = list.shanten;
		}
		else{
			nextshanten = 6;
		}

		if (nextshanten < prevshanten && (menzen == 0 || hanpai)) return MJPIR_CHII3;
	}
#ifdef AIDUMP_STACKTRACE
	printStackTrace("END koe_req\n");
#endif
	return 0;
}

// ǊJn̏
// k : 
// c : 
UINT MahjongAI::on_start_kyoku(int k, int c)
{
	int i, j, sc_max = 0, mysc;

#ifdef AIDUMP_STACKTRACE
	printStackTrace("START on_start_kyoku\n");
#endif
	kyokustate = AI_KYOKUSTS_NORMAL;
	decision = AI_DECISION_AGARI1;
	//set_Tehai();
	for (i = 0; i < 34; i++) {
		for (j = 0; j < 4; j++) state.anpai[i][j] = 0;
	}
	state.kyoku = k;
	state.kaze = state.kyoku / 4;
	state.cha = c;
	menzen = 1;
	nakiok_flag = 0;
	jun = 0;
	sthai = -1;
	for (i = 0; i < 4; i++){
		state.reach_flag[i] = 0;
		state.ippatsu_flag[i] = 0;
	}
	//tehai_score = eval_Tehai(0);
	//set_machi();

	mysc = (*MJSendMessage)(this, MJMI_GETSCORE, 0, 0);

	for (i = 1; i<4; i++){
		j = (*MJSendMessage)(this, MJMI_GETSCORE, i, 0);
		if (j > sc_max) sc_max = j;
	}

	if (k > 4 && sc_max - mysc > 20000){
		sendComment(AI_MESSAGE_TSUYOGARI);
	}

#ifdef AIDUMP_STACKTRACE
	printStackTrace("END on_start_kyoku\n");
#endif
	return 0;
}

// ǏȈ
// reason : IR
// inc_sc : _̕ω
UINT MahjongAI::on_end_kyoku(UINT reason, LONG* inc_sc)
{
	int sc = *inc_sc;

	switch (kyokustate){
	case AI_KYOKUSTS_TSUMO:
		if (sc < 4000){
			sendComment(AI_MESSAGE_TSUMOLITTLE);
		}
		else if (sc < 16000){
			sendComment(AI_MESSAGE_TSUMOMIDDLE);
		}
		else{
			sendComment(AI_MESSAGE_TSUMOBIG);
		}
		break;
	case AI_KYOKUSTS_RON:
		if (sc < 4000){
			sendComment(AI_MESSAGE_RONLITTLE);
		}
		else if (sc < 16000){
			sendComment(AI_MESSAGE_RONMIDDLE);
		}
		else{
			sendComment(AI_MESSAGE_RONBIG);
		}
		break;
	case AI_KYOKUSTS_TEKIAGARI:
		if (sc > -2000){
			sendComment(AI_MESSAGE_TEKIAGARILITTLE);
		}
		else if (sc > -6000){
			sendComment(AI_MESSAGE_TEKIAGARIMIDDLE);
		}
		else{
			sendComment(AI_MESSAGE_TEKIAGARIBIG);
		}
		break;
	case AI_KYOKUSTS_FURIKOMI:
		if (sc > -4000){
			sendComment(AI_MESSAGE_FURIKOMILITTLE);
		}
		else if (sc > -16000){
			sendComment(AI_MESSAGE_FURIKOMIMIDDLE);
		}
		else{
			sendComment(AI_MESSAGE_FURIKOMIBIG);
		}
		break;
	default:
		break;
	}

	return 0;
}

// ANVɑ΂鉞
UINT MahjongAI::on_action(int player, int taishou, UINT action)
{
	int hai = action & 63;

	if (action & MJPIR_REACH){
		state.reach_flag[player] = 1;
		state.ippatsu_flag[player] = 1;
		if (player == 0){
			sendComment(AI_MESSAGE_RIICHI);
		}
	}
	else{
		state.ippatsu_flag[player] = 0;
	}

	if (action & MJPIR_TSUMO){
		if (player == 0){
			kyokustate = AI_KYOKUSTS_TSUMO;
		}
		else{
			kyokustate = AI_KYOKUSTS_TEKIAGARI;
		}
	}
	if (action & (MJPIR_SUTEHAI | MJPIR_REACH)){
		state.anpai[hai][player] = 1;
		for (int i = 0; i < 4; i++) if (state.reach_flag[i]) state.anpai[hai][i] = 1;
		if (player == 0) return 0;
		return koe_req(player, hai);
	}
	if (action & MJPIR_RON){
		if (player == 0){
			kyokustate = AI_KYOKUSTS_RON;
		}
		else if (taishou == 0){
#ifdef AIDUMP_1
			fprintf(fp,"<FURIKOMI/>");
#endif
			kyokustate = AI_KYOKUSTS_FURIKOMI;
		}
		else{
			kyokustate = AI_KYOKUSTS_TEKIAGARI;
		}
	}
	if ((action & MJPIR_PON) && player == 0){
		nakiok_flag = 1;
		menzen = 0;
		sendComment(AI_MESSAGE_PON);
	}
	if ((action & MJPIR_CHII1) && player == 0){
		menzen = 0;
		sendComment(AI_MESSAGE_TII);
	}
	if ((action & MJPIR_CHII2) && player == 0){
		menzen = 0;
		sendComment(AI_MESSAGE_TII);
	}
	if ((action & MJPIR_CHII3) && player == 0){
		menzen = 0;
		sendComment(AI_MESSAGE_TII);
	}
	if ((action & MJPIR_MINKAN) && player == 0){
		menzen = 0;
		sendComment(AI_MESSAGE_PON);
	}
	return 0;
}

// Jn̏
UINT MahjongAI::on_start_game(void)
{
	return 0;
}

// Ȉ
// rank : 
// score : _
UINT MahjongAI::on_end_game(int rank, LONG score)
{
	/*char str[40];
	sprintf(str,"%d_A%dʂc",score,rank+1);
	(*MJSendMessage)(this,MJMI_FUKIDASHI,(UINT)str,0);*/
	return 0;
}

// rQ̏
// state : ̂Ƃ̏
// option : ԂɊ֘Ađ
UINT MahjongAI::on_exchange(UINT ex_state, UINT option)
{
	if (ex_state == MJST_INKYOKU){
		int i, j, k, size;
		HAIPOINT hp[14];
		set_Tehai(-1);
		for (i = 0; i < 34; i++) {
			for (j = 0; j < 4; j++) state.anpai[i][j] = 0;
		}
		for (i = 0; i < 4; i++){
			state.reach_flag[i] = 0;
			state.ippatsu_flag[i] = 0;
		}

		MJIKawahai kawa[30];
		for (i = 0; i < 4; i++){
			k = (*MJSendMessage)(this, MJMI_GETKAWAEX, MAKELPARAM(i, 30), (UINT)kawa);
			state.reach_flag[i] = 0;
			for (j = 0; j < k; j++){
				state.anpai[kawa[j].hai & 63][i] = 1;
				if (kawa[j].state&MJKS_REACH) state.reach_flag[i] = 1;
			}
		}

		state.kyoku = LOWORD(option);
		state.kaze = state.kyoku / 4;
		state.cha = HIWORD(option);
		menzen = state.tehai.minshun_max + state.tehai.minkan_max + state.tehai.minkou_max == 0;
		nakiok_flag = !menzen;
		sthai = -1;
		tehai_score = ai.evalSutehai(state, hp, size);
		set_machi();
	}
	return 0;
}

// CX^Xp̃C^[tF[X֐
UINT MahjongAI::InterfaceFunc(UINT message, UINT param1, UINT param2)
{
	UINT ret = MJR_NOTCARED;
#ifdef AIDUMP
	fp = fopen(TEXT("./AIDUMP_COMMAND.xml"), TEXT("a"));
#endif
	MahjongScoreAI::pObj = this;
	MahjongScoreAI::pMJSendMessage = (UINT(WINAPI *)(void*, UINT, UINT, UINT))MJSendMessage;

	switch (message){
		//	case MJPI_DEBUG:
		//			return type4.getDebugInt();
	case MJPI_SUTEHAI:
		jun++;
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("SUTEHAI %u\n"), param1);
#endif
		ret = sutehai_sub(LOWORD(param1));
		break;
	case MJPI_ONACTION:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("ONACTION %u %u\n"), param1, param2);
#endif
		ret = on_action(LOWORD(param1), HIWORD(param1), param2);
		break;
	case MJPI_STARTKYOKU:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("STARTKYOKU %u %u\n"), param1, param2);
#endif
		ret = on_start_kyoku(LOWORD(param1), LOWORD(param2));
		break;
	case MJPI_ENDKYOKU:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("ENDKYOKU %u %u\n"), param1, param2);
#endif
#ifdef AIDUMP_STACKTRACE
		remove(TEXT("./stacktrace.txt"));
#endif
		ret = on_end_kyoku(param1, (LONG*)param2);
		break;
	case MJPI_STARTGAME:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("STARTGAME\n"));
#endif
		ret = on_start_game();
		break;
	case MJPI_ENDGAME:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("ENDGAME %u %u\n"), param1, param2);
#endif
		ret = on_end_game(LOWORD(param1), (LONG)param2);
		printResult(LOWORD(param1));
		break;
	case MJPI_ONEXCHANGE:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("ONEXCHANGE %u %u\n"), param1, param2);
#endif
		ret = on_exchange(LOWORD(param1), param2);
		break;
	case MJPI_CREATEINSTANCE:
		ret = sizeof(MahjongAI);
		break;
	case MJPI_INITIALIZE:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("INITIALIZE\n"));
#endif
		MJSendMessage = (UINT(WINAPI *)(MahjongAI*, UINT, UINT, UINT))param2;
		initParam();
		ret = 0;
		break;
	case MJPI_YOURNAME:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("YOUENAME\n"));
#endif
		ret = (UINT)player_name;
		break;
	case MJPI_DESTROY:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("DESTROY\n"));
#endif
		destroyParam();
		ret = 0;
		break;
	case MJPI_ISEXCHANGEABLE:
#ifdef AIDUMP_COMMAND
		fprintf(fp, TEXT("ISEXCHANGEABLE\n"));
#endif
		ret = 0; // rQɑΉBΉȂꍇ0ȊOɂB
		break;
	}

#ifdef AIDUMP
	fclose(fp);
#endif
	return ret;
}

// C^[tF[X֐
extern "C" UINT WINAPI MJPInterfaceFunc(MahjongAI* inst, UINT message, UINT param1, UINT param2)
{
	if (inst) return inst->InterfaceFunc(message, param1, param2);
	switch (message){
	case MJPI_CREATEINSTANCE:
		return sizeof(MahjongAI);
	case MJPI_INITIALIZE:
		MJSendMessage = (UINT(WINAPI *)(MahjongAI*, UINT, UINT, UINT))param2;
		MahjongScoreAI::pMJSendMessage = (UINT(WINAPI *)(void*, UINT, UINT, UINT))param2;
		return 0;
	case MJPI_YOURNAME:
		return (UINT)player_name;
	case MJPI_DESTROY:
		return 0;
	case MJPI_ISEXCHANGEABLE:
		return 0; // rQɑΉBΉȂꍇ0ȊOɂB
	}
	return MJR_NOTCARED;
}
