/****************************************************************************************
 * Copyright (c) 2010, Takaya Kakizaki(kacky)
 * All rights reserved.

  \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B 

  E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 

  EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 

  Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁAI[v̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB


  {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸A
  ƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B
  쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩
  iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔ
  i֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳Ȃj
  ڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B 

****************************************************************************************/
// Pai.cpp: CPai NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pai.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

OMPai::OMPai()
{
	m_iCategory = -1;
	m_iNo = -1;
	m_iId = -1;
	m_bTsumogiri = FALSE;
	m_bRiichi = FALSE;
	m_bNaki = FALSE;
	m_bLast = FALSE;

}

OMPai::~OMPai()
{

}

void OMPai::parseXML(OMDomNode pElem)
{
        OMDomNode pNode;

        pNode = OMGetElement(pElem,_T(TAG_CATEGORY));

        OMToNum(pNode,m_iCategory);

        pNode = OMGetElement(pElem,_T(TAG_NO));

        OMToNum(pNode,m_iNo);

        pNode = OMGetElement(pElem,_T(TAG_ID));

        OMToNum(pNode,m_iId);

        pNode = OMGetElement(pElem,_T(TAG_TSUMOGIRI));

        OMToBool(pNode,m_bTsumogiri);

        pNode = OMGetElement(pElem,_T(TAG_RIICHI));

        OMToBool(pNode,m_bRiichi);

}

OMPai::operator UINT()
{
	if(m_iCategory < 0) return PAI_NOTINIT;
	else if(m_iCategory == 0 && m_iNo == 0) return PAI_NIL;
	else return (m_iCategory - 1) * 9 + (m_iNo - 1);
}

void OMPai::getName(OMString& text)
{
	const TCHAR *table[] = {_T(""),_T(""),_T("O"),_T("l"),_T(""),_T("Z"),_T(""),_T(""),_T("")};
	const TCHAR *table2[] = {_T(""),_T(""),_T(""),_T("k"),_T(""),_T(""),_T("")};
	text = _T("");

	switch(m_iCategory){
	case PAI_MANZU:
		text += table[m_iNo - 1];
		text += _T("");
		break;
	case PAI_SOUZU:
		text += table[m_iNo - 1];
		text += _T("");
		break;
	case PAI_PINZU:
		text += table[m_iNo - 1];
		text += _T("");
		break;
	case PAI_ZIHAI:
		text += table2[m_iNo - 1];
		break;
	default:
		break;
	}

	if(m_bTsumogiri){
		text += _T("*");
	}
	if(m_bRiichi){
		text += _T("#");
	}

}

void OMPai::getDora(OMPai& dora)
{
	dora.m_iCategory = m_iCategory;

	if(m_iCategory == PAI_ZIHAI){
		if(m_iNo == 4){
			dora.m_iNo = 1;
		}else if(m_iNo == 7){
			dora.m_iNo = 5;
		}else{
			dora.m_iNo = m_iNo + 1;
		}
	}else{
		if(m_iNo == 9){
			dora.m_iNo = 1;
		}else{
			dora.m_iNo = m_iNo + 1;
		}
	}

}

void OMPai::set(UINT id)
{
	m_iCategory = ((id & 0x3F)/ 9) + 1;
	m_iNo = ((id & 0x3F) % 9) + 1;
}

BOOL OMPai::match(OMPai& pai)
{
	if(m_iCategory == pai.m_iCategory && m_iNo == pai.m_iNo && m_iId == pai.m_iId){
		return TRUE;
	}else{
		return FALSE;
	}
}

BOOL OMPai::isAka(OMRule& rule)
{
	if(rule.m_iAka == 1){
		if(m_iNo == 5 && m_iId == 4 && m_iCategory != PAI_ZIHAI){
			return TRUE;
		}
	}else if(rule.m_iAka == 2){
		if(m_iNo == 5 && m_iId == 4 && m_iCategory != PAI_ZIHAI){
			return TRUE;
		}

		if(m_iCategory == PAI_PINZU && m_iNo == 5 && m_iId == 3){
			return TRUE;
		}
    }else if(rule.m_iAka == 3) {
        if(m_iId == 4){
            return TRUE;
        }
    }

	return FALSE;

}

int OMPai::operator >=(OMPai& pai)
{
	if((UINT)pai == PAI_NIL) return FALSE;
	if((UINT)*this == PAI_NIL) return TRUE;
	if(m_iCategory > pai.m_iCategory){
		return TRUE;
	}else if(m_iCategory == pai.m_iCategory){
		if(m_iNo > pai.m_iNo){
			return TRUE;
		}else if(m_iNo == pai.m_iNo){
			if(m_iId >= pai.m_iId){
				return TRUE;
			}
		}
	}

	return FALSE;
}

bool OMPai::operator ==(OMPai& pai)
{
        if(m_iCategory == pai.m_iCategory && m_iNo == pai.m_iNo && m_iId == pai.m_iId){
            return true;
        }else{
            return false;
        }
}

void OMPai::toPaiString(OMString &str,OMRule &rule)
{
    UINT num;
    static const char *haigaNameTbl[] = {
        "ton","nan","sha","pei","haku","hatu","tyun","ura"
    };

    num = (UINT)*this;

    if(isAka(rule)){
        num += 35;
    }

    if(num < 9) {
        str.sprintf("man%d",num + 1);
    }else if(num < 18) {
        str.sprintf("pin%d",(num % 9) + 1);
    }else if(num < 27) {
        str.sprintf("sou%d",(num % 9) + 1);
    }else if(num < 35) {
        str.sprintf("%s",haigaNameTbl[(num % 9)]);
    }else if(num < 44) {
        str.sprintf("manred%d",((num - 35) % 9) + 1);
    }else if(num < 53) {
        str.sprintf("pinred%d",((num - 35) % 9) + 1);
    }else if(num < 62) {
        str.sprintf("soured%d",((num - 35) % 9) + 1);
    }else if(num < 68) {
        str.sprintf("%sred",haigaNameTbl[(num - 35) % 9]);
    }else{
        str = "tyun";
    }


}
