<?php
/**
 * @copyright 2005-2008 OpenPNE Project
 * @license   http://www.php.net/license/3_01.txt PHP License 3.01
 */

require_once 'OpenPNE/KtaiUA.php';
require_once 'OpenPNE/KtaiEmoji/Common.php';
require_once 'OpenPNE/KtaiEmoji/Docomo.php';
require_once 'OpenPNE/KtaiEmoji/Au.php';
require_once 'OpenPNE/KtaiEmoji/Softbank.php';
require_once 'OpenPNE/KtaiEmoji/Img.php';

class OpenPNE_KtaiEmoji
{
    //変換テーブル
    var $relation_list;

    /**
     * constructor
     */
    function OpenPNE_KtaiEmoji()
    {
        //変換リスト
        //Docomo => SoftBank
        $this->relation_list['i']['s'] = array(
            1 => '[s:74]',
            2 => '[s:73]',
            3 => '[s:75]',
            4 => '[s:72]',
            5 => '[s:151]',
            6 => '[s:414]',
            7 => '［霧］',
            8 => '[s:407]',
            9 => '[s:243]',
            10 => '[s:244]',
            11 => '[s:245]',
            12 => '[s:246]',
            13 => '[s:247]',
            14 => '[s:248]',
            15 => '[s:249]',
            16 => '[s:250]',
            17 => '[s:251]',
            18 => '[s:252]',
            19 => '[s:253]',
            20 => '[s:254]',
            21 => '〓',
            22 => '[s:22]',
            23 => '[s:20]',
            24 => '[s:21]',
            25 => '[s:24]',
            26 => '[s:19]',
            27 => '[s:389]',
            28 => '[s:140]',
            29 => '［ポケベル］',
            30 => '[s:30]',
            31 => '[s:399]',
            32 => '[s:400]',
            33 => '[s:27]',
            34 => '[s:393]',
            35 => '[s:179]',
            36 => '[s:182]',
            37 => '[s:29]',
            38 => '[s:54]',
            39 => '[s:56]',
            40 => '[s:173]',
            41 => '[s:175]',
            42 => '[s:167]',
            43 => '[s:174]',
            44 => '[s:178]',
            45 => '[s:176]',
            46 => '[s:58]',
            47 => '[s:169]',
            48 => '[s:168]',
            49 => '[s:171]',
            50 => '[s:67]',
            51 => '[s:69]',
            52 => '[s:68]',
            53 => '[s:71]',
            54 => '[s:122]',
            55 => '[s:152]',
            56 => '[s:289]',
            57 => '[s:60]',
            58 => '[s:61]',
            59 => '[s:234]',
            60 => '〓',
            61 => '[s:280]',
            62 => '[s:425]',
            63 => '[s:426]',
            64 => '〓',
            65 => '[s:127]',
            66 => '[s:284]',
            67 => '[s:188]',
            68 => '[s:8]',
            69 => '[s:305]',
            70 => '[s:162]',
            71 => '[s:290]',
            72 => '[s:108]',
            73 => '[s:345]',
            74 => '[s:9]',
            75 => '[s:10]',
            76 => '[s:271]',
            77 => '[s:132]',
            78 => '［ゲーム］',
            79 => '[s:128]',
            80 => '[s:192]',
            81 => '[s:194]',
            82 => '[s:193]',
            83 => '[s:195]',
            84 => '[s:372]',
            85 => '[s:374]',
            86 => '[s:16]',
            87 => '[s:17]',
            88 => '[s:18]',
            89 => '[s:236]',
            90 => '[s:235]',
            91 => '[s:477]',
            92 => '[s:7]',
            93 => '［メガネ］',
            94 => '[s:190]',
            95 => '●',
            96 => '[s:76]',
            97 => '[s:76]',
            98 => '[s:76]',
            99 => '○',
            100 => '[s:82]',
            101 => '[s:79]',
            102 => '[s:28]',
            103 => '[s:51]',
            104 => '[s:237]',
            105 => '[s:94]',
            106 => '[s:93]',
            107 => '[s:11]',
            108 => '［ｉモード］',
            109 => '［ｉモード］',
            110 => '[s:93]',
            111 => '［ドコモ］',
            112 => '［ドコモポイント］',
            113 => '￥',
            114 => '［ＦＲＥＥ］',
            115 => '[s:221]',
            116 => '[s:63]',
            117 => '〓',
            118 => '［ＣＬ］',
            119 => '[s:110]',
            120 => '[s:198]',
            121 => '〓',
            122 => '[s:197]',
            123 => '[s:196]',
            124 => '［Ｑ］',
            125 => '[s:208]',
            126 => '[s:209]',
            127 => '[s:210]',
            128 => '[s:211]',
            129 => '[s:212]',
            130 => '[s:213]',
            131 => '[s:214]',
            132 => '[s:215]',
            133 => '[s:216]',
            134 => '[s:217]',
            135 => '[s:257]',
            136 => '[s:34]',
            137 => '[s:309]',
            138 => '[s:35]',
            139 => '[s:309]',
            140 => '[s:87]',
            141 => '[s:89]',
            142 => '[s:88]',
            143 => '[s:354]',
            144 => '[s:353]',
            145 => '[s:234]',
            146 => '[s:62]',
            147 => '[s:125]',
            148 => '〓',
            149 => '[s:3]',
            150 => '[s:316]',
            151 => '[s:105]',
            152 => '[s:322]',
            153 => '[s:13]',
            154 => '[s:287]',
            155 => '[s:308]',
            156 => '[s:236]',
            157 => '[s:150]',
            158 => '[s:33]',
            159 => '！？',
            160 => '！！',
            161 => '〓',
            162 => '[s:319]',
            163 => '[s:319]',
            164 => '[s:318]',
            165 => '〓',
            166 => '〓',
            167 => '[s:306]',
            168 => '［ふくろ］',
            169 => '［ペン］',
            170 => '〓',
            171 => '[s:121]',
            172 => '[s:422]',
            173 => '［ＳＯＯＮ］',
            174 => '［ＯＮ］',
            175 => '［ｅｎｄ］',
            176 => '[s:45]',
            177 => '［ｉアプリ］',
            178 => '［ｉアプリ］',
            179 => '[s:6]',
            180 => '［財布］',
            181 => '[s:298]',
            182 => '［ジーンズ］',
            183 => '［スノボ］',
            184 => '[s:307]',
            185 => '［ドア］',
            186 => '[s:137]',
            187 => '[s:12]',
            188 => '[s:93][s:310]',
            189 => '［レンチ］',
            190 => '[s:271]',
            191 => '[s:104]',
            192 => '[s:52]',
            193 => '［砂時計］',
            194 => '[s:144]',
            195 => '[s:326]',
            196 => '［腕時計］',
            197 => '[s:350]',
            198 => '[s:357]',
            199 => '[s:368][s:319]',
            200 => '[s:98]',
            201 => '[s:369]',
            202 => '[s:361]',
            203 => '[s:96]',
            204 => '[s:14]',
            205 => '[s:95]',
            206 => '[s:352]',
            207 => '[s:357]',
            208 => '[s:353]',
            209 => '[s:349]',
            210 => '[s:364]',
            211 => '[s:366]',
            212 => '［ＮＧ］',
            213 => '［クリップ］',
            214 => '[s:258]',
            215 => '[s:478]',
            216 => '[s:111]',
            217 => '[s:291]',
            218 => '〓',
            219 => '[s:259]',
            220 => '[s:262]',
            221 => '［禁］',
            222 => '[s:223]',
            223 => '［合］',
            224 => '[s:222]',
            225 => '⇔',
            226 => '↑↓',
            227 => '[s:177]',
            228 => '[s:409]',
            229 => '[s:59]',
            230 => '[s:106]',
            231 => '［チェリー］',
            232 => '[s:274]',
            233 => '［バナナ］',
            234 => '[s:339]',
            235 => '[s:106]',
            236 => '[s:114]',
            237 => '[s:48]',
            238 => '[s:336]',
            239 => '[s:70]',
            240 => '[s:281]',
            241 => '[s:334]',
            242 => '[s:327]',
            243 => '［カタツムリ］',
            244 => '[s:458]',
            245 => '[s:85]',
            246 => '[s:25]',
            247 => '[s:86]',
            248 => '[s:351]',
            249 => '[s:26]',
            250 => '[s:101]',
            251 => '[s:68]',
            252 => '[s:97]',
        );
        //Docomo => AU
        $this->relation_list['i']['e'] = array(
            1 => '[e:44]',
            2 => '[e:107]',
            3 => '[e:95]',
            4 => '[e:191]',
            5 => '[e:16]',
            6 => '[e:190]',
            7 => '[e:305]',
            8 => '[e:481]',
            9 => '[e:192]',
            10 => '[e:193]',
            11 => '[e:194]',
            12 => '[e:195]',
            13 => '[e:196]',
            14 => '[e:197]',
            15 => '[e:198]',
            16 => '[e:199]',
            17 => '[e:200]',
            18 => '[e:201]',
            19 => '[e:202]',
            20 => '[e:203]',
            21 => '〓',
            22 => '[e:45]',
            23 => '[e:306]',
            24 => '[e:220]',
            25 => '[e:219]',
            26 => '[e:421]',
            27 => '[e:307]',
            28 => '[e:222]',
            29 => '[e:308]',
            30 => '[e:172]',
            31 => '[e:341]',
            32 => '[e:217]',
            33 => '[e:125]',
            34 => '[e:125]',
            35 => '[e:216]',
            36 => '[e:379]',
            37 => '[e:168]',
            38 => '[e:112]',
            39 => '[e:156]',
            40 => '[e:375]',
            41 => '[e:376]',
            42 => '[e:212]',
            43 => '[e:205]',
            44 => '[e:378]',
            45 => '[e:206]',
            46 => '[e:213]',
            47 => '[e:208]',
            48 => '[e:99]',
            49 => '[e:207]',
            50 => '[e:146]',
            51 => '[e:93]',
            52 => '[e:52]',
            53 => '[e:65]',
            54 => '[e:245]',
            55 => '[e:124]',
            56 => '[e:104]',
            57 => '[e:289]',
            58 => '[e:110]',
            59 => '[e:70]',
            60 => '〓',
            61 => '[e:294]',
            62 => '[e:309]',
            63 => '[e:494]',
            64 => '[e:311]',
            65 => '[e:106]',
            66 => '[e:176]',
            67 => '[e:177]',
            68 => '[e:94]',
            69 => '[e:83]',
            70 => '[e:122]',
            71 => '[e:312]',
            72 => '[e:144]',
            73 => '[e:313]',
            74 => '[e:85]',
            75 => '[e:161]',
            76 => '[e:395]',
            77 => '[e:288]',
            78 => '[e:232]',
            79 => '[e:300]',
            80 => '[e:414]',
            81 => '[e:314]',
            82 => '[e:315]',
            83 => '[e:316]',
            84 => '[e:317]',
            85 => '[e:318]',
            86 => '[e:817]',
            87 => '[e:319]',
            88 => '[e:320]',
            89 => '[e:43]',
            90 => '[e:42]',
            91 => '[e:728]',
            92 => '[e:729]',
            93 => '[e:116]',
            94 => '[e:178]',
            95 => '[e:321]',
            96 => '[e:322]',
            97 => '[e:323]',
            98 => '[e:15]',
            99 => '○',
            100 => '[e:134]',
            101 => '[e:251]',
            102 => '[e:169]',
            103 => '[e:234]',
            104 => '[e:71]',
            105 => '[e:513]',
            106 => '[e:784]',
            107 => '[e:166]',
            108 => '［ｉモード］',
            109 => '［ｉモード］',
            110 => '[e:108]',
            111 => '［ドコモ］',
            112 => '［ドコモポイント］',
            113 => '[e:109]',
            114 => '[e:299]',
            115 => '[e:385]',
            116 => '[e:120]',
            117 => '[e:118]',
            118 => '[e:324]',
            119 => '[e:119]',
            120 => '[e:334]',
            121 => '[e:730]',
            122 => '［フリーダイヤル］',
            123 => '[e:818]',
            124 => '[e:4]',
            125 => '[e:180]',
            126 => '[e:181]',
            127 => '[e:182]',
            128 => '[e:183]',
            129 => '[e:184]',
            130 => '[e:185]',
            131 => '[e:186]',
            132 => '[e:187]',
            133 => '[e:188]',
            134 => '[e:325]',
            135 => '[e:326]',
            136 => '[e:51]',
            137 => '[e:803]',
            138 => '[e:265]',
            139 => '[e:266]',
            140 => '[e:257]',
            141 => '[e:258]',
            142 => '[e:441]',
            143 => '[e:444]',
            144 => '[e:327]',
            145 => '[e:731]',
            146 => '[e:343]',
            147 => '[e:224]',
            148 => '〓',
            149 => '[e:273]',
            150 => '[e:420]',
            151 => '[e:77]',
            152 => '[e:262]',
            153 => '[e:281]',
            154 => '[e:268]',
            155 => '[e:291]',
            156 => '[e:732]',
            157 => '[e:261]',
            158 => '[e:2]',
            159 => '[e:733]',
            160 => '[e:734]',
            161 => '[e:329]',
            162 => '[e:330]',
            163 => '[e:263]',
            164 => '[e:282]',
            165 => '〓',
            166 => '[e:735]',
            167 => '[e:226]',
            168 => '［ふくろ］',
            169 => '[e:508]',
            170 => '〓',
            171 => '［いす］',
            172 => '[e:490]',
            173 => '［ＳＯＯＮ］',
            174 => '［ＯＮ］',
            175 => '［ｅｎｄ］',
            176 => '[e:46]',
            177 => '［ｉアプリ］',
            178 => '［ｉアプリ］',
            179 => '[e:335]',
            180 => '[e:290]',
            181 => '[e:295]',
            182 => '[e:805]',
            183 => '[e:221]',
            184 => '[e:48]',
            185 => '［ドア］',
            186 => '[e:233]',
            187 => '[e:337]',
            188 => '[e:806]',
            189 => '[e:152]',
            190 => '[e:149]',
            191 => '[e:354]',
            192 => '[e:72]',
            193 => '[e:58]',
            194 => '[e:215]',
            195 => '[e:423]',
            196 => '[e:25]',
            197 => '[e:441]',
            198 => '[e:446]',
            199 => '[e:257][e:330]',
            200 => '[e:351]',
            201 => '[e:779]',
            202 => '[e:450]',
            203 => '[e:349]',
            204 => '[e:287]',
            205 => '[e:264]',
            206 => '[e:348]',
            207 => '[e:446]',
            208 => '[e:443]',
            209 => '[e:440]',
            210 => '[e:259]',
            211 => '[e:791]',
            212 => '［ＮＧ］',
            213 => '[e:143]',
            214 => '[e:81]',
            215 => '[e:54]',
            216 => '[e:218]',
            217 => '[e:279]',
            218 => '[e:807]',
            219 => '[e:82]',
            220 => '[e:1]',
            221 => '［禁］',
            222 => '[e:387]',
            223 => '［合］',
            224 => '[e:386]',
            225 => '[e:808]',
            226 => '[e:809]',
            227 => '[e:377]',
            228 => '[e:810]',
            229 => '[e:342]',
            230 => '[e:53]',
            231 => '[e:241]',
            232 => '[e:113]',
            233 => '[e:739]',
            234 => '[e:434]',
            235 => '[e:811]',
            236 => '[e:133]',
            237 => '[e:235]',
            238 => '[e:244]',
            239 => '[e:239]',
            240 => '[e:400]',
            241 => '[e:333]',
            242 => '[e:424]',
            243 => '[e:812]',
            244 => '[e:78]',
            245 => '[e:252]',
            246 => '[e:203]',
            247 => '[e:454]',
            248 => '[e:814]',
            249 => '[e:248]',
            250 => '[e:254]',
            251 => '[e:12]',
            252 => '[e:350]',
        );
        //SoftBank => Docomo
        $this->relation_list['s']['i'] = array(
            1 => '[i:140]',
            2 => '[i:140]',
            3 => '[i:149]',
            4 => '[i:140]',
            5 => '[i:140]',
            6 => '[i:179]',
            7 => '[i:92]',
            8 => '[i:68]',
            9 => '[i:74]',
            10 => '[i:75]',
            11 => '[i:107]',
            12 => '[i:187]',
            13 => '[i:153]',
            14 => '[i:204]',
            15 => '[No.1]',
            16 => '[i:86]',
            17 => '[i:87]',
            18 => '[i:88]',
            19 => '[i:26]',
            20 => '[i:23]',
            21 => '[i:24]',
            22 => '[i:22]',
            23 => '[i:183]',
            24 => '[i:25]',
            25 => '[i:246]',
            26 => '[i:249]',
            27 => '[i:33]',
            28 => '[i:102]',
            29 => '[i:37]',
            30 => '[i:30]',
            31 => '[i:32]',
            32 => '[?]',
            33 => '[i:158]',
            34 => '[i:136]',
            35 => '[i:138]',
            36 => '[i:176]',
            37 => '[i:176]',
            38 => '[i:176]',
            39 => '[i:176]',
            40 => '[i:176]',
            41 => '[i:176]',
            42 => '[i:176]',
            43 => '[i:176]',
            44 => '[i:176]',
            45 => '[i:176]',
            46 => '[i:176]',
            47 => '[i:176]',
            48 => '[i:237]',
            49 => '[i:191]',
            50 => '[バラ]',
            51 => '[i:103]',
            52 => '[i:192]',
            53 => '[i:192]',
            54 => '[i:38]',
            55 => '[教会]',
            56 => '[i:39]',
            57 => '[駅]',
            58 => '[i:46]',
            59 => '[i:229]',
            60 => '[i:57]',
            61 => '[i:58]',
            62 => '[i:146]',
            63 => '[i:116]',
            64 => '[サックス]',
            65 => '[ギター]',
            66 => '[トランペット]',
            67 => '[i:50]',
            68 => '[i:52]',
            69 => '[i:51]',
            70 => '[i:239]',
            71 => '[i:53]',
            72 => '[i:4]',
            73 => '[i:2]',
            74 => '[i:1]',
            75 => '[i:3]',
            76 => '[i:98]',
            77 => '[i:1]',
            78 => '[天使]',
            79 => '[i:101]',
            80 => '[とら]',
            81 => '[くま]',
            82 => '[i:100]',
            83 => '[ねずみ]',
            84 => '[クジラ]',
            85 => '[i:245]',
            86 => '[i:140]',
            87 => '[i:140]',
            88 => '[i:142]',
            89 => '[i:141]',
            90 => '[ウンチ]',
            91 => '[i:40]',
            92 => '[i:40]',
            93 => '[i:106]',
            94 => '[i:105]',
            95 => '[i:205]',
            96 => '[i:203]',
            97 => '[i:252]',
            98 => '[i:200]',
            99 => '[さる]',
            100 => '[たこ]',
            101 => '[i:250]',
            102 => '[宇宙人]',
            103 => '[ロケット]',
            104 => '[i:191]',
            105 => '[i:151]',
            106 => '[i:230]',
            107 => '[i:149]',
            108 => '[i:72]',
            109 => '[ピストル]',
            110 => '[i:119]',
            111 => '[i:216]',
            112 => '[オークション]',
            113 => '[花火]',
            114 => '[i:236]',
            115 => '[落ち葉]',
            116 => '[悪魔]',
            117 => '[おばけ]',
            118 => '[ドクロ]',
            119 => '[ファイヤー]',
            120 => '[i:69]',
            121 => '[i:171]',
            122 => '[i:54]',
            123 => '[公園]',
            124 => '[キャンプ場]',
            125 => '[i:147]',
            126 => '[遊園地]',
            127 => '[i:65]',
            128 => '[i:79]',
            129 => '[i:79]',
            130 => '[ラジオ]',
            131 => '[ビデオ]',
            132 => '[i:77]',
            133 => '[ゲーム]',
            134 => '[歌い出し]',
            135 => '[マージャン]',
            136 => '[VS]',
            137 => '[i:186]',
            138 => '[当り]',
            139 => '[トロフィー]',
            140 => '[i:28]',
            141 => '[777]',
            142 => '[i:249]',
            143 => '[i:102]',
            144 => '[i:194]',
            145 => '[工事中]',
            146 => '[♂]',
            147 => '[♀]',
            148 => '[乳幼児]',
            149 => '[注射器]',
            150 => '[i:157]',
            151 => '[i:5]',
            152 => '[i:55]',
            153 => '[i:147]',
            154 => '[i:49]',
            155 => '[音声]',
            156 => '[お知らせ]',
            157 => '[祝日]',
            158 => '[i:116]',
            159 => '[i:116]',
            160 => '[街]',
            161 => '[料理]',
            162 => '[i:70]',
            163 => '[$\]',
            164 => '[株価]',
            165 => '[ニュース]',
            166 => '[元気]',
            167 => '[i:42]',
            168 => '[i:48]',
            169 => '[i:47]',
            170 => '[バス停]',
            171 => '[i:49]',
            172 => '[交番]',
            173 => '[i:40]',
            174 => '[i:43]',
            175 => '[i:41]',
            176 => '[i:45]',
            177 => '[i:227]',
            178 => '[i:44]',
            179 => '[i:35]',
            180 => '[i:33]',
            181 => '[i:216]',
            182 => '[i:36]',
            183 => '[ココ]',
            184 => '[i:148]',
            185 => '[i:148]',
            186 => '[i:148]',
            187 => '[18禁]',
            188 => '[i:67]',
            189 => '[初心者]',
            190 => '[i:94]',
            191 => '[アンテナマーク]',
            192 => '[i:80]',
            193 => '[i:82]',
            194 => '[i:81]',
            195 => '[i:83]',
            196 => '[i:123]',
            197 => '[i:122]',
            198 => '[i:120]',
            199 => '[UP]',
            200 => '[COOL]',
            201 => '[有]',
            202 => '[無]',
            203 => '[月]',
            204 => '[申]',
            205 => '[i:95]',
            206 => '[i:95]',
            207 => '[i:95]',
            208 => '[i:125]',
            209 => '[i:126]',
            210 => '[i:127]',
            211 => '[i:128]',
            212 => '[i:129]',
            213 => '[i:130]',
            214 => '[i:131]',
            215 => '[i:132]',
            216 => '[i:133]',
            217 => '[i:134]',
            218 => '[得]',
            219 => '[割]',
            220 => '[サ]',
            221 => '[i:115]',
            222 => '[i:224]',
            223 => '[i:222]',
            224 => '[指]',
            225 => '[営]',
            226 => '[↑]',
            227 => '[↓]',
            228 => '[←]',
            229 => '[→]',
            230 => '[↑]',
            231 => '[↓]',
            232 => '[→]',
            233 => '[←]',
            234 => '[i:59]',
            235 => '[i:90]',
            236 => '[i:89]',
            237 => '[i:104]',
            238 => '[>]',
            239 => '[<]',
            240 => '[>>]',
            241 => '[<<]',
            242 => '[星座]',
            243 => '[i:9]',
            244 => '[i:10]',
            245 => '[i:11]',
            246 => '[i:12]',
            247 => '[i:13]',
            248 => '[i:14]',
            249 => '[i:15]',
            250 => '[i:16]',
            251 => '[i:17]',
            252 => '[i:18]',
            253 => '[i:19]',
            254 => '[i:20]',
            255 => '[へびつかい座]',
            256 => '[TOP]',
            257 => '[i:135]',
            258 => '[i:214]',
            259 => '[i:219]',
            260 => '[マナーモード]',
            261 => '[電源切]',
            262 => '[i:220]',
            263 => '[ご案内]',
            264 => '[J-PHONショップ]',
            265 => '[スカイウェイ]',
            266 => '[スカイウォーク]',
            267 => '[スカイメロディ]',
            268 => '[J-PHONE]',
            269 => '[J-PHONE2]',
            270 => '[J-PHONE3]',
            271 => '[i:76]',
            272 => '[ネクタイ]',
            273 => '[ハイビスカス]',
            274 => '[i:232]',
            275 => '[ひまわり]',
            276 => '[花束]',
            277 => '[やしの木]',
            278 => '[サボテン]',
            279 => '[WC]',
            280 => '[i:61]',
            281 => '[i:240]',
            282 => '[i:53]',
            283 => '[祝]',
            284 => '[i:66]',
            285 => '[カプセル薬]',
            286 => '[風船]',
            287 => '[i:154]',
            288 => '[クラッカー]',
            289 => '[i:56]',
            290 => '[i:71]',
            291 => '[i:217]',
            292 => '[MD]',
            293 => '[メガフォン]',
            294 => '[帽子]',
            295 => '[可愛いワンピース]',
            296 => '[i:55]',
            297 => '[ロングブーツ]',
            298 => '[i:181]',
            299 => '[マニュキア]',
            300 => '[エステ]',
            301 => '[i:56]',
            302 => '[理容院]',
            303 => '[着物]',
            304 => '[ビキニ]',
            305 => '[i:69]',
            306 => '[i:167]',
            307 => '[i:184]',
            308 => '[i:155]',
            309 => '[i:136]',
            310 => '[i:137]',
            311 => '[i:136]',
            312 => '[i:136]',
            313 => '[i:136]',
            314 => '[i:136]',
            315 => '[i:136]',
            316 => '[i:150]',
            317 => '[☆]',
            318 => '[i:164]',
            319 => '[i:162]',
            320 => '[i:99]',
            321 => '[×]',
            322 => '[i:152]',
            323 => '[☆]',
            324 => '[?]',
            325 => '[i:158]',
            326 => '[i:195]',
            327 => '[i:242]',
            328 => '[ソフトクリーム]',
            329 => '[フライドポテト]',
            330 => '[串団子]',
            331 => '[せんべい]',
            332 => '[i:241]',
            333 => '[スパゲッティ]',
            334 => '[i:241]',
            335 => '[カレーライス]',
            336 => '[i:238]',
            337 => '[おでん]',
            338 => '[寿司]',
            339 => '[i:234]',
            340 => '[みかん]',
            341 => '[いちご]',
            342 => '[すいか]',
            343 => '[トマト]',
            344 => '[なす]',
            345 => '[i:73]',
            346 => '[駅弁]',
            347 => '[ナベ]',
            348 => '[i:200]',
            349 => '[i:209]',
            350 => '[i:197]',
            351 => '[i:248]',
            352 => '[i:206]',
            353 => '[i:208]',
            354 => '[i:143]',
            355 => '[i:157]',
            356 => '[i:205]',
            357 => '[i:198]',
            358 => '[i:252]',
            359 => '[マスクをつけた顔]',
            360 => '[i:207]',
            361 => '[i:202]',
            362 => '[i:200]',
            363 => '[i:144]',
            364 => '[i:210]',
            365 => '[i:140][i:210]',
            366 => '[i:211]',
            367 => '[i:140]',
            368 => '[i:140]',
            369 => '[i:201]',
            370 => '[i:203]',
            371 => '[i:203]',
            372 => '[i:84]',
            373 => '[鼻]',
            374 => '[i:85]',
            375 => '[i:149]',
            376 => '[ごめんなさい]',
            377 => '[i:88]',
            378 => '[拍手]',
            379 => '[i:135]',
            380 => '[i:156]',
            381 => '[i:88]',
            382 => '[i:212]',
            383 => '[i:135]',
            384 => '[i:137]',
            385 => '[m(_ _)m]',
            386 => '[＼(^o^)／]',
            387 => '[人と人が歩い]',
            388 => '[ラインダンス]',
            389 => '[i:27]',
            390 => '[フットボール]',
            391 => '[ビリヤード]',
            392 => '[水泳]',
            393 => '[i:34]',
            394 => '[トラック]',
            395 => '[消防車]',
            396 => '[救急車]',
            397 => '[パトカー]',
            398 => '[ジェットコースター]',
            399 => '[i:31]',
            400 => '[i:32]',
            401 => '[門松]',
            402 => '[チョコ]',
            403 => '[お雛様]',
            404 => '[卒業式]',
            405 => '[ランドセル]',
            406 => '[鯉のぼり]',
            407 => '[i:8]',
            408 => '[結婚式]',
            409 => '[i:228]',
            410 => '[かき氷]',
            411 => '[線香花火]',
            412 => '[貝]',
            413 => '[風鈴]',
            414 => '[i:6]',
            415 => '[稲穂]',
            416 => '[ハロウィン]',
            417 => '[お月見]',
            418 => '[風がビュー]',
            419 => '[サンタクロース]',
            420 => '[i:1]',
            421 => '[i:1]',
            422 => '[i:172]',
            423 => '[虹]',
            424 => '[i:44][i:139]',
            425 => '[i:62]',
            426 => '[i:63]',
            427 => '[デパート]',
            428 => '[お城(和)]',
            429 => '[お城(洋)]',
            430 => '[i:58]',
            431 => '[工場]',
            432 => '[東京タワー]',
            433 => '[109]',
            434 => '[日本]',
            435 => '[アメリカ]',
            436 => '[フランス]',
            437 => '[ドイツ]',
            438 => '[イタリア]',
            439 => '[イギリス]',
            440 => '[スペイン]',
            441 => '[ロシア]',
            442 => '[中国]',
            443 => '[韓国]',
            444 => '[白人]',
            445 => '[中国人]',
            446 => '[インド人]',
            447 => '[おじいちゃん]',
            448 => '[おばあちゃん]',
            449 => '[あかちゃん]',
            450 => '[安全第一]',
            451 => '[お姫さま]',
            452 => '[自由の女神]',
            453 => '[衛兵]',
            454 => '[フラメンコ]',
            455 => '[イルカ]',
            456 => '[i:244]',
            457 => '[i:246]',
            458 => '[i:244]',
            459 => '[ハムスター]',
            460 => '[けむし]',
            461 => '[ぞう]',
            462 => '[こあら]',
            463 => '[チンパジー]',
            464 => '[ひつじ]',
            465 => '[i:100]',
            466 => '[うし]',
            467 => '[うさぎ]',
            468 => '[へび]',
            469 => '[にわとり]',
            470 => '[いのしし]',
            471 => '[らくだ]',
            472 => '[かえる]',
            473 => '[A]',
            474 => '[B]',
            475 => '[AB]',
            476 => '[O]',
            477 => '[i:91]',
            478 => '[i:215]',
            479 => '[J-Sky1]',
            480 => '[J-Sky2]',
            481 => '[vodafone1]',
            482 => '[vodafone2]',
            483 => '[v',
            484 => 'oda',
            485 => 'fone]',
        );
        //SoftBank => AU
        $this->relation_list['s']['e'] = array(
            1 => '[e:80]',
            2 => '[e:50]',
            3 => '[e:273]',
            4 => '[e:80]',
            5 => '[e:50]',
            6 => '[e:335]',
            7 => '[e:336]',
            8 => '[e:94]',
            9 => '[e:85]',
            10 => '[e:161]',
            11 => '[e:166]',
            12 => '[e:337]',
            13 => '[e:281]',
            14 => '[e:287]',
            15 => '[e:284]',
            16 => '[e:817]',
            17 => '[e:319]',
            18 => '[e:320]',
            19 => '[e:421]',
            20 => '[e:306]',
            21 => '[e:220]',
            22 => '[e:45]',
            23 => '[e:751]',
            24 => '[e:219]',
            25 => '[e:203]',
            26 => '[e:248]',
            27 => '[e:125]',
            28 => '[e:169]',
            29 => '[e:168]',
            30 => '[e:172]',
            31 => '[e:217]',
            32 => '[e:3]',
            33 => '[e:2]',
            34 => '[e:51]',
            35 => '[e:265]',
            36 => '[e:46]',
            37 => '[e:46]',
            38 => '[e:46]',
            39 => '[e:46]',
            40 => '[e:46]',
            41 => '[e:46]',
            42 => '[e:46]',
            43 => '[e:46]',
            44 => '[e:46]',
            45 => '[e:46]',
            46 => '[e:46]',
            47 => '[e:46]',
            48 => '[e:235]',
            49 => '[e:354]',
            50 => '[e:339]',
            51 => '[e:234]',
            52 => '[e:72]',
            53 => '[e:72]',
            54 => '[e:112]',
            55 => '[e:340]',
            56 => '[e:156]',
            57 => '[e:795]',
            58 => '[e:213]',
            59 => '[e:342]',
            60 => '[e:289]',
            61 => '[e:110]',
            62 => '[e:343]',
            63 => '[e:120]',
            64 => '〓',
            65 => '[e:292]',
            66 => '[e:469]',
            67 => '[e:146]',
            68 => '[e:52]',
            69 => '[e:93]',
            70 => '[e:239]',
            71 => '[e:65]',
            72 => '[e:191]',
            73 => '[e:107]',
            74 => '[e:44]',
            75 => '[e:95]',
            76 => '[e:15]',
            77 => '[e:493]',
            78 => '[e:344]',
            79 => '[e:251]',
            80 => '[e:345]',
            81 => '[e:346]',
            82 => '[e:134]',
            83 => '[e:347]',
            84 => '[e:246]',
            85 => '[e:252]',
            86 => '[e:454]',
            87 => '[e:257]',
            88 => '[e:444]',
            89 => '[e:258]',
            90 => '[e:283]',
            91  => '[e:129]',
            92  => '[e:129]',
            93  => '[e:784]',
            94  => '[e:513]',
            95  => '[e:264]',
            96  => '[e:349]',
            97  => '[e:350]',
            98  => '[e:351]',
            99  => '[e:249]',
            100 => '[e:352]',
            101 => '[e:254]',
            102 => '[e:274]',
            103 => '[e:353]',
            104 => '[e:354]',
            105 => '[e:77]',
            106 => '[e:53]',
            107 => '[e:355]',
            108 => '[e:144]',
            109 => '[e:296]',
            110 => '[e:119]',
            111 => '[e:218]',
            112 => '[e:356]',
            113 => '[e:357]',
            114 => '[e:133]',
            115 => '[e:358]',
            116 => '[e:277]',
            117 => '[e:236]',
            118 => '[e:286]',
            119 => '[e:269]',
            120 => '[e:359]',
            121 => '〓',
            122 => '[e:245]',
            123 => '[e:360]',
            124 => '[e:361]',
            125 => '[e:224]',
            126 => '[e:223]',
            127 => '[e:106]',
            128 => '[e:300]',
            129 => '[e:300]',
            130 => '[e:338]',
            131 => '[e:115]',
            132 => '[e:288]',
            133 => '[e:274]',
            134 => '〓',
            135 => '[e:362]',
            136 => '[e:363]',
            137 => '[e:233]',
            138 => '[e:231]',
            139 => '[e:364]',
            140 => '[e:222]',
            141 => '[e:229]',
            142 => '[e:248]',
            143 => '[e:169]',
            144 => '[e:215]',
            145 => '[e:368]',
            146 => '[♂]',
            147 => '[♀]',
            148 => '[e:710]',
            149 => '[e:304]',
            150 => '[e:261]',
            151 => '[e:16]',
            152 => '[e:124]',
            153 => '[e:369]',
            154 => '[e:207]',
            155 => '[e:13]',
            156 => '[e:13]',
            157 => '[e:370]',
            158 => '[e:138]',
            159 => '[e:138]',
            160 => '[e:371]',
            161 => '[e:240]',
            162 => '[e:122]',
            163 => '[$\]',
            164 => '[e:373]',
            165 => '[e:210]',
            166 => '[e:271]',
            167 => '[e:212]',
            168 => '[e:99]',
            169 => '[e:208]',
            170 => '[e:209]',
            171 => '[e:207]',
            172 => '[e:374]',
            173 => '[e:375]',
            174 => '[e:205]',
            175 => '[e:376]',
            176 => '[e:206]',
            177 => '[e:377]',
            178 => '[e:378]',
            179 => '[e:216]',
            180 => '[e:125]',
            181 => '[e:800]',
            182 => '[e:379]',
            183 => '[ココ]',
            184 => '[e:51]',
            185 => '[e:267]',
            186 => '[e:28]',
            187 => '[e:380]',
            188 => '[e:177]',
            189 => '[e:179]',
            190 => '[e:178]',
            191 => '[e:381]',
            192 => '[e:414]',
            193 => '[e:315]',
            194 => '[e:314]',
            195 => '[e:316]',
            196 => '[e:818]',
            197 => '〓',
            198 => '[e:334]',
            199 => '[e:303]',
            200 => '[e:382]',
            201 => '[有]',
            202 => '[無]',
            203 => '[月]',
            204 => '[申]',
            205 => '[e:40]',
            206 => '[e:41]',
            207 => '[e:41]',
            208 => '[e:180]',
            209 => '[e:181]',
            210 => '[e:182]',
            211 => '[e:183]',
            212 => '[e:184]',
            213 => '[e:185]',
            214 => '[e:186]',
            215 => '[e:187]',
            216 => '[e:188]',
            217 => '[e:325]',
            218 => '[e:285]',
            219 => '[e:383]',
            220 => '[e:384]',
            221 => '[e:385]',
            222 => '[e:386]',
            223 => '[e:387]',
            224 => '[e:388]',
            225 => '[e:389]',
            226 => '[e:390]',
            227 => '[e:391]',
            228 => '[e:140]',
            229 => '[e:141]',
            230 => '[e:29]',
            231 => '[e:30]',
            232 => '[e:63]',
            233 => '[e:64]',
            234 => '[e:70]',
            235 => '[e:42]',
            236 => '[e:43]',
            237 => '[e:71]',
            238 => '[e:6]',
            239 => '[e:5]',
            240 => '[e:8]',
            241 => '[e:7]',
            242 => '[e:392]',
            243 => '[e:192]',
            244 => '[e:193]',
            245 => '[e:194]',
            246 => '[e:195]',
            247 => '[e:196]',
            248 => '[e:197]',
            249 => '[e:198]',
            250 => '[e:199]',
            251 => '[e:200]',
            252 => '[e:201]',
            253 => '[e:202]',
            254 => '[e:203]',
            255 => '[e:204]',
            256 => '[TOP]',
            257 => '[e:326]',
            258 => '[e:81]',
            259 => '[e:82]',
            260 => '[e:393]',
            261 => '[e:394]',
            262 => '[e:1]',
            263 => '〓',
            264 => '〓',
            265 => '〓',
            266 => '〓',
            267 => '〓',
            268 => '〓',
            269 => '〓',
            270 => '〓',
            271 => '[e:395]',
            272 => '[e:396]',
            273 => '[e:397]',
            274 => '[e:113]',
            275 => '[e:256]',
            276 => '[e:398]',
            277 => '[e:255]',
            278 => '[e:399]',
            279 => '[WC]',
            280 => '[e:294]',
            281 => '[e:400]',
            282 => '[e:401]',
            283 => '[e:402]',
            284 => '[e:176]',
            285 => '[e:403]',
            286 => '[e:404]',
            287 => '[e:268]',
            288 => '[e:405]',
            289 => '[e:104]',
            290 => '[e:312]',
            291 => '[e:279]',
            292 => '[e:126]',
            293 => '[e:13]',
            294 => '[e:407]',
            295 => '[e:793]',
            296 => '[e:124]',
            297 => '[e:408]',
            298 => '[e:295]',
            299 => '[e:409]',
            300 => '[e:297]',
            301 => '[e:410]',
            302 => '[e:411]',
            303 => '[e:412]',
            304 => '[e:413]',
            305 => '[e:83]',
            306 => '[e:226]',
            307 => '[e:48]',
            308 => '[e:291]',
            309 => '[e:415]',
            310 => '[e:803]',
            311 => '[e:272]',
            312 => '[e:416]',
            313 => '[e:417]',
            314 => '[e:418]',
            315 => '[e:419]',
            316 => '[e:420]',
            317 => '[e:69]',
            318 => '[e:282]',
            319 => '[e:330]',
            320 => '[e:422]',
            321 => '[e:61]',
            322 => '[e:262]',
            323 => '[e:69]',
            324 => '[e:3]',
            325 => '[e:2]',
            326 => '[e:423]',
            327 => '[e:424]',
            328 => '[e:425]',
            329 => '[e:426]',
            330 => '[e:427]',
            331 => '[e:428]',
            332 => '[e:429]',
            333 => '[e:430]',
            334 => '[e:333]',
            335 => '[e:431]',
            336 => '[e:244]',
            337 => '[e:432]',
            338 => '[e:433]',
            339 => '[e:434]',
            340 => '[e:435]',
            341 => '[e:243]',
            342 => '[e:238]',
            343 => '[e:436]',
            344 => '[e:437]',
            345 => '[e:313]',
            346 => '[e:438]',
            347 => '[e:439]',
            348 => '[e:351]',
            349 => '[e:440]',
            350 => '[e:441]',
            351 => '[e:442]',
            352 => '[e:348]',
            353 => '[e:443]',
            354 => '[e:444]',
            355 => '[e:445]',
            356 => '[e:264]',
            357 => '[e:446]',
            358 => '[e:447]',
            359 => '[e:448]',
            360 => '[e:449]',
            361 => '[e:450]',
            362 => '[e:447]',
            363 => '[e:451]',
            364 => '[e:259]',
            365 => '[e:786]',
            366 => '[e:791]',
            367 => '[e:454]',
            368 => '[e:257]',
            369 => '[e:779]',
            370 => '[e:455]',
            371 => '[e:456]',
            372 => '[e:317]',
            373 => '[e:457]',
            374 => '[e:318]',
            375 => '[e:458]',
            376 => '[e:459]',
            377 => '[e:463]',
            378 => '[e:460]',
            379 => '[e:461]',
            380 => '[e:462]',
            381 => '[e:463]',
            382 => '[e:464]',
            383 => '[e:465]',
            384 => '[e:467]',
            385 => '[e:466]',
            386 => '[e:820]',
            387 => '〓',
            388 => '[e:468]',
            389 => '[e:307]',
            390 => '[e:96]',
            391 => '[e:470]',
            392 => '[e:471]',
            393 => '[e:125]',
            394 => '[e:148]',
            395 => '[e:472]',
            396 => '[e:473]',
            397 => '[e:474]',
            398 => '[e:475]',
            399 => '[e:341]',
            400 => '[e:217]',
            401 => '[e:476]',
            402 => '[e:770]',
            403 => '[e:477]',
            404 => '[e:478]',
            405 => '[e:479]',
            406 => '[e:480]',
            407 => '[e:481]',
            408 => '[e:340]',
            409 => '[e:810]',
            410 => '[e:483]',
            411 => '[e:484]',
            412 => '[e:485]',
            413 => '[e:486]',
            414 => '[e:190]',
            415 => '〓',
            416 => '[e:487]',
            417 => '[e:488]',
            418 => '[e:358]',
            419 => '[e:489]',
            420 => '[e:493]',
            421 => '[e:371]',
            422 => '[e:490]',
            423 => '[e:491]',
            424 => '[e:492]',
            425 => '[e:309]',
            426 => '[e:494]',
            427 => '[e:495]',
            428 => '[e:496]',
            429 => '[e:497]',
            430 => '[e:110]',
            431 => '[e:498]',
            432 => '[e:228]',
            433 => '〓',
            434 => '[e:237]',
            435 => '[e:90]',
            436 => '[e:499]',
            437 => '[e:700]',
            438 => '[e:701]',
            439 => '[e:702]',
            440 => '[e:366]',
            441 => '[e:367]',
            442 => '[e:703]',
            443 => '[e:704]',
            444 => '[e:705]',
            445 => '[e:706]',
            446 => '[e:707]',
            447 => '[e:708]',
            448 => '[e:709]',
            449 => '[e:710]',
            450 => '[e:711]',
            451 => '[e:712]',
            452 => '〓',
            453 => '〓',
            454 => '[e:714]',
            455 => '[e:713]',
            456 => '[e:78]',
            457 => '[e:715]',
            458 => '[e:78]',
            459 => '〓',
            460 => '[e:716]',
            461 => '[e:717]',
            462 => '[e:718]',
            463 => '[e:249]',
            464 => '[e:192]',
            465 => '[e:134]',
            466 => '[e:719]',
            467 => '[e:247]',
            468 => '[e:720]',
            469 => '[e:721]',
            470 => '[e:722]',
            471 => '[e:723]',
            472 => '[e:250]',
            473 => '[e:724]',
            474 => '[e:725]',
            475 => '[e:727]',
            476 => '[e:726]',
            477 => '[e:728]',
            478 => '[e:54]',
            479 => '〓',
            480 => '〓',
            481 => '〓',
            482 => '〓',
            483 => '[v',
            484 => 'oda',
            485 => 'fone]',
        );
        //AU => Docomo
        $this->relation_list['e']['i'] = array(
            1 => '[i:220]',
            2 => '[i:158]',
            3 => '？',
            4 => '[i:124]',
            5 => '<',
            6 => '>',
            7 => '<<',
            8 => '>>',
            9 => '■',
            10 => '■',
            11 => '[i]',
            12 => '[i:251]',
            13 => '[スピーカ]',
            14 => '[i:186]',
            15 => '[i:98]',
            16 => '[i:5]',
            17 => '■',
            18 => '■',
            19 => '◆',
            20 => '◆',
            21 => '■',
            22 => '■',
            23 => '[i:95]',
            24 => '[i:95]',
            25 => '[i:196]',
            26 => '＋',
            27 => '－',
            28 => '＊',
            29 => '↑',
            30 => '↓',
            31 => '[i:221]',
            32 => '▼',
            33 => '▲',
            34 => '▼',
            35 => '▲',
            36 => '◆',
            37 => '◆',
            38 => '■',
            39 => '■',
            40 => '[i:95]',
            41 => '[i:95]',
            42 => '[i:90]',
            43 => '[i:89]',
            44 => '[i:1]',
            45 => '[i:22]',
            46 => '[i:176]',
            47 => '[i:97]',
            48 => '[i:184]',
            49 => 'φ',
            50 => '[i:140]',
            51 => '[i:136]',
            52 => '[i:52]',
            53 => '[i:230]',
            54 => '[i:215]',
            55 => '×',
            56 => '[i:76]',
            57 => '[i:193]',
            58 => '[i:193]',
            59 => '[フロッピー]',
            60 => '[雪結晶]',
            61 => '×',
            62 => '×',
            63 => '→',
            64 => '←',
            65 => '[i:53]',
            66 => '÷',
            67 => '[カレンダー]',
            68 => '[i:140]',
            69 => '☆',
            70 => '[i:59]',
            71 => '[i:104]',
            72 => '[i:192]',
            73 => '[チェックマーク]',
            74 => '[i:100]',
            75 => '☆彡',
            76 => '[i:150]',
            77 => '[i:151]',
            78 => '[i:244]',
            79 => '[フォルダ]',
            80 => '[i:140]',
            81 => '[i:214]',
            82 => '[i:219]',
            83 => '[i:69]',
            84 => '[フォルダ]',
            85 => '[i:74]',
            86 => '[フキダシ]',
            87 => '[カード]',
            88 => '▲',
            89 => '▼',
            90 => '[USA]',
            91 => '[i:70]',
            92 => '[i:76]',
            93 => '[i:51]',
            94 => '[i:68]',
            95 => '[i:3]',
            96 => '[フットボール]',
            97 => '[i:70]',
            98 => '[i:212]',
            99 => '[i:48]',
            100 => '[i:70]',
            101 => '[i:70]',
            102 => '[i:70]',
            103 => '[i:76]',
            104 => '[i:56]',
            105 => '[カレンダー]',
            106 => '[i:65]',
            107 => '[i:2]',
            108 => '[i:110]',
            109 => '[i:113]',
            110 => '[i:58]',
            111 => '[i:58]',
            112 => '[i:38]',
            113 => '[i:232]',
            114 => '[包丁]',
            115 => '[ビデオ]',
            116 => '[i:93]',
            117 => '└→',
            118 => '[i:117]',
            119 => '[i:119]',
            120 => '[i:116]',
            121 => '[i:70]',
            122 => '[i:70]',
            123 => '[ネジ]',
            124 => '[i:55]',
            125 => '[i:33]',
            126 => '[フロッピー]',
            127 => '[グラフ]',
            128 => '[グラフ]',
            129 => '[i:40]',
            130 => '[i:151]',
            131 => '[i:70]',
            132 => '[チェックマーク]',
            133 => '[i:236]',
            134 => '[i:100]',
            135 => '[電池]',
            136 => '[i:166]',
            137 => '[画びょう]',
            138 => '[i:116]',
            139 => '[i:186]',
            140 => '←',
            141 => '→',
            142 => '[i:70]',
            143 => '[i:213]',
            144 => '[i:72]',
            145 => '[名札]',
            146 => '[i:50]',
            147 => '[i:70]',
            148 => '[トラック]',
            149 => '[i:190]',
            150 => '[PDC]',
            151 => '[i:106]',
            152 => '[i:189]',
            153 => '[送信BOX]',
            154 => '[受信BOX]',
            155 => '[i:74]',
            156 => '[i:39]',
            157 => '[定規]',
            158 => '[三角定規]',
            159 => '[グラフ]',
            160 => '[肉]',
            161 => '[i:75]',
            162 => '[コンセント]',
            163 => '[家族]',
            164 => '[リンク]',
            165 => '[i:72]',
            166 => '[i:107]',
            167 => '[i:1][i:2]',
            168 => '[i:37]',
            169 => '[i:102]',
            170 => '[サイコロ]',
            171 => '[新聞]',
            172 => '[i:30]',
            173 => '　',
            174 => '0',
            175 => '0',
            176 => '[i:66]',
            177 => '[i:67]',
            178 => '[i:94]',
            179 => '[若葉マーク]',
            180 => '[i:125]',
            181 => '[i:126]',
            182 => '[i:127]',
            183 => '[i:128]',
            184 => '[i:129]',
            185 => '[i:130]',
            186 => '[i:131]',
            187 => '[i:132]',
            188 => '[i:133]',
            189 => '[10]',
            190 => '[i:6]',
            191 => '[i:4]',
            192 => '[i:9]',
            193 => '[i:10]',
            194 => '[i:11]',
            195 => '[i:12]',
            196 => '[i:13]',
            197 => '[i:14]',
            198 => '[i:15]',
            199 => '[i:16]',
            200 => '[i:17]',
            201 => '[i:18]',
            202 => '[i:19]',
            203 => '[i:20]',
            204 => '[蛇使座]',
            205 => '[i:43]',
            206 => '[i:45]',
            207 => '[i:49]',
            208 => '[i:47]',
            209 => '[バス停]',
            210 => '[アンテナ]',
            211 => '[i:36]',
            212 => '[i:42]',
            213 => '[i:46]',
            214 => '[地図]',
            215 => '[i:194]',
            216 => '[i:35]',
            217 => '[i:32]',
            218 => '[i:216]',
            219 => '[i:25]',
            220 => '[i:24]',
            221 => '[i:183]',
            222 => '[i:28]',
            223 => '[観覧車]',
            224 => '[i:147]',
            225 => '[i:240]',
            226 => '[i:167]',
            227 => '[i:172]',
            228 => '[東京タワー]',
            229 => '[777]',
            230 => '[オメデトウ]',
            231 => '[的中]',
            232 => '[i:78]',
            233 => '[i:186]',
            234 => '[i:103]',
            235 => '[i:237]',
            236 => '[お化け]',
            237 => '[日の丸]',
            238 => '[スイカ]',
            239 => '[i:239]',
            240 => '[フライパン]',
            241 => '[i:231]',
            242 => '[i:246]',
            243 => '[イチゴ]',
            244 => '[i:238]',
            245 => '[i:54]',
            246 => '[クジラ]',
            247 => '[ウサギ]',
            248 => '[i:249]',
            249 => '[サル]',
            250 => '[カエル]',
            251 => '[i:101]',
            252 => '[i:245]',
            253 => '[アリ]',
            254 => '[i:250]',
            255 => '[ビーチ]',
            256 => '[ひまわり]',
            257 => '[i:140]',
            258 => '[i:141]',
            259 => '[i:210]',
            260 => '[i:208]',
            261 => '[i:157]',
            262 => '[i:152]',
            263 => '[i:163]',
            264 => '[i:205]',
            265 => '[i:138]',
            266 => '[i:139]',
            267 => '[i:150]',
            268 => '[i:154]',
            269 => '[炎]',
            270 => '[SOS]',
            271 => '[力こぶ]',
            272 => '[i:136]',
            273 => '[i:149]',
            274 => '[宇宙人]',
            275 => '[i:6]',
            276 => '[i:91]',
            277 => '[アクマ]',
            278 => '[花丸]',
            279 => '[i:217]',
            280 => '[100点]',
            281 => '[i:153]',
            282 => '[i:164]',
            283 => '[ウンチ]',
            284 => '[人差し指]',
            285 => '[得]',
            286 => '[ドクロ]',
            287 => '[i:204]',
            288 => '[i:77]',
            289 => '[i:57]',
            290 => '[i:180]',
            291 => '[i:155]',
            292 => '[ギター]',
            293 => '[バイオリン]',
            294 => '[i:61]',
            295 => '[i:181]',
            296 => '[ピストル]',
            297 => '[エステ]',
            298 => '[EZ]',
            299 => '[i:114]',
            300 => '[i:79]',
            301 => '[i:179]',
            302 => '[UFO]',
            303 => '[UP!]',
            304 => '[注射]',
            305 => '[i:7]',
            306 => '[i:23]',
            307 => '[i:27]',
            308 => '[i:29]',
            309 => '[i:62]',
            310 => '[演劇]',
            311 => '[i:64]',
            312 => '[i:71]',
            313 => '[i:73]',
            314 => '[i:81]',
            315 => '[i:82]',
            316 => '[i:83]',
            317 => '[i:84]',
            318 => '[i:85]',
            319 => '[i:87]',
            320 => '[i:88]',
            321 => '[i:95]',
            322 => '[i:96]',
            323 => '[i:97]',
            324 => '[i:118]',
            325 => '[i:134]',
            326 => '[i:135]',
            327 => '[i:144]',
            328 => '[i:137]',
            329 => '[i:161]',
            330 => '[i:162]',
            331 => '[ezplus]',
            332 => '[地球]',
            333 => '[i:241]',
            334 => '[i:120]',
            335 => '[i:179]',
            336 => '[i:92]',
            337 => '[i:187]',
            338 => '[ラジオ]',
            339 => '[バラ]',
            340 => '[教会]',
            341 => '[i:31]',
            342 => '[i:229]',
            343 => '[i:146]',
            344 => '[天使]',
            345 => '[トラ]',
            346 => '[クマ]',
            347 => '[ネズミ]',
            348 => '[i:206]',
            349 => '[i:203]',
            350 => '[i:252]',
            351 => '[i:200]',
            352 => '[タコ]',
            353 => '[ロケット]',
            354 => '[i:191]',
            355 => '[i:149]',
            356 => '[ハンマー]',
            357 => '[花火]',
            358 => '[i:236]',
            359 => '[i:69]',
            360 => '[噴水]',
            361 => '[キャンプ]',
            362 => '[麻雀]',
            363 => '[VS]',
            364 => '[トロフィー]',
            365 => '[カメ]',
            366 => '[スペイン]',
            367 => '[ロシア]',
            368 => '[工事中]',
            369 => '[i:147]',
            370 => '[祝日]',
            371 => '[夕焼け]',
            372 => '[i:244]',
            373 => '[株価]',
            374 => '[警官]',
            375 => '[i:40]',
            376 => '[i:41]',
            377 => '[i:227]',
            378 => '[i:44]',
            379 => '[i:36]',
            380 => '[18禁]',
            381 => '[バリ3]',
            382 => '[COOL]',
            383 => '[割]',
            384 => '[サービス]',
            385 => '[i:115]',
            386 => '[i:224]',
            387 => '[i:222]',
            388 => '[指]',
            389 => '[営]',
            390 => '↑',
            391 => '↓',
            392 => '[占い]',
            393 => '[マナーモード]',
            394 => '[ケータイOFF]',
            395 => '[i:76]',
            396 => '[ネクタイ]',
            397 => '[ハイビスカス]',
            398 => '[花束]',
            399 => '[サボテン]',
            400 => '[i:240]',
            401 => '[i:53]',
            402 => '[祝]',
            403 => '[薬]',
            404 => '[風船]',
            405 => '[クラッカー]',
            406 => '[EZナビ]',
            407 => '[帽子]',
            408 => '[ブーツ]',
            409 => '[マニキュア]',
            410 => '[美容院]',
            411 => '[床屋]',
            412 => '[着物]',
            413 => '[ビキニ]',
            414 => '[i:80]',
            415 => '[i:136]',
            416 => '[i:136]',
            417 => '[i:136]',
            418 => '[i:136]',
            419 => '[i:136]',
            420 => '[i:150]',
            421 => '[i:26]',
            422 => '[i:99]',
            423 => '[i:195]',
            424 => '[i:242]',
            425 => '[ソフトクリーム]',
            426 => '[ポテト]',
            427 => '[だんご]',
            428 => '[せんべい]',
            429 => '[i:241]',
            430 => '[パスタ]',
            431 => '[カレー]',
            432 => '[おでん]',
            433 => '[すし]',
            434 => '[i:234]',
            435 => '[みかん]',
            436 => '[トマト]',
            437 => '[ナス]',
            438 => '[弁当]',
            439 => '[鍋]',
            440 => '[i:209]',
            441 => '[i:197]',
            442 => '[i:248]',
            443 => '[i:208]',
            444 => '[i:143]',
            445 => '[i:157]',
            446 => '[i:198]',
            447 => '[i:252]',
            448 => '[風邪ひき]',
            449 => '[熱]',
            450 => '[i:202]',
            451 => '[i:144]',
            452 => '[i:200]',
            453 => '[i:155]',
            454 => '[i:140]',
            455 => '(>３<)',
            456 => '(´３｀)',
            457 => '[鼻]',
            458 => '[i:149]',
            459 => '(>人<)',
            460 => '[拍手]',
            461 => '[i:135]',
            462 => '[i:156]',
            463 => '[i:88]',
            464 => '[i:212]',
            465 => '[i:135]',
            466 => 'm(_ _)m',
            467 => '[i:137]',
            468 => '[バニー]',
            469 => '[トランペット]',
            470 => '[ビリヤード]',
            471 => '[水泳]',
            472 => '[消防車]',
            473 => '[救急車]',
            474 => '[パトカー]',
            475 => '[ジェットコースター]',
            476 => '[門松]',
            477 => '[ひな祭り]',
            478 => '[卒業式]',
            479 => '[ランドセル]',
            480 => '[こいのぼり]',
            481 => '[i:8]',
            482 => '[花嫁]',
            483 => '[カキ氷]',
            484 => '[線香花火]',
            485 => '[巻貝]',
            486 => '[風鈴]',
            487 => '[ハロウィン]',
            488 => '[お月見]',
            489 => '[サンタ]',
            490 => '[i:172]',
            491 => '[虹]',
            492 => '[i:44][i:139]',
            493 => '[i:1]',
            494 => '[i:63]',
            495 => '[デパート]',
            496 => '[城]',
            497 => '[城]',
            498 => '[工場]',
            499 => '[フランス]',
            500 => '[オープンウェブ]',
            501 => '[カギ]',
            502 => '[ABCD]',
            503 => '[abcd]',
            504 => '[1234]',
            505 => '[記号]',
            506 => '[可]',
            507 => '[チェックマーク]',
            508 => '[i:169]',
            509 => '[ラジオボタン]',
            510 => '[i:119]',
            511 => '[←BACK]',
            512 => '[ブックマーク]',
            513 => '[i:105]',
            514 => '[i:38]',
            515 => '[i:40]',
            516 => '[i:76]',
            517 => '[i:116]',
            518 => '[i:218]',
            700 => '[ドイツ]',
            701 => '[イタリア]',
            702 => '[イギリス]',
            703 => '[中国]',
            704 => '[韓国]',
            705 => '[白人]',
            706 => '[中国人]',
            707 => '[インド人]',
            708 => '[おじいさん]',
            709 => '[おばあさん]',
            710 => '[赤ちゃん]',
            711 => '[工事現場の人]',
            712 => '[お姫様]',
            713 => '[イルカ]',
            714 => '[ダンス]',
            715 => '[i:246]',
            716 => '[ゲジゲジ]',
            717 => '[ゾウ]',
            718 => '[コアラ]',
            719 => '[牛]',
            720 => '[ヘビ]',
            721 => '[ニワトリ]',
            722 => '[イノシシ]',
            723 => '[ラクダ]',
            724 => '[A]',
            725 => '[B]',
            726 => '[O]',
            727 => '[AB]',
            728 => '[i:91]',
            729 => '[i:92]',
            730 => '[i:121]',
            731 => '[i:145]',
            732 => '[i:156]',
            733 => '[i:159]',
            734 => '[i:160]',
            735 => '[i:166]',
            736 => '[メロン]',
            737 => '[パイナップル]',
            738 => '[ブドウ]',
            739 => '[i:233]',
            740 => '[とうもろこし]',
            741 => '[キノコ]',
            742 => '[栗]',
            743 => '[モモ]',
            744 => '[やきいも]',
            745 => '[ピザ]',
            746 => '[チキン]',
            747 => '[七夕]',
            748 => '[i:52]',
            749 => '[辰]',
            750 => '[ピアノ]',
            751 => '[i:183]',
            752 => '[i:246]',
            753 => '[ボーリング]',
            754 => '[なまはげ]',
            755 => '[天狗]',
            756 => '[パンダ]',
            757 => '[i:205]',
            758 => '[i:250]',
            759 => '[花]',
            760 => '[アイスクリーム]',
            761 => '[ドーナツ]',
            762 => '[クッキー]',
            763 => '[チョコ]',
            764 => '[キャンディ]',
            765 => '[キャンディ]',
            766 => '(/_＼)',
            767 => '(・×・)',
            768 => '|(・×・)|',
            769 => '[火山]',
            770 => '[i:136]',
            771 => '[ABC]',
            772 => '[プリン]',
            773 => '[ミツバチ]',
            774 => '[てんとう虫]',
            775 => '[ハチミツ]',
            776 => '[i:234]',
            777 => '[飛んでいくお金]',
            778 => '[クラクラ]',
            779 => '[i:201]',
            780 => '[i:201]',
            781 => '[i:172]',
            782 => '(´３｀)',
            783 => '[i:140]',
            784 => '[i:106]',
            785 => '[i:207]',
            786 => '[i:207]',
            787 => '[i:203]',
            788 => '[i:143]',
            789 => '[i:143]',
            790 => '[i:211]',
            791 => '[i:211]',
            792 => '[i:248]',
            793 => '[ドレス]',
            794 => '[モアイ]',
            795 => '[駅]',
            796 => '[花札]',
            797 => '[ジョーカー]',
            798 => '[エビフライ]',
            799 => '[i:110]',
            800 => '[i:216]',
            801 => '[パトカー]',
            802 => '[EZムービー]',
            803 => '[i:137]',
            804 => '[i:244]',
            805 => '[i:182]',
            806 => '[i:188]',
            807 => '[i:218]',
            808 => '[i:225]',
            809 => '[i:226]',
            810 => '[i:228]',
            811 => '[i:235]',
            812 => '[i:243]',
            813 => '[i:248]',
            814 => '[i:248]',
            815 => '[Cメール]',
            816 => '[i:230]',
            817 => '[i:86]',
            818 => '[i:123]',
            819 => '(^-^)/',
            820 => '＼(^o^)／',
            821 => '[i:143]',
            822 => '[i:201]',
        );
        //AU => SoftBank
        $this->relation_list['e']['s'] = array(
            1 => '[s:262]',
            2 => '[s:33]',
            3 => '[s:32]',
            4 => '[Q]',
            5 => '[s:239]',
            6 => '[s:238]',
            7 => '[s:241]',
            8 => '[s:240]',
            9 => '[s:207]',
            10 => '[s:206]',
            11 => '[i]',
            12 => '[s:68]',
            13 => '[s:155]',
            14 => '[s:137]',
            15 => '[s:76]',
            16 => '[s:151]',
            17 => '[s:207]',
            18 => '[s:206]',
            19 => '[s:207]',
            20 => '[s:207]',
            21 => '[s:207]',
            22 => '[s:206]',
            23 => '[s:205]',
            24 => '[s:205]',
            25 => '[腕時計]',
            26 => '＋',
            27 => '－',
            28 => '＊',
            29 => '[s:230]',
            30 => '[s:231]',
            31 => '[禁止]',
            32 => '▼',
            33 => '▲',
            34 => '▼',
            35 => '▲',
            36 => '[s:207]',
            37 => '[s:207]',
            38 => '[s:207]',
            39 => '[s:206]',
            40 => '[s:205]',
            41 => '[s:205]',
            42 => '[s:235]',
            43 => '[s:236]',
            44 => '[s:74]',
            45 => '[s:22]',
            46 => '[s:45]',
            47 => '[s:76]',
            48 => '[s:307]',
            49 => 'φ',
            50 => '[s:2]',
            51 => '[s:34]',
            52 => '[s:68]',
            53 => '[s:106]',
            54 => '[s:478]',
            55 => '[s:321]',
            56 => '[s:271]',
            57 => '[砂時計]',
            58 => '[砂時計]',
            59 => '[s:292]',
            60 => '[雪結晶]',
            61 => '[s:321]',
            62 => '[s:321]',
            63 => '[s:232]',
            64 => '[s:233]',
            65 => '[s:71]',
            66 => '÷',
            67 => '[カレンダー]',
            68 => '[s:86]',
            69 => '[s:317]',
            70 => '[s:234]',
            71 => '[s:237]',
            72 => '[s:52]',
            73 => '[チェックマーク]',
            74 => '[s:82]',
            75 => '☆彡',
            76 => '[s:316]',
            77 => '[s:105]',
            78 => '[s:458]',
            79 => '[フォルダ]',
            80 => '[s:1]',
            81 => '[s:258]',
            82 => '[s:259]',
            83 => '[s:305]',
            84 => '[フォルダ]',
            85 => '[s:9]',
            86 => '[フキダシ]',
            87 => '[カード]',
            88 => '▲',
            89 => '▼',
            90 => '[s:435]',
            91 => '[s:162]',
            92 => '[s:271]',
            93 => '[s:69]',
            94 => '[s:8]',
            95 => '[s:75]',
            96 => '[s:390]',
            97 => '[s:162]',
            98 => '[s:145]',
            99 => '[s:168]',
            100 => '[s:162]',
            101 => '[s:162]',
            102 => '[s:162]',
            103 => '[s:271]',
            104 => '[s:289]',
            105 => '[カレンダー]',
            106 => '[s:127]',
            107 => '[s:73]',
            108 => '[s:93]',
            109 => '￥',
            110 => '[s:61]',
            111 => '[s:61]',
            112 => '[s:54]',
            113 => '[s:274]',
            114 => '[包丁]',
            115 => '[s:131]',
            116 => '[メガネ]',
            117 => '└→',
            118 => '←┘',
            119 => '[s:110]',
            120 => '[s:63]',
            121 => '[s:162]',
            122 => '[s:162]',
            123 => '[ネジ]',
            124 => '[s:152]',
            125 => '[s:27]',
            126 => '[s:292]',
            127 => '[s:164]',
            128 => '[s:164]',
            129 => '[s:91]',
            130 => '[懐中電灯]',
            131 => '[s:162]',
            132 => '[チェックマーク]',
            133 => '[s:114]',
            134 => '[s:82]',
            135 => '[電池]',
            136 => '[スクロール]',
            137 => '[画びょう]',
            138 => '[s:158]',
            139 => '[s:137]',
            140 => '[s:228]',
            141 => '[s:229]',
            142 => '[s:162]',
            143 => '[クリップ]',
            144 => '[s:108]',
            145 => '[名札]',
            146 => '[s:67]',
            147 => '[s:162]',
            148 => '[s:394]',
            149 => '[s:271]',
            150 => '[PDC]',
            151 => '[s:93]',
            152 => '[レンチ]',
            153 => '[送信BOX]',
            154 => '[受信BOX]',
            155 => '[s:9]',
            156 => '[s:56]',
            157 => '[定規]',
            158 => '[三角定規]',
            159 => '[グラフ]',
            160 => '[肉]',
            161 => '[s:10]',
            162 => '[コンセント]',
            163 => '[家族]',
            164 => '[リンク]',
            165 => '[s:108]',
            166 => '[s:11]',
            167 => '[s:74][s:73]',
            168 => '[s:29]',
            169 => '[s:28]',
            170 => '[サイコロ]',
            171 => '[新聞]',
            172 => '[s:30]',
            173 => '　',
            174 => '0',
            175 => '0',
            176 => '[s:284]',
            177 => '[s:188]',
            178 => '[s:190]',
            179 => '[s:189]',
            180 => '[s:208]',
            181 => '[s:209]',
            182 => '[s:210]',
            183 => '[s:211]',
            184 => '[s:212]',
            185 => '[s:213]',
            186 => '[s:214]',
            187 => '[s:215]',
            188 => '[s:216]',
            189 => '[10]',
            190 => '[s:414]',
            191 => '[s:72]',
            192 => '[s:243]',
            193 => '[s:244]',
            194 => '[s:245]',
            195 => '[s:246]',
            196 => '[s:247]',
            197 => '[s:248]',
            198 => '[s:249]',
            199 => '[s:250]',
            200 => '[s:251]',
            201 => '[s:252]',
            202 => '[s:253]',
            203 => '[s:254]',
            204 => '[s:255]',
            205 => '[s:174]',
            206 => '[s:176]',
            207 => '[s:171]',
            208 => '[s:169]',
            209 => '[s:170]',
            210 => '[s:165]',
            211 => '[s:182]',
            212 => '[s:167]',
            213 => '[s:58]',
            214 => '[地図]',
            215 => '[s:144]',
            216 => '[s:179]',
            217 => '[s:31]',
            218 => '[s:111]',
            219 => '[s:24]',
            220 => '[s:21]',
            221 => '[スノボ]',
            222 => '[s:140]',
            223 => '[s:126]',
            224 => '[s:125]',
            225 => '[s:281]',
            226 => '[s:306]',
            227 => '[s:422]',
            228 => '[s:432]',
            229 => '[s:141]',
            230 => '[オメデトウ]',
            231 => '[s:138]',
            232 => '[ゲーム]',
            233 => '[s:137]',
            234 => '[s:51]',
            235 => '[s:48]',
            236 => '[s:117]',
            237 => '[s:434]',
            238 => '[s:342]',
            239 => '[s:70]',
            240 => '[s:161]',
            241 => '[さくらんぼ]',
            242 => '[s:25]',
            243 => '[s:341]',
            244 => '[s:336]',
            245 => '[s:122]',
            246 => '[s:84]',
            247 => '[s:467]',
            248 => '[s:26]',
            249 => '[s:99]',
            250 => '[s:472]',
            251 => '[s:79]',
            252 => '[s:85]',
            253 => '[アリ]',
            254 => '[s:101]',
            255 => '[s:277]',
            256 => '[s:275]',
            257 => '[s:87]',
            258 => '[s:89]',
            259 => '[s:364]',
            260 => '[s:353]',
            261 => '[s:150]',
            262 => '[s:322]',
            263 => '[s:319]',
            264 => '[s:95]',
            265 => '[s:35]',
            266 => '[s:309]',
            267 => '[s:316]',
            268 => '[s:287]',
            269 => '[s:119]',
            270 => '[SOS]',
            271 => '[s:166]',
            272 => '[s:311]',
            273 => '[s:3]',
            274 => '[s:102]',
            275 => '[なると]',
            276 => '[s:477]',
            277 => '[s:116]',
            278 => '[花丸]',
            279 => '[s:291]',
            280 => '[100点]',
            281 => '[s:13]',
            282 => '[s:318]',
            283 => '[s:90]',
            284 => '[s:15]',
            285 => '[s:218]',
            286 => '[s:118]',
            287 => '[s:14]',
            288 => '[s:132]',
            289 => '[s:60]',
            290 => '[財布]',
            291 => '[s:308]',
            292 => '[s:65]',
            293 => '[バイオリン]',
            294 => '[s:280]',
            295 => '[s:298]',
            296 => '[s:109]',
            297 => '[s:300]',
            298 => '[EZ]',
            299 => '[FREE]',
            300 => '[s:128]',
            301 => '[s:6]',
            302 => '[s:102]',
            303 => '[s:199]',
            304 => '[s:149]',
            305 => '[霧]',
            306 => '[s:20]',
            307 => '[s:389]',
            308 => '[ポケベル]',
            309 => '[s:425]',
            310 => '[s:426]',
            311 => '[イベント]',
            312 => '[s:290]',
            313 => '[s:345]',
            314 => '[s:194]',
            315 => '[s:193]',
            316 => '[s:195]',
            317 => '[s:372]',
            318 => '[s:374]',
            319 => '[s:17]',
            320 => '[s:18]',
            321 => '●',
            322 => '[s:76]',
            323 => '[s:76]',
            324 => '[CL]',
            325 => '[s:217]',
            326 => '[s:257]',
            327 => '[s:353]',
            328 => '[s:309]',
            329 => '[ドンッ]',
            330 => '[s:319]',
            331 => '[ezplus]',
            332 => '[地球]',
            333 => '[s:334]',
            334 => '[s:198]',
            335 => '[s:6]',
            336 => '[s:7]',
            337 => '[s:12]',
            338 => '[s:130]',
            339 => '[s:50]',
            340 => '[s:55]',
            341 => '[s:399]',
            342 => '[s:59]',
            343 => '[s:62]',
            344 => '[s:78]',
            345 => '[s:80]',
            346 => '[s:81]',
            347 => '[s:83]',
            348 => '[s:352]',
            349 => '[s:96]',
            350 => '[s:363]',
            351 => '[s:98]',
            352 => '[s:100]',
            353 => '[s:103]',
            354 => '[s:104]',
            355 => '[s:107]',
            356 => '[s:112]',
            357 => '[s:113]',
            358 => '[s:115]',
            359 => '[s:120]',
            360 => '[s:123]',
            361 => '[s:124]',
            362 => '[s:135]',
            363 => '[s:136]',
            364 => '[s:139]',
            365 => '[カメ]',
            366 => '[s:440]',
            367 => '[s:441]',
            368 => '[s:145]',
            369 => '[s:153]',
            370 => '[s:157]',
            371 => '[s:160]',
            372 => '[s:458]',
            373 => '[s:164]',
            374 => '[s:172]',
            375 => '[s:173]',
            376 => '[s:175]',
            377 => '[s:177]',
            378 => '[s:178]',
            379 => '[s:182]',
            380 => '[s:187]',
            381 => '[s:191]',
            382 => '[s:200]',
            383 => '[s:219]',
            384 => '[s:220]',
            385 => '[s:221]',
            386 => '[s:222]',
            387 => '[s:223]',
            388 => '[s:224]',
            389 => '[s:225]',
            390 => '[s:226]',
            391 => '[s:227]',
            392 => '[s:242]',
            393 => '[s:260]',
            394 => '[s:261]',
            395 => '[s:271]',
            396 => '[s:272]',
            397 => '[s:273]',
            398 => '[s:276]',
            399 => '[s:278]',
            400 => '[s:281]',
            401 => '[s:282]',
            402 => '[s:283]',
            403 => '[s:285]',
            404 => '[s:286]',
            405 => '[s:288]',
            406 => '[EZナビ]',
            407 => '[s:294]',
            408 => '[s:297]',
            409 => '[s:299]',
            410 => '[s:301]',
            411 => '[s:302]',
            412 => '[s:303]',
            413 => '[s:304]',
            414 => '[s:192]',
            415 => '[s:309]',
            416 => '[s:312]',
            417 => '[s:313]',
            418 => '[s:314]',
            419 => '[s:315]',
            420 => '[s:316]',
            421 => '[s:19]',
            422 => '[s:320]',
            423 => '[s:326]',
            424 => '[s:327]',
            425 => '[s:328]',
            426 => '[s:329]',
            427 => '[s:330]',
            428 => '[s:331]',
            429 => '[s:332]',
            430 => '[s:333]',
            431 => '[s:335]',
            432 => '[s:337]',
            433 => '[s:338]',
            434 => '[s:339]',
            435 => '[s:340]',
            436 => '[s:343]',
            437 => '[s:344]',
            438 => '[s:346]',
            439 => '[s:347]',
            440 => '[s:349]',
            441 => '[s:350]',
            442 => '[s:351]',
            443 => '[s:353]',
            444 => '[s:354]',
            445 => '[s:355]',
            446 => '[s:357]',
            447 => '[s:358]',
            448 => '[s:359]',
            449 => '[s:360]',
            450 => '[s:361]',
            451 => '[s:363]',
            452 => '[s:362]',
            453 => '[s:308]',
            454 => '[s:86]',
            455 => '[s:370]',
            456 => '[s:371]',
            457 => '[s:373]',
            458 => '[s:375]',
            459 => '[s:376]',
            460 => '[s:378]',
            461 => '[s:379]',
            462 => '[s:380]',
            463 => '[s:377]',
            464 => '[s:382]',
            465 => '[s:383]',
            466 => '[s:385]',
            467 => '[s:384]',
            468 => '[s:388]',
            469 => '[s:66]',
            470 => '[s:391]',
            471 => '[s:392]',
            472 => '[s:395]',
            473 => '[s:396]',
            474 => '[s:397]',
            475 => '[s:398]',
            476 => '[s:401]',
            477 => '[s:403]',
            478 => '[s:404]',
            479 => '[s:405]',
            480 => '[s:406]',
            481 => '[s:407]',
            482 => '[花嫁]',
            483 => '[s:410]',
            484 => '[s:411]',
            485 => '[s:412]',
            486 => '[s:413]',
            487 => '[s:416]',
            488 => '[s:417]',
            489 => '[s:419]',
            490 => '[s:422]',
            491 => '[s:423]',
            492 => '[s:424]',
            493 => '[s:420]',
            494 => '[s:426]',
            495 => '[s:427]',
            496 => '[s:428]',
            497 => '[s:429]',
            498 => '[s:431]',
            499 => '[s:436]',
            500 => '[オープンウェブ]',
            501 => '[s:158]',
            502 => '[ABCD]',
            503 => '[abcd]',
            504 => '[1234]',
            505 => '[記号]',
            506 => '[可]',
            507 => '[チェックマーク]',
            508 => '[ペン]',
            509 => '[ラジオボタン]',
            510 => '[s:110]',
            511 => '[s:233]',
            512 => '[ブックマーク]',
            513 => '[s:94]',
            514 => '[s:54]',
            515 => '[s:91]',
            516 => '[s:271]',
            517 => '[s:158]',
            518 => '↑↓',
            700 => '[s:437]',
            701 => '[s:438]',
            702 => '[s:439]',
            703 => '[s:442]',
            704 => '[s:443]',
            705 => '[s:444]',
            706 => '[s:445]',
            707 => '[s:446]',
            708 => '[s:447]',
            709 => '[s:448]',
            710 => '[s:449]',
            711 => '[s:450]',
            712 => '[s:451]',
            713 => '[s:455]',
            714 => '[s:454]',
            715 => '[s:457]',
            716 => '[s:460]',
            717 => '[s:461]',
            718 => '[s:462]',
            719 => '[s:466]',
            720 => '[s:468]',
            721 => '[s:469]',
            722 => '[s:470]',
            723 => '[s:471]',
            724 => '[s:473]',
            725 => '[s:474]',
            726 => '[s:476]',
            727 => '[s:475]',
            728 => '[s:477]',
            729 => '[s:7]',
            730 => '[旗]',
            731 => '[s:234]',
            732 => '[s:236]',
            733 => '！？',
            734 => '！！',
            735 => '～',
            736 => '[メロン]',
            737 => '[パイナップル]',
            738 => '[ブドウ]',
            739 => '[バナナ]',
            740 => '[とうもろこし]',
            741 => '[キノコ]',
            742 => '[栗]',
            743 => '[モモ]',
            744 => '[やきいも]',
            745 => '[ピザ]',
            746 => '[チキン]',
            747 => '[七夕]',
            748 => '[s:68]',
            749 => '[辰]',
            750 => '[ピアノ]',
            751 => '[s:23]',
            752 => '[s:25]',
            753 => '[ボーリング]',
            754 => '[なまはげ]',
            755 => '[天狗]',
            756 => '[パンダ]',
            757 => '[s:356]',
            758 => '[s:101]',
            759 => '[s:275]',
            760 => '[アイスクリーム]',
            761 => '[ドーナツ]',
            762 => '[クッキー]',
            763 => '[チョコ]',
            764 => '[キャンディ]',
            765 => '[キャンディ]',
            766 => '(/_＼)',
            767 => '(・×・)',
            768 => '|(・×・)|',
            769 => '[火山]',
            770 => '[s:310]',
            771 => '[ABC]',
            772 => '[プリン]',
            773 => '[ミツバチ]',
            774 => '[てんとう虫]',
            775 => '[ハチミツ]',
            776 => '[s:339]',
            777 => '[飛んでいくお金]',
            778 => '[s:354]',
            779 => '[s:369]',
            780 => '[s:369]',
            781 => '[s:422]',
            782 => '[s:371]',
            783 => '[s:87]',
            784 => '[s:93]',
            785 => '[s:365]',
            786 => '[s:365]',
            787 => '[s:96]',
            788 => '[s:350]',
            789 => '[s:350]',
            790 => '[s:366]',
            791 => '[s:366]',
            792 => '[s:351]',
            793 => '[s:295]',
            794 => '[モアイ]',
            795 => '[s:57]',
            796 => '[花札]',
            797 => '[ジョーカー]',
            798 => '[エビフライ]',
            799 => '[s:93]',
            800 => '[s:181]',
            801 => '[s:397]',
            802 => '[EZムービー]',
            803 => '[s:309]',
            804 => '[s:458]',
            805 => '[ジーンズ]',
            806 => '[s:93][s:310]',
            807 => '↑↓',
            808 => '⇔',
            809 => '↑↓',
            810 => '[s:409]',
            811 => '[s:106]',
            812 => '[カタツムリ]',
            813 => '[s:351]',
            814 => '[s:351]',
            815 => '[Cメール]',
            816 => '[s:106]',
            817 => '[s:16]',
            818 => '[s:196]',
            819 => '[s:18]',
            820 => '[s:386]',
            821 => '[s:350]',
            822 => '[s:369]',
        );
    }

    function &getInstance()
    {
        static $singleton;
        if (empty($singleton)) {
            $singleton = new OpenPNE_KtaiEmoji();
        }
        return $singleton;
    }

    /**
     * 与えられた絵文字からその絵文字の絵文字コードを取得する
     */
    function get_emoji_code4emoji($emoji, $carrier = '')
    {
        $emoji_code = '';
        switch ($carrier) {
        case 'i':
            $converter = OpenPNE_KtaiEmoji_Docomo::getInstance();
            $emoji_code = $converter->get_emoji_code4emoji($emoji);
            break;
        case 's':
            $converter = OpenPNE_KtaiEmoji_Softbank::getInstance();
            $emoji_code = $converter->get_emoji_code4emoji($emoji);
            break;
        case 'e':
            $converter = OpenPNE_KtaiEmoji_Au::getInstance();
            $emoji_code = $converter->get_emoji_code4emoji($emoji);
            break;
        default:
            //キャリアが指定されていない場合は全てのキャリアでチェックを行う
            $converter = OpenPNE_KtaiEmoji_Docomo::getInstance();
            $emoji_code = $converter->get_emoji_code4emoji($emoji);
            if (!$emoji_code) {
                $converter = OpenPNE_KtaiEmoji_Softbank::getInstance();
                $emoji_code = $converter->get_emoji_code4emoji($emoji);
            }
            if (!$emoji_code) {
                $converter = OpenPNE_KtaiEmoji_Au::getInstance();
                $emoji_code = $converter->get_emoji_code4emoji($emoji);
            }
            break;
        }

        return $emoji_code;
    }

    /**
     * 絵文字コードを指定キャリアの絵文字もしくは代替文字列に変換する
     */
    function convert_emoji($o_code, $c_carrier = null)
    {
        $o_carrier = $o_code[0];
        $o_id = substr($o_code, 2);

        if (is_null($c_carrier) || ($o_carrier == $c_carrier)) {  // キャリアの変更がないか、キャリアが指定されていない場合はそのまま変換処理
            $c_code = $o_id;
            switch ($c_carrier) {
            case 'i':
                $converter = OpenPNE_KtaiEmoji_Docomo::getInstance();
                break;
            case 's':
                $converter = OpenPNE_KtaiEmoji_Softbank::getInstance();
                break;
            case 'e':
                $converter = OpenPNE_KtaiEmoji_Au::getInstance();
                break;
            default:
                // PC向けau/SoftBank→DoCoMo絵文字変換
                if (OPENPNE_EMOJI_DOCOMO_FOR_PC && $o_carrier !== 'i') {
                    return emoji_convert($this->relation_list[$o_carrier]['i'][$o_id]);
                }

                $c_code = $o_code;  // 画像出力の際にキャリア情報が必要になるため、絵文字IDではなく絵文字コードを用いる
                $converter = OpenPNE_KtaiEmoji_Img::getInstance();
                break;
            }
            return $converter->get_emoji4emoji_code_id($c_code);
        } else {  // キャリアの変更がある場合、ここでの変換処理はおこなわず、対応する文字列に置換した上で再度変換処理
            return emoji_convert($this->relation_list[$o_carrier][$c_carrier][$o_id]);
        }
    }
}

?>
