/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.lms.XcalatInputValue;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

public class XcalatInputAction
implements InstallerAction {
    private static Logger _logger = LoggerUtil.getLogger(class$jp$co$ntt$lms$installer$lms$XcalatInputAction == null ? (class$jp$co$ntt$lms$installer$lms$XcalatInputAction = XcalatInputAction.class$("jp.co.ntt.lms.installer.lms.XcalatInputAction")) : class$jp$co$ntt$lms$installer$lms$XcalatInputAction);
    static /* synthetic */ Class class$jp$co$ntt$lms$installer$lms$XcalatInputAction;

    public boolean isSkipped(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");
        boolean bl = false;
        try {
            bl = !installerValues.getOptionLOSelected("xcalat");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", bl);
        return bl;
    }

    public InstallerActionValue action(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "action(InstallerValues)");
        XcalatInputValue xcalatInputValue = null;
        try {
            XcalatInputValue xcalatInputValue2 = this.getDefaultValue(installerValues);
            InstallerUiUtil.outputMessageAsTitle(installerValues, "XcalatInputAction.welcome");
            while (!this.confirmInputValue(installerValues, xcalatInputValue = this.readInputValue(installerValues, xcalatInputValue2))) {
            }
            File file = new File(xcalatInputValue.getMaterialInstallPath());
            installerValues.addMadeDirectory(file);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "action(InstallerValues)", xcalatInputValue);
        return xcalatInputValue;
    }

    private XcalatInputValue readInputValue(InstallerValues installerValues, XcalatInputValue xcalatInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "readInputValue(InstallerValues)");
        XcalatInputValue xcalatInputValue2 = null;
        try {
            xcalatInputValue2 = new XcalatInputValue();
            String[] stringArray = xcalatInputValue.getServerNames();
            int n = 0;
            while ((n = InstallerUiUtil.askUserInputInteger(installerValues, "XcalatInputAction.prompt.serverNumber")) <= 0) {
            }
            for (int i = 0; i < n; ++i) {
                String string = null;
                if (i < stringArray.length) {
                    string = stringArray[i];
                }
                String string2 = null;
                while (InstallerCheckUtil.isEmptyViolation(string2 = InstallerUiUtil.askUserInput(installerValues, "XcalatInputAction.prompt.serverName", string), installerValues, "XcalatInputAction.error.serverName.empty")) {
                }
                xcalatInputValue2.addServerName(string2);
            }
            String string = null;
            while (InstallerCheckUtil.isEmptyViolation(string = InstallerUiUtil.askUserInput(installerValues, "XcalatInputAction.prompt.materialInstallPath", xcalatInputValue.getMaterialInstallPath()), installerValues, "XcalatInputAction.error.materialInstallPath.empty") || InstallerCheckUtil.isFilePath(string, installerValues, "XcalatInputAction.error.materialInstallPath.file")) {
            }
            xcalatInputValue2.setMaterialInstallPath(string);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "readInputValue(InstallerValues)", xcalatInputValue2);
        return xcalatInputValue2;
    }

    private boolean confirmInputValue(InstallerValues installerValues, XcalatInputValue xcalatInputValue) throws InstallerException {
        LoggerUtil.methodHead(_logger, "confirmInputValue(InstallerValues, XcalatInputValue)");
        boolean bl = false;
        try {
            InstallerUiUtil.outputConfirmTitle(installerValues, "XcalatInputAction.confirm.title");
            String[] stringArray = xcalatInputValue.getServerNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                InstallerUiUtil.outputConfirm(installerValues, "XcalatInputAction.confirm.serverName", objectArray, stringArray[i]);
            }
            InstallerUiUtil.outputConfirm(installerValues, "XcalatInputAction.confirm.materialInstallPath", xcalatInputValue.getMaterialInstallPath());
            bl = InstallerUiUtil.askUserConfirm(installerValues, "XcalatInputAction.confirm");
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "confirmInputValue(InstallerValues, XcalatInputValue)", bl);
        return bl;
    }

    private XcalatInputValue getDefaultValue(InstallerValues installerValues) throws InstallerException {
        LoggerUtil.methodHead(_logger, "getDefaultValue(InstallerValues)");
        XcalatInputValue xcalatInputValue = null;
        try {
            String string;
            xcalatInputValue = new XcalatInputValue();
            File file = installerValues.getFileOnSystem(xcalatInputValue.getTargetFileKey());
            Properties properties = FileUtil.loadAsProperties(file);
            Properties properties2 = InstallerPropertiesUtil.load(installerValues, xcalatInputValue.getTargetFileKey());
            int n = 0;
            while (!StringUtil.isEmpty(string = properties.getProperty("xcal_name" + (n + 1)))) {
                String string2 = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "xcal_name" + (n + 1));
                xcalatInputValue.addServerName(string2);
                ++n;
            }
            String string3 = InstallerPropertiesUtil.determineInitialValue(properties, properties2, "material_temp");
            xcalatInputValue.setMaterialInstallPath(string3);
        }
        catch (InstallerException installerException) {
            throw installerException;
        }
        catch (Exception exception) {
            LoggerUtil.throwable(_logger, exception);
            throw new InstallerException(exception);
        }
        LoggerUtil.methodTail(_logger, "getDefaultValue(InstallerValues)", xcalatInputValue);
        return xcalatInputValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

