/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSRPCParameter;
import com.microsoft.jdbc.sqlserver.tds.TDSRPCRequest;
import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilByteOrderedDataWriter;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public class TDSCursorRequest
extends TDSRPCRequest {
    private static String footprint = "$Revision:   1.11.1.0  $";
    String commandText;
    String cursorName;
    int requestedConcurrency;
    int requestedScrollType;
    int actualScrollType;
    int cursorHandle;
    int cursorType;
    int concurrencyOptions;
    int rowsInTable;
    static final int DEFAULT_FETCH_SIZE = 256;
    int fetchSize;
    boolean resultTypeHasBeenRequested;
    boolean executingSQLDirectly;
    TDSRPCParameter cursorHandleParam;
    TDSRPCParameter cursorTypeParam;
    TDSRPCParameter concurrencyOptionsParam;
    TDSRPCParameter rowsInTableParam;
    TDSRPCParameter rowNumberParam;
    TDSRPCParameter numRowsParam;

    public TDSCursorRequest(TDSConnection tDSConnection, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string, int n, int n2, boolean bl) {
        super(tDSConnection, utilByteOrderedDataReader, utilByteOrderedDataWriter, "");
        int n3;
        this.commandText = string;
        this.cursorName = null;
        this.cursorHandle = -1;
        this.executingSQLDirectly = false;
        this.fetchSize = 256;
        this.requestedScrollType = n;
        this.requestedConcurrency = n2;
        this.reset("sp_cursoropen", 1, 0);
        this.cursorHandleParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        this.cursorHandleParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(0));
        this.addParameter(this.cursorHandleParam);
        TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)99, true, false, string.length(), string.length(), 0, new String(string));
        this.addParameter(tDSRPCParameter);
        this.cursorTypeParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        switch (this.requestedScrollType) {
            case 1003: {
                n3 = 4;
                break;
            }
            case 1004: {
                n3 = 8;
                break;
            }
            case 1005: {
                n3 = 1;
                break;
            }
            default: {
                n3 = 4;
            }
        }
        if (bl) {
            n3 |= 0x1000;
        }
        this.cursorTypeParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(n3));
        this.addParameter(this.cursorTypeParam);
        this.concurrencyOptionsParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        this.concurrencyOptionsParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(8193));
        this.addParameter(this.concurrencyOptionsParam);
        this.rowsInTableParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        this.rowsInTableParam.initializeInternalParam((byte)56, true, true, 4, 4, 0, new Integer(0));
        this.addParameter(this.rowsInTableParam);
    }

    public void closeCursor(BaseWarnings baseWarnings) throws SQLException {
        this.reset("sp_cursorclose", 1, 0);
        TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(this.cursorHandle));
        this.addParameter(tDSRPCParameter);
        this.submitRequest();
        this.processReply(baseWarnings);
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        if (this.executingSQLDirectly) {
            super.completeRowProcessing(baseWarnings);
        } else {
            this.closeCursor(baseWarnings);
        }
    }

    public boolean fetchAbsolute(int n, BaseWarnings baseWarnings) throws SQLException {
        this.sendCursorFetch(16, n, baseWarnings);
        return this.getRow(baseWarnings);
    }

    private int getActualScrollType() {
        int n;
        if (this.executingSQLDirectly) {
            n = 1003;
        } else {
            switch (this.cursorType) {
                case 4: 
                case 16: {
                    n = 1003;
                    break;
                }
                case 8: {
                    if (this.requestedScrollType == 1003) {
                        n = 1003;
                        break;
                    }
                    n = 1004;
                    break;
                }
                case 1: {
                    if (this.requestedScrollType == 1003) {
                        n = 1003;
                        break;
                    }
                    if (this.requestedScrollType == 1004) {
                        n = 1004;
                        break;
                    }
                    n = 1003;
                    break;
                }
                default: {
                    UtilDebug.assert((String)"Unexpected cursor type", (boolean)false);
                    n = 1003;
                }
            }
        }
        return n;
    }

    public boolean getExecutingSQLDirectly() {
        return this.executingSQLDirectly;
    }

    public int getNumResultRows() {
        return this.rowsInTable;
    }

    public int getResultType() {
        if (this.executingSQLDirectly) {
            return super.getResultType();
        }
        if (this.resultTypeHasBeenRequested) {
            return 1;
        }
        this.resultTypeHasBeenRequested = true;
        return 2;
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        if (this.executingSQLDirectly) {
            return super.getRow(baseWarnings);
        }
        if (super.getRow(baseWarnings)) {
            return true;
        }
        this.processReply(baseWarnings);
        if (this.actualScrollType == 1003) {
            this.sendCursorFetch(2, 1, baseWarnings);
            if (super.getRow(baseWarnings)) {
                return true;
            }
            this.processReply(baseWarnings);
        }
        return false;
    }

    public int getScrollType() {
        return this.actualScrollType;
    }

    public void openCursor(BaseWarnings baseWarnings) throws SQLException {
        this.resultTypeHasBeenRequested = false;
        this.submitRequest();
        this.processReply(baseWarnings);
        if (!this.executingSQLDirectly) {
            this.cursorHandle = (Integer)this.cursorHandleParam.value;
            this.cursorType = (Integer)this.cursorTypeParam.value;
            this.concurrencyOptions = (Integer)this.concurrencyOptionsParam.value;
            this.rowsInTable = (Integer)this.rowsInTableParam.value;
            this.actualScrollType = this.getActualScrollType();
            this.sendCursorFetch(2, 1, baseWarnings);
        } else {
            this.rowsInTable = -1;
            this.actualScrollType = 1003;
        }
    }

    protected boolean processInfoTokenAction(int n, byte by, byte by2) {
        if (n == 16954) {
            this.executingSQLDirectly = true;
            this.processMode = 2;
            return false;
        }
        return true;
    }

    public void reset(String string, int n, int n2) {
        this.parameters.removeAllElements();
        this.procedureName = string;
        this.processMode = n;
        this.RPCOptions = n2;
    }

    private void sendCursorFetch(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        this.reset("sp_cursorfetch", 2, 2);
        this.numRowsFetchedFromResultSet = 0;
        TDSRPCParameter tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(this.cursorHandle));
        this.addParameter(tDSRPCParameter);
        tDSRPCParameter = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        tDSRPCParameter.initializeInternalParam((byte)56, true, false, 4, 4, 0, new Integer(n));
        this.addParameter(tDSRPCParameter);
        this.rowNumberParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        Integer n3 = n == 16 || n == 32 ? new Integer(n2) : new Integer(1);
        boolean bl = n == 256;
        this.rowNumberParam.initializeInternalParam((byte)56, bl ^ true, bl, 4, 4, 0, n3);
        this.addParameter(this.rowNumberParam);
        this.numRowsParam = new TDSRPCParameter(this.conn.getTDSVersion(), 28, this.conn.exceptions);
        Integer n4 = (n == 1 || n == 8) && n2 == 0 ? new Integer(0) : (this.actualScrollType == 1003 ? new Integer(this.fetchSize) : new Integer(1));
        this.numRowsParam.initializeInternalParam((byte)56, bl ^ true, bl, 4, 4, 0, n4);
        this.addParameter(this.numRowsParam);
        this.submitRequest();
        if (this.conn.getTDSVersion() == 2 || n == 256) {
            this.processReply(baseWarnings);
        }
        this.resultType = 2;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n > 0 ? n : 256;
    }
}

