/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.vprt;

import com.microsoft.jdbc.vprt.SSLexMark;

public abstract class SSLexConsumer {
    private static String footprint = "$Revision:   1.2.1.0  $";
    public int m_line = 0;
    public int m_start = 0;
    public int m_index = 0;
    public int m_offset = 0;
    public char m_current;
    public char m_bof = '\u0000';
    public int m_length = 0;
    public int m_consumed = 0;
    public int m_scanLine = 0;
    public int m_scanOffset = 0;
    public boolean m_endOfData = false;
    public StringBuffer m_buffer = new StringBuffer(4096);

    public int absoluteOffset() {
        return this.m_start;
    }

    public void flushEndOfLine(SSLexMark sSLexMark) {
        --sSLexMark.m_line;
        --sSLexMark.m_index;
    }

    public void flushLexeme() {
        this.m_start = this.m_index;
        this.m_line += this.m_scanLine;
        this.m_offset = this.m_scanOffset;
        this.m_scanLine = 0;
    }

    public void flushLexeme(SSLexMark sSLexMark) {
        this.m_start = this.m_index = sSLexMark.m_index;
        this.m_line += sSLexMark.m_line;
        this.m_offset = sSLexMark.m_offset;
        this.m_scanLine = 0;
        this.m_scanOffset = sSLexMark.m_offset;
    }

    public void flushStartOfLine(SSLexMark sSLexMark) {
        ++this.m_line;
        ++this.m_start;
        --sSLexMark.m_line;
        this.m_offset = 1;
    }

    public char getCurrent() {
        return this.m_current;
    }

    public abstract boolean getNext();

    public char[] lexemeBuffer() {
        char[] cArray = new char[this.lexemeLength()];
        int n = this.m_start;
        while (n < this.m_index - 1) {
            cArray[n - this.m_start] = this.m_buffer.charAt(n);
            ++n;
        }
        return cArray;
    }

    public char[] lexemeBuffer(SSLexMark sSLexMark) {
        int n = this.lexemeLength(sSLexMark);
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = this.m_buffer.charAt(this.m_start + n2);
            ++n2;
        }
        return cArray;
    }

    public int lexemeLength() {
        return this.m_index - this.m_start;
    }

    public int lexemeLength(SSLexMark sSLexMark) {
        return sSLexMark.index() - this.m_start;
    }

    public int line() {
        return this.m_line;
    }

    public SSLexMark mark() {
        return new SSLexMark(this.m_scanLine, this.m_scanOffset, this.m_index);
    }

    public boolean next() {
        if (this.m_endOfData) {
            return false;
        }
        this.m_current = this.m_bof;
        if (this.m_current != '\u0000') {
            this.m_bof = '\u0000';
            return true;
        }
        if (this.m_index >= this.m_buffer.length()) {
            if (!this.getNext()) {
                ++this.m_index;
                this.m_endOfData = true;
                return false;
            }
            ++this.m_index;
            this.m_buffer.append(this.m_current);
        } else {
            this.m_current = this.m_buffer.charAt(this.m_index++);
        }
        if (this.m_current == '\n') {
            ++this.m_scanLine;
            this.m_scanOffset = 1;
        } else {
            ++this.m_scanOffset;
        }
        return true;
    }

    public int offset() {
        return this.m_offset;
    }
}

