/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormObjectiveDataAccess
//	ύX
//		2004.02.01	VK쐬
//      2006.12.01@ύX T.Kiyokawa
//                  IMOXMLeLXg`ɕύXA
//

package jp.co.ntt.lms.lo.scorm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;

// CommentOut Start 2006.11.24 T.Kiyokawa wKOCSV̂
//import org.w3c.dom.Node;
// CommentOut End

/**
 * ScormObjectiveCommente[uւ̃ANZXENXB
 * @author T.Nishiki
 */
public class ScormObjectiveDataAccess extends ScormDataAccess {
	/**
	 * e[uB
	 */
	public static final String TABLE_NAME = "Scorm_Objective";
	/**
	 * e[uE񖼁F[UIDB
	 */
	public static final String USERID = "UserID";

	/**
	 * e[uE񖼁FLOIDB
	 */
	public static final String LOID = "LOID";

	/**
	 * e[uE񖼁FwKZbV񐔁B
	 */
	public static final String STUDY_SESSION_COUNT = "StudySessionCount";

	/**
	 * e[uE񖼁FANeBreBIDB
	 */
	public static final String ACTIVITYID = "ActivityID";

	/**
	 * e[uE񖼁Fs񐔁B
	 */
	public static final String ATTEMPT_COUNT = "AttemptCount";

	/**
	 * e[uE񖼁FLearnZbV񐔁B
	 */
	public static final String LEARN_SESSION_COUNT = "LearnSessionCount";

	/**
	 * e[uE񖼁FwKڕWB
	 */
	public static final String OBJECTIVE_COUNT = "ObjectiveCount";

	/**
	 * e[uE񖼁FZbVIDB
	 */
	public static final String SESSIONID = "SessionID";

	/**
	 * e[uE񖼁FwKڕWB
	 */
	public static final String OBJECTIVEID = "ObjectiveId";

	/**
	 * e[uE񖼁FKςݓ_B
	 */
	public static final String SCALEDSCORE = "ScaledScore";

	/**
	 * e[uE񖼁F_B
	 */
	public static final String RAWSCORE = "RawScore";

	/**
	 * e[uE񖼁Fō_B
	 */
	public static final String MAXSCORE = "MaxScore";

	/**
	 * e[uE񖼁FŒᓾ_B
	 */
	public static final String MINSCORE = "MinScore";

	/**
	 * e[uE񖼁FiXe[^XB
	 */
	public static final String SUCCESS_STATUS = "SuccessStatus";

	/**
	 * e[uE񖼁FXe[^XB
	 */
	public static final String COMPLETION_STATUS = "CompletionStatus";

	/**
	 * &lt;wKڕWID&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_OBJECTIVEID_VALUE =
		"./id/text()";

	/**
	 * &lt;Kςݓ_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_SCALED_SCORE_VALUE =
		"./score/scaled/text()";

	/**
	 * &lt;_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_RAW_SCORE_VALUE = "./score/raw/text()";

	/**
	 * &lt;ō_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_MAX_SCORE_VALUE = "./score/max/text()";

	/**
	 * &lt;Œᓾ_&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_MIN_SCORE_VALUE = "./score/min/text()";

	/**
	 * &lt;iXe[^X&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_SUCCESS_STATUS_VALUE =
		"./successstatus/text()";

	/**
	 * &lt;Xe[^X&gt;vf̒l擾邽߂̃P[VEpXB
	 */
	public static final String PATH_COMPLETION_STATUS_VALUE =
		"./completionstatus/text()";

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_MAX;

	/**
	 * J̍őTCYB
	 */
	public static final int COLUMN_SIZE_UNIT;
	
//	ADD start 2006.11.22 T.Kiyokawa

	/** 
	CSVEԍFwKڕWID 
	 */
	public static final int CSVCOL_OB_ID = 4 ;


	/** 
	CSVEԍFwKڕWɑ΂wK҂̐Kςݓ
	 */
	public static final int CSVCOL_OB_SCORE_SCALED = 5 ;


	/** 
	CSVEԍFwKڕWɑ΂链_ 
	 */
	public static final int CSVCOL_OB_SCORE_RAW = 6 ;


	/** 
	CSVEԍFwKڕWɑ΂ŏ_
	 */
	public static final int CSVCOL_OB_SCORE_MIN = 7 ;


	/** 
	CSVEԍFwKڕWɑ΂ő哾_
	 */
	public static final int CSVCOL_OB_SCORE_MAX = 8 ;


	/** 
	CSVEԍFwKڕWɑ΂鍇itO
	 */
	public static final int CSVCOL_OB_SUCCESS_STATUS = 9 ;


	/** 
	CSVEԍFwKڕWɑ΂銮tO
	 */
	public static final int CSVCOL_OB_COMPLETION_STATUS = 10 ;
//	ADD end 
	
	/**
	 * X^eBbNECjVCUB
	 * f[^x[X̎ʂɊÂAJ̍őTCY萔肵܂B
	 */
	static {
		// f[^x[XɂăJTCYETCYʂݒ
		int columnSizeMax = 0;
		int columnSizeUnit = 0;
		try {
			Environment environment = new Environment();
			String dbType = environment.getDBType();
			if (dbType.equals(Environment.DB_SQLSERVER)) {
				columnSizeMax = 4096;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_SQLSERVER;
			}
			else if (dbType.equals(Environment.DB_ORACLE)) {
				columnSizeMax = 4000;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_ORACLE;
			}
			else if (dbType.equals(Environment.DB_POSTGRE)) {
				columnSizeMax = 4096;
				columnSizeUnit = ScormLoConstant.COLUMN_SIZE_UNIT_POSTGRE;
			}
		}
		catch (Exception e) {
		}
		COLUMN_SIZE_MAX = columnSizeMax;
		COLUMN_SIZE_UNIT = columnSizeUnit;
	}

	/**
	 * RXgN^
	 **/
	public ScormObjectiveDataAccess() {
		super( TABLE_NAME );
	}

	// Add Start 2006.11.24 T.Kiyokawa

	/**
	 * ScormObjectivee[uւ݂̏s܂B<br>
	 * &lt;objective&gt;vfƂɌĂяoAR[hǉ܂B
	 *
	 * @param dataAccess f[^ANZXNXB
	 * @param endLearnData wKIB
	 * @param objectiveCsv &lt;objective&gt;CSVf[^B
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param objectiveCount wKڕWB
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;objective&gt;vf̈ʒuiPȏ̐jB
	 *
	 * @throws LOException f[^x[Xւ̏ɎsꍇB
	 */
	public static void insert(
		DataAccess dataAccess,
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData objectiveCsv,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		int objectiveCount)
		throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"HEAD insert("
				+ "dataAccess,endLearnData"
				+ "," + objectiveCsv + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + objectiveCount + ")",
			DebugLog.ROW);

		try {
			////////////////////////////////////////////////////////////////////
			// eJ̒l擾
			//==================================================================
			// Jƒl̃}bv
			ScormColumnInfo[] columnInfos =
				makeColumnInfos(
					endLearnData, objectiveCsv,
					activityID,	attemptCount,
					learnSessionCount, objectiveCount);
			////////////////////////////////////////////////////////////////////
			// SQL̐
			String query =
				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
			////////////////////////////////////////////////////////////////////
			// SQL̎s
			dataAccess.execute(query.toString());
		}
		catch (LOException e) {
			throw e;
		}
		catch (SQLException e) {
			DebugLog.write(
				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"TAIL insert("
				+ "dataAccess,endLearnData"
				+ "," + objectiveCsv + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + objectiveCount + ")",
			DebugLog.ROW);
	}

	/**
	 * ScormObjectivee[ũJz𐶐܂B<br>
	 * @param endLearnData wKIB
	 * @param objectiveCsv &lt;objective&gt;CSVf[^B
	 * @param activityID f[^ޑΏۂĂANeBreBIDB
	 * @param attemptCount s񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
	 * @param learnSessionCount LearnZbV񐔁B
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
	 * @param objectiveCount wKڕWB
	 *         wKOŁAf[^ޑΏۂĂ
	 *         &lt;objective&gt;vf̈ʒuiPȏ̐jB
	 * @return ScormObjectivee[ũJzB
	 * @throws LOException m[hf[^擾sꍇB
	 */
	private static ScormColumnInfo[] makeColumnInfos(
		ScormLoEndLearnData endLearnData,
		ScormLoCsvData objectiveCsv,
		String activityID,
		int attemptCount,
		int learnSessionCount,
		int objectiveCount)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"HEAD makeColumnInfos(endLearnData"
				+ "," + objectiveCsv + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + objectiveCount + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		ScormColumnInfo[] columnInfos = null;
		// z񐶐pXg
		List columnInfoList = new ArrayList();
		try {
			////////////////////////////////////////////////////////////////////
			// endLearnData擾łf[^JƂĐݒ
			//==================================================================
			// [UID
			String userID = endLearnData.getUserID();
			ScormColumnInfo userIDColumn = new ScormColumnInfo(
				USERID, userID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(userIDColumn);
			// LOID
			String loID = endLearnData.getLoID();
			ScormColumnInfo loIDColumn = new ScormColumnInfo(
				LOID, loID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(loIDColumn);
			// wKZbV
			int studySessionCount = endLearnData.getStudySession();
			ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
				STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(studySessionCountColumn);
			// ZbVID
			int sessionID = endLearnData.getLoginSession();
			ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
				SESSIONID, Integer.toString(sessionID),
				ScormColumnInfo.COLUMN_TYPE_STRING,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(sessionIDColumn);
			////////////////////////////////////////////////////////////////////
			// endLearnDataANodeȊO擾łf[^JƂĐݒ
			//==================================================================
			// ANeBreBID
			ScormColumnInfo activityIDColumn = new ScormColumnInfo(
				ACTIVITYID, activityID,
				ScormColumnInfo.COLUMN_TYPE_STRING,
				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
			columnInfoList.add(activityIDColumn);
			// s
			ScormColumnInfo attemptCountColumn = new ScormColumnInfo(
				ATTEMPT_COUNT, Integer.toString(attemptCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(attemptCountColumn);
			// LearnZbV
			ScormColumnInfo learnSessionCountColumn = new ScormColumnInfo(
				LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(learnSessionCountColumn);
			// wKڕW
			ScormColumnInfo objectiveCountColumn = new ScormColumnInfo(
				OBJECTIVE_COUNT, Integer.toString(objectiveCount),
				ScormColumnInfo.COLUMN_TYPE_NUMBER,
				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
			columnInfoList.add(objectiveCountColumn);
			////////////////////////////////////////////////////////////////////
			// Node擾łf[^JƂĐݒ
			//==================================================================
			List columnInfoFromNodeList =
				makeColumnInfosFromCSV(objectiveCsv);
			columnInfoList.addAll(columnInfoFromNodeList);
			////////////////////////////////////////////////////////////////////
			// Xgzɕϊ
			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
			columnInfoList.toArray(columnInfos);
		}
		catch (LOException e) {
			throw e;
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"TAIL makeColumnInfos(endLearnData"
				+ "," + objectiveCsv + "," + activityID
				+ "," + attemptCount + "," + learnSessionCount
				+ "," + objectiveCount + ")"
				+ " return " + columnInfos,
			DebugLog.ROW);
		return columnInfos;
	}

	/**
	 * m[hScormObjectivee[ũJz𐶐܂B<br>
	 * @param objectiveCsv &lt;objective&gt;CSVf[^B
	 * @return ScormObjectivee[ũJzB
	 * @throws LOException m[hf[^擾sꍇB
	 */
	private static List makeColumnInfosFromCSV(ScormLoCsvData objectiveCsv)
		throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"HEAD makeColumnInfosFromNode(" + objectiveCsv + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		List columnInfoList = new ArrayList();
		try {
			////////////////////////////////////////////////////////////////////
			// Node擾łf[^JƂĐݒ
			//==================================================================
			// wKڕW
			String objectiveId =
				objectiveCsv.getData(CSVCOL_OB_ID);
			if ( objectiveId != null ) {
				ScormColumnInfo objectiveIdColumn = new ScormColumnInfo(
					OBJECTIVEID, objectiveId,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(objectiveIdColumn);
			}
			// Kςݓ_
			String scaledScore =
				objectiveCsv.getData(CSVCOL_OB_SCORE_SCALED);
			if (scaledScore != null ) {
				ScormColumnInfo scaledScoreColumn = new ScormColumnInfo(
					SCALEDSCORE, scaledScore,
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(scaledScoreColumn);
			}
			// _
			String rawScore =
				objectiveCsv.getData(CSVCOL_OB_SCORE_RAW) ;
			if (rawScore != null ) {
				ScormColumnInfo rawScoreColumn = new ScormColumnInfo(
					RAWSCORE, rawScore,
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(rawScoreColumn);
			}
			// ō_
			String maxScore =
				objectiveCsv.getData(CSVCOL_OB_SCORE_MAX) ;
			if (maxScore != null) {
				ScormColumnInfo maxScoreColumn = new ScormColumnInfo(
					MAXSCORE, maxScore,
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(maxScoreColumn);
			}
			// Œᓾ_
			String minScore =
				objectiveCsv.getData(CSVCOL_OB_SCORE_MIN) ;
			if (minScore != null) {
				ScormColumnInfo minScoreColumn = new ScormColumnInfo(
					MINSCORE, minScore,
					ScormColumnInfo.COLUMN_TYPE_NUMBER,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(minScoreColumn);
			}
			// iXe[^X
			String successStatus =
				objectiveCsv.getData(CSVCOL_OB_SUCCESS_STATUS) ;
			if (successStatus != null) {
				ScormColumnInfo successStatusColumn = new ScormColumnInfo(
					SUCCESS_STATUS, successStatus,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(successStatusColumn);
			}
			// Xe[^X
			String completionStatus =
				objectiveCsv.getData(CSVCOL_OB_COMPLETION_STATUS) ;
			if (completionStatus != null) {
				ScormColumnInfo completionStatusColumn = new ScormColumnInfo(
					COMPLETION_STATUS, completionStatus,
					ScormColumnInfo.COLUMN_TYPE_STRING,
					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
				columnInfoList.add(completionStatusColumn);
			}
		}
		catch (LOException e) {
			throw e;
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"TAIL makeColumnInfosFromNode(" + objectiveCsv + ")"
				+ " return " + columnInfoList,
			DebugLog.ROW);
		return columnInfoList;
	}
	// Add End

	// CommentOut Start 2006.11.24 T.Kiyokawa wKOCSV̂
//	/**
//	 * ScormObjectivee[uւ݂̏s܂B<br>
//	 * &lt;objective&gt;vfƂɌĂяoAR[hǉ܂B
//	 *
//	 * @param dataAccess f[^ANZXNXB
//	 * @param endLearnData wKIB
//	 * @param objectiveNode &lt;objective&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param objectiveCount wKڕWB
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;objective&gt;vf̈ʒuiPȏ̐jB
//	 *
//	 * @throws LOException f[^x[Xւ̏ɎsꍇB
//	 */
//	public static void insert(
//		DataAccess dataAccess,
//		ScormLoEndLearnData endLearnData,
//		Node objectiveNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		int objectiveCount)
//		throws LOException {
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormObjectiveDataAccess.class,
//			"HEAD insert("
//				+ "dataAccess,endLearnData"
//				+ "," + objectiveNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + objectiveCount + ")",
//			DebugLog.ROW);
//
//		try {
//			////////////////////////////////////////////////////////////////////
//			// eJ̒l擾
//			//==================================================================
//			// Jƒl̃}bv
//			ScormColumnInfo[] columnInfos =
//				makeColumnInfos(
//					endLearnData, objectiveNode,
//					activityID,	attemptCount,
//					learnSessionCount, objectiveCount);
//			////////////////////////////////////////////////////////////////////
//			// SQL̐
//			String query =
//				ScormLoUtil.makeInsertQuery(TABLE_NAME, columnInfos);
//			////////////////////////////////////////////////////////////////////
//			// SQL̎s
//			dataAccess.execute(query.toString());
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		catch (SQLException e) {
//			DebugLog.write(
//				ScormInteractionDataAccess.class, e, DebugLog.HIGHT);
//			throw new LOException(e.getMessage());
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormObjectiveDataAccess.class,
//			"TAIL insert("
//				+ "dataAccess,endLearnData"
//				+ "," + objectiveNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + objectiveCount + ")",
//			DebugLog.ROW);
//	}
//
//	/**
//	 * ScormObjectivee[ũJz𐶐܂B<br>
//	 * @param endLearnData wKIB
//	 * @param objectiveNode &lt;objective&gt;vf\m[hB
//	 * @param activityID f[^ޑΏۂĂANeBreBIDB
//	 * @param attemptCount s񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;attemptcount&gt;vf̈ʒuiPȏ̐jB
//	 * @param learnSessionCount LearnZbV񐔁B
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;learnsession&gt;vf̈ʒuiPȏ̐jB
//	 * @param objectiveCount wKڕWB
//	 *         wKOŁAf[^ޑΏۂĂ
//	 *         &lt;objective&gt;vf̈ʒuiPȏ̐jB
//	 * @return ScormObjectivee[ũJzB
//	 * @throws LOException m[hf[^擾sꍇB
//	 */
//	private static ScormColumnInfo[] makeColumnInfos(
//		ScormLoEndLearnData endLearnData,
//		Node objectiveNode,
//		String activityID,
//		int attemptCount,
//		int learnSessionCount,
//		int objectiveCount)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormObjectiveDataAccess.class,
//			"HEAD makeColumnInfos(endLearnData"
//				+ "," + objectiveNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + objectiveCount + ")",
//			DebugLog.ROW);
//
//		// ̃\bh̖߂l
//		ScormColumnInfo[] columnInfos = null;
//		// z񐶐pXg
//		List columnInfoList = new ArrayList();
//		try {
//			////////////////////////////////////////////////////////////////////
//			// endLearnData擾łf[^JƂĐݒ
//			//==================================================================
//			// [UID
//			String userID = endLearnData.getUserID();
//			ScormColumnInfo userIDColumn = new ScormColumnInfo(
//				USERID, userID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(userIDColumn);
//			// LOID
//			String loID = endLearnData.getLoID();
//			ScormColumnInfo loIDColumn = new ScormColumnInfo(
//				LOID, loID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(loIDColumn);
//			// wKZbV
//			int studySessionCount = endLearnData.getStudySession();
//			ScormColumnInfo studySessionCountColumn = new ScormColumnInfo(
//				STUDY_SESSION_COUNT, Integer.toString(studySessionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(studySessionCountColumn);
//			// ZbVID
//			int sessionID = endLearnData.getLoginSession();
//			ScormColumnInfo sessionIDColumn = new ScormColumnInfo(
//				SESSIONID, Integer.toString(sessionID),
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(sessionIDColumn);
//			////////////////////////////////////////////////////////////////////
//			// endLearnDataANodeȊO擾łf[^JƂĐݒ
//			//==================================================================
//			// ANeBreBID
//			ScormColumnInfo activityIDColumn = new ScormColumnInfo(
//				ACTIVITYID, activityID,
//				ScormColumnInfo.COLUMN_TYPE_STRING,
//				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_MAX,
//				ScormLoConstant.COLUMN_ACITIVITY_ID_SIZE_UNIT);
//			columnInfoList.add(activityIDColumn);
//			// s
//			ScormColumnInfo attemptCountColumn = new ScormColumnInfo(
//				ATTEMPT_COUNT, Integer.toString(attemptCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(attemptCountColumn);
//			// LearnZbV
//			ScormColumnInfo learnSessionCountColumn = new ScormColumnInfo(
//				LEARN_SESSION_COUNT, Integer.toString(learnSessionCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(learnSessionCountColumn);
//			// wKڕW
//			ScormColumnInfo objectiveCountColumn = new ScormColumnInfo(
//				OBJECTIVE_COUNT, Integer.toString(objectiveCount),
//				ScormColumnInfo.COLUMN_TYPE_NUMBER,
//				COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//			columnInfoList.add(objectiveCountColumn);
//			////////////////////////////////////////////////////////////////////
//			// Node擾łf[^JƂĐݒ
//			//==================================================================
//			List columnInfoFromNodeList =
//				makeColumnInfosFromNode(objectiveNode);
//			columnInfoList.addAll(columnInfoFromNodeList);
//			////////////////////////////////////////////////////////////////////
//			// Xgzɕϊ
//			columnInfos = new ScormColumnInfo[ columnInfoList.size() ];
//			columnInfoList.toArray(columnInfos);
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormObjectiveDataAccess.class,
//			"TAIL makeColumnInfos(endLearnData"
//				+ "," + objectiveNode + "," + activityID
//				+ "," + attemptCount + "," + learnSessionCount
//				+ "," + objectiveCount + ")"
//				+ " return " + columnInfos,
//			DebugLog.ROW);
//		return columnInfos;
//	}
//
//	/**
//	 * m[hScormObjectivee[ũJz𐶐܂B<br>
//	 * @param objectiveNode &lt;objective&gt;vf\m[hB
//	 * @return ScormObjectivee[ũJzB
//	 * @throws LOException m[hf[^擾sꍇB
//	 */
//	private static List makeColumnInfosFromNode(Node objectiveNode)
//		throws LOException {
//
//		////////////////////////////////////////////////////////////////////////
//		// \bhJnO
//		DebugLog.write(
//			ScormObjectiveDataAccess.class,
//			"HEAD makeColumnInfosFromNode(" + objectiveNode + ")",
//			DebugLog.ROW);
//
//		// ̃\bh̖߂l
//		List columnInfoList = new ArrayList();
//		try {
//			////////////////////////////////////////////////////////////////////
//			// Node擾łf[^JƂĐݒ
//			//==================================================================
//			// wKڕW
//			String objectiveId =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_OBJECTIVEID_VALUE);
//			if ( objectiveId != null ) {
//				ScormColumnInfo objectiveIdColumn = new ScormColumnInfo(
//					OBJECTIVEID, objectiveId,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(objectiveIdColumn);
//			}
//			// Kςݓ_
//			String scaledScore =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_SCALED_SCORE_VALUE);
//			if (scaledScore != null ) {
//				ScormColumnInfo scaledScoreColumn = new ScormColumnInfo(
//					SCALEDSCORE, scaledScore,
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(scaledScoreColumn);
//			}
//			// _
//			String rawScore =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_RAW_SCORE_VALUE);
//			if (rawScore != null ) {
//				ScormColumnInfo rawScoreColumn = new ScormColumnInfo(
//					RAWSCORE, rawScore,
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(rawScoreColumn);
//			}
//			// ō_
//			String maxScore =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_MAX_SCORE_VALUE);
//			if (maxScore != null) {
//				ScormColumnInfo maxScoreColumn = new ScormColumnInfo(
//					MAXSCORE, maxScore,
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(maxScoreColumn);
//			}
//			// Œᓾ_
//			String minScore =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_MIN_SCORE_VALUE);
//			if (minScore != null) {
//				ScormColumnInfo minScoreColumn = new ScormColumnInfo(
//					MINSCORE, minScore,
//					ScormColumnInfo.COLUMN_TYPE_NUMBER,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(minScoreColumn);
//			}
//			// iXe[^X
//			String successStatus =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_SUCCESS_STATUS_VALUE);
//			if (successStatus != null) {
//				ScormColumnInfo successStatusColumn = new ScormColumnInfo(
//					SUCCESS_STATUS, successStatus,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(successStatusColumn);
//			}
//			// Xe[^X
//			String completionStatus =
//				ScormLoUtil.getNodeValue(
//					objectiveNode, PATH_COMPLETION_STATUS_VALUE);
//			if (completionStatus != null) {
//				ScormColumnInfo completionStatusColumn = new ScormColumnInfo(
//					COMPLETION_STATUS, completionStatus,
//					ScormColumnInfo.COLUMN_TYPE_STRING,
//					COLUMN_SIZE_MAX, COLUMN_SIZE_UNIT);
//				columnInfoList.add(completionStatusColumn);
//			}
//		}
//		catch (LOException e) {
//			throw e;
//		}
//		////////////////////////////////////////////////////////////////////////
//		// \bhIO
//		DebugLog.write(
//			ScormObjectiveDataAccess.class,
//			"TAIL makeColumnInfosFromNode(" + objectiveNode + ")"
//				+ " return " + columnInfoList,
//			DebugLog.ROW);
//		return columnInfoList;
//	}
	// CommentOut End
	
	/**
	 * w肳ꂽ[UAނ̑gݍ킹̃O폜܂B
	 * @param dataAccess f[^ANZXEIuWFNgB
	 * @param userID 폜Ώۂ̃[UIDB
	 * @param loID 폜Ώۂ̋ނLOIDB
	 * @throws LOException f[^x[XANZXɗOꍇB
	 */
	public static void delete(
		DataAccess dataAccess, String userID, String loID)
		throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"HEAD delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
		try {
			// WHERE̐
			StringBuffer queryWhere = new StringBuffer();
			if (loID != null) {
				queryWhere.append(" and " + LOID + "='" + loID + "'" );
			}
			if (userID != null) {
				queryWhere.append(" and " + USERID + "='" + userID + "'" );
			}
			// 폜NG̐
			StringBuffer query = new StringBuffer();
			query.append("delete from " + TABLE_NAME );
			if (queryWhere.length() > 0) {
				query.append(" where " + queryWhere.substring(5) );
			}
			// 폜NG̎s
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			dataAccess.execute(queryString);
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
		}
		// \bhIO
		DebugLog.write(
			ScormObjectiveDataAccess.class,
			"TAIL delete(" + dataAccess + "," + userID + "," + loID + ")",
			DebugLog.ROW);
	}

	/**
	 * LearnZbV񐔍ől擾܂B<br>
	 * w肵[UIDALOIDAwK񐔂̑gݍ킹ŁA
	 * ANeBreBʂɍő厎s񐔂̍őLearnZbV񐔂
	 * ̂QzƂĖ߂܂B
	 * Y郌R[h݂ȂꍇAvfO̔z߂܂B
	 * <br>
	 * @param dataAccess f[^ANZXIuWFNgB
	 * @param userID [UIDB
	 * @param loID LOIDB
	 * @param studySession wK񐔁iJn|IłPPʂ̉񐔁j
	 * @return ȉ̂PzvfƂz߂܂B
	 * <table border="1">
	 * 	<tr>
	 * 		<th>CfbNX</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">0</td>
	 * 		<td>ANeBreBID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">1</td>
	 * 		<td>ANeBreB̒ōő̎s</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td align="right">2</td>
	 * 		<td>
	 * 			ANeBreB̒ōő̎s񐔂̒
	 * 			őLearnZbV
	 * 		</td>
	 * 	</tr>
	 * </table>
	 * <br>
	 * @throws LOException if[^x[XANZXjɃG[ꍇB
	 */
	public static String[][] getMaxLearnSessionCount(
			DataAccess dataAccess, String userID,
			String loID, int studySession)
			throws LOException {

		// \bhJnO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"HEAD getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		String[][] matrix = null;
		// NGʃZbg
		ResultSet resultSet = null;
		// tryubNɗOĂȂtOitrueOȂj
		boolean successFlag = false;
		try {
			////////////////////////////////////////////////////////////////////
			// NG̐
			StringBuffer query = new StringBuffer();
			query.append("select");
			// ANeBreBID
			query.append(" a." + ACTIVITYID + " as " + ACTIVITYID);
			// ő厎s
			query.append(",a." + ATTEMPT_COUNT + " as " + ATTEMPT_COUNT);
			// ̒̍őLearnZbV
			query.append(",max(a." + LEARN_SESSION_COUNT + ")"
							+ " as " + LEARN_SESSION_COUNT);
			query.append(" from " + TABLE_NAME + " a");
			query.append(" inner join (");
			// =================================================================
			// ő厎s񐔂擾邽߂̃TuNG
			query.append(	"select");
			query.append(	" " + USERID + " as " + USERID);
			query.append(	"," + LOID + " as " + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(			" as " + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID + " as " + ACTIVITYID);
			query.append(	",max(" + ATTEMPT_COUNT + ") as " + ATTEMPT_COUNT);
			query.append(	" from " + TABLE_NAME);
			// TuNGł̏
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(	" where " + USERID + "='" + userID + "'");
			query.append(	" and " + LOID + "='" + loID + "'");
			query.append(	" and " + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// TuNGmax(AttemptCount)gp邽߂group by
			query.append(	" group by ");
			query.append(	" " + USERID);
			query.append(	"," + LOID);
			query.append(	"," + STUDY_SESSION_COUNT);
			query.append(	"," + ACTIVITYID);
			query.append(") b");
			// =================================================================
			// TuNGƂ̌
			// [UIDALOIDAwK񐔁AANeBreBIDvāA
			// s񐔂ől̃R[h
			query.append(" on a." + USERID + "=b." + USERID );
			query.append(" and a." + LOID + "=b." + LOID );
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=b." + STUDY_SESSION_COUNT );
			query.append(" and a." + ACTIVITYID + "=b." + ACTIVITYID );
			query.append(" and a." + ATTEMPT_COUNT + "=b." + ATTEMPT_COUNT );
			// =================================================================
			// where
			// w肳ꂽ[UIDALOIDAwK񐔂ƈv郌R[h
			query.append(" where a." + USERID + "='" + userID + "'");
			query.append(" and a." + LOID + "='" + loID + "'");
			query.append(" and a." + STUDY_SESSION_COUNT );
			query.append(		"=" + studySession );
			// =================================================================
			// max(LearnSessionCount)gp邽߂group by
			query.append(" group by");
			query.append(" a." + ACTIVITYID);
			query.append(",a." + ATTEMPT_COUNT);
			////////////////////////////////////////////////////////////////////
			// NGs
			String queryString = query.toString();
			DebugLog.write( ScormAttemptDataAccess.class,
				queryString, DebugLog.MID);
			resultSet = dataAccess.executeQuery(queryString);
			////////////////////////////////////////////////////////////////////
			// NGʂ̃Xg
			List list = new ArrayList();
			while (resultSet.next()) {
				String[] record = new String[3];
				record[0] = resultSet.getString(ACTIVITYID).trim();
				record[1] = resultSet.getString(ATTEMPT_COUNT);
				record[2] = resultSet.getString(LEARN_SESSION_COUNT);

				list.add(record);
			}
			//Xgz
			matrix = new String[list.size()][];
			list.toArray(matrix);

			// tryubNŌ܂œB̂ŃtOtrueɕύX
			successFlag = true;
		}
		catch (SQLException e) {
			DebugLog.write(ScormAttemptDataAccess.class,
				e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		finally {
			// ʃZbg̃N[Y
			if (resultSet != null) {
				try {
					resultSet.close();
				}
				catch (SQLException e) {
					DebugLog.write(ScormAttemptDataAccess.class,
						e, DebugLog.HIGHT);
					// tryubNɂėOȂ΁AX[
					if (successFlag) {
						throw new LOException(e.getMessage());
					}
				}
			}
		}
		// \bhIO
		DebugLog.write(
			ScormAttemptDataAccess.class,
			"TAIL getMaxLearnSessionCount("
				+ dataAccess + "," + userID
				+ "," + loID + "," + studySession + ")",
			DebugLog.ROW);
		return matrix;
	}
}
