/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormServerInfoControl
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * SCORM LOT[oǗNXB<BR>
 * NT[ȏIAT[o̎gpl̑Ǘ܂B<br>
 * ǗNX̂߁AVOgEp^[Ő܂B<BR>
 * @author T.Nishiki
 */
public final class ScormServerInfoControl {
	/**
	 * VOgEp^[pIuWFNgB
	 */
	private static final ScormServerInfoControl CONTROL;

	/**
	 * NJnT[oI邽߂ɔrIuWFNgB
	 * @see #getServerSelected(String, String)
	 */
	private static final Comparator CHOICE_START_SERVER_COMPARATOR;

	/**
	 * X^eBbNECjVCUB<br>
	 */
	static {
		CONTROL = new ScormServerInfoControl();
		CHOICE_START_SERVER_COMPARATOR = new StartServerComparator();
	}

	/**
	 * SCORM LO T[oi[}bvB<br>
	 * L[ƂăT[oԍAlƂScormServerInfoi[܂B
	 */
	private Map serverInfoMap;

	/**
	 * SCORM LO T[o̎gp󋵂i[}bvB<br>
	 * L[Ƃă[UID^LOID̑gAlƂScormServerInfoi[܂B
	 */
	private Map serverUsedMap;

	/**
	 * RXgN^B
	 * VOgEp^[̂߁AprivateƂĐ錾܂B
	 */
	private ScormServerInfoControl() {
		serverInfoMap = new HashMap();
		serverUsedMap = new HashMap();
	}

	/**
	 * ScormServerInfoControl擾܂B
	 * @return vZXŗBScormServerInfoControlIuWFNgB
	 */
	public static ScormServerInfoControl getInstance() {
		return CONTROL;
	}

	/**
	 * SCORM LOT[o܂B<br>
	 * NɂPxĂяoĂB
	 * @throws LOException ݒt@C̋NɎsƂB
	 */
	public void initialize() throws LOException {
		// \bhJnO
		DebugLog.write(this.getClass(), "HEAD initialize()", DebugLog.ROW);
		// ݒt@C
		ScormLoEnv env = new ScormLoEnv();

		// ݒt@C̓o^ĂSCORM LOT[oǂݍ݂܂B
		ScormServerInfo[] serverList = env.getScormLoServerList();
		for (int i = 0; i < serverList.length; i++) {
			serverInfoMap.put(serverList[i].getServerNo(), serverList[i]);
		}
		// \bhIO
		DebugLog.write(this.getClass(), "TAIL initialize()", DebugLog.ROW);
	}

	/**
	 * wKNSCORM LOT[o肵ÃT[o߂܂B<br>
	 * łɂQdNȂǂɂAw肳ꂽ[UAނŋNĂ
	 * T[o邩mF܂B
	 * AT[omFł΂߂AmFłȂ΁AVɑI܂B<br>
	 * IꍇAgpl̂ƂȂSCORM LOT[o߂܂B
	 * gplT[oꍇAT[oԍႢT[o[̏߂܂B
	 * ܂AVɑIT[óAgplP₵Ă߂܂B<br>
	 * @param userID [UIDB
	 * @param loID  LOIDB
	 * @return IꂽT[oB
	 */
	public synchronized ScormServerInfo getServerSelected(
				String userID, String loID) {
		// \bhJnO
		DebugLog.write(
			this.getClass(),
			"HEAD getServerSelected(" + userID + "," + loID + ")",
			DebugLog.ROW);

		// ̃\bh̖߂l
		ScormServerInfo selected = null;

		// łɎgpĂ邩fB
		selected = (ScormServerInfo)serverUsedMap.get(
						makeKeyOfServerUsed(userID, loID));
		// gpĂT[oȂ΁AIB
		if ( selected == null ) {
			//T[oԍ̏擾
			List serverInfoList = null;
			serverInfoList = getServerInfoList();
			// gplAT[oԍɕёւB
			Collections.sort(serverInfoList, CHOICE_START_SERVER_COMPARATOR);
			// 擪vfIAgpl𑝂₵܂B
			selected = (ScormServerInfo) serverInfoList.get(0);
			selected.incrementNumberOfUsers();
			// [UID + LOID ŐڑT[oi[܂B
			serverUsedMap.put(makeKeyOfServerUsed(userID, loID), selected);
		}

		// \bhIO
		DebugLog.write(
			this.getClass(),
			"TAIL getServerSelected(" + userID + "," + loID + ")"
				+ " retrun " + selected,
			DebugLog.ROW);

		return selected;
	}

	/**
	 * w肳ꂽ[UAނ̑gŎgp̃T[ô̎gpl炷B<br>
	 *
	 * @param userID [UIDB
	 * @param loID LOIDB
	 */
	public synchronized void decrementNumberOfUsers(
			String userID, String loID) {
		// \bhJnO
		DebugLog.write( getClass(),
			"HEAD decrementNumberOfUsers(" + userID + "," + loID + ")",
			DebugLog.ROW);

		// gpƂȂĂT[o擾
		ScormServerInfo serverInfo = null;
		String mapKey = makeKeyOfServerUsed(userID, loID);
		serverInfo = (ScormServerInfo)serverUsedMap.get(mapKey);
		DebugLog.write( getClass(),
			"serverUsedMap[" + userID + "][" + loID + "]"
				+ "->serverInfo!=null:" + (serverInfo != null), DebugLog.MID);
		// 擾łꍇ́Agp炷B
		if ( serverInfo != null ) {
			serverInfo.decrementNumberOfUsers();
			serverUsedMap.remove(mapKey);
		}
		// \bhIO
		DebugLog.write( getClass(),
			"TAIL decrementNumberOfUsers(" + userID + "," + loID + ")",
			DebugLog.ROW);
	}

	/**
	 * SCORM LOT[o擾܂B<br>
	 * T[oԍɕ񂾃Xg߂܂B
	 * @return vfScormServerInfoIuWFNgł郊XgB
	 */
	public List getServerInfoList() {
		// \bhJnO
		DebugLog.write( this.getClass(),
			"HEAD getServerInfoList()", DebugLog.ROW);

		// T[o}bvl̏W擾A
		// T[oԍɕёւĂǂB
		Collection collection = serverInfoMap.values();
		List serverInfoList = new ArrayList(collection);
		Collections.sort(serverInfoList);

		// \bhJnO
		DebugLog.write( this.getClass(),
			"HEAD getServerInfoList() return " + serverInfoList, DebugLog.ROW);

		return serverInfoList;
	}

	/**
	 * gpT[o}bṽL[𐶐܂B<br>
	 * @param userID [UIDB
	 * @param loID ނLOIDB
	 * @return gpT[o}bṽL[B
	 */
	private static String makeKeyOfServerUsed(String userID, String loID) {
		return userID + loID;
	}

	/**
	 * SCORM LOT[oɂĔrNXB<br>
	 * {@link ScormServerInfoControl#getServerSelected(String, String)}
	 * \bh̃T[oIŗp܂B
	 * gpl̑召ł܂rAȂꍇ̓T[oԍƂ܂B
	 */
	private static class StartServerComparator implements Comparator {
		/**
		 * Q́uSCORM LO T[ovIuWFNgƏr܂B<br>
		 * ܂Agpl̑召ŔrAgpl̏Ȃ
		 * SCORM LO T[ovƂ܂B
		 * AgplꍇAT[oԍ̃vtBbNX
		 * ̐l̑召ŔrA
		 * l菬uSCORM LO T[ovƂ܂B
		 * @param obj1 rΏۂ́uSCORM LO T[ovIuWFNĝPB
		 * @param obj2 rΏۂ́uSCORM LO T[ovIuWFNĝQB
		 * @return obj1ꍇ-1A
		 *          obj2ꍇ1Aꍇ0߂܂B
		 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
		 * @see #compare(ScormServerInfo, ScormServerInfo)
		 */
		public int compare(Object obj1, Object obj2) {
			return compare((ScormServerInfo) obj1, (ScormServerInfo) obj2);
		}

		/**
		 * Q́uSCORM LO T[ovIuWFNgƏr܂B<br>
		 * ܂Agpl̑召ŔrAgpl̏Ȃ
		 * SCORM LO T[ovƂ܂B
		 * AgplꍇAT[oԍ̃vtBbNX
		 * ̐l̑召ŔrA
		 * l菬uSCORM LO T[ovƂ܂B
		 * @param server1 rΏۂ́uSCORM LO T[ovIuWFNĝPB
		 * @param server2 rΏۂ́uSCORM LO T[ovIuWFNĝQB
		 * @return server1ꍇ-1A
		 *          server2ꍇ1Aꍇ0߂܂B
		 * @see ScormServerInfo#compareTo(ScormServerInfo)
		 */
		public int compare(ScormServerInfo server1, ScormServerInfo server2) {
			if (server1.getNumberOfUsers() < server2.getNumberOfUsers()) {
				return -1;
			}
			if (server1.getNumberOfUsers() > server2.getNumberOfUsers()) {
				return 1;
			}
			return server1.compareTo(server2);
		}
	}
}