--
-- PostgreSQL database dump
--

-- Started on 2009-04-03 17:04:23

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1594 (class 1259 OID 42027)
-- Dependencies: 6
-- Name: aicccomment; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE aicccomment (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    course_id character varying(255),
    student_id character(10),
    lesson_id character varying(255),
    "DATE" timestamp without time zone,
    "time" character(16),
    location character varying(255),
    "COMMENT" character varying(4096)
);


ALTER TABLE public.aicccomment OWNER TO zinzi;

--
-- TOC entry 1595 (class 1259 OID 42033)
-- Dependencies: 6
-- Name: aicccore; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE aicccore (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    lesson_status character varying(30),
    rawscore double precision,
    maxscore double precision,
    minscore double precision,
    "time" character(16),
    lesson_location character varying(255),
    exist character(10)
);


ALTER TABLE public.aicccore OWNER TO zinzi;

--
-- TOC entry 1597 (class 1259 OID 42042)
-- Dependencies: 6
-- Name: aiccinteraction; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE aiccinteraction (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    course_id character varying(255),
    student_id character(10),
    lesson_id character varying(255),
    response_times integer NOT NULL,
    "DATE" timestamp without time zone,
    "time" character(16),
    interaction_id character varying(255),
    objective_id character varying(255),
    type_interaction character(30),
    correct_response character varying(4000),
    response_value character(30),
    student_response character varying(255),
    result character(30),
    weighting double precision,
    latency character(16)
);


ALTER TABLE public.aiccinteraction OWNER TO zinzi;

--
-- TOC entry 1598 (class 1259 OID 42048)
-- Dependencies: 6
-- Name: aiccobjectives; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE aiccobjectives (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    course_id character varying(255),
    student_id character(10),
    lesson_id character varying(255),
    "DATE" timestamp without time zone,
    "time" character(16),
    objective_id character varying(255),
    rawscore double precision,
    maxscore double precision,
    minscore double precision,
    status character(30),
    mastery_time character(16)
);


ALTER TABLE public.aiccobjectives OWNER TO zinzi;

--
-- TOC entry 1599 (class 1259 OID 42054)
-- Dependencies: 6
-- Name: assignments; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE assignments (
    assignid character(10) NOT NULL,
    membershipid character(30),
    materialid character(20),
    study_start_date timestamp without time zone,
    enddate timestamp without time zone,
    assigner character(15),
    learn_authority character(1),
    management_authority character(1),
    opening_date timestamp without time zone,
    closing_date timestamp without time zone,
    study_limit_cnt integer,
    study_cnt integer,
    method_flag character(1)
);


ALTER TABLE public.assignments OWNER TO zinzi;

--
-- TOC entry 1632 (class 1259 OID 42184)
-- Dependencies: 6
-- Name: cataloglo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE cataloglo (
    loid character(10) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.cataloglo OWNER TO zinzi;

--
-- TOC entry 1633 (class 1259 OID 42187)
-- Dependencies: 6
-- Name: cataloglo_lolist; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE cataloglo_lolist (
    loid character(10) NOT NULL,
    cataloglistloid character(10) NOT NULL,
    sort_no numeric(4,0) NOT NULL
);


ALTER TABLE public.cataloglo_lolist OWNER TO zinzi;

--
-- TOC entry 1600 (class 1259 OID 42057)
-- Dependencies: 6
-- Name: conferencelo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE conferencelo (
    loid character(10) NOT NULL,
    urlpath character varying(256) NOT NULL,
    meetingtitle character varying(64) NOT NULL,
    startdate timestamp without time zone NOT NULL,
    enddate timestamp without time zone NOT NULL,
    resourcemail character varying(128) NOT NULL,
    logonuser character varying(128) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.conferencelo OWNER TO zinzi;

--
-- TOC entry 1601 (class 1259 OID 42063)
-- Dependencies: 6
-- Name: evaluate; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE evaluate (
    user_id character(8) NOT NULL,
    loid character(10) NOT NULL,
    score_date timestamp without time zone NOT NULL,
    score integer,
    custom_msg_dir character varying(256)
);


ALTER TABLE public.evaluate OWNER TO zinzi;

--
-- TOC entry 1602 (class 1259 OID 42066)
-- Dependencies: 6
-- Name: exchangelo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE exchangelo (
    loid character(10) NOT NULL,
    urlpath character varying(256) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.exchangelo OWNER TO zinzi;

--
-- TOC entry 1603 (class 1259 OID 42069)
-- Dependencies: 6
-- Name: face2facelo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE face2facelo (
    loid character(10) NOT NULL,
    teacherid character(16)
);


ALTER TABLE public.face2facelo OWNER TO zinzi;

--
-- TOC entry 1604 (class 1259 OID 42072)
-- Dependencies: 1919 6
-- Name: groupandpeople; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE groupandpeople (
    membershipid character(30) NOT NULL,
    sort_no integer DEFAULT 0 NOT NULL,
    parentid character(15) NOT NULL,
    childid character(15) NOT NULL
);


ALTER TABLE public.groupandpeople OWNER TO zinzi;

--
-- TOC entry 1605 (class 1259 OID 42076)
-- Dependencies: 6
-- Name: groups; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE groups (
    group_id character(8) NOT NULL,
    group_name character varying(64),
    group_type character(4) NOT NULL,
    delete_flag character(1),
    foreignid character varying(256),
    custom_msg_dir character varying(128),
    "OID" character varying(256),
    ad_dn character varying(256)
);


ALTER TABLE public.groups OWNER TO zinzi;

--
-- TOC entry 1619 (class 1259 OID 42129)
-- Dependencies: 6
-- Name: launchforgetlo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE launchforgetlo (
    loid character(10) NOT NULL,
    lourl character varying(256) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.launchforgetlo OWNER TO zinzi;

--
-- TOC entry 1606 (class 1259 OID 42082)
-- Dependencies: 6
-- Name: lo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lo (
    loid character(10) NOT NULL,
    lotype character(3),
    lotitle character varying(64),
    loexplanation character varying(256),
    foreignid character varying(256),
    keyword character varying(256),
    delete_flag character(1),
    loversion character varying(10),
    conclusion character varying(1024),
    realloid character(10) NOT NULL,
    prere character varying(1024),
    mentoremailaddress character varying(256)
);


ALTER TABLE public.lo OWNER TO zinzi;

--
-- TOC entry 1645 (class 1259 OID 42346)
-- Dependencies: 6
-- Name: loextend; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE loextend (
    loid character(10) NOT NULL,
    buy integer,
    keyword1 character varying(256),
    keyword2 character varying(256),
    keyword3 character varying(256),
    keyword4 character varying(256),
    keyword5 character varying(256)
);


ALTER TABLE public.loextend OWNER TO zinzi;

--
-- TOC entry 1625 (class 1259 OID 42151)
-- Dependencies: 6
-- Name: lohistory; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lohistory (
    loid character(10) NOT NULL,
    time_stamp timestamp without time zone NOT NULL,
    userid character(8) NOT NULL
);


ALTER TABLE public.lohistory OWNER TO zinzi;

--
-- TOC entry 1607 (class 1259 OID 42088)
-- Dependencies: 6
-- Name: lolog; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lolog (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    study_start_date timestamp without time zone,
    residancetime double precision,
    passday timestamp without time zone,
    study_end_date timestamp without time zone,
    highscore double precision,
    lowsscore double precision,
    execise_point double precision,
    fullscore double precision,
    access_cnt integer,
    last_access timestamp without time zone
);


ALTER TABLE public.lolog OWNER TO zinzi;

--
-- TOC entry 1608 (class 1259 OID 42091)
-- Dependencies: 1920 6
-- Name: lologsession; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lologsession (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    study_start_date timestamp without time zone,
    residancetime double precision,
    passday timestamp without time zone,
    study_end_date timestamp without time zone,
    highscore double precision,
    lowsscore double precision,
    execise_point double precision,
    fullscore double precision,
    lunchtimes integer DEFAULT 0
);


ALTER TABLE public.lologsession OWNER TO zinzi;

--
-- TOC entry 1642 (class 1259 OID 42332)
-- Dependencies: 6
-- Name: lom; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lom (
    lom_no character(10) NOT NULL,
    loid character(10) NOT NULL,
    path character varying(2000) NOT NULL,
    lom_type character(2),
    value character varying(2000)
);


ALTER TABLE public.lom OWNER TO zinzi;

--
-- TOC entry 1643 (class 1259 OID 42338)
-- Dependencies: 6
-- Name: lom_type; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lom_type (
    display_no character(10) NOT NULL,
    path character varying(2000) NOT NULL,
    lom_type character(2) NOT NULL,
    name character varying(50),
    value character varying(2000),
    disp_value character varying(2000),
    scorm_vocabulary character varying(2000)
);


ALTER TABLE public.lom_type OWNER TO zinzi;

--
-- TOC entry 1609 (class 1259 OID 42095)
-- Dependencies: 1921 6
-- Name: lorelation; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lorelation (
    materialid character(20) NOT NULL,
    sort_no integer DEFAULT 0 NOT NULL,
    parentid character(10),
    childid character(10)
);


ALTER TABLE public.lorelation OWNER TO zinzi;

--
-- TOC entry 1610 (class 1259 OID 42099)
-- Dependencies: 6
-- Name: lotype; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE lotype (
    lotype character(3) NOT NULL,
    typename character varying(64),
    losubtype character(3)
);


ALTER TABLE public.lotype OWNER TO zinzi;

--
-- TOC entry 1611 (class 1259 OID 42102)
-- Dependencies: 6
-- Name: officelo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE officelo (
    loid character(10) NOT NULL,
    lourl character varying(256),
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.officelo OWNER TO zinzi;

--
-- TOC entry 1631 (class 1259 OID 42181)
-- Dependencies: 6
-- Name: offlinelo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE offlinelo (
    loid character(10) NOT NULL,
    materialid character varying(32) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.offlinelo OWNER TO zinzi;

--
-- TOC entry 1626 (class 1259 OID 42154)
-- Dependencies: 6
-- Name: ol_aicccomment; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE ol_aicccomment (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    course_id character varying(255),
    student_id character(10),
    lesson_id character varying(255),
    "DATE" timestamp without time zone,
    "time" character(16),
    location character varying(255),
    "COMMENT" character varying(4096)
);


ALTER TABLE public.ol_aicccomment OWNER TO zinzi;

--
-- TOC entry 1627 (class 1259 OID 42160)
-- Dependencies: 6
-- Name: ol_aicccore; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE ol_aicccore (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    lesson_status character varying(30),
    rawscore double precision,
    maxscore double precision,
    minscore double precision,
    "time" character(16),
    lesson_location character varying(255),
    exist character(10)
);


ALTER TABLE public.ol_aicccore OWNER TO zinzi;

--
-- TOC entry 1629 (class 1259 OID 42169)
-- Dependencies: 6
-- Name: ol_aiccinteraction; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE ol_aiccinteraction (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    course_id character varying(255),
    student_id character(10),
    lesson_id character varying(255),
    response_times integer NOT NULL,
    "DATE" timestamp without time zone,
    "time" character(16),
    interaction_id character varying(255),
    objective_id character varying(255),
    type_interaction character(30),
    correct_response character varying(4000),
    response_value character(30),
    student_response character varying(255),
    result character(30),
    weighting double precision,
    latency character(16)
);


ALTER TABLE public.ol_aiccinteraction OWNER TO zinzi;

--
-- TOC entry 1630 (class 1259 OID 42175)
-- Dependencies: 6
-- Name: ol_aiccobjectives; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE ol_aiccobjectives (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    course_id character varying(255),
    student_id character(10),
    lesson_id character varying(255),
    "DATE" timestamp without time zone,
    "time" character(16),
    objective_id character varying(255),
    rawscore double precision,
    maxscore double precision,
    minscore double precision,
    status character(30),
    mastery_time character(16)
);


ALTER TABLE public.ol_aiccobjectives OWNER TO zinzi;

--
-- TOC entry 1628 (class 1259 OID 42166)
-- Dependencies: 6
-- Name: ol_sectionlog; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE ol_sectionlog (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    lesson_status character varying(30),
    "time" character(16)
);


ALTER TABLE public.ol_sectionlog OWNER TO zinzi;

--
-- TOC entry 1612 (class 1259 OID 42105)
-- Dependencies: 6
-- Name: people; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE people (
    user_id character(8) NOT NULL,
    user_name character varying(64),
    encrypt_password character(32),
    contact_address character varying(256),
    sex character(1),
    contact_email character varying(128),
    contact_email2 character varying(128),
    reading_name character varying(64),
    birthday timestamp without time zone,
    contact_tel character(13),
    custom_msg_dir character varying(128),
    delete_flag character(1),
    foreignid character varying(256),
    loginid character varying(16),
    ad_user_id character varying(255),
    user_type character(4) NOT NULL,
    "OID" character varying(256),
    ad_dn character varying(256)
);


ALTER TABLE public.people OWNER TO zinzi;

--
-- TOC entry 1624 (class 1259 OID 42148)
-- Dependencies: 6
-- Name: perceptionlo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE perceptionlo (
    loid character(10) NOT NULL,
    assessment_id character varying(16) NOT NULL,
    session_name character(50) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.perceptionlo OWNER TO zinzi;

--
-- TOC entry 1634 (class 1259 OID 42190)
-- Dependencies: 6
-- Name: prerequisite; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE prerequisite (
    loid character(10),
    prereid character(10)
);


ALTER TABLE public.prerequisite OWNER TO zinzi;

--
-- TOC entry 1593 (class 1259 OID 42024)
-- Dependencies: 6
-- Name: propagaterelation; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE propagaterelation (
    loid character(10),
    relatedid character(10)
);


ALTER TABLE public.propagaterelation OWNER TO zinzi;

--
-- TOC entry 1613 (class 1259 OID 42111)
-- Dependencies: 6
-- Name: roleassignments; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE roleassignments (
    role_assign_id character(15) NOT NULL,
    user_id character(8),
    role_id character(10),
    groupid character(8)
);


ALTER TABLE public.roleassignments OWNER TO zinzi;

--
-- TOC entry 1614 (class 1259 OID 42114)
-- Dependencies: 6
-- Name: roles; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE roles (
    roleid character(10) NOT NULL,
    rolename character varying(64),
    deleted character(1)
);


ALTER TABLE public.roles OWNER TO zinzi;

--
-- TOC entry 1616 (class 1259 OID 42120)
-- Dependencies: 6
-- Name: rolesfunction; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE rolesfunction (
    roleid character(10) NOT NULL,
    function character(15) NOT NULL
);


ALTER TABLE public.rolesfunction OWNER TO zinzi;

--
-- TOC entry 1636 (class 1259 OID 42196)
-- Dependencies: 6
-- Name: scorm_attempt; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scorm_attempt (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    studysessioncount integer NOT NULL,
    activityid character(255) NOT NULL,
    attemptcount integer NOT NULL,
    learnsessioncount integer NOT NULL,
    sessionid character(128) NOT NULL,
    learnsession_date timestamp without time zone NOT NULL,
    completion_status character varying(30),
    scaledscore numeric(17,7),
    rawscore numeric(17,7),
    maxscore numeric(17,7),
    minscore numeric(17,7),
    attempt_session_time numeric(15,3),
    success_status character varying(30),
    location character varying(1000),
    exit character varying(10)
);


ALTER TABLE public.scorm_attempt OWNER TO zinzi;

--
-- TOC entry 1637 (class 1259 OID 42202)
-- Dependencies: 6
-- Name: scorm_interaction; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scorm_interaction (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    studysessioncount integer NOT NULL,
    activityid character(255) NOT NULL,
    attemptcount integer NOT NULL,
    learnsessioncount integer NOT NULL,
    interactioncount integer NOT NULL,
    sessionid character(128) NOT NULL,
    interactionid character varying(4096),
    interactiontype character varying(30),
    objectiveid character varying(4096),
    "timestamp" timestamp without time zone,
    correctresponse1 character varying(4096),
    correctresponse2 character varying(4096),
    correctresponse3 character varying(4096),
    correctresponse4 character varying(4096),
    correctresponse5 character varying(4096),
    weighting numeric(17,7),
    learnerresponse character varying(4096),
    learner_result character varying(30),
    latency numeric(15,3),
    description character varying(255)
);


ALTER TABLE public.scorm_interaction OWNER TO zinzi;

--
-- TOC entry 1638 (class 1259 OID 42208)
-- Dependencies: 6
-- Name: scorm_learnercomment; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scorm_learnercomment (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    studysessioncount integer NOT NULL,
    activityid character(255) NOT NULL,
    attemptcount integer NOT NULL,
    learnsessioncount integer NOT NULL,
    learnercommentcount integer NOT NULL,
    sessionid character(128) NOT NULL,
    learnercomment character varying(4096),
    learnercommentlocation character varying(255),
    learnercommenttime character varying(255)
);


ALTER TABLE public.scorm_learnercomment OWNER TO zinzi;

--
-- TOC entry 1639 (class 1259 OID 42214)
-- Dependencies: 6
-- Name: scorm_lmscomment; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scorm_lmscomment (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    studysessioncount integer NOT NULL,
    activityid character(255) NOT NULL,
    attemptcount integer NOT NULL,
    learnsessioncount integer NOT NULL,
    lmscommentcount integer NOT NULL,
    sessionid character(128) NOT NULL,
    lmscomment character varying(4096),
    lmscommentlocation character varying(255),
    lmscommenttime character varying(255)
);


ALTER TABLE public.scorm_lmscomment OWNER TO zinzi;

--
-- TOC entry 1640 (class 1259 OID 42220)
-- Dependencies: 6
-- Name: scorm_objective; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scorm_objective (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    studysessioncount integer NOT NULL,
    activityid character(255) NOT NULL,
    attemptcount integer NOT NULL,
    learnsessioncount integer NOT NULL,
    objectivecount integer NOT NULL,
    sessionid character(128) NOT NULL,
    objectiveid character varying(4096),
    scaledscore numeric(17,7),
    rawscore numeric(17,7),
    maxscore numeric(17,7),
    minscore numeric(17,7),
    successstatus character varying(30),
    completionstatus character varying(30)
);


ALTER TABLE public.scorm_objective OWNER TO zinzi;

--
-- TOC entry 1635 (class 1259 OID 42193)
-- Dependencies: 6
-- Name: scormlo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scormlo (
    loid character(10) NOT NULL,
    materialid character varying(32) NOT NULL,
    w_height integer NOT NULL,
    w_width integer NOT NULL
);


ALTER TABLE public.scormlo OWNER TO zinzi;

--
-- TOC entry 1641 (class 1259 OID 42226)
-- Dependencies: 6
-- Name: scormsession; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE scormsession (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    studysessioncount integer NOT NULL,
    sessionid character(128) NOT NULL
);


ALTER TABLE public.scormsession OWNER TO zinzi;

--
-- TOC entry 1596 (class 1259 OID 42039)
-- Dependencies: 6
-- Name: sectionlog; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE sectionlog (
    userid character(8) NOT NULL,
    loid character(10) NOT NULL,
    sessionid character(128) NOT NULL,
    "UID" character(255) NOT NULL,
    lesson_status character varying(30),
    "time" character(16)
);


ALTER TABLE public.sectionlog OWNER TO zinzi;

--
-- TOC entry 1618 (class 1259 OID 42126)
-- Dependencies: 6
-- Name: serverinformation; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE serverinformation (
    server_id character(8) NOT NULL,
    server_name character varying(128),
    ip_address character(15),
    os_kind character(1),
    server_kind character(1),
    access_account character varying(32),
    access_password character varying(32),
    proxy_server_name character varying(32),
    access_timeout integer,
    http_port_number integer,
    ftp_port_number integer,
    protocol_kind integer,
    access_type integer,
    url_host_name character varying(32),
    virtual_dir_name character varying(128),
    w3s_interface character(1)
);


ALTER TABLE public.serverinformation OWNER TO zinzi;

--
-- TOC entry 1620 (class 1259 OID 42132)
-- Dependencies: 6
-- Name: smartforcelo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE smartforcelo (
    loid character(10) NOT NULL,
    coursecode character varying(255) NOT NULL
);


ALTER TABLE public.smartforcelo OWNER TO zinzi;

--
-- TOC entry 1617 (class 1259 OID 42123)
-- Dependencies: 6
-- Name: spslo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE spslo (
    loid character(10) NOT NULL,
    urlpath character varying(256) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.spslo OWNER TO zinzi;

--
-- TOC entry 1621 (class 1259 OID 42135)
-- Dependencies: 6
-- Name: urllo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE urllo (
    loid character(10) NOT NULL,
    lourl character varying(256) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.urllo OWNER TO zinzi;

--
-- TOC entry 1646 (class 1259 OID 42352)
-- Dependencies: 1723 6
-- Name: v_lolist; Type: VIEW; Schema: public; Owner: zinzi
--

CREATE VIEW v_lolist AS
    SELECT c.loid AS parentid, c.lotitle AS parentname, c.foreignid AS parentforeignid, l.realloid AS realid, l.lotype AS type, l.loid AS childid, l.lotitle AS childname, l.foreignid AS childforeignid, r.sort_no FROM lorelation r, lo l, lo c WHERE (((l.loid = r.childid) AND (c.loid = r.parentid)) AND (c.lotype = '0'::bpchar));


ALTER TABLE public.v_lolist OWNER TO zinzi;

--
-- TOC entry 1647 (class 1259 OID 42356)
-- Dependencies: 1724 6
-- Name: v_userlist; Type: VIEW; Schema: public; Owner: zinzi
--

CREATE VIEW v_userlist AS
    SELECT g.group_id AS parentid, g.group_name AS parentname, g.foreignid AS parentforeignid, p.user_id AS childid, p.user_name AS childname, p.foreignid AS childforeignid, r.sort_no FROM groupandpeople r, people p, groups g WHERE ((p.user_id = r.childid) AND (g.group_id = r.parentid));


ALTER TABLE public.v_userlist OWNER TO zinzi;

--
-- TOC entry 1622 (class 1259 OID 42138)
-- Dependencies: 6
-- Name: wbtlo; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE wbtlo (
    loid character(10) NOT NULL,
    materialid character varying(32) NOT NULL,
    w_height numeric(4,0) NOT NULL,
    w_width numeric(4,0) NOT NULL
);


ALTER TABLE public.wbtlo OWNER TO zinzi;

--
-- TOC entry 1623 (class 1259 OID 42141)
-- Dependencies: 1922 6
-- Name: xmoentry; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE xmoentry (
    xmo_id character(15) NOT NULL,
    xmo_name character varying(64),
    xmo_out_line character varying(100),
    xmo_uri character varying(100),
    xmo_on_flg character(1) DEFAULT '1'::bpchar,
    class_name character varying(256),
    tree_view_type character(1),
    ini_menu character varying(64),
    priority integer
);


ALTER TABLE public.xmoentry OWNER TO zinzi;

--
-- TOC entry 1615 (class 1259 OID 42117)
-- Dependencies: 6
-- Name: xmorelation; Type: TABLE; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE TABLE xmorelation (
    xmo_id character(15) NOT NULL,
    related_id character(15) NOT NULL
);


ALTER TABLE public.xmorelation OWNER TO zinzi;

--
-- TOC entry 22 (class 1255 OID 42364)
-- Dependencies: 6
-- Name: date_text(date); Type: FUNCTION; Schema: public; Owner: zinzi
--

CREATE FUNCTION date_text(date) RETURNS text
    AS $_$SELECT textin(date_out($1))$_$
    LANGUAGE sql IMMUTABLE STRICT;


ALTER FUNCTION public.date_text(date) OWNER TO zinzi;

--
-- TOC entry 20 (class 1255 OID 42360)
-- Dependencies: 6
-- Name: int4text(integer); Type: FUNCTION; Schema: public; Owner: zinzi
--

CREATE FUNCTION int4text(integer) RETURNS text
    AS $_$SELECT textin(int4out($1))$_$
    LANGUAGE sql IMMUTABLE STRICT;


ALTER FUNCTION public.int4text(integer) OWNER TO zinzi;

--
-- TOC entry 21 (class 1255 OID 42362)
-- Dependencies: 6
-- Name: numeric_text(numeric); Type: FUNCTION; Schema: public; Owner: zinzi
--

CREATE FUNCTION numeric_text(numeric) RETURNS text
    AS $_$SELECT textin(numeric_out($1))$_$
    LANGUAGE sql IMMUTABLE STRICT;


ALTER FUNCTION public.numeric_text(numeric) OWNER TO zinzi;

SET search_path = pg_catalog;

--
-- TOC entry 1860 (class 2605 OID 42365)
-- Dependencies: 22 22
-- Name: CAST (date AS text); Type: CAST; Schema: pg_catalog; Owner: 
--

CREATE CAST (date AS text) WITH FUNCTION public.date_text(date) AS IMPLICIT;


--
-- TOC entry 1770 (class 2605 OID 42361)
-- Dependencies: 20 20
-- Name: CAST (integer AS text); Type: CAST; Schema: pg_catalog; Owner: 
--

CREATE CAST (integer AS text) WITH FUNCTION public.int4text(integer) AS IMPLICIT;


--
-- TOC entry 1891 (class 2605 OID 42363)
-- Dependencies: 21 21
-- Name: CAST (numeric AS text); Type: CAST; Schema: pg_catalog; Owner: 
--

CREATE CAST (numeric AS text) WITH FUNCTION public.numeric_text(numeric) AS IMPLICIT;


SET search_path = public, pg_catalog;

--
-- TOC entry 1644 (class 1259 OID 42344)
-- Dependencies: 6
-- Name: lom_no_seq; Type: SEQUENCE; Schema: public; Owner: zinzi
--

CREATE SEQUENCE lom_no_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lom_no_seq OWNER TO zinzi;

--
-- TOC entry 2083 (class 0 OID 0)
-- Dependencies: 1644
-- Name: lom_no_seq; Type: SEQUENCE SET; Schema: public; Owner: zinzi
--

SELECT pg_catalog.setval('lom_no_seq', 1, false);


--
-- TOC entry 2027 (class 0 OID 42027)
-- Dependencies: 1594
-- Data for Name: aicccomment; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY aicccomment (userid, loid, sessionid, "UID", course_id, student_id, lesson_id, "DATE", "time", location, "COMMENT") FROM stdin;
\.


--
-- TOC entry 2028 (class 0 OID 42033)
-- Dependencies: 1595
-- Data for Name: aicccore; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY aicccore (userid, loid, sessionid, "UID", lesson_status, rawscore, maxscore, minscore, "time", lesson_location, exist) FROM stdin;
\.


--
-- TOC entry 2030 (class 0 OID 42042)
-- Dependencies: 1597
-- Data for Name: aiccinteraction; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY aiccinteraction (userid, loid, sessionid, "UID", course_id, student_id, lesson_id, response_times, "DATE", "time", interaction_id, objective_id, type_interaction, correct_response, response_value, student_response, result, weighting, latency) FROM stdin;
\.


--
-- TOC entry 2031 (class 0 OID 42048)
-- Dependencies: 1598
-- Data for Name: aiccobjectives; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY aiccobjectives (userid, loid, sessionid, "UID", course_id, student_id, lesson_id, "DATE", "time", objective_id, rawscore, maxscore, minscore, status, mastery_time) FROM stdin;
\.


--
-- TOC entry 2032 (class 0 OID 42054)
-- Dependencies: 1599
-- Data for Name: assignments; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY assignments (assignid, membershipid, materialid, study_start_date, enddate, assigner, learn_authority, management_authority, opening_date, closing_date, study_limit_cnt, study_cnt, method_flag) FROM stdin;
\.


--
-- TOC entry 2065 (class 0 OID 42184)
-- Dependencies: 1632
-- Data for Name: cataloglo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY cataloglo (loid, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2066 (class 0 OID 42187)
-- Dependencies: 1633
-- Data for Name: cataloglo_lolist; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY cataloglo_lolist (loid, cataloglistloid, sort_no) FROM stdin;
\.


--
-- TOC entry 2033 (class 0 OID 42057)
-- Dependencies: 1600
-- Data for Name: conferencelo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY conferencelo (loid, urlpath, meetingtitle, startdate, enddate, resourcemail, logonuser, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2034 (class 0 OID 42063)
-- Dependencies: 1601
-- Data for Name: evaluate; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY evaluate (user_id, loid, score_date, score, custom_msg_dir) FROM stdin;
\.


--
-- TOC entry 2035 (class 0 OID 42066)
-- Dependencies: 1602
-- Data for Name: exchangelo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY exchangelo (loid, urlpath, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2036 (class 0 OID 42069)
-- Dependencies: 1603
-- Data for Name: face2facelo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY face2facelo (loid, teacherid) FROM stdin;
\.


--
-- TOC entry 2037 (class 0 OID 42072)
-- Dependencies: 1604
-- Data for Name: groupandpeople; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY groupandpeople (membershipid, sort_no, parentid, childid) FROM stdin;
GR000000GR000001              	0	GR000000       	GR000001       
\.


--
-- TOC entry 2038 (class 0 OID 42076)
-- Dependencies: 1605
-- Data for Name: groups; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY groups (group_id, group_name, group_type, delete_flag, foreignid, custom_msg_dir, "OID", ad_dn) FROM stdin;
GR000000	root	1   	1	\N	\N	\N	\N
GR000001	未所属	1   	1	\N	\N	\N	\N
\.


--
-- TOC entry 2052 (class 0 OID 42129)
-- Dependencies: 1619
-- Data for Name: launchforgetlo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY launchforgetlo (loid, lourl, w_height, w_width) FROM stdin;
LO3       	http://yahoo.co.jp	600	800
\.


--
-- TOC entry 2039 (class 0 OID 42082)
-- Dependencies: 1606
-- Data for Name: lo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lo (loid, lotype, lotitle, loexplanation, foreignid, keyword, delete_flag, loversion, conclusion, realloid, prere, mentoremailaddress) FROM stdin;
LO0       	0  	root		\N	root	0	\N	\N	LO0       	\N	\N
LO1       	0  	未整理	\N	\N	未整理	0	\N	\N	LO1       	\N	\N
LO2       	0  	サンプル	\N	LO-SAMPLE	\N	0	\N	\N	LO2       	\N	\N
LO3       	3  	URLサンプル	\N	URL-SAMPLE	\N	0	\N	\N	LO3       	\N	\N
LO4       	20 	SCORM 2004 3rd Edition Data Model Content Example 1.1	\N	SCORM-DMCE	\N	0	\N	\N	LO4       	\N	\N
\.


--
-- TOC entry 2077 (class 0 OID 42346)
-- Dependencies: 1645
-- Data for Name: loextend; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY loextend (loid, buy, keyword1, keyword2, keyword3, keyword4, keyword5) FROM stdin;
LO2       	0	\N	\N	\N	\N	\N
LO3       	0	\N	\N	\N	\N	\N
LO4       	0	\N	\N	\N	\N	\N
\.


--
-- TOC entry 2058 (class 0 OID 42151)
-- Dependencies: 1625
-- Data for Name: lohistory; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lohistory (loid, time_stamp, userid) FROM stdin;
LO2       	2009-04-03 16:12:25	PE000000
LO3       	2009-04-03 16:13:04	PE000000
LO4       	2009-04-03 16:16:35	PE000000
\.


--
-- TOC entry 2040 (class 0 OID 42088)
-- Dependencies: 1607
-- Data for Name: lolog; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lolog (userid, loid, study_start_date, residancetime, passday, study_end_date, highscore, lowsscore, execise_point, fullscore, access_cnt, last_access) FROM stdin;
PE000000	LO3       	2009-04-03 16:13:20	0	2009-04-03 16:13:20	2009-04-03 16:13:20	0	0	0	0	1	2009-04-03 16:13:20
PE000000	LO2       	2009-04-03 16:13:20	0	2009-04-03 16:13:20	2009-04-03 16:13:20	0	0	0	0	1	2009-04-03 16:13:20
\.


--
-- TOC entry 2041 (class 0 OID 42091)
-- Dependencies: 1608
-- Data for Name: lologsession; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lologsession (userid, loid, sessionid, study_start_date, residancetime, passday, study_end_date, highscore, lowsscore, execise_point, fullscore, lunchtimes) FROM stdin;
PE000000	LO3       	1                                                                                                                               	2009-04-03 16:13:20	0	2009-04-03 16:13:20	2009-04-03 16:13:20	0	0	0	0	0
\.


--
-- TOC entry 2075 (class 0 OID 42332)
-- Dependencies: 1642
-- Data for Name: lom; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lom (lom_no, loid, path, lom_type, value) FROM stdin;
\.


--
-- TOC entry 2076 (class 0 OID 42338)
-- Dependencies: 1643
-- Data for Name: lom_type; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lom_type (display_no, path, lom_type, name, value, disp_value, scorm_vocabulary) FROM stdin;
0000000000	//:lom/:general/:title	00	学習資源タイトル			
0000000001	//:lom/:general/:language	11	言語	0	jp	
0000000002	//:lom/:general/:description	15	内容			
0000000003	//:lom/:general/:keyword	15	キーワード			
0000000004	//:lom/:general/:coverage	15	対象範囲			
0000000005	//:lom/:educational/:interactivetype	11	情報交換タイプ	0	対話型	active
0000000005	//:lom/:educational/:interactivetype	11	情報交換タイプ	1	提示型	expositive
0000000005	//:lom/:educational/:interactivetype	11	情報交換タイプ	2	対話提示混合	mixed
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	0	ドリル	exercise
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	1	シミュレーション	simulation
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	2	問題集	questionnaire
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	3	図形	diagram
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	4	画像	figure
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	5	グラフ	graph
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	6	インデックス	index
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	7	スライド	slide
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	8	表	table
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	9	説明文	narrative text
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	10	試験	exam
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	11	実験	experiment
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	12	問題記述	problem statement
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	13	自己評価	self assessment
0000000006	//:lom/:educational/:learningresourcetype	11	情報資源タイプ	14	講義	lecture
0000000007	//:lom/:educational/:intendedenduserrole	11	利用者種別	0	教師	teacher
0000000007	//:lom/:educational/:intendedenduserrole	11	利用者種別	1	製作者	author
0000000007	//:lom/:educational/:intendedenduserrole	11	利用者種別	2	学習者	learner
0000000007	//:lom/:educational/:intendedenduserrole	11	利用者種別	3	管理者	manager
0000000008	//:lom/:educational/:difficulty	11	難易度	0	大変易しい	very easy
0000000008	//:lom/:educational/:difficulty	11	難易度	1	易しい	easy
0000000008	//:lom/:educational/:difficulty	11	難易度	2	標準的	medium
0000000008	//:lom/:educational/:difficulty	11	難易度	3	難しい	difficult
0000000008	//:lom/:educational/:difficulty	11	難易度	4	大変難しい	very difficult
0000000009	//:lom/:educational/:typicallearningtime	00	学習時間			
0000000010	//:lom/:rights/:cost	11	費用	0	No	no
0000000010	//:lom/:rights/:cost	11	費用	1	Yes	yes
0000000011	//:lom/:rights/:copyrightandotherrestrictions	11	著作権および制約	0	No	no
0000000011	//:lom/:rights/:copyrightandotherrestrictions	11	著作権および制約	1	Yes	yes
0000000012	//:lom/:rights/:description	00	使用条件に関する記述			
\.


--
-- TOC entry 2042 (class 0 OID 42095)
-- Dependencies: 1609
-- Data for Name: lorelation; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lorelation (materialid, sort_no, parentid, childid) FROM stdin;
LO0LO1              	0	LO0       	LO1       
LO0LO2              	1	LO0       	LO2       
LO2LO3              	1	LO2       	LO3       
LO2LO4              	2	LO2       	LO4       
\.


--
-- TOC entry 2043 (class 0 OID 42099)
-- Dependencies: 1610
-- Data for Name: lotype; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY lotype (lotype, typename, losubtype) FROM stdin;
0  	コンテナ	0  
3  	URL	0  
5  	オフィス文書（upload）	0  
6  	カタログ	0  
8  	指導者	0  
20 	SCORM	0  
\.


--
-- TOC entry 2044 (class 0 OID 42102)
-- Dependencies: 1611
-- Data for Name: officelo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY officelo (loid, lourl, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2064 (class 0 OID 42181)
-- Dependencies: 1631
-- Data for Name: offlinelo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY offlinelo (loid, materialid, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2059 (class 0 OID 42154)
-- Dependencies: 1626
-- Data for Name: ol_aicccomment; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY ol_aicccomment (userid, loid, sessionid, "UID", course_id, student_id, lesson_id, "DATE", "time", location, "COMMENT") FROM stdin;
\.


--
-- TOC entry 2060 (class 0 OID 42160)
-- Dependencies: 1627
-- Data for Name: ol_aicccore; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY ol_aicccore (userid, loid, sessionid, "UID", lesson_status, rawscore, maxscore, minscore, "time", lesson_location, exist) FROM stdin;
\.


--
-- TOC entry 2062 (class 0 OID 42169)
-- Dependencies: 1629
-- Data for Name: ol_aiccinteraction; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY ol_aiccinteraction (userid, loid, sessionid, "UID", course_id, student_id, lesson_id, response_times, "DATE", "time", interaction_id, objective_id, type_interaction, correct_response, response_value, student_response, result, weighting, latency) FROM stdin;
\.


--
-- TOC entry 2063 (class 0 OID 42175)
-- Dependencies: 1630
-- Data for Name: ol_aiccobjectives; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY ol_aiccobjectives (userid, loid, sessionid, "UID", course_id, student_id, lesson_id, "DATE", "time", objective_id, rawscore, maxscore, minscore, status, mastery_time) FROM stdin;
\.


--
-- TOC entry 2061 (class 0 OID 42166)
-- Dependencies: 1628
-- Data for Name: ol_sectionlog; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY ol_sectionlog (userid, loid, sessionid, "UID", lesson_status, "time") FROM stdin;
\.


--
-- TOC entry 2045 (class 0 OID 42105)
-- Dependencies: 1612
-- Data for Name: people; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY people (user_id, user_name, encrypt_password, contact_address, sex, contact_email, contact_email2, reading_name, birthday, contact_tel, custom_msg_dir, delete_flag, foreignid, loginid, ad_user_id, user_type, "OID", ad_dn) FROM stdin;
PE000000	root	GyEhFw==                        	\N	\N	\N	\N	\N	\N	\N	\N	0	111	root	\N	1   	\N	\N
\.


--
-- TOC entry 2057 (class 0 OID 42148)
-- Dependencies: 1624
-- Data for Name: perceptionlo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY perceptionlo (loid, assessment_id, session_name, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2067 (class 0 OID 42190)
-- Dependencies: 1634
-- Data for Name: prerequisite; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY prerequisite (loid, prereid) FROM stdin;
\.


--
-- TOC entry 2026 (class 0 OID 42024)
-- Dependencies: 1593
-- Data for Name: propagaterelation; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY propagaterelation (loid, relatedid) FROM stdin;
\.


--
-- TOC entry 2046 (class 0 OID 42111)
-- Dependencies: 1613
-- Data for Name: roleassignments; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY roleassignments (role_assign_id, user_id, role_id, groupid) FROM stdin;
0              	PE000000	0         	GR000000
\.


--
-- TOC entry 2047 (class 0 OID 42114)
-- Dependencies: 1614
-- Data for Name: roles; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY roles (roleid, rolename, deleted) FROM stdin;
0         	システム管理者	0
1         	学習者	0
\.


--
-- TOC entry 2049 (class 0 OID 42120)
-- Dependencies: 1616
-- Data for Name: rolesfunction; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY rolesfunction (roleid, function) FROM stdin;
0         	0              
0         	1              
0         	2              
0         	3              
0         	4              
0         	5              
0         	7              
0         	8              
0         	9              
0         	10             
0         	11             
0         	12             
0         	13             
0         	14             
1         	0              
1         	14             
\.


--
-- TOC entry 2069 (class 0 OID 42196)
-- Dependencies: 1636
-- Data for Name: scorm_attempt; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scorm_attempt (userid, loid, studysessioncount, activityid, attemptcount, learnsessioncount, sessionid, learnsession_date, completion_status, scaledscore, rawscore, maxscore, minscore, attempt_session_time, success_status, location, exit) FROM stdin;
\.


--
-- TOC entry 2070 (class 0 OID 42202)
-- Dependencies: 1637
-- Data for Name: scorm_interaction; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scorm_interaction (userid, loid, studysessioncount, activityid, attemptcount, learnsessioncount, interactioncount, sessionid, interactionid, interactiontype, objectiveid, "timestamp", correctresponse1, correctresponse2, correctresponse3, correctresponse4, correctresponse5, weighting, learnerresponse, learner_result, latency, description) FROM stdin;
\.


--
-- TOC entry 2071 (class 0 OID 42208)
-- Dependencies: 1638
-- Data for Name: scorm_learnercomment; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scorm_learnercomment (userid, loid, studysessioncount, activityid, attemptcount, learnsessioncount, learnercommentcount, sessionid, learnercomment, learnercommentlocation, learnercommenttime) FROM stdin;
\.


--
-- TOC entry 2072 (class 0 OID 42214)
-- Dependencies: 1639
-- Data for Name: scorm_lmscomment; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scorm_lmscomment (userid, loid, studysessioncount, activityid, attemptcount, learnsessioncount, lmscommentcount, sessionid, lmscomment, lmscommentlocation, lmscommenttime) FROM stdin;
\.


--
-- TOC entry 2073 (class 0 OID 42220)
-- Dependencies: 1640
-- Data for Name: scorm_objective; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scorm_objective (userid, loid, studysessioncount, activityid, attemptcount, learnsessioncount, objectivecount, sessionid, objectiveid, scaledscore, rawscore, maxscore, minscore, successstatus, completionstatus) FROM stdin;
\.


--
-- TOC entry 2068 (class 0 OID 42193)
-- Dependencies: 1635
-- Data for Name: scormlo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scormlo (loid, materialid, w_height, w_width) FROM stdin;
LO4       	SCORM2004.3.DMCE.1.1.0	600	800
\.


--
-- TOC entry 2074 (class 0 OID 42226)
-- Dependencies: 1641
-- Data for Name: scormsession; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY scormsession (userid, loid, studysessioncount, sessionid) FROM stdin;
\.


--
-- TOC entry 2029 (class 0 OID 42039)
-- Dependencies: 1596
-- Data for Name: sectionlog; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY sectionlog (userid, loid, sessionid, "UID", lesson_status, "time") FROM stdin;
\.


--
-- TOC entry 2051 (class 0 OID 42126)
-- Dependencies: 1618
-- Data for Name: serverinformation; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY serverinformation (server_id, server_name, ip_address, os_kind, server_kind, access_account, access_password, proxy_server_name, access_timeout, http_port_number, ftp_port_number, protocol_kind, access_type, url_host_name, virtual_dir_name, w3s_interface) FROM stdin;
\.


--
-- TOC entry 2053 (class 0 OID 42132)
-- Dependencies: 1620
-- Data for Name: smartforcelo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY smartforcelo (loid, coursecode) FROM stdin;
\.


--
-- TOC entry 2050 (class 0 OID 42123)
-- Dependencies: 1617
-- Data for Name: spslo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY spslo (loid, urlpath, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2054 (class 0 OID 42135)
-- Dependencies: 1621
-- Data for Name: urllo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY urllo (loid, lourl, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2055 (class 0 OID 42138)
-- Dependencies: 1622
-- Data for Name: wbtlo; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY wbtlo (loid, materialid, w_height, w_width) FROM stdin;
\.


--
-- TOC entry 2056 (class 0 OID 42141)
-- Dependencies: 1623
-- Data for Name: xmoentry; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY xmoentry (xmo_id, xmo_name, xmo_out_line, xmo_uri, xmo_on_flg, class_name, tree_view_type, ini_menu, priority) FROM stdin;
1              	ユーザ管理	ユーザを管理する	xms2/	0	jp.co.ntt.lms.xmo.People.People	1	ユーザ管理	1
2              	ロール管理	権限を管理する	xms2/	0	jp.co.ntt.lms.xmo.Roles.Roles	1	ロール管理	3
3              	ユーザツリー管理	グループツリーを管理する	xms2/	0	jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeople	1	ユーザ管理	1
4              	グループ管理	グループを管理する	xms2/	0	jp.co.ntt.lms.xmo.Groups.Groups	1	ユーザ管理	1
5              	ロールアサイン管理	権限の割り当てを管理する	xms2/	0	jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignments	1	ロール管理	3
6              	メッセージ管理	メッセージを管理します	xms2/	1	jp.co.ntt.lms.xmo.Message.Message	1		0
7              	LO管理	LOを管理します	xms2/	0	jp.co.ntt.lms.xmo.Lo.Lo	2	LO管理	2
8              	LOツリー管理	LOツリーを管理します	xms2/	0	jp.co.ntt.lms.xmo.LoRelation.LoRelation	2	LO管理	2
9              	アサイン管理（ユーザ)	LOの割り当てを管理します	xms2/	0	jp.co.ntt.lms.xmo.Assignments.Assignments	1	ユーザ管理	1
0              	学習	学習者権限	xms2/	0	learn	2	学習	4
10             	一括登録管理	一括登録	xms2/	0	jp.co.ntt.lms.xmo.LumpInsert.LumpInsert	1	ユーザ管理	1
11             	メール送信	メールを送信します	xms2/	0	jp.co.ntt.lms.xmo.Mail.Mail	1		0
12             	評価管理	学習を評価します	xms2/	0	jp.co.ntt.lms.xmo.Evaluate.Evaluate	2	LO管理	2
13             	アサイン管理(LO）	LOの割当を管理します	xms2/	0	jp.co.ntt.lms.xmo.Assignments.Assignments	2	LO管理	2
14             	ログ管理(LO)	ログを参照します	xms2/	0	log	2	LO管理	2
15             	AD 連携	AD 連携	xms2/	1	jp.co.ntt.lms.xmo.Ad.ADCorp	1		2
16             	ログ管理(ユーザ)	ログを参照します	xms2/	0	log	1	LO管理	2
\.


--
-- TOC entry 2048 (class 0 OID 42117)
-- Dependencies: 1615
-- Data for Name: xmorelation; Type: TABLE DATA; Schema: public; Owner: zinzi
--

COPY xmorelation (xmo_id, related_id) FROM stdin;
10             	1              
10             	4              
\.


--
-- TOC entry 1924 (class 1259 OID 42229)
-- Dependencies: 1594
-- Name: aicccomment_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aicccomment_index_1 ON aicccomment USING btree (userid);


--
-- TOC entry 1925 (class 1259 OID 42230)
-- Dependencies: 1594
-- Name: aicccomment_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aicccomment_index_2 ON aicccomment USING btree (loid);


--
-- TOC entry 1926 (class 1259 OID 42231)
-- Dependencies: 1595
-- Name: aicccore_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aicccore_index_1 ON aicccore USING btree (userid);


--
-- TOC entry 1927 (class 1259 OID 42232)
-- Dependencies: 1595
-- Name: aicccore_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aicccore_index_2 ON aicccore USING btree (loid);


--
-- TOC entry 1930 (class 1259 OID 42233)
-- Dependencies: 1597
-- Name: aiccinteraction_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aiccinteraction_index_1 ON aiccinteraction USING btree (userid);


--
-- TOC entry 1931 (class 1259 OID 42234)
-- Dependencies: 1597
-- Name: aiccinteraction_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aiccinteraction_index_2 ON aiccinteraction USING btree (loid);


--
-- TOC entry 1932 (class 1259 OID 42235)
-- Dependencies: 1598
-- Name: aiccobjectives_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aiccobjectives_index_1 ON aiccobjectives USING btree (userid);


--
-- TOC entry 1933 (class 1259 OID 42236)
-- Dependencies: 1598
-- Name: aiccobjectives_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX aiccobjectives_index_2 ON aiccobjectives USING btree (loid);


--
-- TOC entry 1934 (class 1259 OID 42237)
-- Dependencies: 1599 1599
-- Name: assignments_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX assignments_index_1 ON assignments USING btree (membershipid, materialid);


--
-- TOC entry 1935 (class 1259 OID 42238)
-- Dependencies: 1599
-- Name: assignments_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX assignments_index_2 ON assignments USING btree (membershipid);


--
-- TOC entry 1979 (class 1259 OID 42239)
-- Dependencies: 1632
-- Name: cataloglo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX cataloglo_index_1 ON cataloglo USING btree (loid);


--
-- TOC entry 1980 (class 1259 OID 42240)
-- Dependencies: 1633
-- Name: cataloglo_lolist_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX cataloglo_lolist_index_1 ON cataloglo_lolist USING btree (loid);


--
-- TOC entry 1936 (class 1259 OID 42241)
-- Dependencies: 1600
-- Name: conferencelo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX conferencelo_index_1 ON conferencelo USING btree (loid);


--
-- TOC entry 1937 (class 1259 OID 42242)
-- Dependencies: 1601
-- Name: evaluate_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX evaluate_index_1 ON evaluate USING btree (user_id);


--
-- TOC entry 1938 (class 1259 OID 42243)
-- Dependencies: 1601
-- Name: evaluate_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX evaluate_index_2 ON evaluate USING btree (loid);


--
-- TOC entry 1939 (class 1259 OID 42244)
-- Dependencies: 1602
-- Name: exchangelo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX exchangelo_index_1 ON exchangelo USING btree (loid);


--
-- TOC entry 1940 (class 1259 OID 42245)
-- Dependencies: 1603
-- Name: face2facelo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX face2facelo_index_1 ON face2facelo USING btree (loid);


--
-- TOC entry 1941 (class 1259 OID 42246)
-- Dependencies: 1604
-- Name: groupandpeople_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX groupandpeople_index_1 ON groupandpeople USING btree (membershipid);


--
-- TOC entry 1942 (class 1259 OID 42247)
-- Dependencies: 1604
-- Name: groupandpeople_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX groupandpeople_index_2 ON groupandpeople USING btree (parentid);


--
-- TOC entry 1943 (class 1259 OID 42248)
-- Dependencies: 1604
-- Name: groupandpeople_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX groupandpeople_index_3 ON groupandpeople USING btree (childid);


--
-- TOC entry 1944 (class 1259 OID 42249)
-- Dependencies: 1605
-- Name: groups_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX groups_index_1 ON groups USING btree (group_id);


--
-- TOC entry 1961 (class 1259 OID 42250)
-- Dependencies: 1619
-- Name: launchforgetlo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX launchforgetlo_index_1 ON launchforgetlo USING btree (loid);


--
-- TOC entry 1945 (class 1259 OID 42251)
-- Dependencies: 1606
-- Name: lo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lo_index_1 ON lo USING btree (loid);


--
-- TOC entry 1946 (class 1259 OID 42252)
-- Dependencies: 1606
-- Name: lo_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lo_index_2 ON lo USING btree (realloid);


--
-- TOC entry 1967 (class 1259 OID 42253)
-- Dependencies: 1625
-- Name: lohistory_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lohistory_index_1 ON lohistory USING btree (loid);


--
-- TOC entry 1947 (class 1259 OID 42254)
-- Dependencies: 1607
-- Name: lolog_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lolog_index_1 ON lolog USING btree (userid);


--
-- TOC entry 1948 (class 1259 OID 42255)
-- Dependencies: 1607
-- Name: lolog_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lolog_index_2 ON lolog USING btree (loid);


--
-- TOC entry 1949 (class 1259 OID 42256)
-- Dependencies: 1608
-- Name: lologsession_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lologsession_index_1 ON lologsession USING btree (userid);


--
-- TOC entry 1950 (class 1259 OID 42257)
-- Dependencies: 1608
-- Name: lologsession_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lologsession_index_2 ON lologsession USING btree (loid);


--
-- TOC entry 1951 (class 1259 OID 42258)
-- Dependencies: 1609
-- Name: lorelation_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lorelation_index_1 ON lorelation USING btree (parentid);


--
-- TOC entry 1952 (class 1259 OID 42259)
-- Dependencies: 1609
-- Name: lorelation_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lorelation_index_2 ON lorelation USING btree (materialid);


--
-- TOC entry 1953 (class 1259 OID 42260)
-- Dependencies: 1609
-- Name: lorelation_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lorelation_index_3 ON lorelation USING btree (childid);


--
-- TOC entry 1954 (class 1259 OID 42261)
-- Dependencies: 1610
-- Name: lotype_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX lotype_index_1 ON lotype USING btree (lotype);


--
-- TOC entry 1955 (class 1259 OID 42262)
-- Dependencies: 1611
-- Name: officelo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX officelo_index_1 ON officelo USING btree (loid);


--
-- TOC entry 1978 (class 1259 OID 42263)
-- Dependencies: 1631
-- Name: offlinelo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX offlinelo_index_1 ON offlinelo USING btree (loid);


--
-- TOC entry 1968 (class 1259 OID 42264)
-- Dependencies: 1626
-- Name: ol_aicccomment_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aicccomment_index_1 ON ol_aicccomment USING btree (userid);


--
-- TOC entry 1969 (class 1259 OID 42265)
-- Dependencies: 1626
-- Name: ol_aicccomment_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aicccomment_index_2 ON ol_aicccomment USING btree (loid);


--
-- TOC entry 1970 (class 1259 OID 42266)
-- Dependencies: 1627
-- Name: ol_aicccore_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aicccore_index_1 ON ol_aicccore USING btree (userid);


--
-- TOC entry 1971 (class 1259 OID 42267)
-- Dependencies: 1627
-- Name: ol_aicccore_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aicccore_index_2 ON ol_aicccore USING btree (loid);


--
-- TOC entry 1974 (class 1259 OID 42268)
-- Dependencies: 1629
-- Name: ol_aiccinteraction_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aiccinteraction_index_1 ON ol_aiccinteraction USING btree (userid);


--
-- TOC entry 1975 (class 1259 OID 42269)
-- Dependencies: 1629
-- Name: ol_aiccinteraction_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aiccinteraction_index_2 ON ol_aiccinteraction USING btree (loid);


--
-- TOC entry 1976 (class 1259 OID 42270)
-- Dependencies: 1630
-- Name: ol_aiccobjectives_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aiccobjectives_index_1 ON ol_aiccobjectives USING btree (userid);


--
-- TOC entry 1977 (class 1259 OID 42271)
-- Dependencies: 1630
-- Name: ol_aiccobjectives_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_aiccobjectives_index_2 ON ol_aiccobjectives USING btree (loid);


--
-- TOC entry 1972 (class 1259 OID 42272)
-- Dependencies: 1628
-- Name: ol_sectionlog_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_sectionlog_index_1 ON ol_sectionlog USING btree (userid);


--
-- TOC entry 1973 (class 1259 OID 42273)
-- Dependencies: 1628
-- Name: ol_sectionlog_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX ol_sectionlog_index_2 ON ol_sectionlog USING btree (loid);


--
-- TOC entry 1956 (class 1259 OID 42274)
-- Dependencies: 1612
-- Name: people_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX people_index_1 ON people USING btree (user_id);


--
-- TOC entry 1966 (class 1259 OID 42275)
-- Dependencies: 1624
-- Name: perceptionlo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX perceptionlo_index_1 ON perceptionlo USING btree (loid);


--
-- TOC entry 1981 (class 1259 OID 42277)
-- Dependencies: 1634
-- Name: prerequisite_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX prerequisite_index_1 ON prerequisite USING btree (loid);


--
-- TOC entry 1923 (class 1259 OID 42276)
-- Dependencies: 1593
-- Name: propagaterelation_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX propagaterelation_index_1 ON propagaterelation USING btree (loid);


--
-- TOC entry 1957 (class 1259 OID 42279)
-- Dependencies: 1613
-- Name: roleassignments_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX roleassignments_index_1 ON roleassignments USING btree (user_id);


--
-- TOC entry 1958 (class 1259 OID 42278)
-- Dependencies: 1614
-- Name: roles_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX roles_index_1 ON roles USING btree (roleid);


--
-- TOC entry 1959 (class 1259 OID 42280)
-- Dependencies: 1616
-- Name: rolesfunction_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX rolesfunction_index_1 ON rolesfunction USING btree (roleid);


--
-- TOC entry 1983 (class 1259 OID 42289)
-- Dependencies: 1636
-- Name: scormattempt_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_1 ON scorm_attempt USING btree (userid);


--
-- TOC entry 1984 (class 1259 OID 42290)
-- Dependencies: 1636
-- Name: scormattempt_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_2 ON scorm_attempt USING btree (loid);


--
-- TOC entry 1985 (class 1259 OID 42291)
-- Dependencies: 1636
-- Name: scormattempt_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_3 ON scorm_attempt USING btree (studysessioncount);


--
-- TOC entry 1986 (class 1259 OID 42292)
-- Dependencies: 1636
-- Name: scormattempt_index_4; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_4 ON scorm_attempt USING btree (activityid);


--
-- TOC entry 1987 (class 1259 OID 42293)
-- Dependencies: 1636
-- Name: scormattempt_index_5; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_5 ON scorm_attempt USING btree (attemptcount);


--
-- TOC entry 1988 (class 1259 OID 42294)
-- Dependencies: 1636
-- Name: scormattempt_index_6; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_6 ON scorm_attempt USING btree (learnsessioncount);


--
-- TOC entry 1989 (class 1259 OID 42295)
-- Dependencies: 1636
-- Name: scormattempt_index_7; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormattempt_index_7 ON scorm_attempt USING btree (sessionid);


--
-- TOC entry 1990 (class 1259 OID 42296)
-- Dependencies: 1637
-- Name: scorminteraction_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_1 ON scorm_interaction USING btree (userid);


--
-- TOC entry 1991 (class 1259 OID 42297)
-- Dependencies: 1637
-- Name: scorminteraction_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_2 ON scorm_interaction USING btree (loid);


--
-- TOC entry 1992 (class 1259 OID 42298)
-- Dependencies: 1637
-- Name: scorminteraction_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_3 ON scorm_interaction USING btree (studysessioncount);


--
-- TOC entry 1993 (class 1259 OID 42299)
-- Dependencies: 1637
-- Name: scorminteraction_index_4; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_4 ON scorm_interaction USING btree (activityid);


--
-- TOC entry 1994 (class 1259 OID 42300)
-- Dependencies: 1637
-- Name: scorminteraction_index_5; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_5 ON scorm_interaction USING btree (attemptcount);


--
-- TOC entry 1995 (class 1259 OID 42301)
-- Dependencies: 1637
-- Name: scorminteraction_index_6; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_6 ON scorm_interaction USING btree (learnsessioncount);


--
-- TOC entry 1996 (class 1259 OID 42302)
-- Dependencies: 1637
-- Name: scorminteraction_index_7; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_7 ON scorm_interaction USING btree (interactioncount);


--
-- TOC entry 1997 (class 1259 OID 42303)
-- Dependencies: 1637
-- Name: scorminteraction_index_8; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scorminteraction_index_8 ON scorm_interaction USING btree (sessionid);


--
-- TOC entry 1998 (class 1259 OID 42304)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_1 ON scorm_learnercomment USING btree (userid);


--
-- TOC entry 1999 (class 1259 OID 42305)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_2 ON scorm_learnercomment USING btree (loid);


--
-- TOC entry 2000 (class 1259 OID 42306)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_3 ON scorm_learnercomment USING btree (studysessioncount);


--
-- TOC entry 2001 (class 1259 OID 42307)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_4; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_4 ON scorm_learnercomment USING btree (activityid);


--
-- TOC entry 2002 (class 1259 OID 42308)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_5; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_5 ON scorm_learnercomment USING btree (attemptcount);


--
-- TOC entry 2003 (class 1259 OID 42309)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_6; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_6 ON scorm_learnercomment USING btree (learnsessioncount);


--
-- TOC entry 2004 (class 1259 OID 42310)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_7; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_7 ON scorm_learnercomment USING btree (learnercommentcount);


--
-- TOC entry 2005 (class 1259 OID 42311)
-- Dependencies: 1638
-- Name: scormlearnercomment_index_8; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlearnercomment_index_8 ON scorm_learnercomment USING btree (sessionid);


--
-- TOC entry 2006 (class 1259 OID 42312)
-- Dependencies: 1639
-- Name: scormlmscomment_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_1 ON scorm_lmscomment USING btree (userid);


--
-- TOC entry 2007 (class 1259 OID 42313)
-- Dependencies: 1639
-- Name: scormlmscomment_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_2 ON scorm_lmscomment USING btree (loid);


--
-- TOC entry 2008 (class 1259 OID 42314)
-- Dependencies: 1639
-- Name: scormlmscomment_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_3 ON scorm_lmscomment USING btree (studysessioncount);


--
-- TOC entry 2009 (class 1259 OID 42315)
-- Dependencies: 1639
-- Name: scormlmscomment_index_4; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_4 ON scorm_lmscomment USING btree (activityid);


--
-- TOC entry 2010 (class 1259 OID 42316)
-- Dependencies: 1639
-- Name: scormlmscomment_index_5; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_5 ON scorm_lmscomment USING btree (attemptcount);


--
-- TOC entry 2011 (class 1259 OID 42317)
-- Dependencies: 1639
-- Name: scormlmscomment_index_6; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_6 ON scorm_lmscomment USING btree (learnsessioncount);


--
-- TOC entry 2012 (class 1259 OID 42318)
-- Dependencies: 1639
-- Name: scormlmscomment_index_7; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_7 ON scorm_lmscomment USING btree (lmscommentcount);


--
-- TOC entry 2013 (class 1259 OID 42319)
-- Dependencies: 1639
-- Name: scormlmscomment_index_8; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlmscomment_index_8 ON scorm_lmscomment USING btree (sessionid);


--
-- TOC entry 1982 (class 1259 OID 42288)
-- Dependencies: 1635
-- Name: scormlo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormlo_index_1 ON scormlo USING btree (loid);


--
-- TOC entry 2014 (class 1259 OID 42320)
-- Dependencies: 1640
-- Name: scormobjective_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_1 ON scorm_objective USING btree (userid);


--
-- TOC entry 2015 (class 1259 OID 42321)
-- Dependencies: 1640
-- Name: scormobjective_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_2 ON scorm_objective USING btree (loid);


--
-- TOC entry 2016 (class 1259 OID 42322)
-- Dependencies: 1640
-- Name: scormobjective_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_3 ON scorm_objective USING btree (studysessioncount);


--
-- TOC entry 2017 (class 1259 OID 42323)
-- Dependencies: 1640
-- Name: scormobjective_index_4; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_4 ON scorm_objective USING btree (activityid);


--
-- TOC entry 2018 (class 1259 OID 42324)
-- Dependencies: 1640
-- Name: scormobjective_index_5; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_5 ON scorm_objective USING btree (attemptcount);


--
-- TOC entry 2019 (class 1259 OID 42325)
-- Dependencies: 1640
-- Name: scormobjective_index_6; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_6 ON scorm_objective USING btree (learnsessioncount);


--
-- TOC entry 2020 (class 1259 OID 42326)
-- Dependencies: 1640
-- Name: scormobjective_index_7; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_7 ON scorm_objective USING btree (objectivecount);


--
-- TOC entry 2021 (class 1259 OID 42327)
-- Dependencies: 1640
-- Name: scormobjective_index_8; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormobjective_index_8 ON scorm_objective USING btree (sessionid);


--
-- TOC entry 2022 (class 1259 OID 42328)
-- Dependencies: 1641
-- Name: scormsession_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormsession_index_1 ON scormsession USING btree (userid);


--
-- TOC entry 2023 (class 1259 OID 42329)
-- Dependencies: 1641
-- Name: scormsession_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormsession_index_2 ON scormsession USING btree (loid);


--
-- TOC entry 2024 (class 1259 OID 42330)
-- Dependencies: 1641
-- Name: scormsession_index_3; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormsession_index_3 ON scormsession USING btree (studysessioncount);


--
-- TOC entry 2025 (class 1259 OID 42331)
-- Dependencies: 1641
-- Name: scormsession_index_4; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX scormsession_index_4 ON scormsession USING btree (sessionid);


--
-- TOC entry 1928 (class 1259 OID 42281)
-- Dependencies: 1596
-- Name: sectionlog_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX sectionlog_index_1 ON sectionlog USING btree (userid);


--
-- TOC entry 1929 (class 1259 OID 42282)
-- Dependencies: 1596
-- Name: sectionlog_index_2; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX sectionlog_index_2 ON sectionlog USING btree (loid);


--
-- TOC entry 1962 (class 1259 OID 42283)
-- Dependencies: 1620
-- Name: smartforcelo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX smartforcelo_index_1 ON smartforcelo USING btree (loid);


--
-- TOC entry 1960 (class 1259 OID 42284)
-- Dependencies: 1617
-- Name: spslo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX spslo_index_1 ON spslo USING btree (loid);


--
-- TOC entry 1963 (class 1259 OID 42285)
-- Dependencies: 1621
-- Name: urllo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX urllo_index_1 ON urllo USING btree (loid);


--
-- TOC entry 1964 (class 1259 OID 42286)
-- Dependencies: 1622
-- Name: wbtlo_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX wbtlo_index_1 ON wbtlo USING btree (loid);


--
-- TOC entry 1965 (class 1259 OID 42287)
-- Dependencies: 1623
-- Name: xmoentry_index_1; Type: INDEX; Schema: public; Owner: zinzi; Tablespace: 
--

CREATE INDEX xmoentry_index_1 ON xmoentry USING btree (xmo_id);


--
-- TOC entry 2082 (class 0 OID 0)
-- Dependencies: 6
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


-- Completed on 2009-04-03 17:04:28

--
-- PostgreSQL database dump complete
--

