/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

// 
//	@\	
//		MI f[^f ]f[^( evaluationData ) NX     
//
//		ύX	
//			2003.12.01 gxl VK쐬
//

package jp.co.ntt.lms.lo.scorm.cbtcom;

import java.io.File;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.IOException;
//import java.util.StringTokenizer;

/**
 * CMI f[^f ]f[^( evaluationData ) NX. <br>
 * @author gxl
 */
public class CMIEvaluationData extends CMIObjBase {

	/**
	 * CmiEvaluationDataNX̃RXgN^<br>		
	 */
	public CMIEvaluationData() {
		// I[vԃtO(I[v)
		m_isOpen = false;
		// vg^Cvf[^Zbg
		m_proto = CMIElementProto.g_evaluationProto;
		// qf[^f𐶐
		makeChildren(CMIElementProto.g_evaluationProto);	
	}

	/**			
	 * CmiEvaluationDataNX̃RXgN^<br>		
	 * @param cbt CMICBTIuWFNg
	 */		
	public CMIEvaluationData(CMICBT cbt) {
		// I[vԃtO(I[v)
		m_isOpen = false;	
		// vg^Cvf[^Zbg
		m_proto = CMIElementProto.g_evaluationProto;
		// CBTIuWFNgZbg
		m_CBT = cbt;						
		// ĹAmakeChildren OɃZbgKvB
		
		// qf[^f𐶐
		makeChildren(CMIElementProto.g_evaluationProto);	
	}
	
	/**			
	 * fXgN^ <br>		
	 */		
	public void finalize() {
	}

	/**			
	 * ZbVJn@ <br>		
	 * @return @String@CBTNURL
	 */		
	public String open() {
		// CBTIuWFNg̃I[vR[
		return m_CBT.open();	
	}
	
	/**			
	 * ZbVI@ <br>		
	 */		
	public void close() {
		// CBTIuWFNg̃N[YR[
		m_CBT.close();	
	}
	
	/**			
	 * IuWFNg̃I[vs@ <br>		
	 */		
	public void myOpen() {
		// I[vԃtOI[vς݂ɂ
		m_isOpen = true;	
	}

	/**		
	 * ZbVI@ <br>	
	 */	
	public void myClose() {
		// I[vԃtO𖢃I[vɂ
		m_isOpen = false;		
	}
	
	/**			
	 * (LocalValue)lݒ@ <br>		
	 * @param name String f[^fpX
	 * @param value String f[^l
	 */		
	public void setValue(String name, String value) {
		// G[NA
		m_CBT.clearError();

		if (!m_isOpen) {
			// I[vԂȂ΁AwpX̃GgɒlZbg
			CMIParameterPath param = new CMIParameterPath(name);
			String strDataModelName = param.popFirstElement();
			String strCategory = param.getNthElement(1);

			localSetValue(param.getPath(), value);
		}
		else {
			// I[vԂȂ΁AG[Zbg
			setError(CMIError.ERR_NOT_INITALIZED);
			setVendorError(getVendorData("CMIEvaluationData.setValue", this));
		}
	}
	
	/**			
	 * ([Jl)l擾@ <br>
	 * @param name String f[^fpX		
	 * @return @String  f[^l
	 */		
	public String getValue(String name) {
		// G[NA
		m_CBT.clearError();

		// wpX̃Gg̒l擾
		String retStr = null;
		CMIParameterPath param = new CMIParameterPath(name);
		String strDataModelName = param.popFirstElement();
		String strCategory = param.getNthElement(1);

		retStr = localGetValue(param.getPath());
		// 擾lԂ
		return retStr;
	}
	
	/**			
	 * AICCf[^PutParam ̃f[^Ƃď@ <br>		
	 * @param aiccData AICC f[^		
	 * @param response X|X		
	 * @return @int  HACPG[R[h		
	 */		
	public int doPutParam(String aiccData, StringBuffer response) {
		// f[^fp[^t@C̒l擾
		String strCharFilePath = m_CBT.getLocalValue("evaluation.parameter");
		if ( strCharFilePath != null ) {
			// p[^t@Cw肳ĂȂ΁Ãt@CAICCf[^
			// (㏑)ۑ
			writeToFile(aiccData, "evaluation.parameter", ".PRM", false);
		}
		// G[R[h()Ԃ
		return HACPError.HACP_ERR_SUCCESSFUL;
	}

	/**				
	* AICCf[^GetParam ̃f[^Ƃď@ <br>			
	* EvaluationData ɂ鏈͂Ȃ	
	* @param aiccData AICC f[^			
	* @param response X|X			
	* @return @int  HACPG[R[h			
	*/			
	public int doGetParam(String aiccData, StringBuffer response) {
		// G[R[h()Ԃ
		return HACPError.HACP_ERR_SUCCESSFUL;
	}
	
	/**		
	*  AICCf[^PutComments ̃f[^Ƃď@ <br>	
	* @param aiccData AICC f[^	
	* @param response X|X	
	* @return @int  HACPG[R[h	
	*/	
	public int doPutComments(String aiccData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(aiccData);
		CMITokenizer tokenizer = new CMITokenizer(aiccData, strLineDelimiter);
		String strLine = null;
		CMICsvRow titleLine = new CMICsvRow();
		CMICsvRow dataLine = new CMICsvRow();

		// AICCf[^PsAAICCf[^ԌJԂ
		for(int intLine = 0; tokenizer.hasMoreTokens();){	

			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgsȂ΁A̍s
			if (CMIUtil.isComment(strLine)) {
				continue;
			}
			if (intLine == 0) {
				// Jg擪sȂ΁AJgs^CgsƂ݂Ȃ
				titleLine.setCsvData(strLine);
			} else {
				// Jg擪słȂ΁AJgsf[^sƂ݂Ȃ
				dataLine.setCsvData(strLine);
				// f[^s̍ڐ擾
				int intCount = dataLine.getCount();	
				// evaluation.comments ̍ŐV̔zԍ擾
				String strSubPath = "evaluation.comments";
				CMINode objectives_Node = (CMINode)getNChild(strSubPath);
				int intNum = objectives_Node.getChildCount();

				String strTitle = null;
				String strValue = null;
				String strDate = null;
				String strTime = null;
				// f[^s̍ڐJԂ
				for (int i = 0; i < intCount; i++) {
					// ^CgsJgڂ̃^Cg擾
					strTitle = titleLine.getNthItem(i);
					strTitle = strTitle.toLowerCase();
					
					// f[^sJgڂ̃f[^擾
					strValue = dataLine.getNthItem(i);

					// f[^lf[^̏ꍇAݒȂƂĈ
					if ("".equals(strValue) == true){
						// ̃f[^ڂo
						continue;
					}

					// ^CgɑGg̃pX𐶐ÃGg
					// f[^Zbg
					//course_id
					if ("course_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".course_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					//student_id 
					else if ("student_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".student_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					} 
					//lesson_id
					else if ("lesson_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".lesson_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					//date
					else if ("date".equals(strTitle)) {
						strDate = strValue;
						strSubPath = String.valueOf(intNum) + ".date";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					//time
					else if ("time".equals(strTitle)) {
						strTime = strValue;
						strSubPath = String.valueOf(intNum) + ".time";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// SCORM1.3̓t`ɕϊ
					if ((strDate != null) && (strTime != null))
					{
						try {
							strValue = CMIS13ModelUtil.parseS13Date(strDate,strTime);
							strSubPath = String.valueOf(intNum) + ".date";
							objectives_Node.setLessonValue(strSubPath, strValue);
						}
						catch (S13LogFormatException ex) {
							setError(CMIError.ERR_ELEMENT_TYPE_MISMATCH);

							// x_[G[bZ[W쐬
							StringBuffer sbMsg = new StringBuffer();
							sbMsg.append("CMIEvaluationData.doPutComments");
							sbMsg.append("/");
							sbMsg.append(this.getPath() + "." + strSubPath);
							setVendorError(getVendorData(sbMsg.toString()));
							sbMsg.delete(0,sbMsg.length());
						}
						strTime = null;
						strDate = null;
					}
					//location
					else if ("location".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".location";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					//comment
					else if ("comment".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".content";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
				}
			}
			// Jgs̃JEgCNg
			intLine++;	
		}
		// AICCf[^Ot@Cɏo
		if (getError() == CMIError.ERR_NO_ERROR){
			intErrCode = getPutComments("",response);
			writeToFile(response.toString(), "evaluation.comments", ".CMT", false);
			response.delete(0,response.length());
		}

		// ԋpG[R[h𔻒肷
		// @G[R[h No Error(0) ̏ꍇ@@F      --> HACP_ERR_SUCCESSFUL(0)
		// @G[R[h No Error(0) ȊȌꍇFCMIG[ --> HACP_ERR_CMI(4)
		if (getError() != CMIError.ERR_NO_ERROR){
			intErrCode = HACPError.HACP_ERR_CMI;
		}
		return intErrCode;	
	}
	
	/**			
	*  AICCf[^PutInteractions ̃f[^Ƃď@ <br>		
	* @param aiccData AICC f[^		
	* @param response X|X		
	* @return @int  HACPG[R[h		
	*/
	public int doPutInteractions(String aiccData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(aiccData);
		CMITokenizer tokenizer = new CMITokenizer(aiccData, strLineDelimiter);
		String strLine = null;
		CMICsvRow titleLine = new CMICsvRow();
		CMICsvRow dataLine = new CMICsvRow();

		// AICCf[^PsAAICCf[^ԌJԂ
		for ( int intLine = 0; tokenizer.hasMoreTokens(); ) {

			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgsȂ΁A̍s
			if (CMIUtil.isComment(strLine)) {
				continue;
			}
			if (intLine == 0) {
				// Jg擪sȂ΁AJgs^CgsƂ݂Ȃ
				titleLine.setCsvData(strLine);
			} else {
				// Jg擪słȂ΁AJgsf[^sƂ݂Ȃ
				dataLine.setCsvData(strLine);
				// f[^s̍ڐ擾
				int intCount = dataLine.getCount();	
				// evaluation.interactions ̍ŐV̔zԍ擾
				String strSubPath = "interactions";
				CMINode objectives_Node = (CMINode)getNChild(strSubPath);
				int intNum = objectives_Node.getChildCount();

				String strTitle = null;
				String strValue = null;
				String strDate = null;
				String strTime = null;
				// f[^s̍ڐJԂ
				for (int i = 0; i < intCount; i++) {
					// ^CgsJgڂ̃^Cg擾
					strTitle = titleLine.getNthItem(i);
					strTitle = strTitle.toLowerCase();
					// f[^sJgڂ̃f[^擾
					strValue = dataLine.getNthItem(i);

					// f[^lf[^̏ꍇAݒȂƂĈ
					if ("".equals(strValue) == true){
						// ̃f[^ڂo
						continue;
					}

					// ^CgɑGg̃pX𐶐ÃGg
					// f[^Zbg
					// course_id
					if ("course_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".course_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					} 
					// student_id
					else if ("student_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".student_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// lesson_id
					else if ("lesson_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".lesson_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// date
					else if ("date".equals(strTitle)) {
						strDate = strValue;
						strSubPath = String.valueOf(intNum) + ".date";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// time
					else if ("time".equals(strTitle)) {
						strTime = strValue;
						strSubPath = String.valueOf(intNum) + ".time";
						objectives_Node.setLessonValue(strSubPath, strValue);
					} 
					// SCORM1.3̓t`ɕϊ
					if ((strDate != null) && (strTime != null))
					{
						try {
							strValue = CMIS13ModelUtil.parseS13Date(strDate,strTime);
							strSubPath = String.valueOf(intNum) + ".date";
							objectives_Node.setLessonValue(strSubPath, strValue);
						}
						catch (S13LogFormatException ex) {
							setError(CMIError.ERR_ELEMENT_TYPE_MISMATCH);

							// x_[G[bZ[W쐬
							StringBuffer sbMsg = new StringBuffer();
							sbMsg.append("CMIEvaluationData.doPutInteractions");
							sbMsg.append("/");
							sbMsg.append(this.getPath() + "." + strSubPath);
							setVendorError(getVendorData(sbMsg.toString()));
							sbMsg.delete(0,sbMsg.length());
						}
						strTime = null;
						strDate = null;
					}
					// interaction_id
					else if ("interaction_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// objective_id
					else if ("objective_id".equals(strTitle)) {
						CMITokenizer inner_tokenizer = 
													new CMITokenizer(strValue, ";");
						for(int j=0; inner_tokenizer.hasMoreTokens(); j++){
							String val;
							strSubPath = String.valueOf(intNum) + ".objectives." 
																+ String.valueOf(j) + ".id";
							val = inner_tokenizer.nextToken();
							objectives_Node.setLessonValue(strSubPath, val);
						}
					}
					// type_interaction
					else if ("type_interaction".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".type";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// correct_response
					else if ("correct_response".equals(strTitle)) {
						CMITokenizer inner_tokenizer = new CMITokenizer(strValue, ";");
						for(int j=0; inner_tokenizer.hasMoreTokens(); j++){
							String val;
							strSubPath = String.valueOf(intNum) + ".correct_responses." 
													+ String.valueOf(j) + ".pattern";
							val = inner_tokenizer.nextToken();
							objectives_Node.setLessonValue(strSubPath, val);
						}
					}
					// student_response
					else if ("student_response".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".student_response";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// result
					else if ("result".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".result";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// weighting
					else if ("weighting".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".weighting";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// latency
					else if ("latency".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".latency";
						try {
							strValue = CMIS13ModelUtil.parseS13Timespan(strValue);
						}
						catch (S13LogFormatException ex) {
							setError(CMIError.ERR_ELEMENT_TYPE_MISMATCH);
							// x_[G[bZ[W쐬
							StringBuffer sbMsg = new StringBuffer();
							sbMsg.append("CMIEvaluationData.doPutInteractions");
							sbMsg.append("/");
							sbMsg.append(this.getPath() + "." + strSubPath);
							setVendorError(getVendorData(sbMsg.toString()));
							sbMsg.delete(0,sbMsg.length());
						}
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
				}
			}
			// Jgs̃JEgCNg
			intLine++;	
		}
		if (getError() == CMIError.ERR_NO_ERROR){
			intErrCode = getPutInteractions("",response);
			// AICCf[^Ot@Cɏo(ǉ)
			writeToFile(response.toString(), "evaluation.interactions", ".INT", false);
			response.delete(0,response.length());
		}
		// ԋpG[R[h𔻒肷
		// @G[R[h No Error(0) ̏ꍇ@@F      --> HACP_ERR_SUCCESSFUL(0)
		// @G[R[h No Error(0) ȊȌꍇFCMIG[ --> HACP_ERR_CMI(4)
		if (getError() != CMIError.ERR_NO_ERROR){
			intErrCode = HACPError.HACP_ERR_CMI;
		}
		return intErrCode;	
	}
	
	/**				
	*  AICCf[^PutPerformance ̃f[^Ƃď@ <br>			
	* @param aiccData AICC f[^			
	* @param response X|X			
	* @return @int  HACPG[R[h			
	*/			
	public int doPutPerformance(String aiccData, StringBuffer response) {
		// AICCf[^Ot@Cɏo(ǉ)
		writeToFile(aiccData, "evaluation.performance", ".PFC", false);
		// G[R[h()Ԃ
		return HACPError.HACP_ERR_SUCCESSFUL;		
	}

	/**			
	*  AICCf[^PutPath ̃f[^Ƃď@ <br>		
	* @param aiccData AICC f[^		
	* @param response X|X		
	* @return @int  HACPG[R[h		
	*/		
	public int doPutPath(String aiccData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(aiccData);
		CMITokenizer tokenizer = new CMITokenizer(aiccData, strLineDelimiter);
		String strLine = null;
		CMICsvRow titleLine = new CMICsvRow();
		CMICsvRow dataLine = new CMICsvRow();

		// AICCf[^PsAAICCf[^ԌJԂ
		for(int intLine = 0; tokenizer.hasMoreTokens();){
			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgsȂ΁A̍s
			if (CMIUtil.isComment(strLine)) {
				continue;
			}
			if (intLine == 0) {
				// Jg擪sȂ΁AJgs^CgsƂ݂Ȃ
				titleLine.setCsvData(strLine);
			} else {
				// Jg擪słȂ΁AJgsf[^sƂ݂Ȃ
				dataLine.setCsvData(strLine);
				// f[^s̍ڐ擾
				int intCount = dataLine.getCount();
				// evaluation.objectives ŐV̔zԍ擾
				String strSubPath = "paths";
				CMINode objectives_Node = (CMINode)getNChild(strSubPath);
				int intNum = objectives_Node.getChildCount();

				String strTitle = null;
				String strValue = null;
				// f[^s̍ڐJԂ
				for (int i = 0; i < intCount; i++) {
					// ^CgsJgڂ̃^Cg擾
					strTitle = titleLine.getNthItem(i);
					// f[^sJgڂ̃f[^擾
					strValue = dataLine.getNthItem(i);		// f[^擾

					// ^CgɑGg̃pX𐶐ÃGg
					// f[^Zbg
					// course_id
					if ("course_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".course_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// student_id
					else if ("student_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".student_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// lesson_id
					else if ("lesson_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".lesson_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// date
					else if ("date".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".date";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// time
					else if ("time".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".time";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// element_location
					else if ("element_location".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".location_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// status
					else if ("status".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".status";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// why_left
					else if ("why_left".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".why_left";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// time_in_element
					else if ("time_in_element".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".time_in_element";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
				}
			}
			// Jgs̃JEgCNg
			intLine++;	
		}
		// AICCf[^Ot@Cɏo(ǉ)
		writeToFile(aiccData, "evaluation.path", ".PTH", true);
		// G[R[h()Ԃ
		return intErrCode;		
	}
	
	/**			
	*  AICCf[^PutObjectives ̃f[^Ƃď@ <br>		
	* @param aiccData AICC f[^		
	* @param response X|X		
	* @return @int  HACPG[R[h		
	*/		
	public int doPutObjectives(String aiccData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(aiccData);
		CMITokenizer tokenizer = new CMITokenizer(aiccData, strLineDelimiter);
		String strLine = null;
		CMICsvRow titleLine = new CMICsvRow();
		CMICsvRow dataLine = new CMICsvRow();

		// AICCf[^PsAAICCf[^ԌJԂ
		for(int intLine = 0; tokenizer.hasMoreTokens();){
			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgsȂ΁A̍s
			if (CMIUtil.isComment(strLine)) {
				continue;
			}
			if (intLine == 0) {
				// Jg擪sȂ΁AJgs^CgsƂ݂Ȃ
				titleLine.setCsvData(strLine);
			} else {
				// Jg擪słȂ΁AJgsf[^sƂ݂Ȃ
				dataLine.setCsvData(strLine);
				// f[^s̍ڐ擾
				int intCount = dataLine.getCount();

				// evaluation.objectives_status ŐV̔zԍ擾
				String strSubPath = "objectives_status";
				CMINode objectives_Node = (CMINode)getNChild(strSubPath);
				int intNum = objectives_Node.getChildCount();
				
				String strTitle = null;
				String strValue = null;
				// f[^s̍ڐJԂ
				for (int i = 0; i < intCount; i++) {
					// ^CgsJgڂ̃^Cg擾
					strTitle = titleLine.getNthItem(i);
					// f[^sJgڂ̃f[^擾
					// f[^擾
					strValue = dataLine.getNthItem(i);

					// ^CgɑGg̃pX𐶐ÃGg
					// f[^Zbg
					// course_id
					if ("course_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".course_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// student_id
					else if ("student_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".student_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// lesson_id
					else if ("lesson_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".lesson_id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// date
					else if ("date".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".date";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// time
					else if ("time".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".time";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// objective_id
					else if ("objective_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".id";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// score
					else if ("score".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".scores";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// status
					else if ("status".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".status";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
					// mastery_time
					else if ("mastery_time".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".mastery_time";
						objectives_Node.setLessonValue(strSubPath, strValue);
					}
				}
			}
			// Jgs̃JEgCNg
			intLine++;	
		}
		// AICCf[^Ot@Cɏo(ǉ)
		writeToFile(aiccData, "evaluation.objectives_status", ".OBJ", true);
		// G[R[h()Ԃ
		return intErrCode;		
	}
	
	/**			
	*  o̓f[^Ot@Cɏo@ <br>		
	* @param aiccData AICC f[^		
	* @param paramPath  o̓pX̃p[^		
	* @param ext  o̓t@C̊gq		
	* @param append  ǉ㏑̃XCb`		
	*/		
	private void writeToFile(String aiccData, String paramPath, 
										String ext, boolean append) {

		String strFilePath = null;
		//o̓f[^iRs[j
		String strOutData = null;
		
		String strLineDelimiter = null;
		int intDelimiterSize;
		
		// f[^f̃Ot@CGgl擾
		String charFilePath = m_CBT.getLocalValue(paramPath);

		if ( charFilePath != null && !"".equals(charFilePath)) {
			// l擾łȂ΁A̒lOt@C̃pXƂ
			strFilePath = charFilePath;
		}
		// filePath ̂Ƃ́Afile_pathgăt@C
		if (strFilePath == null) {
			// Ot@C̃pX擾łĂȂ t@CpX̒l琶
			// f[^f̃t@CpX Ggl擾
			charFilePath = m_CBT.getLocalValue("evaluation.file_path");
			if (charFilePath != null) {
				// l擾łȂ΁A̒lOt@C̃pXƂ
				strFilePath = charFilePath;
			}
			if (strFilePath == null || "".equals(strFilePath)) {
				// Ot@C̃pX擾łĂȂ΁AuNpXƂ
			}
			// Ot@C̃pXɃGNXeVt
			strFilePath += ext;
		}

		// AICCf[^̍sf~^擾
		strLineDelimiter = CMIUtil.checkLineDelimiter(aiccData);
		intDelimiterSize = strLineDelimiter.length();
		// t@CpX̃t@CI[v			
		File logFile = new File(strFilePath);
		try {
			synchronized(this) {
				if ( append ) {
					// ǉ^Cṽf[^Ȃ΁At@C̗Lɂ킹ď
					boolean blnCanWrite = logFile.canWrite();
					if  ( blnCanWrite ) {
						// łɃt@C݂Ȃ΁A擪śAo͂A
						// f[^ۑ
						int head = aiccData.indexOf(strLineDelimiter);
						if (head != -1) {
							strOutData = aiccData.substring(head + intDelimiterSize);
						} else {
							strOutData = aiccData;
						}
					} else {
						strOutData = aiccData;
					}
				}
				else {
					// ǉ^Cṽf[^łȂ΁Af[^ŏ㏑
					strOutData = aiccData;
				}
				// t@CpX̃fBNg𐶐
				makeDirectories(strFilePath);			

				BufferedWriter bw = new BufferedWriter(new FileWriter(logFile, append));
				// t@CI[vłȂ΁Af[^t@Cɏo
				bw.write(strOutData, 0, strOutData.length());
				// ŌオsłȂ΁Aso
				String last2 = "";
				if (strOutData.length() >= intDelimiterSize) {
					last2 = strOutData.substring(strOutData.length() - intDelimiterSize);
				}
				if (!last2.equals(strLineDelimiter)) {
					bw.write(strLineDelimiter, 0, strLineDelimiter.length());
				}
				// t@CN[Y
				bw.flush();
				bw.close();
			}
		} catch (IOException ioe) {
			ioe.printStackTrace();
		}	
	}

	/**						
	*  fBNg쐬@ <br>					
	* @param path pX					
	*/					
	private void makeDirectories(String path) {
		
		String strFilePath = null;
		String strFile = null;
		int lastSeparator = path.lastIndexOf(File.separator);
		if (lastSeparator != -1) {				
			strFilePath = path.substring(0, lastSeparator);
			strFile = path.substring(lastSeparator + 1);
		} else {
			strFile = path;
		}
		
		try{
			if (strFilePath != null) {
				File dirs = new File(strFilePath);
				if (!dirs.exists()){
					if ( !dirs.mkdirs() ) {

					}
				}
			}
			 
			if ( strFile != null && !"".equals(strFile) ) {
				File nfile = new File(path);
				if ( !nfile.exists() ) {
					if ( !nfile.createNewFile() ) {

					}
				}
			}
		} catch ( SecurityException se ) {

		} catch ( IOException se ) {

		}
	}

	/**			
	 * w肳ꂽp[^Oo͗pHACPtH[}bgSCORM1.3f[^Oo͂B<br>
	 * @param scoData String SCORM1.3 f[^		
	 * @param response StringBuffer f[^igp I/Fʉ̂ߎj
	 * @return @int  HACPG[R[h
	 */		
	public int doPutParamToS13(String scoData, StringBuffer response) {
		// f[^fp[^t@C̒l擾
		String strCharFilePath = m_CBT.getLocalValue("evaluation.parameter");
		if ( strCharFilePath != null ) {
			// p[^t@Cw肳ĂȂ΁Ãt@CSCORM1.3
			// f[^(㏑)ۑ
			writeToFile(scoData, "evaluation.parameter", ".prm", false);
		}
		// G[R[h()Ԃ
		return HACPError.HACP_ERR_SUCCESSFUL;		
	}

	/**
	 * PutCommentsR}hŎMHACPtH[}bgSCORM1.3f[^
	 * ۊǂBɕۊǌA̕ۊǃf[^oOo͂B<br>
	 * @param scoData SCORM1.3 f[^	
	 * @param response f[^igp I/Fʉ̂ߎj
	 * @return @int  HACPG[R[h	
	 */	
	public int doPutCommentsToS13(String scoData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(scoData);
		CMITokenizer tokenizer = new CMITokenizer(scoData, strLineDelimiter);
		String strLine = null;
		CMICsvRow titleLine = new CMICsvRow();
		CMICsvRow dataLine = new CMICsvRow();

		// SCORM1.3f[^PsAAICCf[^ԌJԂ
		for(int intLine = 0; tokenizer.hasMoreTokens();){	

			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgsȂ΁A̍s
			if (CMIUtil.isComment(strLine)) {
				continue;
			}
			if (intLine == 0) {
				// Jg擪sȂ΁AJgs^CgsƂ݂Ȃ
				titleLine.setCsvData(strLine);
			} else {
				// Jg擪słȂ΁AJgsf[^sƂ݂Ȃ
				dataLine.setCsvData(strLine);
				// f[^s̍ڐ擾
				int intCount = dataLine.getCount();	
				// evaluation.comments ̍ŐV̔zԍ擾
				String strSubPath = "evaluation.comments";
				CMINode comments_Node = (CMINode)getNChild(strSubPath);
				int intNum = comments_Node.getChildCount();

				String strTitle = null;
				String strValue = null;
				// f[^s̍ڐJԂ
				for (int i = 0; i < intCount; i++) {
					// ^CgsJgڂ̃^Cg擾
					strTitle = titleLine.getNthItem(i);
					strTitle = strTitle.toLowerCase();
					// f[^sJgڂ̃f[^擾
					strValue = dataLine.getNthItem(i);

					// f[^lUTF-8URLfR[hAۊǂ
					strValue = CMIUtil.urlDecode(strValue);

					// ^CgɑGg̃pX𐶐ÃGg
					// f[^Zbg
					//date
					if ("date".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".date";
						comments_Node.setLessonValue(strSubPath, strValue);
					}
					//location
					else if ("location".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".location";
						comments_Node.setLessonValue(strSubPath, strValue);
					}
					//comment
					else if ("comment".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".content";
						comments_Node.setLessonValue(strSubPath, strValue);
					}
				}
			}
			// Jgs̃JEgCNg
			intLine++;	
		}
		intErrCode = getPutComments("",response);
		if (intErrCode == HACPError.HACP_ERR_SUCCESSFUL) {
			// SCORM1.3f[^Ot@Cɏo(ǉ)
			scoData = response.toString();
			response.delete(0,response.length());
			writeToFile(scoData, "evaluation.comments", ".cmt", false);
		}
		// G[R[h()Ԃ
		return intErrCode;	
	}
	
	/**			
	 * PutInteractionsR}hŎMHACPtH[}bgSCORM1.3f[^
	 * ֕ۊǂBɕۊǌA̕ۊǃf[^o
	 * Oo͂B<br>
	 * @param scoData SCORM1.3 f[^
	 * @param response X|Xigp I/Fʉ̂߂ɒ`j
	 * @return @int  HACPG[R[h		
	 */
	public int doPutInteractionsToS13(String scoData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;
		String strLineDelimiter = CMIUtil.checkLineDelimiter(scoData);
		CMITokenizer tokenizer = new CMITokenizer(scoData, strLineDelimiter);
		String strLine = null;
		CMICsvRow titleLine = new CMICsvRow();
		CMICsvRow dataLine = new CMICsvRow();

		// SCORM1.3f[^PsASCORM1.3f[^ԌJԂ
		for ( int intLine = 0; tokenizer.hasMoreTokens(); ) {

			// Jgs擾
			strLine = tokenizer.nextToken();
			// JgsRgsȂ΁A̍s
			if (CMIUtil.isComment(strLine)) {
				continue;
			}
			if (intLine == 0) {
				// Jg擪sȂ΁AJgs^CgsƂ݂Ȃ
				titleLine.setCsvData(strLine);
			} else {
				// Jg擪słȂ΁AJgsf[^sƂ݂Ȃ
				dataLine.setCsvData(strLine);
				// f[^s̍ڐ擾
				int intCount = dataLine.getCount();	
				// evaluation.interactions ̍ŐV̔zԍ擾
				String strSubPath = "evaluation.interactions";
				CMINode interactions_Node = (CMINode)getNChild(strSubPath);
				int intNum = interactions_Node.getChildCount();

				String strTitle = null;
				String strValue = null;
				// f[^s̍ڐJԂ
				for (int i = 0; i < intCount; i++) {
					// ^CgsJgڂ̃^Cg擾
					strTitle = titleLine.getNthItem(i);
					strTitle = strTitle.toLowerCase();
					// f[^sJgڂ̃f[^擾
					strValue = dataLine.getNthItem(i);

					// f[^lUTF-8URLfR[hAۊǂ
					strValue = CMIUtil.urlDecode(strValue);

					// ^CgɑGg̃pX𐶐ÃGg
					// f[^Zbg
					// date
					if ("date".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".date";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// interaction_id
					else if ("interaction_id".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".id";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// objective_id
					else if ("objective_id".equals(strTitle)) {
						CMITokenizer inner_tokenizer = 
													new CMITokenizer(strValue, ";");
						for(int j=0; inner_tokenizer.hasMoreTokens(); j++){
							String val;
							strSubPath = String.valueOf(intNum) + ".objectives." 
																+ String.valueOf(j) + ".id";
							val = inner_tokenizer.nextToken();
							interactions_Node.setLessonValue(strSubPath, val);
						}
					}
					// type_interaction
					else if ("type_interaction".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".type";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// correct_response
					else if ("correct_response".equals(strTitle)) {
						CMITokenizer inner_tokenizer = new CMITokenizer(strValue, ";");
						for(int j=0; inner_tokenizer.hasMoreTokens(); j++){
							String val;
							strSubPath = String.valueOf(intNum) + ".correct_responses." 
													+ String.valueOf(j) + ".pattern";
							val = inner_tokenizer.nextToken();
							interactions_Node.setLessonValue(strSubPath, val);
						}
					}
					// student_response
					else if ("student_response".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".student_response";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// result
					else if ("result".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".result";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// weighting
					else if ("weighting".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".weighting";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// latency
					else if ("latency".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".latency";


						interactions_Node.setLessonValue(strSubPath, strValue);
					}
					// description
					else if ("description".equals(strTitle)) {
						strSubPath = String.valueOf(intNum) + ".description";
						interactions_Node.setLessonValue(strSubPath, strValue);
					}
				}
			}
			// Jgs̃JEgCNg
			intLine++;	
		}
		intErrCode = getPutInteractions("",response);
		if (intErrCode == HACPError.HACP_ERR_SUCCESSFUL) {
			scoData = response.toString();
			response.delete(0,response.length());
			writeToFile(scoData, "evaluation.interactions", ".int", false);
		}
		// G[R[h()Ԃ
		return intErrCode;	
	}

	/**
	 * ֕ێĂPutCommentsR}hŎMHACPtH[}bg
	 * SCORM1.3f[^擾B<br>
	 * @param scoData String SCORM1.3 f[^
	 * @param response String 擾Comments from Learnerf[^
	 * @return @int  HACPG[R[h	
	 */	
	private int getPutComments(String scoData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;

		//	"cmi.comments_from_learner"
		String strSubPath = "evaluation.comments";
		CMINode comments_Node = (CMINode)getNChild(strSubPath);

		// Comment from Learnerf[^̌擾
		//	"comments_from_learner._count"
		int intNum = comments_Node.getChildCount();

		// ^Cgs쐬
		String strTitleLine = "\"Date\",\"Location\",\"Comment\"";
		strTitleLine = strTitleLine + CMIElement.STR_CRLF;
		response.append(strTitleLine);

		// SCORM1.3Commentf[^PsAAICCf[^tH[}bg쐬
		for(int i = 0; i < intNum; i++){

			String strValue = null;

			// ^CgɑGg̃pX𐶐ÃGg
			// f[^Zbg
			//date
			strSubPath = String.valueOf(i) + ".date";
			strValue = comments_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\",");
	
			//location
			strSubPath = String.valueOf(i) + ".location";
			strValue = comments_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\",");
	
			//comment
			strSubPath = String.valueOf(i) + ".content";
			strValue = comments_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\"" + CMIElement.STR_CRLF);
		}
		// G[R[h()Ԃ
		return intErrCode;	
	}

	/**
	 * ֕ێĂPutInteractionsR}hŎMHACP
	 * tH[}bgSCORM1.3f[^擾B<br>
	 * @param scoData String SCORM1.3 f[^
	 * @param response String 擾interactionsf[^
	 * @return @int  HACPG[R[h	
	 */	
	private int getPutInteractions(String scoData, StringBuffer response) {
		
		int intErrCode = HACPError.HACP_ERR_SUCCESSFUL;

		//	"cmi.interactions"
		String strSubPath = "evaluation.interactions";
		CMINode interactions_Node = (CMINode)getNChild(strSubPath);

		// Interactionsf[^̌擾
		//	"cmi.interactions._count"
		int intNum = interactions_Node.getChildCount();

		// ^Cgs쐬
		String strTitleLine = "\"Date\",\"Interaction_ID\",\"Objective_ID\",";
		strTitleLine = strTitleLine + "\"Type_Interaction\",";
		strTitleLine = strTitleLine + "\"Correct_Response\",";
		strTitleLine = strTitleLine + "\"Student_Response\",";
		strTitleLine = strTitleLine + "\"Result\",\"Weighting\",";
		strTitleLine = strTitleLine + "\"Latency\",\"Description\"";
		strTitleLine = strTitleLine + CMIElement.STR_CRLF;
		response.append(strTitleLine);

		// SCORM1.3Interactionsf[^PsAAICCf[^tH[}bg쐬
		for(int i = 0; i < intNum; i++){

			String strValue = null;

			// C^NVɊY^CgɑGg̃pX𐶐ÃGg
			// f[^Zbg
			//timestamp
			strSubPath = String.valueOf(i) + ".date";
			strValue = interactions_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\",");

			//interaction_id
			strSubPath = String.valueOf(i) + ".id";
			strValue = interactions_Node.getLessonValue(strSubPath);
			response.append("\"" + strValue + "\",");

			//cmi.interactions.n.objectives
			strSubPath = String.valueOf(i) + ".objectives";
			CMINode objectives_Node = (CMINode)interactions_Node.getNChild(strSubPath);
	
			// ObjectivesIDf[^̌擾
			//	"cmi.interactions.n.objectives._count"
			int intNum2 = objectives_Node.getChildCount();
			// ObjectivesIDPAAICCf[^tH[}bg쐬
			response.append("\"");
			for(int j = 0; j < intNum2; j++){
				
				//objective_id
				strSubPath = String.valueOf(j) + ".id";
				strValue = objectives_Node.getLessonValue(strSubPath);
				if (strValue == null) {
					strValue = "";
				}
				// R[hUTF-8ɃGR[h
				strValue = CMIUtil.urlEncode(strValue);
				response.append(strValue + CMIUtil.urlEncode(";"));
			}
			response.append("\",");

			//type_interaction
			strSubPath = String.valueOf(i) + ".type";
			strValue = interactions_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\",");
	
			//cmi.interactions.n.correct_responses
			strSubPath = String.valueOf(i) + ".correct_responses";
			CMINode correct_Node = (CMINode)interactions_Node.getNChild(strSubPath);
	
			// Correct_Responsef[^̌擾
			//	"cmi.interactions.n.correct_responses._count"
			intNum2 = correct_Node.getChildCount();
			// Correct_ResponsePAAICCf[^tH[}bg쐬
			response.append("\"");
			for(int j = 0; j < intNum2; j++){
				
				//correct_response
				strSubPath = String.valueOf(j) + ".pattern";
				strValue = correct_Node.getLessonValue(strSubPath);
				if (strValue == null) {
					strValue = "";
				}
				// R[hUTF-8ɃGR[h
				strValue = CMIUtil.urlEncode(strValue);
				response.append(strValue + CMIUtil.urlEncode(";"));
	
			}
			response.append("\",");
	
			strSubPath = String.valueOf(i) + ".student_response";
			strValue = interactions_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\",");
	
			strSubPath = String.valueOf(i) + ".result";
			strValue = interactions_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\",");
	
			strSubPath = String.valueOf(i) + ".weighting";
			strValue = interactions_Node.getLessonValue(strSubPath);
			response.append("\"" + strValue + "\",");
	
			strSubPath = String.valueOf(i) + ".latency";
			strValue = interactions_Node.getLessonValue(strSubPath);
			response.append("\"" + strValue + "\",");
	
			strSubPath = String.valueOf(i) + ".description";
			strValue = interactions_Node.getLessonValue(strSubPath);
			if (strValue == null) {
				strValue = "";
			}
			// R[hUTF-8ɃGR[h
			strValue = CMIUtil.urlEncode(strValue);
			response.append("\"" + strValue + "\"" + CMIElement.STR_CRLF);
		}
		// G[R[h()Ԃ
		return intErrCode;	
	}

}