/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ONX
//			ύX
//				2004.01.08	VK쐬	؁@qq
//
package jp.co.ntt.lms.Common.status.prerequisite;

import java.util.Vector;

import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Lo.LoClient;

/**
 * ONXłB<BR>
 * @author T.Suzuki
 * @version 0.0.0.1
 */
public class Prerequisite implements PrerequisiteMessage{

	// CX^Xϐ
	/** Oێ܂ */
	private String mstrPrerequisite;
	/** [UIDێ܂ */
	private String mstrUserID;
	/** LOIDێ܂ */
	private String mstrLoID;
	/** f[^ANZXIuWFNgێ܂B*/
	private DataAccess mobjDataAccess;
	/** p[Xʂێ܂ */
	private DecidePrerequisite objDecide = null;

	// RXgN^
	/**
	 * Ow肵܂B<BR>
	 * O̍\`FbN݂̂sꍇ͂̃RXgN^ĂłB
	 * @param strPrerequisite O
	 */
	public Prerequisite( String strPrerequisite ) {
		mstrPrerequisite = strPrerequisite;
	}

	/**
	 * OсALOIDw肵܂B<BR>
	 * O̍\`FbNсALOID`FbNsꍇ͂̃RXgN^ĂłB
	 * @param strPrerequisite O
	 * @param strLoID LOID
	 */
	public Prerequisite( String strPrerequisite, String strLoID ) {
		mstrPrerequisite = strPrerequisite;
		mstrLoID = strLoID;
	}

	/**
	 * OA[UIDALOIDw肵܂B<BR>
	 * p[XsāAO𖞂Ă邩`FbNꍇ͂̃RXgN^ĂłB
	 * @param strPrerequisite O
	 * @param strUserID [UID
	 * @param strLoID LOID
	 */
	public Prerequisite( String strPrerequisite, String strUserID, String strLoID ) {
		mstrPrerequisite = strPrerequisite;
		mstrUserID = strUserID;
		mstrLoID = strLoID;
	}

	/**
	 * OA[UIDALOIDw肵܂B<BR>
	 * p[XsāAO𖞂Ă邩`FbNꍇ͂̃RXgN^ĂłB
	 * @param strPrerequisite O
	 * @param strUserID [UID
	 * @param strLoID LOID
	 * @param objDataAccess f[^ANZXIuWFNg
	 */
	public Prerequisite( String strPrerequisite, String strUserID, String strLoID, DataAccess objDataAccess ) {
		mstrPrerequisite = strPrerequisite;
		mstrUserID = strUserID;
		mstrLoID = strLoID;
		mobjDataAccess = objDataAccess;
	}

	// O\bh
	/**
	 * O͂܂B
	 * @exception PrerequisiteParseException O̍\Ɍ肪ꍇ
	 * @exception PrerequisiteException ͒ɎsOꍇ
	 */
	public void parse()
		throws PrerequisiteParseException,PrerequisiteException
	{
		if ( mstrPrerequisite == null || mstrPrerequisite.equals("") ){
			throw new PrerequisiteParseException( PrerequisiteEnv.getMessage( INPUT_EMPTY_ERR ) );
		}
		PrerequisiteData objCd = new PrerequisiteData( mstrPrerequisite, mstrUserID, mobjDataAccess );
		PrerequisiteNode objCn = new PrerequisiteNode( objCd );
		objCn.parse();
		objDecide = (DecidePrerequisite)objCn;
	}

	/**
	 * ȎÓ`FbNs܂B<BR>
	 * ȉ̂悤ȃ`FbNs肪ꍇ́APrerequisiteParseExceptionX[܂B<BR>
	 * <PRE>
	 *       @@\`FbN@\łĂ邩`FbN
	 *       A@LOID`FbN@RXgN^ŁALOIDw肳ĂꍇA
	 *                         w肳ꂽLOIDLOe[uɑ݂邱Ƃ`FbN܂B
	 * </PRE>
	 * @exception PrerequisiteParseException O̍\Ɍ肪ꍇ
	 * @exception PrerequisiteException ͒ɎsOꍇ
	 */
	public void check(boolean bInsMode)
		throws PrerequisiteParseException,PrerequisiteException
	{
		try
		{
			if ( mstrPrerequisite == null || mstrPrerequisite.equals("") ){
				throw new PrerequisiteParseException( PrerequisiteEnv.getMessage( INPUT_EMPTY_ERR ) );
			}
			PrerequisiteData objCd = new PrerequisiteData( mstrPrerequisite, mstrUserID, mobjDataAccess );
			PrerequisiteNode objCn = new PrerequisiteNode( objCd );
			objCn.parse();
			objDecide = (DecidePrerequisite)objCn;

			//LOID`FbN
			if ( mstrLoID != null ){
				Vector vecPrerequisite = objDecide.getLoIDList();
				if ( vecPrerequisite.size() == 0 ){
					throw new PrerequisiteParseException( PrerequisiteEnv.getMessage( LOID_LIST_NONE ) );
				}
				// OɎw肳ĂLOIDLOe[uɑ݂邩`FbNB
				boolean boolCheck = checkLOID( vecPrerequisite );
				if ( !boolCheck ){
					DebugLog.write( this.getClass(), vecPrerequisite, DebugLog.ROW );
					throw new PrerequisiteParseException( PrerequisiteEnv.getMessage( LOID_CHECK_ERR ) );
				}
			}
		}
		catch( PrerequisiteParseException pe)
		{
			DebugLog.write( this.getClass(), pe, DebugLog.ROW );
			throw pe;
		}
		catch( PrerequisiteException ce)
		{
			DebugLog.write( this.getClass(), ce, DebugLog.ROW );
			throw ce;
		}
	}

	/**
	 * O𖞂Ă邩Ԃ܂B
	 * @return boolean true: Ă false: ĂȂ
	 * @exception PrerequisiteException Op[XĂȂƂȂ
	 */
	public boolean isPrerequisited()
		throws PrerequisiteException
	{
		mobjDataAccess = new DataAccess();
		return objDecide.isPrerequisited();
	}

	/**
	 * OŎgpĂLOID̈ꗗ擾܂
	 * @return String[] LOIDꗗ
	 * @exception PrerequisiteParseException O̍\Ɍ肪ꍇ
	 * @exception PrerequisiteException ͒ɎsOꍇ
	 */
	public String[] getLoIDList()
		throws PrerequisiteParseException,PrerequisiteException
	{
		if ( objDecide == null ){
			parse();
		}
		Vector vecTemp = objDecide.getLoIDList();
		if ( vecTemp.size() == 0 ){
			return new String[0];
		}
		else{
			String[] result = new String[vecTemp.size()];
			vecTemp.copyInto( result );
			return result;
		}
	}

	/**
	 * OɎw肳ꂽLOIDgpĂ邩ǂ𒲂ׂ܂B
	 * @param strLoID rΏLOID
	 * @return boolean true:gpĂ false: gpĂȂ
	 * @exception PrerequisiteParseException O̍\Ɍ肪ꍇ
	 * @exception PrerequisiteException ͒ɎsOꍇ
	 */
	public boolean isUsedLoID( String strLoID )
		throws PrerequisiteParseException,PrerequisiteException
	{
		if ( objDecide == null ){
			parse();
		}
		Vector vecTemp = objDecide.getLoIDList();
		return vecTemp.contains( strLoID );
	}



	/**
	 * LOIDeLOID擾郁\bhłB
	 * @exception PrerequisiteException `O
	 */
	private String getParentID(String strLoID)
		throws PrerequisiteException
	{
		String strParentID = null;
		try {
			LoRelationClient objLoRelation = new LoRelationClient();
			// ɎqLOIDw肵܂
			objLoRelation.setWhereChildID( strLoID );
			// 
			if( !objLoRelation.select() ) {
				// Ɏsꍇ
				throw new PrerequisiteException( objLoRelation.getMessage() );
			}

			// ʂ擾
			if( objLoRelation.next() ) {
				strParentID = objLoRelation.getParentID();
			}
		}
		catch(PrerequisiteException pe) {
			throw pe;
		}
		catch(Exception ex) {
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			throw new PrerequisiteException(ex.getMessage());
		}
		return strParentID;
	}

	/**
	 * w肳ꂽLOIDLOe[uɑ݂邩`FbN܂B
	 * @param vecPrereList LOID
	 * @return Vector qIDXg
	 * @exception PrerequisiteException `O
	 */
	private boolean checkLOID(Vector vecPrereList)
		throws PrerequisiteException
	{
		Vector vecChildList = new Vector();
		try {
			LoClient objLo = new LoClient();
			for(int i=0;i<vecPrereList.size();i++){
				// LOIDw肵܂
				objLo.clear();
				objLo.setWhereLoID( (String)vecPrereList.get(i) );
				// 
				if( !objLo.select() ) {
					// Ɏsꍇ
					throw new PrerequisiteException( objLo.getMessage() );
				}
				// LOID̃R[h݂Ȃꍇ
				if( !objLo.next() ){
					return false;
				}
			}
		}
		catch(PrerequisiteException pe) {
			throw pe;
		}
		catch(Exception ex) {
			DebugLog.write( this.getClass(), ex, DebugLog.HIGHT );
			throw new PrerequisiteException(ex.getMessage());
		}
		return true;
	}

}


