/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormMenuMaker
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;

import java.util.Hashtable;
import java.util.Vector;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.lo.LoPropertyDef;
import jp.co.ntt.lms.lo.MenuMaker;
import jp.co.ntt.lms.xmo.MenuData;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * SCORM LOj[쐬NXB
 *
 * @author T.Nishiki
 */
public class ScormMenuMaker implements MenuMaker {

	/**
	 * SCORMLOpj[𐶐܂B<br>
	 * @param params p[^B<br>
	 * ݒ肵ĂׂĺAQƂ郁\bhQlɂĂB
	 * @return j[ڏzB
	 * @throws LOException ɗOꍇB
	 * @see jp.co.ntt.lms.lo.MenuMaker#makeMenu(java.util.Hashtable)
	 * @see jp.co.ntt.lms.lo.LoEnvironment#getStartLearnServletURL(Hashtable)
	 * @see ScormLoEnv#getLoLogURL(Hashtable)
	 * @see ScormLoEnv#getIndividualLogMenuURL(Hashtable)
	 * @see ScormLoEnv#getInsertMenuURL(Hashtable)
	 * @see ScormLoEnv#getUpdateMenuURL(Hashtable)
	 * @see ScormLoEnv#getDeleteMenuURL(Hashtable)
	 */
	public MenuData[] makeMenu(Hashtable params) throws LOException {

		MenuData[] menuDatum = null;
		try {

			Vector menuDataVector = new Vector();

			// wKJnj[
			if (isAbleToStartLearn(params) == true) {
				menuDataVector.add(makeStartLearnMenu(params));
			}
			if (isAbleToBrowseLog(params) == true) {
				// wKOj[ݒ
				menuDataVector.add(makeLoLogMenu(params));
				menuDataVector.add(makeIndividualLogMenu(params));
			}

			// ZbgAbvj[̑gݗ
			String setUp = (String) params.get(LoPropertyDef.SETUP_STATUS);
			if (setUp != null) {
				if (setUp.equals(LoPropertyDef.SETUP_INSERT)) {
					// o^j[ݒ
					menuDataVector.add(makeInsertMenu(params));
				}
				else if (setUp.equals(LoPropertyDef.SETUP_UPDATE)) {
					// XVj[ݒ
					menuDataVector.add(makeUpdateMenu(params));
				}
				else if (setUp.equals(LoPropertyDef.SETUP_DELETE)) {
					// 폜j[ݒ
					menuDataVector.add(makeDeleteMenu(params));
				}
			}

			// Vectorj[f[^z^ɕϊ
			menuDatum = new MenuData[menuDataVector.size()];
			menuDataVector.copyInto(menuDatum);

		}
		catch (LOException e) {
			throw e;
		}

		return menuDatum;
	}

	/**
	 * j[ځuwKJnv̏𐶐܂B
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.REAL_LOID</td>
	 * 		<td>wK鋳ނRealLOID</td>
	 * 	</tr>
	 * </table><br><br>
	 * @return j[ځuwKJnv̏B
	 * @throws LOException 擾ɗOꍇB
	 * @see jp.co.ntt.lms.lo.LoEnvironment#getStartLearnServletURL(Hashtable)
	 */
	private MenuData makeStartLearnMenu(Hashtable params) throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeStartLearnMenu(" + params + ")",
			DebugLog.ROW);
		////////////////////////////////////////////////////////////////////////
		// p[^ǉ
		// =====================================================================
		// ނ̏擾Ap[^ɒǉB
		putLoInfo(params);
		// ZbVID̐ݒiRealLOIDZbVIDj
		String loID = null;
		loID = (String) params.get(LoPropertyDef.REAL_LOID);
		if (loID != null) {
			params.put(LoPropertyDef.SESSIONID, loID);
		}
		////////////////////////////////////////////////////////////////////////
		// ݒt@CAwKJnURL擾Aj[ڂ𐶐B
		ScormLoEnv scormEnv = new ScormLoEnv();
		String learnURL = scormEnv.getStartLearnServletURL(params);
		MenuData menuData =
			new MenuData(
				learnURL,
				ScormLoConstant.MENU_LABEL_START_LEARN,
				MenuData.DEFAULT_MENU,
				MenuData.STUDENT_MENU);
		//EDIT START wKEBhEwOpen悤ɕύX܂ 2006/3/9 NTT-R MNM 
		//menuData.setTargetWindow(ScormLoConstant.WINDOW_TARGET_BLANK);	// EBhE\@ʃEBhEɐݒ肵܂B
		menuData.setTargetWindow(ScormLoConstant.WINDOW_TARGET_LEARN);
		// EDIT END 2006/3/9 NTT-R MNM
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeStartLearnMenu(" + params + ")" + " return " + menuData,
			DebugLog.ROW);
		return menuData;
	}

	/**
	 * j[ځuwKOv̏𐶐܂B
	 * @param params p[^B<br>
	 * @return j[ځuwKOv̏B
	 * @throws LOException 擾ɗOꍇB
	 * @see ScormLoEnv#getLoLogURL(Hashtable)
	 */
	private MenuData makeLoLogMenu(Hashtable params) throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeLoLogMenu(" + params + ")",
			DebugLog.ROW);
		////////////////////////////////////////////////////////////////////////
		// ݒt@CAʃOURL擾Aj[ڂ𐶐B
		ScormLoEnv scormEnv = new ScormLoEnv();
		String logMenuURL = scormEnv.getLoLogURL(params);
		MenuData menuData =
			new MenuData(
				logMenuURL,
				ScormLoConstant.MENU_LABEL_LO_LOG,
				MenuData.DEFAULT_MENU,
				MenuData.ALL_MENU);
		// EBhE\@ʃEBhEɐݒ肵܂B
		menuData.setTargetWindow(ScormLoConstant.WINDOW_TARGET_BLANK);
		
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeLoLogMenu(" + params + ")" + " return " + menuData,
			DebugLog.ROW);
		return menuData;
	}

	/**
	 * j[ځuʃOv̏𐶐܂B
	 * @param params p[^B<br>
	 * @return j[ځuʃOv̏B
	 * @throws LOException 擾ɗOꍇB
	 * @see ScormLoEnv#getIndividualLogMenuURL(Hashtable)
	 */
	private MenuData makeIndividualLogMenu(Hashtable params)
		throws LOException {
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeIndividualLogMenu(" + params + ")",
			DebugLog.ROW);

		// ݒt@CAʃOURL擾Aj[ڂ𐶐B
		ScormLoEnv scormEnv = new ScormLoEnv();
		String logMenuURL = scormEnv.getIndividualLogMenuURL(params);
		MenuData menuData =
			new MenuData(
				logMenuURL,
				ScormLoConstant.MENU_LABEL_INDIVIDUAL_LOG,
				MenuData.DEFAULT_MENU,
				MenuData.ALL_MENU);

		// EBhE\@ʃEBhEɐݒ肵܂B
		menuData.setTargetWindow(ScormLoConstant.WINDOW_TARGET_BLANK);

		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeIndividualLogMenu("
				+ params
				+ ")"
				+ " return "
				+ menuData,
			DebugLog.ROW);
		return menuData;
	}

	/**
	 * j[ځuLOo^v̏𐶐܂B
	 * @param params p[^B
	 * @return j[ځuLOo^v̏B
	 * @throws LOException 擾ɗOꍇB
	 * @see ScormLoEnv#getInsertMenuURL(Hashtable)
	 */
	private MenuData makeInsertMenu(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeInsertMenu(" + params + ")",
			DebugLog.ROW);

		// ݒt@CALOXVURL擾Aj[ڂ𐶐B
		ScormLoEnv scormEnv = new ScormLoEnv();
		String insertMenuURL = scormEnv.getInsertMenuURL(params);
		MenuData menuData =
			new MenuData(
				insertMenuURL,
				ScormLoConstant.MENU_LABEL_LO_INSERT,
				MenuData.INSERT_MENU,
				MenuData.INSTRUCTOR_MENU);

		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeInsertMenu(" + params + ")" + " return " + menuData,
			DebugLog.ROW);
		return menuData;
	}

	/**
	 * j[ځuLOXVv̏𐶐܂B
	 * @param params p[^B
	 * @return j[ځuLOXVv̏B
	 * @throws LOException 擾ɗOꍇB
	 * @see ScormLoEnv#getUpdateMenuURL(Hashtable)
	 */
	private MenuData makeUpdateMenu(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeUpdateMenu(" + params + ")",
			DebugLog.ROW);

		// ݒt@CALOXVURL擾Aj[ڂ𐶐B
		ScormLoEnv scormEnv = new ScormLoEnv();
		String updateMenuURL = scormEnv.getUpdateMenuURL(params);
		MenuData menuData =
			new MenuData(
				updateMenuURL,
				ScormLoConstant.MENU_LABEL_LO_UPDATE,
				MenuData.UPDATE_MENU,
				MenuData.INSTRUCTOR_MENU);

		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeUpdateMenu(" + params + ")" + " return " + menuData,
			DebugLog.ROW);
		return menuData;
	}

	/**
	 * j[ځuLO폜v̏𐶐܂B
	 * @param params p[^igpjB
	 * @return j[ځuLO폜v̏B
	 * @throws LOException 擾ɗOꍇB
	 * @see ScormLoEnv#getDeleteMenuURL(Hashtable)
	 */
	private MenuData makeDeleteMenu(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD makeDeleteMenu(" + params + ")",
			DebugLog.ROW);
		// ݒt@CALO폜URL擾Aj[ڂ𐶐B
		ScormLoEnv scormEnv = new ScormLoEnv();
		String deleteMenuURL = scormEnv.getDeleteMenuURL(params);
		MenuData menuData =
			new MenuData(
				deleteMenuURL,
				ScormLoConstant.MENU_LABEL_LO_DELETE,
				MenuData.DELETE_MENU,
				MenuData.INSTRUCTOR_MENU);

		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL makeDeleteMenu(" + params + ") return " + menuData,
			DebugLog.ROW);
		return menuData;
	}

	/**
	 * SCORM LȌ擾܂B<br>
	 * @param params p[^B<br>
	 * ȉ̒lݒ肳Ă邱Ƃ҂Ă܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.REAL_LOID</td>
	 * 		<td>wK鋳ނRealLOID</td>
	 * 	</tr>
	 * </table><br><br>
	 * ܂Ã\bhďo͈ȉ̒lݒ肳܂B<br>
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.MATLID</td>
	 * 		<td>wK鋳ނ̋ID</td>
	 * 	</tr>
	 * </table><br><br>
	 *
	 * @throws LOException 擾ɗOꍇB
	 */
	private void putLoInfo(Hashtable params) throws LOException {
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD putLoInfo(" + params + ")",
			DebugLog.ROW);

		// Real LOID擾āAID擾B
		String realLOID = (String) params.get(LoPropertyDef.REAL_LOID);
		if (realLOID == null) {
			throw new LOException("RealLOID擾ł܂B");
		}

		Hashtable condition = new Hashtable();
		condition.put(LoPropertyDef.LOID, realLOID);
		ScormLoDataAccess scormLoDataAccess = new ScormLoDataAccess();
		ScormLoData[] objData = scormLoDataAccess.getLoData(condition);
		// IDݒ
		params.put(LoPropertyDef.MATLID, objData[0].getMaterialID());

		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL putLoInfo(" + params + ")",
			DebugLog.ROW);
	}

	/**
	 * wKJnj[ڂƂĕ\邩ۂ肵܂B
	 * @param params p[^B<br>
	 * ȉ̒l擾āA肵܂BlȂinullłjł삵܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.LEARN_AUTH</td>
	 * 		<td>OCE[ŮwK̗L</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.LEARNER_ASSIGN</td>
	 * 		<td>OCE[UƑΏۋނƂ̊wKATCL</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.TARGET_ID</td>
	 * 		<td>O擾̃^[QbgƂȂIDݒL[</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.USER</td>
	 * 		<td>[UID</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.PRERE_FLG</td>
	 * 		<td>OtO</td>
	 * 	</tr>
	 * </table><br>
	 *
	 * @return wKJnj[\ꍇ́AtrueB
	 *          \Ȃꍇ́AfalseB
	 */
	private boolean isAbleToStartLearn(Hashtable params) {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD isAbleToStartLearn(" + params + ")",
			DebugLog.ROW);
		////////////////////////////////////////////////////////////////////////
		// p[^擾
		// =====================================================================
		// wK
		String learnAuth = (String) params.get(LoPropertyDef.LEARN_AUTH);
		// wKATC
		String learnerAssign =
			(String) params.get(LoPropertyDef.LEARNER_ASSIGN);
		// O擾̃^[QbgƂȂIDݒL[([UID)
		String targetID = (String) params.get(LoPropertyDef.TARGET_ID);
		// [UID
		String userID = (String) params.get(LoPropertyDef.USER);
		// OtO
		String prereFlg = (String) params.get(LoPropertyDef.PRERE_FLG);
		// =====================================================================
		// Oo
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.LEARN_AUTH + "]=" + learnAuth,
			DebugLog.MID);
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.LEARNER_ASSIGN + "]=" + learnerAssign,
			DebugLog.MID);
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.TARGET_ID + "]=" + targetID,
			DebugLog.MID);
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.USER + "]=" + userID,
			DebugLog.MID);
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.PRERE_FLG + "]=" + prereFlg,
			DebugLog.MID);
		////////////////////////////////////////////////////////////////////////
		// j[\ۊmF
		boolean able = false;
		if (learnAuth != null
			&& learnerAssign != null
			&& targetID != null
			&& (userID != null && userID.equals(targetID))
			&& (prereFlg != null && prereFlg.equals("on"))) {
			able = true;
		}
		DebugLog.write(getClass(), "Start Learn is " + able, DebugLog.MID);
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL isAbleToStartLearn(" + params + ")" + " return " + able,
			DebugLog.ROW);
		return able;
	}

	/**
	 * wKOQƂj[ڂƂĕ\邩ۂ肵܂B
	 * @param params p[^B<br>
	 * ȉ̒l擾āA肵܂BlȂinullłjł삵܂B<br>
	 * <table border="1">
	 * 	<tr>
	 * 		<th>L[</th>
	 * 		<th>l</th>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.MANAGE_ASSIGN</td>
	 * 		<td>OCE[UƑΏۋނƂ̊ǗATCL</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.LEARNER_ASSIGN</td>
	 * 		<td>OCE[UƑΏۋނƂ̊wKATCL</td>
	 * 	</tr>
	 * 	<tr>
	 * 		<td>LoPropertyDef.LOG_AUTH</td>
	 * 		<td>OCE[ŨOQƌ̗L</td>
	 * 	</tr>
	 * </table><br>
	 *
	 * @return OQƃj[\ꍇ́AtrueB
	 *           \Ȃꍇ́AfalseB
	 */
	private boolean isAbleToBrowseLog(Hashtable params) {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(
			getClass(),
			"HEAD isAbleToBrowseLog(" + params + ")",
			DebugLog.ROW);
		////////////////////////////////////////////////////////////////////////
		// p[^擾
		// =====================================================================
		// ǗATC
		String manageAssign = (String)params.get(LoPropertyDef.MANAGE_ASSIGN);
		// wKATC
		String learnerAssign = (String)params.get(LoPropertyDef.LEARNER_ASSIGN);
		// OQƌ̎擾
		String logAuth = (String)params.get(LoPropertyDef.LOG_AUTH);
		// =====================================================================
		// Oo
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.MANAGE_ASSIGN + "]=" + manageAssign,
			DebugLog.MID);
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.LEARNER_ASSIGN + "]=" + learnerAssign,
			DebugLog.MID);
		DebugLog.write(
			getClass(),
			"[" + LoPropertyDef.LOG_AUTH + "]=" + logAuth,
			DebugLog.MID);

		////////////////////////////////////////////////////////////////////////
		// j[\ۊmF
		boolean able = false;
		if (logAuth != null
			&& (manageAssign != null || learnerAssign != null)) {
			able = true;
		}
		DebugLog.write(getClass(), "Browse Log is " + able, DebugLog.MID);
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(
			getClass(),
			"TAIL isAbleToBrowseLog(" + params + ")" + " return " + able,
			DebugLog.ROW);
		return able;
	}
}
