/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	j[JX^}CY`NX
//
//		ύX
//			2005.02.19  VK쐬  ~ _i
//
//	@\
//
//	̃NX̓j[JX^}CY`ۑNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.io.FileOutputStream;
import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult; 

import org.w3c.dom.Node;
import org.w3c.dom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import jp.co.ntt.lms.xmf.beans.CustomMenuBean;


/**
 *  j[JX^}CY`NX
 * 
 *  ̃NX̓j[JX^}CY`ۑNXłB
 * 
 *  @author ~ _i
 *  @version 1.0
 */
public class CustomMenuDef
{
	private String defType = "";
	private String userId = "";
	private String groupId = "";
	
	private Node documentRoot = null;
	private Document document = null;
	
	// j[JX^}CY`ʒ萔
	public static final String DEFTYPE_DEFAULT = "default";	// ftHg`	
	public static final String DEFTYPE_USER = "user";			// [U[`
	public static final String DEFTYPE_GROUP = "group";		// O[v`
	
	/**
	 * RXgN^
	 * 
	 * @param defType	j[JX^}CY`
	 * @param userId	`̑ΏۂƂȂ郆[UID
	 * @param groupId	`̑ΏۂƂȂO[vID
	 */
	public CustomMenuDef(String defType, String userId, String groupId)
	{
		this.defType = defType;
		this.userId = userId;
		this.groupId = groupId;
	}
	
	/**
	 * j[JX^}CY`t@CǂݍށB
	 * 
	 * @param parser 	p[T[IuWFNg
	 * @param is		̓Xg[IuWFNg
	 * @throws SAXException
	 * @throws IOException
	 */
	public void loadMenuDef(DocumentBuilder parser, InputStream is)
		throws SAXException, IOException
	{
		document = parser.parse(new InputSource(is));
		documentRoot = document.getFirstChild();
	}
	
	/**
	 * JX^j[`t@Cɏo͂B
	 * 
	 * @param strSaveFileName o̓t@C
	 * @throws IOException 
	 */
	public void saveMenuDef(String strSaveFileName)
		throws IOException
	{
		//t@Cւ̏o
		try {
			TransformerFactory transFactory = TransformerFactory.newInstance(); 
			Transformer transformer = transFactory.newTransformer(); 

			DOMSource source = new DOMSource(document);
			File newXML = new File(strSaveFileName); 
			FileOutputStream os = new FileOutputStream(newXML);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);
			os.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	
	/**
	 * `̑ΏۂƂȂ郆[UID擾B
	 * 
	 * @return String [U[ID
	 */
	public String getUserId()
	{
		return userId;
	}
	
	/**
	 * `̑ΏۂƂȂO[vID擾B
	 * 
	 * @return String O[vID
	 */
	public String getGroupId()
	{
		return groupId;
	}
	
	/**
	 * JX^j[`ʂ[U`ǂB
	 * 
	 * @return boolean true:[U`ł
	 */
	private boolean isUserDef()
	{
		return defType.equals(DEFTYPE_USER);
	}
	
	/**
	 * JX^j[`ʂO[v`ǂB
	 * @return boolean true:O[v`ł
	 */
	private boolean isGroupDef()
	{
		return defType.equals(DEFTYPE_GROUP);
	}
	
	/**
	 * JX^j[`ʂftHg`ǂB
	 * 
	 * @return boolean true:ftHg`łB
	 */
	private boolean isDefaultDef()
	{
		return defType.equals(DEFTYPE_DEFAULT);
	}
	
	/**
	 * titleselectŎw肵j[`visibleǂB
	 * 
	 * @param menuTitle ƂȂtitlel
	 * @param selectId ƂȂselectl
	 * @return boolean true:visibleł
	 */
	public boolean isMenuVisible(String menuTitle, String selectId)
	{
		List list = NodeUtil.getNamedChildElementList(documentRoot, "menu");
		for (int i=0; i < list.size(); i++)
		{
			Node menuNode = (Node)list.get(i);
			if (menuTitle.equals(NodeUtil.getAttribute(menuNode, "title")))
			{
				String selectAttribute = NodeUtil.getAttribute(menuNode, "select");
				if (selectAttribute != null)
				{
					if (selectAttribute.equals(selectId))
					{
						String visibleAttribute = NodeUtil.getAttribute(menuNode, "visible");
						if ("false".equalsIgnoreCase(visibleAttribute))
						{
							return false;
						}
					}
				}
				else
				{
					String visibleAttribute = NodeUtil.getAttribute(menuNode, "visible");
					if ("false".equalsIgnoreCase(visibleAttribute))
					{
						return false;
					}
				}
			}
		}
		return true;
	}
	
	/**
	 * titleselectŎw肵j[`displaytitlel擾B
	 * 
	 * @param menuTitle ƂȂtitlel
	 * @param selectId ƂȂselectl
	 * @return String w肳ꂽdisplaytitilelB
	 */
	public String changeMenuTitle(String menuTitle, String selectId)
	{
		List list = NodeUtil.getNamedChildElementList(documentRoot, "menu");
		for (int i=0; i < list.size(); i++)
		{
			Node menuNode = (Node)list.get(i);
			if (menuTitle.equals(NodeUtil.getAttribute(menuNode, "title")))
			{
				String dispTitleAttribute = NodeUtil.getAttribute(menuNode, "displaytitle");
				if (dispTitleAttribute != null)
				{
					String selectAttribute = NodeUtil.getAttribute(menuNode, "select");
					if (selectAttribute != null)
					{
						if (selectAttribute.equals(selectId))
						{
							return dispTitleAttribute;
						}
					}
					else
					{
						return dispTitleAttribute;
					}
				}
			}
		}
		return menuTitle;
	}
	
	/**
	 * JX^j[`̈ꗗ擾B
	 * 
	 * @return List JX^j[`ꗗB
	 */
	public List getCustomMenuList()
	{
		List menuList = new ArrayList();
		
		List list = NodeUtil.getNamedChildElementList(documentRoot, "menu");
		for (int i=0; i < list.size(); i++)
		{
			Node menuNode = (Node)list.get(i);
			
			String title = NodeUtil.getAttribute(menuNode, "title");
			String dispTitle = NodeUtil.getAttribute(menuNode, "displaytitle");
			String visible = NodeUtil.getAttribute(menuNode, "visible");
			String select = NodeUtil.getAttribute(menuNode, "select");

			CustomMenuBean menuBean = new CustomMenuBean();
			menuBean.setTitle(title);
			menuBean.setDisplaytitle(dispTitle);
			menuBean.setVisible(visible);
			menuBean.setSelect(select);
			
			menuList.add(menuBean);
		}
		
		return menuList;
	}
	
	/**
	 * VKmenuvfǉB
	 * 
	 * @param strTitle title
	 * @param strSelect select
	 * @param strDisplayTitle displaytitle
	 * @param blnVisible trueȂvisible=false𑮐ɐݒ
	 * @return /s
	 */
	public boolean addCustomMenu(String strTitle, String strSelect, String strDisplayTitle, boolean blnVisible)
	{
		// s̃eLXgm[hǉB
		Text txtCR = document.createTextNode("\n");
		// VKm[hǉB
		Element elmMenu= document.createElement("menu");
		elmMenu.setAttribute("title", strTitle);
		if (blnVisible)
		{
			// visibleݒB
			elmMenu.setAttribute("visible", "false");
		}
		else
		{
			// displaytitleݒB
			elmMenu.setAttribute("displaytitle", strDisplayTitle);
		}
		if (!strSelect.equals("ALL") && !strSelect.equals("") )
		{
			// ʐݒ̏ꍇAS̐ݒ̑Oɑ}
			elmMenu.setAttribute("select", strSelect);
			Node nextNode = getInsertPersonalMenuNode();
			if (nextNode == null)
			{
				// S̐ݒ肪Ȃ΍ŌɒǉB
				documentRoot.appendChild(elmMenu);
				documentRoot.appendChild(txtCR);
			}
			else
			{
				// ΂̑OɒǉB
				documentRoot.insertBefore(elmMenu, nextNode);
				documentRoot.insertBefore(txtCR, nextNode);
			}
		}
		else
		{
			// Ŝ̐ݒ̏ꍇAselect͂ȂB
			documentRoot.appendChild(elmMenu);
			documentRoot.appendChild(txtCR);
		}
		
		
		return true;
	}
	
	/**
	 * title,selectL[ɈvmenuvfdisplaytitleXVB
	 * 
	 * @param strTitle	L[ƂȂtitle
	 * @param strSelect L[ƂȂselect
	 * @param strDisplayTitle displaytitleɐݒ肷镶
	 * @param blnUnvisible L[Ƃvisible="false"w肷邩ǂ
	 * @return boolean /s
	 */
	public boolean updateCustomMenu(String strTitle, String strSelect, String strDisplayTitle, boolean blnUnvisible)
	{
		Element menuElement = (Element)searchCustomMenu(strTitle, strSelect, blnUnvisible);
		if (menuElement == null) return false;
		
		menuElement.setAttribute("displaytitle", strDisplayTitle);
		
		return true;
	}
	
	/**
	 * title,selectL[Ɉvmenuvf폜B
	 * 
	 * @param strTitle	L[ƂȂtitle
	 * @param strSelect L[ƂȂselect
	 * @param blnUnvisible L[Ƃvisible="false"w肷邩ǂ
	 * @return boolean /s
	 */
	public boolean deleteCustomMenu(String strTitle, String strSelect, boolean blnUnvisible)
	{
		Node menuNode = searchCustomMenu(strTitle, strSelect, blnUnvisible);
		if (menuNode == null) return false;
		
		// em[hwm[h폜B
		Node parentNode = menuNode.getParentNode();
		Node nextNode = menuNode.getNextSibling();
		parentNode.removeChild(menuNode);
		// 폜m[h̎eLXgm[h(s)Ȃ폜B
		if (nextNode != null && nextNode.getNodeType() == Node.TEXT_NODE)
		{
			parentNode.removeChild(nextNode);
		}
		
		return true;
	}
	
	/**
	 * title,selectL[menuvfB
	 * 
	 * @param strTitle	L[ƂȂtitle
	 * @param strSelect L[ƂȂselect
	 * @param blnUnvisible L[Ƃvisible="false"w肷邩ǂ
	 * @return Node ʂmenuvf
	 */
	private Node searchCustomMenu(String strTitle, String strSelect, boolean blnUnvisible)
	{
		if (strSelect.equals("ALL")) strSelect = "";
		List list = NodeUtil.getNamedChildElementList(documentRoot, "menu");
		for (int i=0; i < list.size(); i++)
		{
			Node menuNode = (Node)list.get(i);
			
			String title = NodeUtil.getAttribute(menuNode, "title");
			String select = NodeUtil.getAttribute(menuNode, "select");
			String visible = NodeUtil.getAttribute(menuNode, "visible");
			boolean unvisible = (visible != null && visible.equals("false"));	// visible="false"w肳Ă邩
			if (title == null) title = "";
			if (select == null) select = "";

			if (strTitle.equals(title) && strSelect.equals(select) && blnUnvisible == unvisible)
			{
				return menuNode;
			}
		}
		return null;
	}
	
	/**
	 * ʐݒmenuvf}ꏊmenuvf擾B
	 * 
	 * @return Node ʐݒ}ꏊmenuvf 
	 */
	private Node getInsertPersonalMenuNode()
	{
		List list = NodeUtil.getNamedChildElementList(documentRoot, "menu");
		for (int i=0; i < list.size(); i++)
		{
			Node menuNode = (Node)list.get(i);
			
			String select = NodeUtil.getAttribute(menuNode, "select");
			
			// S̐ݒ̍ŏ
			if (select == null)
			{
				// ̈O̗vf擾B
				Node prevNode = menuNode.getPreviousSibling();
				while (prevNode.getNodeType() == Node.TEXT_NODE)
				{
					// OeLXgm[hȂOԂ
					prevNode = prevNode.getPreviousSibling();
					if (prevNode == null) break;
				}
				if (prevNode.getNodeType() == Node.COMMENT_NODE)
				{
					// ORgȂ炻ԂB
					return prevNode;
				}
				else
				{
					// łȂȂS̐ݒ̍ŏԂB
					return menuNode;
				}
			}
		}
		return null;	// S̐ݒȂꍇ
	}
}
