/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerFileUtil;
import jp.co.ntt.lms.installer.core.util.InstallerProcessUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * OracleɃf[^x[XEe[u쐬ANVENXB
 * @author T.Nishiki
 */
public class CreateDbOracleAction extends CreateDbAbstractAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(CreateDbOracleAction.class);
	}

	/**
	 * Ήf[^x[X̎ʂ߂܂B<br>
	 * @return f[^x[Xʂ߂܂B
	 */
	protected String getDbCategory() {
		return "1";
	}

	/**
	 * f[^x[XEe[u쐬鋤ʃANVB
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return null߂܂B
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");
		try {
			// JnbZ[Wo
			InstallerUiUtil.outputMessageAsTitle(
				values,	"CreateDbAbstractAction.head");
			// =================================================================
			// f[^x[Xpɓ͂l擾
			ConfirmDbInitializeValue initializeValue
				= (ConfirmDbInitializeValue)values.getActionValue(
					ConfirmDbInitializeAction.class.getName());
			// f[^x[XǗ҃[U
			String dbaUser = initializeValue.getDbaUser();
			// f[^x[XǗ҃pX[h
			String dbaPass = initializeValue.getDbaPassword();
			// lbgT[rX
			Properties extendProperties
				= initializeValue.getExtendProperties();
			String serviceName = extendProperties.getProperty(
						"db.extend.oracle.netservice.name");
			// =================================================================
			// Manager̐ݒlgp
			ManagerInputValue inputValue = (ManagerInputValue)
				values.getActionValue(ManagerInputAction.class.getName());
			// ڑ[U
			String user = inputValue.getDbUser();
			// ڑ[UEpX[h
			String pass = inputValue.getDbPassword();
			////////////////////////////////////////////////////////////////////
			// SQLs
			// =================================================================
			// e[uXy[X쐬
			executeSqlPlusQueryType(values, "create.database",
				dbaUser, dbaPass, serviceName);
			// [U쐬
			executeSqlPlusQueryType(values, "create.user",
				dbaUser, dbaPass, serviceName);
			// ʏ̃NGiOj
			executeSqlPlusQueryType(values, "common.first",
				user, pass, serviceName);
			// IvVLOpNG
			String[] optionLOKeys = values.getOptionLOKeys();
			for (int i = 0; i < optionLOKeys.length; i++) {
				if ( values.getOptionLOSelected(optionLOKeys[i]) == false ) {
					continue;
				}
				executeSqlPlusQueryType(values,
					"optionLO." + optionLOKeys[i],
					user, pass, serviceName);
			}
			// ʏ̃NGi㔼j
			executeSqlPlusQueryType(values, "common.second",
				user, pass, serviceName);
			// IbZ[Wo
			InstallerUiUtil.outputMessage(
				values, "CreateDbAbstractAction.tail", true);
		}
		catch (InstallerException e) {
			// G[bZ[Wo
			InstallerUiUtil.outputMessage(
				values, "CreateDbAbstractAction.error", true);
			throw e;
		}
		catch (Exception e) {
			// G[bZ[Wo
			InstallerUiUtil.outputMessage(
				values, "CreateDbAbstractAction.error", true);
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger, "action(InstallerValues)");
		return null;
	}


	/**
	 * w肳ꂽNG^CṽNG[s܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param queryType sNG[ʁB
	 * @param user ڑ[UB
	 * @param password ڑ[UEpX[hB
	 * @param serviceName ڑۂɎgpT[rXB
	 * @throws InstallerException f[^x[XANZXɗOꍇB
	 */
	private void executeSqlPlusQueryType(
			InstallerValues values, String queryType,
			String user, String password, String serviceName)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"executeSqlPlusQueryType(InstallerValues," + queryType + ","
				+ user + "," + password + "," +  serviceName + ")");
		// \[XSQLt@C𐶐
		File[] queryFiles = makeSqlFilesFromResource(values, queryType);
		// SQLt@CSQL PlusʂĎs
		for (int i = 0; i < queryFiles.length; i++) {
			executeSqlPlus(values, user, password, serviceName, queryFiles[i]);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"executeSqlPlusQueryType(InstallerValues," + queryType + ","
				+ user + "," + password + "," +  serviceName + ")");
	}

	/**
	 * SQL Plus̃R}hʂāAw肵SQLt@Cs܂B
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param user ڑ[UB
	 * @param password ڑ[UEpX[hB
	 * @param serviceName ڑۂɎgpT[rXB
	 * @param file SQLXNvgt@CB
	 * @throws InstallerException SQL Plus̃R}hĂяosȂǂꍇB
	 */
	private void executeSqlPlus(
		InstallerValues values,
		String user, String password, String serviceName, File file)
		throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"executeSqlPlus(InstallerValues," + user + ","
				+ password + "," +  serviceName + "," + file + ")");
		try {
 			// RlNV𐶐B
			String connectionString
				= user + "/" + password + "@" + serviceName;
			// SQL PlusR}h
			String[] commandArray = new String[] {
				"sqlplus", "-S", "-L", connectionString,
				"@" + file.getAbsolutePath(),
			};
			// SQL PlusR}hs
			InstallerProcessUtil.excuteCommands(commandArray);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"executeSqlPlus(InstallerValues," + user + ","
				+ password + "," +  serviceName + "," + file + ")");
	}

	/**
	 * w肳ꂽNG^CṽNG[t@CƂĐ܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param queryType NG[ʁB
	 * @return SQLt@C̔zBȂꍇ͗vfO̔zB
	 * @throws InstallerException f[^ANZXɗOꍇB
	 */
	private File[] makeSqlFilesFromResource(
		InstallerValues values, String queryType)
		throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"makeSqlFilesFromResource(InstallerValues," + queryType + ")");

		List fileList = new ArrayList();
		try {
			String[][] queryResources
				= values.getQueryResources(queryType);
			// NGȂꍇ͏I
			if (queryResources.length > 0) {
				for (int i = 0; i < queryResources.length; i++) {
					// NGt@C
					List sqlFileList = makeSqlFileFromResource(values,
						queryResources[i][0], queryResources[i][1]);
					fileList.addAll(sqlFileList);
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// zɕϊ
		File[] sqlFiles = new File[fileList.size()];
		fileList.toArray(sqlFiles);
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"makeSqlFilesFromResource(InstallerValues," + queryType + ")",
			sqlFiles);
		return sqlFiles;
	}

	/**
	 * ^ꂽ\[XpXSQLt@Ce|ɍ쐬܂B<br>
	 * SQLt@ĆA\[XǍA&quot;;&quot;Ƃ
	 * o͂t@C؂܂B
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param resourcePath 擾t@CE\[XpXB
	 * @param encode ̓Xg[ǂݍރGR[hB
	 * @return t@CIuWFNgvfƂ郊XgB
	 * @throws InstallerException@\[X擾ɎsꍇA
	 *          t@CɎsꍇɃX[܂B
	 */
	private List makeSqlFileFromResource(
		InstallerValues values, String resourcePath, String encode)
		throws InstallerException {

		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"makeSqlFileFromResource(InstallerValues,"
				+ resourcePath + ","  + encode + ")");
		// ̃\bh̖߂l
		List sqlFileList = new ArrayList();
		boolean successFlag = false;
		BufferedReader reader = null;
		BufferedWriter writer = null;
		try {
			// \[X̓̕Xg[𐶐
			reader = new BufferedReader(
				new InputStreamReader(
					values.getResourcePathStream(resourcePath), encode));
			////////////////////////////////////////////////////////////////////
			// o͐t@C̐ݒ
			File tempDir = values.getInstallerTempDir();
			File sqlBaseFile = new File(tempDir, resourcePath);
			String sqlBaseFileName = sqlBaseFile.getName();
			// o͐fBNgɐ
			File madeFileParentDir = sqlBaseFile.getParentFile();
			if (madeFileParentDir.exists() == false) {
				madeFileParentDir.mkdirs();
			}
			// =================================================================
			// t@C̐ړƊgq
			String fileNamePrefix = null;
			String fileNameSuffix = null;
			int periodPos = sqlBaseFileName.lastIndexOf(".");
			if (periodPos <= 0) {
				fileNamePrefix = "temp";
				fileNameSuffix = ".sql";
			}
			else {
				fileNamePrefix = sqlBaseFileName.substring(0, periodPos);
				fileNameSuffix = ".sql";
			}
			// =================================================================
			// ŏ̃t@C𐶐
			File sqlFile = File.createTempFile(
					fileNamePrefix, fileNameSuffix, madeFileParentDir);
			sqlFileList.add(sqlFile);
			// t@Cւ̕o̓Xg[𐶐
			writer = new BufferedWriter( new FileWriter(sqlFile));
			// =================================================================
			// f[^̈ڂς
			while (true) {
				// ̓Xg[Ǎ
				String line = reader.readLine();
				if (line == null) {
					break;
				}
				// ǂݍ񂾕u
				line = replace(values, line);
				if (line.trim().toLowerCase().startsWith("exit;") == true) {
					continue;
				}
				// o̓Xg[ɏo
				writer.write(line);
				writer.newLine();
				// =============================================================
				// SQL̋؂蕶ꍇA
				// sqlplusIR}htāAt@CU؂B
				if (line.trim().endsWith(";")) {
					writer.write("EXIT;");
					writer.newLine();
					writer.close();
					// Vt@C𐶐
					sqlFile = File.createTempFile(
						fileNamePrefix, fileNameSuffix, madeFileParentDir);
					sqlFileList.add(sqlFile);
					// Vt@Cɑ΂镶o̓Xg[𐶐
					writer = new BufferedWriter( new FileWriter(sqlFile));
				}
			}
			// Ō̃t@CɏO̓R}htB
			writer.write("EXIT;");
			writer.newLine();
			// tryubNI[܂œB
			successFlag = true;
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
		}
		finally {
			InstallerException thrown = null;
			// ̓Xg[̃N[Y
			try {
				InstallerFileUtil.close(reader, successFlag);
			}
			catch (InstallerException e) {
				thrown = e;
			}
			// o̓Xg[̃N[Y
			try {
				InstallerFileUtil.close(writer, successFlag);
			}
			catch (InstallerException e) {
				if ( thrown == null) {
					thrown = e;
				}
			}
			if (thrown != null) {
				throw thrown;
			}
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"makeSqlFileFromResource(InstallerValues,"
				+ resourcePath + ","  + encode + ")",
			sqlFileList);
		return sqlFileList;
	}

	/**
	 * ^ꂽNG[̒us܂B
	 * @param values CXg[ʃf[^IuWFNgB
	 * @param queryLine ϊΏۂ̃NG[B
	 * @return ũNG[B
	 */
	protected String replace(InstallerValues values, String queryLine) {

		// =====================================================================
		// }l[Wݒl
		ManagerInputValue managerValue
			= (ManagerInputValue)values.getActionValue(
				ManagerInputAction.class.getName());
		queryLine = queryLine.replaceAll(
				"\"%XMS2_USER_NAME%\"", managerValue.getDbUser());
		queryLine = queryLine.replaceAll(
				"%XMS2_USER_NAME%", managerValue.getDbUser());
		queryLine = queryLine.replaceAll(
				"\"%XMS2_USER_PASSWORD%\"", managerValue.getDbPassword());
		queryLine = queryLine.replaceAll(
				"%XMS2_USER_PASSWORD%", managerValue.getDbPassword());
		queryLine = queryLine.replaceAll(
				"%DB_ENCODE%", managerValue.getDbEncode());
		// =====================================================================
		// Ǝ͒l
		ConfirmDbInitializeValue initializeValue = (ConfirmDbInitializeValue)
			values.getActionValue(ConfirmDbInitializeAction.class.getName());
		Properties extendProperties = initializeValue.getExtendProperties();
		// \̈於
		queryLine = queryLine.replaceAll(
				"\"%TABLESPACE%\"",
				 extendProperties.getProperty(
					"db.extend.oracle.tablespace.name"));
		queryLine = queryLine.replaceAll(
				"%TABLESPACE%",
				 extendProperties.getProperty(
					"db.extend.oracle.tablespace.name"));
		// =====================================================================
		// [Ǘҗp[AhX
		MailInputValue mailValue
			= (MailInputValue)values.getActionValue(
					MailInputAction.class.getName());
		if (mailValue != null) {
			String siteAdministratorMail
				= mailValue.getSiteAdministratorMail();
			if (siteAdministratorMail != null) {
				siteAdministratorMail = "null";
			}
			else {
				siteAdministratorMail = "'" + siteAdministratorMail + "'";
			}
			queryLine = queryLine.replaceAll(
					"%MAILSITEADMIN%", siteAdministratorMail);
		}
		else {
			queryLine = queryLine.replaceAll(
					"%MAILSITEADMIN%", "null");
		}
		// ϊ̕߂B
		return queryLine;
	}
}
