/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ScormStudyInfoServlet
//	ύX
//		2004.02.01	VK쐬
//

package jp.co.ntt.lms.lo.scorm;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.util.DebugLog;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/**
 * ލ\`Ȃђf擾T[ubgB<br>
 * NGXg̎wɏ]Aލ\AKvΒf擾A
 * NCAgɈȉXML`Ŗ߂܂B
 * &lt;result&gt;<br>
 * 		&lt;status&gt;ʒlilj&lt;/status&gt;<br>
 * 	 	ލ\`i&lt;manifest&gt;Ŏn܂j<br>
 * 		fi&lt;resume&gt;Ŏn܂j<br>
 * &lt;/result&gt;<br>
 * ʒĺA(0)AF؃G[(1)ȂG[(2)B
 * <br>
 * @author T.Nishiki
 */
public class ScormStudyInfoServlet extends HttpServlet {

	/**
	 * GETNGXg܂B<br>
	 * @param request HTTPNGXgB
	 * @param response HTTPX|XB
	 * @throws IOException NGXg̓͂܂̓X|Xւ̏o͎
	 * @@@@@G[ƂȂꍇB
	 * @throws ServletException ɗOꍇB
	 * @see HttpServlet#doGet(HttpServletRequest, HttpServletResponse)
	 */
	protected void doGet(
		HttpServletRequest request,
		HttpServletResponse response)
		throws IOException, ServletException {
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD doGet(reqeust,response)",
			DebugLog.ROW);

		doRequest(request, response);

		// \bhIO
		DebugLog.write(getClass(),
			"TAIL doGet(reqeust,response)",
			DebugLog.ROW);
	}

	/**
	 * POSTNGXg܂B<br>
	 * @param request HTTPNGXgB
	 * @param response HTTPX|XB
	 * @throws IOException NGXg̓͂܂̓X|Xւ̏o͎
	 * @@@@@G[ƂȂꍇB
	 * @throws ServletException ɗOꍇB
	 * @see HttpServlet#doPost(HttpServletRequest, HttpServletResponse)
	 */
	protected void doPost(
		HttpServletRequest request,
		HttpServletResponse response)
		throws IOException, ServletException {
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD doPost(reqeust,response)",
			DebugLog.ROW);

		doRequest(request, response);

		// \bhIO
		DebugLog.write(getClass(),
			"TAIL doPost(reqeust,response)",
			DebugLog.ROW);
	}

	/**
	 * NGXg܂B<br>
	 *
	 * @param request HTTPNGXgB
	 * @param response HTTPX|XB
	 * @throws IOException NGXg̓͂܂̓X|Xւ̏o͎
	 * @@@@@G[ƂȂꍇB
	 * @throws ServletException ɗOꍇB
	 */
	private void doRequest(
		HttpServletRequest request,
		HttpServletResponse response)
		throws IOException, ServletException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD doRequest(reqeust,response)",
			DebugLog.ROW);

		ServletOutputStream outputStream = null;
		try {
			////////////////////////////////////////////////////////////////////
			// p[^̎擾
			// [UID
			String userID = request.getParameter(
					ScormLoConstant.PARAM_NAME_USERID);
			// LOID
			String loID = request.getParameter(ScormLoConstant.PARAM_NAME_LOID);
			// _CWFXgL[
			String authKey =
				request.getParameter(ScormLoConstant.PARAM_NAME_AUTHKEY);
			// wK
			String studySession = request.getParameter(
				ScormLoConstant.PARAM_NAME_STUDY_SESSION);
			// wK
			String command = request.getParameter(
				ScormLoConstant.PARAM_NAME_COMMAND);
			// =================================================================
			// Oo
			DebugLog.write(getClass(),
				"[" + ScormLoConstant.PARAM_NAME_USERID + "][" + userID + "]",
				DebugLog.MID);
			DebugLog.write(getClass(),
				"[" + ScormLoConstant.PARAM_NAME_LOID + "][" + loID + "]",
				DebugLog.MID);
			DebugLog.write(getClass(),
				"[" + ScormLoConstant.PARAM_NAME_AUTHKEY + "][" + authKey + "]",
				DebugLog.MID);
			DebugLog.write(getClass(),
				"[" + ScormLoConstant.PARAM_NAME_STUDY_SESSION + "]"
					+ "[" + studySession + "]",
				DebugLog.MID);
			DebugLog.write(getClass(),
				"[" + ScormLoConstant.PARAM_NAME_COMMAND + "]"
					+ "[" + command + "]", DebugLog.MID);
			////////////////////////////////////////////////////////////////////
			// ŏIIɃNCAgɕԐMXML Dom Dcument
			Document resultDocument = null;
			DocumentBuilderFactory factory =
					DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			resultDocument = builder.newDocument();
			// =================================================================
			// [gvf̐ݒ
			Element rootElement = resultDocument.createElement(
					ScormLoConstant.STUDYINFO_TAG_NAME_ROOT);
			resultDocument.appendChild(rootElement);
			////////////////////////////////////////////////////////////////////
			// F؊mF
			boolean authStatus = appendAuthenticateElement(
					resultDocument, rootElement, userID, loID, authKey);
			////////////////////////////////////////////////////////////////////
			// F؂ɐƂ̂݁A擾{
			if (authStatus == true) {
				String materialID = getMaterialID(loID);
				// =============================================================
				// ލ\`̎擾E
				appendManifestElement(resultDocument, rootElement, materialID);
				// =============================================================
				// f̎擾E
				if (command != null
					&& command.equals(
						ScormLoConstant.START_PARAM_COMD_CONT)
					&& studySession != null
					&& studySession.length() > 0) {
					int intStudySession = Integer.parseInt(studySession);
					appendResumeElement(
						resultDocument, rootElement,
						userID, loID, intStudySession);
				}
			}

			ScormLoEnv scormEnv = new ScormLoEnv();
			// X|X̃GR[h擾
			String responseEncode = scormEnv.getProperty(
				ScormLoEnv.CHARSET_RESPONSE_STUDY_INFO);
			// X|X擾
			response.setContentType(
				"text/xml;charset="	+ responseEncode );
			outputStream = response.getOutputStream();
			Properties outProperties = new Properties();
			outProperties.put(ScormLoUtil.PROPERTY_ENCODING, responseEncode);
			ScormLoUtil.transformNodeToStream(
				resultDocument, outputStream, outProperties);
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new ServletException(e);
		}
		finally {
			if (outputStream != null) {
				outputStream.close();
			}
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL doRequest(reqeust,response)",
			DebugLog.ROW);
	}

	/**
	 * F؂ȂǍʂXMLvfƂĒǉ܂B<br>
	 * w肳ꂽ[UIDALOIDAF؃L[ƂɔF؂sA
	 * ̌ʂ܂DOM Element𐶐A
	 * w肵evfɎqvfƂēo^܂B<br>
	 *
	 * @param document vf𐶐邽߂DOM DocumentB
	 * @param parentElement ʗvfo^evfƂȂDOM ElementB
	 * @param userID NCAg瑗Mꂽ[UIDB
	 * @param loID NCAg瑗MꂽLOIDB
	 * @param authKey NCAg瑗MꂽF؃L[B
	 * @return F؂ɐꍇtrueAsꍇfalse߂܂B
	 * @throws LOException F؏ɃG[ꍇB
	 */
	private boolean appendAuthenticateElement(
			Document document,
			Element parentElement,
			String userID,
			String loID,
			String authKey) throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD appendAuthenticateElement("
				+ document + "," + parentElement + ","
				+ userID + "," + loID + "," + authKey + ")",
			DebugLog.ROW);

		// F،
		boolean authStatus = false;
		try {
			// =================================================================
			// mF
			authStatus = authenticate(userID, loID, authKey);
			// F؂ɎsꍇAȍ~̏擾͏ȗ
			int status = 0;
			if (authStatus == false) {
				status = ScormLoConstant.STUDYINFO_STATUS_FAILURE_AUTH;
			}
			else {
				// ܂œBꍇAƂ܂B
				status = ScormLoConstant.STUDYINFO_STATUS_SUCCESS;
			}
			// =================================================================
			// ʒlpm[hǉ
			Element statusElement = document.createElement(
					ScormLoConstant.STUDYINFO_TAG_NAME_STATUS);
			parentElement.appendChild(statusElement);
			Text statusText = document.createTextNode(
					Integer.toString(status));
			statusElement.appendChild(statusText);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(getClass(),
		"TAIL appendAuthenticateElement("
			+ document + "," + parentElement + ","
				+ userID + "," + loID + "," + authKey + ")"
				+ (" return " + authStatus),
			DebugLog.ROW);

		return authStatus;
	}

	/**
	 * ލ\`擾Aw肳ꂽvfɓ܂B<br>
	 * w肳ꂽIDɍv鋳ލ\`DOM DocumentƂĎ擾A
	 * w肵evfɎqvfƂăC|[go^܂B<br>
	 *
	 * @param document vf𐶐邽߂DOM DocumentB
	 * @param parentElement ލ\o^evfƂȂDOM ElementB
	 * @param materialID IDB
	 * @throws LOException 擾ɗOꍇB
	 */
	private void appendManifestElement(
		Document document,
		Element parentElement,
		String materialID) throws LOException {

		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(getClass(),
		"HEAD appendManifestElement("
			+ document + "," + parentElement + "," + materialID + ")",
			DebugLog.ROW);

		try {
			// ލ\`t@C
			File materialFile =
					ScormManifestUtil.getManifestPathFile(materialID);
			// ލ\`DOM Document
			Document manifestDocument =
				ScormLoUtil.transformXmlFileToDocument(materialFile);
			// ލ\`DocumentDocumentɓ
			Node importedManifestNode = document.importNode(
					manifestDocument.getDocumentElement(), true);
			parentElement.appendChild(importedManifestNode);
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(getClass(),
		"TAIL appendManifestElement("
			+ document + "," + parentElement + "," + materialID + ")",
			DebugLog.ROW);
	}

	/**
	 * f擾Aw肳ꂽvfɓ܂B<br>
	 * w肳ꂽIDɍv鋳ލ\`DOM DocumentƂĎ擾A
	 * w肵evfɎqvfƂăC|[go^܂B<br>
	 *
	 * @param document vf𐶐邽߂DOM DocumentB
	 * @param parentElement fo^evfƂȂDOM ElementB
	 * @param userID NCAg瑗Mꂽ[UIDB
	 * @param loID NCAg瑗MꂽLOIDB
	 * @param studySession NCAg瑗MꂽwKZbV񐔁B
	 * @throws LOException 擾ɗOꍇB
	 */
	private void appendResumeElement(
		Document document,
		Element parentElement,
		String userID,
		String loID,
		int studySession) throws LOException {

		// ft@C擾
		File resumeFile =
			ScormLoUtil.getResumeFile(
				userID, loID, studySession);
		// ft@CDOM Document
		Document resumeDocument =
			ScormLoUtil.transformXmlFileToDocument(resumeFile);
		// fDocumentDocumentɓ
		Node importedResumeNode = document.importNode(
			resumeDocument.getDocumentElement(), true);
		parentElement.appendChild(importedResumeNode);
	}

	/**
	 * F؏{܂B<br>
	 * @param userID NGXgɊ܂܂郆[UIDB
	 * @param loID NGXgɊ܂܂LOIDB
	 * @param requestAuthKey NGXgɊ܂܂_CWFXgL[B
	 * @return F؂ɐꍇtrueA
	 *          sꍇfalse߂܂B<br>
	 *          ̂Pnull̏ꍇAsƂfalse߂܂B
	 * @throws LOException F؏̎ZoɎsꍇB
	 */
	private boolean authenticate(
		String userID, String loID, String requestAuthKey)
			throws LOException {
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD authenticate("
				+ userID + "," + loID + "," + requestAuthKey + ")",
			DebugLog.ROW);

		// ̃\bh̖߂lBlFF؎sB
		boolean status = false;
		try {
			if (userID != null && loID != null && requestAuthKey != null) {
				// }l[WET[o[zXĝ擾
				Environment environment = new Environment();
				String hostName = environment.getServerName();
				// ؂̂Ă鎞ԕ擾B
				ScormLoEnv scormEnv = new ScormLoEnv();
				int minuteSpan = scormEnv.getAuthenticMinuteSpan();
				// ݓ擾A̎ԕɐ؂̂ĂB
				Calendar currentTime = Calendar.getInstance();
				ScormLoUtil.truncateMinute(currentTime, minuteSpan);
				// ZoF؃L[
				String authKey = null;
				// =============================================================
				// A݂̎ԑсAO̎ԑсA̎ԑт
				// _CWFXgL[vZA
				// nꂽ_CWFXgL[ƈv邩肷B
				// ZoԑтA_CWFXgL[ZoB
				Date thisTime = currentTime.getTime();
				authKey = ScormLoUtil.makeAuthenticKey(
						userID, loID, hostName, thisTime);

				DebugLog.write(getClass(),
					"[" + thisTime + "]"
					+ "->Digest[" + authKey + "]", DebugLog.MID);
				DebugLog.write(getClass(),
					"compare Auth-Keys[" + authKey + "]"
						+ "[" + requestAuthKey + "]", DebugLog.MID);
				// _CWFXgL[v΁A̎_ŐB
				status = authKey.equals(requestAuthKey);
				// =============================================================
				// sꍇ͒O̎ԑ
				if (status == false) {
					Calendar previousCalendar = (Calendar)currentTime.clone();
					previousCalendar.add(Calendar.MINUTE, -minuteSpan);
					Date previousTime = previousCalendar.getTime();
					authKey = ScormLoUtil.makeAuthenticKey(
							userID, loID, hostName, previousTime);

					DebugLog.write(getClass(),
						"[" + previousTime + "]"
						+ "->Digest[" + authKey + "]", DebugLog.MID);
					DebugLog.write(getClass(),
						"compare Auth-Keys[" + authKey + "]"
							+ "[" + requestAuthKey + "]", DebugLog.MID);
					// _CWFXgL[v΁A̎_ŐB
					status = authKey.equals(requestAuthKey);
				}
				// =============================================================
				// sꍇ͒̎ԑ
				if (status == false) {
					Calendar nextCalendar = (Calendar)currentTime.clone();
					nextCalendar.add(Calendar.MINUTE, minuteSpan);
					Date nextTime = nextCalendar.getTime();
					authKey = ScormLoUtil.makeAuthenticKey(
							userID, loID, hostName, nextTime);

					DebugLog.write(getClass(),
						"[" + nextTime + "]"
						+ "->Digest[" + authKey + "]", DebugLog.MID);
					DebugLog.write(getClass(),
						"compare Auth-Keys[" + authKey + "]"
							+ "[" + requestAuthKey + "]", DebugLog.MID);
					// _CWFXgL[v΁A̎_ŐB
					status = authKey.equals(requestAuthKey);
				}
			}
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL authenticate("
				+ userID + "," + loID + "," + requestAuthKey + ")"
				+ (" return " + status),
			DebugLog.ROW);
		return status;
	}

	/**
	 * ID擾܂B
	 * @param loID LOIDB
	 * @return w肳ꂽLOIDɊY鋳ނ̋IDB
	 * @throws LOException ɗOꍇB
	 */
	private String getMaterialID(String loID)
			throws LOException {
		////////////////////////////////////////////////////////////////////////
		// \bhJnO
		DebugLog.write(getClass(),
			"HEAD getMaterialID(" + loID + ")", DebugLog.ROW);

		String materialID = null;
		try {
			Environment environment = new Environment();
			String serverName = environment.getLoServerName();
			ScormLoClient scormLoClient = new ScormLoClient(serverName);
			boolean result = scormLoClient.getData(loID);
			if ( result == false ) {
				throw new LOException(scormLoClient.getMessageData());
			}
			ScormLoData loData = (ScormLoData)scormLoClient.getDataInfo(0);
			// ID̎擾
			materialID = loData.getMaterialID();
		}
		catch (LOException e) {
			throw e;
		}
		catch (Exception e) {
			DebugLog.write(getClass(), e, DebugLog.HIGHT);
			throw new LOException(e.getMessage());
		}
		////////////////////////////////////////////////////////////////////////
		// \bhIO
		DebugLog.write(getClass(),
			"TAIL getMaterialID(" + loID + ")" + ( " return " + materialID ),
			DebugLog.ROW);

		return materialID;
	}
}
