/*
 * 쐬: 2005/10/20
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package jp.co.ntt.lms.otm.util;

import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import jp.co.ntt.lms.otm.sheet.SheetInfo;
import jp.co.ntt.lms.xmf.xmo.Base.Common;
import jp.co.ntt.lms.xmo.Assignments.AssignmentsClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.Method.MethodClient;
import jp.co.ntt.lms.xmo.Method.MethodData;

/**
 * 
 * OTM ł悭gp鏈W߂[eBeBNX
 * 
 * @author yasu
 *
 */
public class OTMUtil
{

	/**
	 * LOIDŎw肳ꂽ\bhz̃\bh(eLO̓\bhƂO)
	 * Vector ɓĕԋpB
	 * ԋpl MethodData(jp.co.ntt.lms.xmo.Method.MethodData) Ȃ Vector łB
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static Vector getChildMethodList(String loID) throws Exception
	{
		Vector methodList = new Vector();
		
		MethodClient objXmo = new MethodClient();
		objXmo.setLoID(loID); // e\bhLOIDw肷B
		//яɃ\[g
		objXmo.setOrderBy(LoRelationClient.TABLE_NAME + "." + LoRelationClient.SORT_NO);
		if(objXmo.getChildMethodList()) {
			while(objXmo.next()) {
				MethodData objData = objXmo.getMethodData();
				if(objData == null) break;
				methodList.add(objData);
			}
		}
		
		return methodList;
	}


	/**
	 * LOIDŎw肳ꂽ\bhz̃\bh(eLO̓\bhƂO)
	 * Vector ɓĕԋpB
	 * ȂAL[[hkeywordɊŶ݂̂ԋp
	 * ԋpl MethodData(jp.co.ntt.lms.xmo.Method.MethodData) Ȃ Vector łB
	 * 
	 * 
	 * @param loID,keyword
	 * @return
	 * @throws Exception
	 */
	public static Vector getChildMethodList(String loID, String keyword) throws Exception
	{
		// 20051208 O.Takeuchi added.
		//
		Vector methodList = new Vector();
		
		MethodClient objXmo = new MethodClient();
		objXmo.clear();		
		objXmo.setLoID(loID); // e\bhLOIDw肷B
		objXmo.setWhereString(LoClient.KEYWORD , "=", keyword);
		//яɃ\[g
		objXmo.setOrderBy(LoRelationClient.TABLE_NAME + "." + LoRelationClient.SORT_NO);
		if(objXmo.getChildMethodList()) {
			while(objXmo.next()) {
				MethodData objData = objXmo.getMethodData();
				if(objData == null) break;
				methodList.add(objData);
			}
		}
		
		return methodList;
	}
	
	/**
	 * w肵LOID \bhLÕf[^擾B
	 * Ȃ΁Anull ԋpB
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static MethodData getMethodData(String loID) throws Exception
	{
		MethodClient client = new MethodClient();
		client.clear();
		client.setWhereLoID(loID);
		client.select();
		if (client.next())
		{
			return client.getMethodData();
		}
		else
		{
			return null;
		}
	}
	
	/**
	 * w肵\bhLOMethodLOID 擾B
	 * w肵LOID ̃\bhLOȂꍇAnull ԋpB
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static String getMethodLOID(String loID) throws Exception
	{
		MethodData data = getMethodData(loID);
		if (data != null)
		{
			return data.getMethodLOID();
		}
		else
		{
			return null;
		}
	}
	
	/**
	 * w肳ꂽLÕ}eAID擾B
	 * (LO̎qɂȂĂꍇ̂݁APȏ̃}eAIDԋpB)
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static Vector getMaterialID(String loID) throws Exception {
		Vector	vcMaterialID = new Vector();
		LoRelationClient lrc = new LoRelationClient(); 
		lrc.setWhereChildID(loID);
		lrc.select();
		while( lrc.next() )
		{
			String strMaterialID = lrc.getmaterialID();
			vcMaterialID.add(strMaterialID);
		}
		return vcMaterialID;
	}
	
	/**
	 * w肳ꂽO[v̏ʃO[v̂Aw肳ꂽLOwKATCꂽ
	 * ŏʂ̃O[ṽO[vID擾B
	 * 
	 * Ȃꍇ́Anull ԋpB
	 * 
	 * @param groupID
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static String getAssigneeTopGroupID(String groupID, String loID) throws Exception
	{
		String materialID = null;
		Vector materialVector = getMaterialID(loID);
		if (materialVector.size() < 1)
		{
			throw new Exception("LOID " + loID + " ̃}eAID擾ł܂B");
		}
		materialID = (String)materialVector.get(0);
		
		String childID = null;
		String parentID = groupID;
		
		String result = null;
		AssignmentsClient assignClient = new AssignmentsClient();
		while (!parentID.equals(Common.GROUP_ROOT))
		{
			childID = groupID;
			groupID = parentID;
			parentID = getParentGroupID(groupID);
			
			//̃O[vɑ΂Ďw肵LOwKATCĂ邩
			assignClient.clear();
			assignClient.setWhereLearnAuthority();
			assignClient.setMaterialID(materialID);
			assignClient.setWhereMemberShipID(parentID + groupID);
			assignClient.select();
			if (!assignClient.next())
			{
				//wKATCĂȂ
				//̎_ł childID ̒l擾ׂO[vID
				result = childID;
				break;
			}
			else
			{
				//wKATCĂ
				result = groupID;
			}
		}
		
		return result;
	}

	/**
	 * w肳ꂽO[v ̐eO[vID 擾B
	 * eȂꍇAnull ԋpB
	 * 
	 * @param groupID O[vID
	 * @return
	 * @throws Exception
	 */
	public static String getParentGroupID(String groupID) throws Exception
	{
		GroupAndPeopleClient client = new GroupAndPeopleClient();
		client.setWhereChildID(groupID);
		client.select();
		if (client.next())
		{
			return client.getParentID();
		}
		else
		{
			return null;
		}
	}
	
	/**
	 * w肳ꂽLO̐eLOLOID擾B
	 * ȂꍇAnull ԋpB
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static String getParentLOID(String loID) throws Exception
	{
		LoRelationClient client = new LoRelationClient();
		client.clear();
		client.setWhereChildID(loID);
		client.select();
		if (client.next())
		{
			return client.getParentID();
		}
		else
		{
			return null;
		}
	}

	/**
	 * w肳ꂽLÕ}eAID̃Xg擾B
	 * (LO̎qɂȂĂꍇ̂݁APȏ̃}eAIDԋpB)
	 * 
	 * @param loID
	 * @return
	 * @throws Exception
	 */
	public static Vector getMaterial(String loID) throws Exception {
		Vector	vcMaterialID = new Vector();
		LoRelationClient lrc = new LoRelationClient(); 
		lrc.setWhereChildID(loID);
		lrc.select();
		while( lrc.next() ) {
			String strMaterialID = lrc.getmaterialID();
			vcMaterialID.add(strMaterialID);
		}
		return vcMaterialID;
	}

	/**
	 * w肳ꂽO[v̊OID 擾B
	 * 
	 * Ȃꍇ́Anull ԋpB
	 * 
	 * @param loID
	 * @return
	 */
	public static String getGroupForeignID(String groupID) throws Exception
	{
		String foreignID = null;
		GroupsClient gClient = new GroupsClient();
		gClient.setWhereGroupID(groupID);
		if (gClient.select())
		{
			if (gClient.next())
			{
				foreignID = gClient.getForeignID();
			}
		}
		gClient = null;
		
		return foreignID;
	}
	
	/**
	 * w肳ꂽ[U[܂̓O[vǂ̃O[vɏ邩
	 * o[Vbv܂ Hashtable 擾B
	 * 
	 * o[VbvID L[ƂAO[vID lƂ Hashtable 
	 * ԋpB
	 * 
	 * @param childID    [U[ID ܂ O[vID w肷B
	 * @return
	 * @throws Exception
	 */
	public static Hashtable getMembershipHash(String childID) throws Exception
	{
		Hashtable membershipHash = new Hashtable();

		GroupAndPeopleClient gapc = new GroupAndPeopleClient(); 
		gapc.setWhereChildID(childID);
		gapc.select();
		while( gapc.next() )
		{
			String strMembershipID = gapc.getMemberShipID();
			//vcMembership.add(strMembershipID);
			if (!membershipHash.containsKey(strMembershipID))
			{
				membershipHash.put(strMembershipID, gapc.getParentID());
			}
		}
		
		return membershipHash;
	}

	/**
	 * w肳ꂽO[ṽo[Vbv܂ Hashtable 擾B
	 * 
	 * o[VbvID L[ƂA[U[ID ܂ O[vID lƂ
	 * Hashtable ԋpB
	 * 
	 * @param parentID    O[vID w肷B
	 * @return
	 * @throws Exception
	 */
	public static Hashtable getChildMembershipHash(String parentID) throws Exception
	{
		Hashtable membershipHash = new Hashtable();

		GroupAndPeopleClient gapc = new GroupAndPeopleClient();
		gapc.clear();
		gapc.setWhereParentID(parentID);
		gapc.select();
		while( gapc.next() )
		{
			String strMembershipID = gapc.getMemberShipID();
			if (!membershipHash.containsKey(strMembershipID))
			{
				membershipHash.put(strMembershipID, gapc.getChildID());
			}
		}
		
		return membershipHash;
	}

	/**
	 * w肳ꂽ[U[̎w肳ꂽLÕXe[^X擾B
	 * 
	 * @param userID
	 * @param loID
	 * 
	 * @return
	 * @throws Exception
	 */
	public static int getLOStatus(String userID, String loID) throws Exception
	{
		LoClient lo = new LoClient();
		int status = 0;
		if( !lo.checkStatus(loID, userID) )
		{
			throw new Exception(lo.getMessage());
		}
		status = lo.getStatus();
		
		return status;
	}


	/**
	 * w肳ꂽo[VbvID O[vID 擾B
	 * o[VbvID  ԋpO[ṽo[VbvIDB
	 * 
	 * @param membershipID
	 * @return
	 */
	public static String getGroupID(String membershipID)
	{
		if (membershipID != null)
		{
			return membershipID.substring(0, 8);
		}
		else
		{
			return null;
		}
	}

	/**
	 * w肳ꂽO[vID̃O[vԂB
	 * @param strGroupID O[vIDB
	 * @return O[vBw肳ꂽO[vID̃O[v݂ȂƂ nullB
	 * @throws Exception
	 */
	public static String getGroupName(String strGroupID)
		throws Exception
	{
		// NCAg̃CX^X
		GroupsClient objClient = new GroupsClient();
		
		// O[vIDɐݒ肷
		objClient.setWhereGroupID(strGroupID);
		
		// s
		if (objClient.select() == false)
		{
			throw new Exception(objClient.getMessage());
		}
		
		if (objClient.next() == true)
		{
			return objClient.getGroupName();
		}
		
		return null;
	}
	
	/**
	 * w肳ꂽo[VbvID  }eAID ̃ATC
	 * Hashtable Ɋi[ĕԋpB
	 * 
	 * assignid : ATCID
	 * study_start_date
	 * enddate
	 * assigner
	 * learn_authority
	 * management_authority
	 * opening_date
	 * closing_date
	 * study_limit_count
	 * study_count
	 * method_flag
	 * 
	 * @param membershipID
	 * @param materialID
	 * @return
	 * @throws Exception
	 */
	public static Hashtable getAssignData(String membershipID, String materialID) throws Exception
	{
	    Hashtable result = null;
	    
	    AssignmentsClient client = new AssignmentsClient();
	    client.setWhereMemberShipID(membershipID);
	    client.setWhereMaterialID(materialID);
	    
	    if (client.select() == false)
	    {
	        throw new Exception(client.getMessage());
	    }
	    
	    if (client.next())
	    {
	        result = new Hashtable();
	        putToHash("assignid", client.getAssignID(), result);
	        putToHash("study_start_date", client.getStudyStartDate(), result);
	        putToHash("enddate", client.getEndDate(), result);
	        putToHash("assigner", client.getAssigner(), result);
	        putToHash("learn_authority", client.getLearnAuthority(), result);
	        putToHash("management_authority", client.getManagementAuthority(), result);
	        putToHash("opening_date", client.getOpeningDate(), result);
	        putToHash("closing_date", client.getClosingDate(), result);
	        putToHash("study_limit_count", client.getStudyLimitCount(), result);
	        putToHash("study_count", client.getStudyCount(), result);
	        putToHash("method_flag", client.getMethodFlag(), result);
	    }
	    
	    return result;
	}
	
	private static void putToHash(String key, Object value, Hashtable hash)
	{
	    if (value != null)
	    {
	        hash.put(key, value);
	    }
	}
	
	/**
	 * V[g擾
	 * 
	 * @param userId
	 * @param sheetType
	 * @param methodId
	 * @param sheetLoID
	 * @return
	 * @throws Exception
	 */
	public static SheetInfo getSheetInfo(String userId, String sheetType, String methodId, String sheetLoID)
		throws Exception {
		System.out.println("userId : " + userId);
		System.out.println("sheetType : " + sheetType);
		System.out.println("methodId : " + methodId);
		System.out.println("sheetLoID : " + sheetLoID);
		
		
		SheetInfo sheetInfo = new SheetInfo();
		sheetInfo.setUserId(userId);
		sheetInfo.setMethodId(methodId);
		sheetInfo.setSheetLoID(sheetLoID);
		sheetInfo.setSheetType(sheetType);
		
		// materialId擾
		String materialId = null;
		String childLoID = sheetLoID;
		String parentLoID = getParentLOID(childLoID);
		while (parentLoID != null) {
			materialId = parentLoID + childLoID;
			System.out.println("materialId : " + materialId);
			
			childLoID = parentLoID;
			parentLoID = getParentLOID(childLoID);
		}
		
		// membershipId 擾
		Hashtable memberships = getMembershipHash(userId);
		for (Iterator it = memberships.keySet().iterator(); it.hasNext();) {
			String membership = (String)it.next();
			System.out.println("membership : " + membership);
			
			// ATC擾
			Hashtable assignData = getAssignData(membership, materialId);
			if (assignData == null) continue;
			
			sheetInfo.setOpeningDate((Date)assignData.get("opening_date"));
			sheetInfo.setClosingDate((Date)assignData.get("closing_date"));
			sheetInfo.setAssignId((String)assignData.get("assignid"));
			break; // 1sڂ̂
		}
		
		return sheetInfo;
	}
}
