/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	[U[EO[vELOݒ菈 Velcity ToolNX
//
//		ύX
//			2005.02.19  VK쐬   
//
//	@\
//
//	̃NX̓[U[EO[vELOݒ菈sVelocity ToolNXłB
//
////////////////////////////////////////////////////////////////

package jp.co.ntt.lms.xmf.tools;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;
import jp.co.ntt.lms.xmo.Lo.HistoryData;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.People.PeopleClient;
import jp.co.ntt.lms.xmo.RoleAssignments.RoleAssignmentsClient;
import jp.co.ntt.lms.xmo.Roles.RolesClient;
import jp.co.ntt.lms.xms.framework.XmsInnerException;

/**
 * URL񑀍 Velocity ToolNX
 * 
 * ̃NX̓[U[EO[vELOrequest ReLXg<BR>
 * ݒ菈s߂ Velocity ToolNXłB
 * 
 * @author  
 * @version 1.0
 */
public class ViewItemInfoTool
{
	/**
	 * w肵ID [U[IDǂ𔻒f
	 * 
	 * @param id ID
	 * @return [U[IDǂtO
	 */
	public boolean isUserId(String id)
	{
		if (id != null)
		{
			return id.startsWith("PE");
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * w肵ID O[vID ǂ𔻒fB
	 * 
	 * @param id ID
	 * @return O[vIDǂtO
	 */
	public boolean isGroupId(String id)
	{
		if (id != null)
		{
			return id.startsWith("GR");
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * w肵ID  LO ID ǂ𔻒fB
	 * 
	 * @param id ID
	 * @return LO ID ǂtOB
	 */
	public boolean isLoId(String id)
	{
		if (id != null)
		{
			return id.startsWith("LO");
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * w肵[U[̃[U[ request ReLXgɐݒ肷B
	 * ȉ̑ request ReLXgɐݒ肳B
	 * 
	 *   prefix + "_userinfo_loginid" OCID
     *   prefix + "_userinfo_foreignid" OID
     *   prefix + "_userinfo_username" [U[
     *   prefix + "_userinfo_readingname" [U[Ji
     *   prefix + "_userinfo_custommsgdir" Rg
     *   prefix + "_userinfo_groupname" O[v
     *   prefix + "_userinfo_groupid" O[vID
     *   prefix + "_userinfo_roleid_list" ATCĂ郍[ID̃Xg
     *   prefix + "_userinfo_rolegroupid_list" ATCĂ郍[̃O[vID ̃Xg
     * 											́A[ID ̃Xg̏ɑΉB
     *   prefix + "_userinfo_rolename_list" ATCĂ郍[̃Xg	
     * 											́A[ID ̃Xg̏ɑΉB
     *   prefix + "_userinfo_rolegroupname_list" ATCĂ [̃O[ṽXg	
     * 											́A[ID ̃Xg̏ɑΉB
     *
	 * @param userId [U[ID
	 * @param request NGXg
	 * @param prefix vtBbNXB̃vtBbNXƂĎgpB
	 * @throws Exception
	 */
    public void setUserInfo(String userId, HttpServletRequest request, String prefix) throws Exception
    {
        //[U[̎擾
        PeopleClient pClient = new PeopleClient();
        pClient.setWhereUserID(userId);
        if (!pClient.select())
        {
            // G[
            throw new XmsInnerException("[U[ID烆[U[񂪎擾ł܂B");
        }
        if (!pClient.next())
        {
            // G[
            throw new XmsInnerException("[U[ID擾郆[U[񂪂܂B");
        }
        String userName = pClient.getUserName();
        String userLoginId = pClient.getLoginID();
        String userReadingName = pClient.getReadingName();
        String userCustomMsgDir = pClient.getCustomMsgDir();
        String userForeignId = pClient.getForeignID();

        //O[vID̎擾
        String groupId = "";
        GroupAndPeopleClient gpClient = new GroupAndPeopleClient();
        gpClient.setWhereChildID(userId);
        if (gpClient.select())
        {
            if (gpClient.next())
            {
                groupId = gpClient.getParentID();
            }
        }

        //O[v̎擾
        String groupName = "";
        GroupsClient gsClient = new GroupsClient();
        if (groupId.length() > 0)
        {
            gsClient.setWhereGroupID(groupId);
            if (!gsClient.select())
            {
                // G[
                throw new XmsInnerException("O[vIDO[v񂪎擾ł܂B");
            }
            if (!gsClient.next())
            {
                // G[
                throw new XmsInnerException("O[vID擾O[v񂪂܂B");
            }
            groupName = gsClient.getGroupName();
        }
        else
        {
            groupName = "";
        }

        //[̎擾
        RoleAssignmentsClient raClient = new RoleAssignmentsClient();
        raClient.setWhereUserID(userId);
        ArrayList roleIdList = new ArrayList();
        ArrayList roleGroupIdList = new ArrayList();
        if (raClient.select())
        {
            int count = raClient.getResultCount();
            for (int i=0; i < count; i++)
            {
                raClient.next();
                roleIdList.add(raClient.getRoleID());
                roleGroupIdList.add(raClient.getGroupID());
            }
        }
        
        ArrayList roleNameList = new ArrayList();
        RolesClient rolesClient = new RolesClient();
        for (int i=0; i < roleIdList.size(); i++)
        {
            rolesClient.clear();
            rolesClient.setWhereRoleID((String)roleIdList.get(i));
            if (rolesClient.select())
            {
                rolesClient.next();
                roleNameList.add(rolesClient.getRoleName());
            }
        }
        
        ArrayList roleGroupNameList = new ArrayList();
        for (int i=0; i < roleGroupIdList.size(); i++)
        {
            gsClient.clear();
            gsClient.setWhereGroupID((String)roleGroupIdList.get(i));
            if (gsClient.select())
            {
                gsClient.next();
                roleGroupNameList.add(gsClient.getGroupName());
            }
        }
        
        request.setAttribute(prefix + "_userinfo_loginid", userLoginId);
        request.setAttribute(prefix + "_userinfo_foreignid", userForeignId);
        request.setAttribute(prefix + "_userinfo_username", userName);
        request.setAttribute(prefix + "_userinfo_readingname", userReadingName);
        request.setAttribute(prefix + "_userinfo_custommsgdir", userCustomMsgDir);        
        request.setAttribute(prefix + "_userinfo_groupname", groupName);
        request.setAttribute(prefix + "_userinfo_groupid", groupId);
        request.setAttribute(prefix + "_userinfo_roleid_list", roleIdList);
        request.setAttribute(prefix + "_userinfo_rolegroupid_list", roleGroupIdList);
        request.setAttribute(prefix + "_userinfo_rolename_list", roleNameList);
        request.setAttribute(prefix + "_userinfo_rolegroupname_list", roleGroupNameList);
    }
    
    /**
	 * w肵O[ṽO[v request ReLXgɐݒ肷B
	 * ȉ̑ request ReLXgɐݒ肳B
	 * 
	 * prefix + "_groupinfo_foreignid" OID
     * prefix + "_groupinfo_groupname" O[v
     * prefix + "_groupinfo_custommsgdir" Rg
     * 
     * @param groupId O[vID
     * @param request NGXg
     * @param prefix vtBbNXB̃vtBbNXƂĎgpB
     * @throws Exception
     */
    public void setGroupInfo(String groupId, HttpServletRequest request, String prefix) throws Exception
    {
    	if (groupId == null)
    	{
    		return;
    	}
        //O[v̎擾
        String groupName = "";
        String groupForeignId = "";
        String groupCustomMsgDir = "";
        
        GroupsClient gsClient = new GroupsClient();
        if (groupId.length() > 0)
        {
            gsClient.setWhereGroupID(groupId);
            if (!gsClient.select())
            {
                // G[
                throw new XmsInnerException("O[vIDO[v񂪎擾ł܂B");
            }
            if (!gsClient.next())
            {
                // G[
                throw new XmsInnerException("O[vID擾O[v񂪂܂B");
            }
            groupName = gsClient.getGroupName();
            groupForeignId = gsClient.getForeignID();
            groupCustomMsgDir = gsClient.getCustomMsgDir();
        }
        
        request.setAttribute(prefix + "_groupinfo_foreignid", groupForeignId);
        request.setAttribute(prefix + "_groupinfo_groupname", groupName);
        request.setAttribute(prefix + "_groupinfo_custommsgdir", groupCustomMsgDir);        
    }
    
    /**
	 * w肵LOLO request ReLXgɐݒ肷B
	 * ȉ̑ request ReLXgɐݒ肳B
	 * 
	 *	prefix + "_loinfo_foreignid" OID
     *  prefix + "_loinfo_title" ^Cg
     *  prefix + "_loinfo_keyword" L[[h
     *  prefix + "_loinfo_version" o[W
     *  prefix + "_loinfo_realloid" Real LO ID
     *  prefix + "_loinfo_entrydate" o^
     *  prefix + "_loinfo_entryusername" o^[U[
     *  prefix + "_loinfo_entryloginid" o^[U[OCID
     *  prefix + "_loinfo_lastdate" ŏIXV
     *  prefix + "_loinfo_lastusername" ŏIXV[U[
     *  prefix + "_loinfo_lastloginid" ŏIXV[U[OCID
     *  prefix + "_loinfo_renewcount" XV
     *  prefix + "_loinfo_explanation" 
     * 
     * @param loId LO ID
     * @param request NGXg
     * @param prefix vtBbNXB̃vtBbNXƂĎgpB
     * @throws Exception
     */
    public void setLoInfo(String loId, HttpServletRequest request, String prefix) throws Exception
    {
    	if (loId == null)
    	{
    		return;
    	}
    	
    	LoClient loClient = new LoClient();
    	loClient.setWhereLoID(loId);
    	
    	String loForeignId = "";
    	String loTitle = "";
    	String loKeyword = "";
    	String loVersion = "";
    	String loEntryDate = "";
    	String loEntryUserName = "";
    	String loEntryLoginId = "";
    	String loLastDate = "";
    	String loLastUserName = "";
    	String loLastLoginId = "";
    	String loRenewCount = "";
    	String loRealLoId = "";
    	String loExplanation = "";
    	
    	if (loClient.select())
    	{
    		if (loClient.next())
    		{
    			loForeignId = loClient.getForeignID();
    			loTitle 	= loClient.getLoTytle();
    			loKeyword 	= loClient.getKeyWord();
    			loVersion 	= loClient.getLoVersion();
    			loRealLoId  = loClient.getRealLOID();
    			loExplanation = loClient.getLoExplanation();
    			if (loClient.selectHistory(loRealLoId))
    			{
        			HistoryData historyData = (HistoryData) loClient.getHistory();
        			loEntryDate 	= historyData.getEntryDate();		//o^
        			loEntryUserName	= historyData.getEntryUserName();	//o^
        			loEntryLoginId	= historyData.getEntryLoginID();	//o^ID
        			loLastDate 		= historyData.getLastDate(); 		//ŏIXV
        			loLastUserName	= historyData.getLastUserName();	//ŏIXV
        			loLastLoginId	= historyData.getLastLoginID();		//XVID
        			loRenewCount	= historyData.getRenewCnt();		//XV
    			}
    		}
    	}
    	
        request.setAttribute(prefix + "_loinfo_foreignid", loForeignId);
        request.setAttribute(prefix + "_loinfo_title", loTitle);
        request.setAttribute(prefix + "_loinfo_keyword", loKeyword);
        request.setAttribute(prefix + "_loinfo_version", loVersion);
        request.setAttribute(prefix + "_loinfo_realloid", loRealLoId);
        request.setAttribute(prefix + "_loinfo_entrydate", loEntryDate);
        request.setAttribute(prefix + "_loinfo_entryusername", loEntryUserName);
        request.setAttribute(prefix + "_loinfo_entryloginid", loEntryLoginId);
        request.setAttribute(prefix + "_loinfo_lastdate", loLastDate);
        request.setAttribute(prefix + "_loinfo_lastusername", loLastUserName);
        request.setAttribute(prefix + "_loinfo_lastloginid", loLastLoginId);
        request.setAttribute(prefix + "_loinfo_renewcount", loRenewCount);
        request.setAttribute(prefix + "_loinfo_explanation", loExplanation);
    }
}
