#/bin/sh
#-----------------------------------------------------
# Function : runXmsII.sh
# Revision : 2004.02.16 T.Nozawa
#-----------------------------------------------------

#----------------------------------
#---- set enviroment --------------
HOME_PATH=${LMS_HOME}/WEB-INF/classes
RUNLO_PID_FILE=${HOME_PATH}/runLoAll.PID
RUNXMO_PID_FILE=${HOME_PATH}/runXmoAll.PID
classpath=${HOME_PATH}:${HOME_PATH}/../lib/xercesImpl.jar:${HOME_PATH}/../lib/xmlParserAPIs.jar:${HOME_PATH}/../lib/xcmi.jar:./:${HOME_PATH}/../lib/msbase.jar:${HOME_PATH}/../lib/mssqlserver.jar:${HOME_PATH}/../lib/msutil.jar:${HOME_PATH}/../lib/pg74.1jdbc3.jar:${HOME_PATH}/../lib/commons-lang-2.0.jar:${HOME_PATH}/../lib/activation.jar:${HOME_PATH}/../lib/mail.jar:${HOME_PATH}/../lib/soap.jar:${HOME_PATH}/../lib/classes12.jar:${HOME_PATH}/../lib/velocity-dep-1.3.1.jar:${HOME_PATH}/../lib/velocity-tools-view-1.1.jar:${HOME_PATH}/../lib/velocity-tools-1.1.jar:${HOME_PATH}/../lib/velocity-tools-generic-1.1.jar:${HOME_PATH}/../lib/avalon-framework-cvs-20020806.jar:${HOME_PATH}/../lib/fop.jar

#----------------------------------
#---- XMS START -------------------
case "$1" in
 start)
	#--- lo  start ---
	$JAVA_HOME/bin/java  -Xms256m -Xmx1536m -classpath ${classpath}  -Djava.security.policy=${HOME_PATH}/policy -Djava.rmi.server.codebase=file:${HOME_PATH}/ jp.co.ntt.lms.lo.LoStart &
	if [ $? == 0 ]
	then
		rm -f $RUNLO_PID_FILE
		echo $! > $RUNLO_PID_FILE
	fi
	#--- xmo start ---
	$JAVA_HOME/bin/java  -Xms256m -Xmx768m -classpath ${classpath} -Djava.security.policy=${HOME_PATH}/policy -Djava.rmi.server.codebase=file:${classpath}/ jp.co.ntt.lms.xmo.Base.XMSBaseStart &
	if [ $? == 0 ]
	then
		rm -f $RUNXMO_PID_FILE
		echo $! > $RUNXMO_PID_FILE
	fi
	;;
 stop)
	#--- lo  stop ---
	if [ -f $RUNLO_PID_FILE ]
	then
		kill `cat $RUNLO_PID_FILE`
		rm -f $RUNLO_PID_FILE
	fi
	#--- xmo stop ---
	$JAVA_HOME/bin/java -classpath ${classpath} -Djava.security.policy=${HOME_PATH}/policy -Djava.rmi.server.codebase=file:${HOME_PATH}/ jp.co.ntt.lms.xmo.Base.XMSBaseShutDown
	rm -f $RUNXMO_PID_FILE
	;;
 status)
	if [ -f $RUNLO_PID_FILE ]
	then
		echo "LoStart      status ------ running PID:`cat $RUNLO_PID_FILE`"
	else
		echo "LoStart      status ------ Not running"
	fi
	if [ -f $RUNXMO_PID_FILE ]
	then
		echo "XMSBaseStart status ------ running PID:`cat $RUNLO_PID_FILE`"
	else
		echo "XMSBaseStart status ------ Not running"
	fi
	;;
 *)
	echo $"Usage: $prog {start|stop|status}"
	exit 1
esac

exit $RETVAL

