/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.xml.sax.SAXException;

public class ValidatorPlugIn
implements PlugIn {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$struts$validator$ValidatorPlugIn == null ? (class$org$apache$struts$validator$ValidatorPlugIn = ValidatorPlugIn.class$("org.apache.struts.validator.ValidatorPlugIn")) : class$org$apache$struts$validator$ValidatorPlugIn));
    private ModuleConfig config = null;
    private ActionServlet servlet = null;
    private static final String RESOURCE_DELIM = ",";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.VALIDATOR_RESOURCES";
    public static final String STOP_ON_ERROR_KEY = "org.apache.struts.validator.STOP_ON_ERROR";
    protected ValidatorResources resources = null;
    private String pathnames = null;
    private boolean stopOnFirstError = true;
    static /* synthetic */ Class class$org$apache$struts$validator$ValidatorPlugIn;

    public String getPathnames() {
        return this.pathnames;
    }

    public void setPathnames(String pathnames) {
        this.pathnames = pathnames;
    }

    public boolean isStopOnFirstError() {
        return this.stopOnFirstError;
    }

    public void setStopOnFirstError(boolean stopOnFirstError) {
        this.stopOnFirstError = stopOnFirstError;
    }

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.config = config;
        this.servlet = servlet;
        try {
            this.initResources();
            servlet.getServletContext().setAttribute(VALIDATOR_KEY + config.getPrefix(), (Object)this.resources);
            servlet.getServletContext().setAttribute("org.apache.struts.validator.STOP_ON_ERROR." + config.getPrefix(), (Object)(this.stopOnFirstError ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UnavailableException("Cannot load a validator resource from '" + this.pathnames + "'");
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying ValidatorPlugin");
        }
        this.servlet = null;
        this.config = null;
        this.destroyResources();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initResources() throws IOException, ServletException {
        Iterator streamIterator2222;
        if (this.pathnames == null || this.pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.pathnames, RESOURCE_DELIM);
        ArrayList<BufferedInputStream> streamList = new ArrayList<BufferedInputStream>();
        try {
            try {
                while (st.hasMoreTokens()) {
                    InputStream input;
                    String validatorRules = st.nextToken().trim();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loading validation rules file from '" + validatorRules + "'"));
                    }
                    if ((input = this.servlet.getServletContext().getResourceAsStream(validatorRules)) == null) {
                        throw new ServletException("Skipping validation rules file from '" + validatorRules + "'.  No stream could be opened.");
                    }
                    BufferedInputStream bis = new BufferedInputStream(input);
                    streamList.add(bis);
                }
                int streamSize = streamList.size();
                InputStream[] streamArray = new InputStream[streamSize];
                for (int streamIndex = 0; streamIndex < streamSize; ++streamIndex) {
                    InputStream is;
                    streamArray[streamIndex] = is = (InputStream)streamList.get(streamIndex);
                }
                this.resources = new ValidatorResources(streamArray);
            }
            catch (SAXException sex) {
                log.error((Object)"Skipping all validation", (Throwable)sex);
                throw new ServletException((Throwable)sex);
            }
            Object var8_10 = null;
            streamIterator2222 = streamList.iterator();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            Iterator streamIterator2222 = streamList.iterator();
            while (true) {
                if (!streamIterator2222.hasNext()) {
                    throw throwable;
                }
                InputStream is = (InputStream)streamIterator2222.next();
                is.close();
            }
        }
        while (streamIterator2222.hasNext()) {
            InputStream is = (InputStream)streamIterator2222.next();
            is.close();
        }
        return;
    }

    protected void destroyResources() {
        this.resources = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

