/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberTool {
    public static final String DEFAULT_FORMAT = "default";
    private static final int STYLE_NUMBER = 0;
    private static final int STYLE_CURRENCY = 1;
    private static final int STYLE_PERCENT = 2;
    private static final int STYLE_INTEGER = 4;

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getFormat() {
        return DEFAULT_FORMAT;
    }

    public String format(Object obj) {
        return this.format(this.getFormat(), obj);
    }

    public String format(String format, Object obj) {
        return this.format(format, obj, this.getLocale());
    }

    public String format(String format, Object obj, Locale locale) {
        Number number = this.toNumber(obj);
        NumberFormat nf = this.getNumberFormat(format, locale);
        if (number == null || nf == null) {
            return null;
        }
        return nf.format(number);
    }

    public NumberFormat getNumberFormat(String format, Locale locale) {
        if (format == null) {
            return null;
        }
        NumberFormat nf = null;
        int style = this.getStyleAsInt(format);
        nf = style < 0 ? new DecimalFormat(format, new DecimalFormatSymbols(locale)) : this.getNumberFormat(style, locale);
        return nf;
    }

    protected NumberFormat getNumberFormat(int numberStyle, Locale locale) {
        try {
            NumberFormat nf;
            switch (numberStyle) {
                case 0: {
                    nf = NumberFormat.getNumberInstance(locale);
                    break;
                }
                case 1: {
                    nf = NumberFormat.getCurrencyInstance(locale);
                    break;
                }
                case 2: {
                    nf = NumberFormat.getPercentInstance(locale);
                    break;
                }
                case 4: {
                    nf = this.getIntegerInstance(locale);
                    break;
                }
                default: {
                    nf = null;
                }
            }
            return nf;
        }
        catch (Exception suppressed) {
            return null;
        }
    }

    private NumberFormat getIntegerInstance(Locale locale) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        format.setMaximumFractionDigits(0);
        format.setDecimalSeparatorAlwaysShown(false);
        format.setParseIntegerOnly(true);
        return format;
    }

    protected int getStyleAsInt(String style) {
        if (style == null || style.length() < 6 || style.length() > 8) {
            return -1;
        }
        if (style.equalsIgnoreCase(DEFAULT_FORMAT)) {
            return 0;
        }
        if (style.equalsIgnoreCase("number")) {
            return 0;
        }
        if (style.equalsIgnoreCase("currency")) {
            return 1;
        }
        if (style.equalsIgnoreCase("percent")) {
            return 2;
        }
        if (style.equalsIgnoreCase("integer")) {
            return 4;
        }
        return -1;
    }

    public Number toNumber(Object obj) {
        return this.toNumber(this.getFormat(), obj, this.getLocale());
    }

    public Number toNumber(String format, Object obj) {
        return this.toNumber(format, obj, this.getLocale());
    }

    public Number toNumber(String format, Object obj, Locale locale) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        try {
            NumberFormat parser = this.getNumberFormat(format, locale);
            return parser.parse(String.valueOf(obj));
        }
        catch (Exception e) {
            return null;
        }
    }
}

