/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.extensions.ExtEmbeddedConnection;
import com.microsoft.jdbcx.base.BaseCallableStatementWrapper;
import com.microsoft.jdbcx.base.BaseDatabaseMetaDataWrapper;
import com.microsoft.jdbcx.base.BaseDependents;
import com.microsoft.jdbcx.base.BasePooledConnection;
import com.microsoft.jdbcx.base.BasePreparedStatementWrapper;
import com.microsoft.jdbcx.base.BaseResultSetWrapper;
import com.microsoft.jdbcx.base.BaseStatementWrapper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Map;

public abstract class BaseConnectionWrapper
implements Connection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   1.0.1.1  $";
    protected Connection realConnection;
    protected SQLWarning warnings;
    protected BaseDependents statementDependents;
    protected BaseDependents resultSetDependents;
    protected BaseDependents databaseMetaDataDependents;
    BaseExceptions exceptions;
    protected BasePooledConnection pooledConnection;

    protected BaseConnectionWrapper(Connection connection, BaseExceptions baseExceptions) {
        this.realConnection = connection;
        this.exceptions = baseExceptions;
        this.statementDependents = new BaseDependents();
        this.resultSetDependents = new BaseDependents();
        this.databaseMetaDataDependents = new BaseDependents();
        this.pooledConnection = (BasePooledConnection)connection;
    }

    void addDependent(BaseResultSetWrapper baseResultSetWrapper) {
        this.resultSetDependents.add(baseResultSetWrapper);
    }

    public void clearWarnings() throws SQLException {
        try {
            this.realConnection.clearWarnings();
        }
        catch (NullPointerException nullPointerException) {
            this.warnings = null;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public abstract void close() throws SQLException;

    protected SQLException closedException() {
        return this.exceptions.getException(6010);
    }

    public void commit() throws SQLException {
        try {
            this.realConnection.commit();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        try {
            Statement statement = this.realConnection.createStatement();
            BaseStatementWrapper baseStatementWrapper = new BaseStatementWrapper(this, statement);
            this.statementDependents.add(baseStatementWrapper);
            return baseStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            Statement statement = this.realConnection.createStatement(n, n2);
            BaseStatementWrapper baseStatementWrapper = new BaseStatementWrapper(this, statement);
            return baseStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            return this.realConnection.getAutoCommit();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        try {
            return this.realConnection.getCatalog();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            DatabaseMetaData databaseMetaData = this.realConnection.getMetaData();
            BaseDatabaseMetaDataWrapper baseDatabaseMetaDataWrapper = (BaseDatabaseMetaDataWrapper)this.databaseMetaDataDependents.getDependent(databaseMetaData);
            if (baseDatabaseMetaDataWrapper == null) {
                baseDatabaseMetaDataWrapper = new BaseDatabaseMetaDataWrapper(databaseMetaData, this);
                this.databaseMetaDataDependents.add(baseDatabaseMetaDataWrapper);
            }
            return baseDatabaseMetaDataWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            return this.realConnection.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            return this.realConnection.getTypeMap();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.realConnection.getWarnings();
        }
        catch (NullPointerException nullPointerException) {
            return this.warnings;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            return this.realConnection.isClosed();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            return this.realConnection.isReadOnly();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        try {
            return this.realConnection.nativeSQL(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    void notifyMetaDataGarbage() {
        this.databaseMetaDataDependents.notifyGarbage();
    }

    void notifyResultSetGarbage() {
        this.resultSetDependents.notifyGarbage();
    }

    void notifyStatementGarbage() {
        this.statementDependents.notifyGarbage();
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            CallableStatement callableStatement = this.realConnection.prepareCall(string);
            BaseCallableStatementWrapper baseCallableStatementWrapper = new BaseCallableStatementWrapper(this, callableStatement);
            this.statementDependents.add(baseCallableStatementWrapper);
            return baseCallableStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            CallableStatement callableStatement = this.realConnection.prepareCall(string, n, n2);
            BaseCallableStatementWrapper baseCallableStatementWrapper = new BaseCallableStatementWrapper(this, callableStatement);
            return baseCallableStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.realConnection.prepareStatement(string);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            this.statementDependents.add(basePreparedStatementWrapper);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            PreparedStatement preparedStatement = this.realConnection.prepareStatement(string, n, n2);
            BasePreparedStatementWrapper basePreparedStatementWrapper = new BasePreparedStatementWrapper(this, preparedStatement);
            return basePreparedStatementWrapper;
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    void removeFromDependents(BaseDatabaseMetaDataWrapper baseDatabaseMetaDataWrapper) {
        this.databaseMetaDataDependents.remove(baseDatabaseMetaDataWrapper);
    }

    void removeFromDependents(BaseResultSetWrapper baseResultSetWrapper) {
        this.resultSetDependents.remove(baseResultSetWrapper);
    }

    void removeFromDependents(BaseStatementWrapper baseStatementWrapper) {
        this.statementDependents.remove(baseStatementWrapper);
    }

    public void rollback() throws SQLException {
        try {
            this.realConnection.rollback();
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.realConnection.setAutoCommit(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setCatalog(String string) throws SQLException {
        try {
            this.realConnection.setCatalog(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        try {
            this.realConnection.setReadOnly(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        try {
            this.realConnection.setTransactionIsolation(n);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.realConnection.setTypeMap(map);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }

    public boolean unlock(String string) throws SQLException {
        try {
            return ((ExtEmbeddedConnection)((Object)this.realConnection)).unlock(string);
        }
        catch (NullPointerException nullPointerException) {
            throw this.closedException();
        }
        catch (SQLException sQLException) {
            if (this.pooledConnection != null && sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                this.pooledConnection.connectionErrorOccurred(sQLException);
            }
            throw sQLException;
        }
    }
}

