/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	vm[hNX
//			ύX
//				2004.01.08	VK쐬	R땶
//
package jp.co.ntt.lms.Common.status.conclusion;

import java.util.Vector;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * vm[hNXłB<BR>
 * @author 񞊒q
 * @version 0.0.0.1
 */
class ConclusionNode implements DecideConclusion, ConclusionMessage {

	/** vێ܂ */
	private ConclusionData mobjConclusionData;

	/**
	 * m[h^Cvێ܂<BR>
	 * ftHgŘ_a^CvłB
	 */
	private int mintNodeType = OR_TYPE;

	/** qm[hXgێ܂ */
	private Vector mvecChildList;

	/** _a(OR)m[h^CvłB*/
	private static final int OR_TYPE = 0;

	/** _(AND)m[h^CvłB*/
	private static final int AND_TYPE = 1;

	/** _a(OR)LłB*/
	private static final char OR_CHAR = '|';

	/** _(AND)LłB*/
	private static final char AND_CHAR = '&';

	/** ʂłB*/
	private static final char LEFT_PARENTHESIS = '(';

	/** EʂłB*/
	private static final char RIGHT_PARENTHESIS = ')';


	/**
	 * RXgN^łB<BR>
	 * p[X銮vi[f[^IuWFNgw肵܂B
	 * @param objConclusionData
	 */
	public ConclusionNode( ConclusionData objConclusionData ) {
		mobjConclusionData = objConclusionData;
	}

	/**
	 * v𖞂Ă邩ǂ`FbN܂
	 * @boolean true: Ă false: ĂȂ
	 * @exception ConclusionException ͒ɎsOꍇ
	 */
	public boolean isConcluded()
		throws ConclusionException
	{
		for( int i = 0; i < mvecChildList.size(); i++ ) {
			DecideConclusion objDecide = (DecideConclusion)mvecChildList.get(i);
			if( mintNodeType == OR_TYPE ) {
				if( objDecide.isConcluded() ) {
					// _ȁꍇ͂ЂƂł݂琳Ԃ
					return true;
				}
			}
			else if( mintNodeType == AND_TYPE ) {
				if( !objDecide.isConcluded() ) {
					// _ς̏ꍇ͂ЂƂł݂畉Ԃ
					return false;
				}
			}
		}

		if( mintNodeType == OR_TYPE ) {
			return false;
		}
		else if( mintNodeType == AND_TYPE ) {
			return true;
		}

		return false;
	}

	/**
	 * vɎgpĂLOID̃Xg擾܂B
	 * @return Vector LOIDXg
	 */
	public Vector getLoIDList() {
		Vector vecReq = new Vector();
		for( int i = 0; i < mvecChildList.size(); i++ ) {
			DecideConclusion objDecide = (DecideConclusion)mvecChildList.get(i);
			Vector vecTemp = objDecide.getLoIDList();
			for( int j = 0; j < vecTemp.size(); j++ ) {
				vecReq.add(vecTemp.get(j));
			}
		}
		return vecReq;
	}

	/**
	 * v𕪉܂B<BR>
	 * ͈ȉ̂悤ɍs܂B<P>
	 *
	 *     v '|'(_a) ܂܂ꍇ
	 *     _aŕăXg܂B<BR>
	 *     v '&'(_) ݂̂̏ꍇ͘_ς
	 *     ܂B
	 *  <PRE>
	 *     1:
	 *       v:: LO5 = p & (LO6 = c | LO7 = p) | LO8 = c
	 *       ̏ꍇȉ̂悤ɕÃNX̃m[h^CvOR_TYPE
	 *       ݒ肳܂B
	 *               [0] :: LO5 = p & (LO6 = c | LO7 = p)
	 *               [1] :: LO8 = c
	 *     2:
	 *       v:: LO5 = p & (LO6 = c | LO7 = p)
	 *       ̏ꍇȉ̂悤ɕÃNX̃m[h^CvAND_TYPE
	 *       ݒ肳܂B
	 *               [0] :: LO5 = p
	 *               [1] :: LO6 = c | LO7 = p
	 *  </PRE>
	 * @exception ConclusionParseException p[XOꍇB
	 */
	public void parse()
		throws ConclusionParseException
	{
		if ( mobjConclusionData == null ){
			throw new ConclusionParseException( ConclusionEnv.getMessage(SYSTEM_ERR) );
		}
		
		Vector result;
		//Xy[XA^uACRALFA()폜B
		String strConclusion = eraseSPTABCRLF( mobjConclusionData.getConclusion() );

		// | ō\͂sB
		result = parseSentence( strConclusion, OR_CHAR );
		if ( result.size() != 0 ){
			mintNodeType = OR_TYPE;
			for( int i=0; i<result.size(); i++ ){
				makeChildObject( (String)result.get(i), mobjConclusionData.getUserID(), 
													mobjConclusionData.getDataAccess() );
			}
		}
		else{
			// |ŕoȂꍇ́A&ō\͂sB
			result = parseSentence( strConclusion, AND_CHAR );
			if ( result.size() != 0 ){
				mintNodeType = AND_TYPE;
				for( int i=0; i<result.size(); i++ ){
					makeChildObject( (String)result.get(i), mobjConclusionData.getUserID(),
													mobjConclusionData.getDataAccess() );
				}
			}
		}

		// |ł&łłȂꍇ̓v~eBu
		if ( result.size() == 0 ){
			makeChildObject( strConclusion, mobjConclusionData.getUserID(),
												mobjConclusionData.getDataAccess() );
		}

		return;
	}

	/**
	 * \͂s܂B
	 * @param  String v
	 * @param  char   \͋L(| or &)
	 * @return ZeXi[Vector
	 * @exception ConclusionParseException ͒ɎsOꍇ
	 */
	private Vector parseSentence( String strInput, char cDest)
			throws ConclusionParseException	
	{
		int				iParenthesis = 0;	//ʂ̊Kw
		char			c;
		int				beforeindex = 0;	//O񌟍̍Ō{PwItZbg
		Vector			vecResult = new Vector();
		StringBuffer	check = new StringBuffer(strInput);


		for( int i=0; i<check.length(); i++ ){
			c = check.charAt(i);
			switch( c ){
				case LEFT_PARENTHESIS:
						//Kw𑝂₷
						iParenthesis++;
					break;
				case RIGHT_PARENTHESIS:
						//Kw炷
						iParenthesis--;
						if ( iParenthesis < 0 ){
							throw new ConclusionParseException( ConclusionEnv.getMessage(RIGTHPARENTHESIS_ERR) );
						}
					break;
				default:
					if ( c == cDest ){
						if ( iParenthesis == 0 ){//ŏʂ̏ꍇ̂ݕ
							if ( i <= beforeindex ){
									throw new ConclusionParseException( ConclusionEnv.getMessage(SYMBOL_ERR) );
							}
							String strSentence = eraseParenthesis( check.substring(beforeindex, i) );
							vecResult.add( strSentence );
							beforeindex = i+1;//cDestXLbvCfbNXݒ
						}
					}
					break;
			}
		}
		// iParenthesisO傫ꍇ)܂B
		if ( iParenthesis > 0 ){
			throw new ConclusionParseException( ConclusionEnv.getMessage(LEFTPARENTHESIS_ERR) );
		}
		// łɐ؂oꍇAcĂ镔Ō̃ZeXƂĐ؂o܂B
		if ( beforeindex != 0 ){
			if ( beforeindex >= check.length() ){
				throw new ConclusionParseException( ConclusionEnv.getMessage(ENDSENTENCE_ERR) );
			}
			String strSentence = eraseParenthesis( check.substring(beforeindex, check.length()) );
			vecResult.add( strSentence );
		}
		
		return vecResult;
	}


	/**
	 * ()폜܂B
	 * @param  String ̊v
	 * @return ()폜v
	 */
	private String eraseParenthesis(String strInput)
	{
		int				iParenthesis = 0;
		char			c;
		int				iEndIndex = strInput.length()-1;
		
		//擪ƍŌオ()Ȃ΍폜B
		if ( strInput.charAt(0) == LEFT_PARENTHESIS && strInput.charAt(iEndIndex) == RIGHT_PARENTHESIS ){
			StringBuffer check = new StringBuffer( strInput.substring( 1, iEndIndex ) );
			//()폜̕`FbNB
			for( int i=0; i<check.length(); i++ ){
				c = check.charAt(i);
				switch( c ){
					case LEFT_PARENTHESIS:
							//Kw𑝂₷
							iParenthesis++;
						break;
					case RIGHT_PARENTHESIS:
							//Kw炷
							iParenthesis--;
							if ( iParenthesis < 0 ){
								// ()폜Ƃɂs̈ד͂ꂽ̂ԋpB
								return strInput;
							}
						break;
					default:
						break;
				}
			}
			if ( iParenthesis > 0 ){
				// ()폜Ƃɂs̈ד͂ꂽ̂ԋpB
				return strInput;
			}
			//ċAĂяos()̍폜݂B
			return eraseParenthesis( check.toString() );
		}
		else{
			// ŏƍŌオ()łȂꍇ͓͂ꂽ̂ԋpB
			return strInput;
		}
	}

	/**
	 * ͂ɕsvȃR[hƊʂ폜܂B
	 * @param strInput v
	 * @return 폜̕
	 */
	private String eraseSPTABCRLF(String strInput)
	{
		
		String strCheck = replace(strInput, ' ');
		strCheck = replace(strCheck, '\t');
		strCheck = replace(strCheck, '\r');
		strCheck = replace(strCheck, '\n');
		strCheck = eraseParenthesis( strCheck );
		return strCheck;
	}

	private String replace(String src, char match) {
		StringBuffer	result = new StringBuffer(src);
		
		int i = 0;
		while( true ){
			if ( i >= result.length() ){
				break;
			}
			if ( result.charAt(i) == match ){
				result = result.deleteCharAt(i);
				i--;
			}
			i++;
		}
		return result.toString();
	}

	/**
	 * v~eBuǂ`FbN܂B
	 * @param strInput v
	 * @return true:v~eBu
	 * @exception ConclusionParseException ͒ɎsOꍇ
	 */
	private boolean isPrimitive(String strInput) throws ConclusionParseException
	{
		
		Vector result;
				// | ō\͂sB
		result = parseSentence( strInput, OR_CHAR );
		if ( result.size() != 0 ){
			return false;
		}
		else{
			// |ŕoȂꍇ́A&ō\͂sB
			result = parseSentence( strInput, AND_CHAR );
			if ( result.size() != 0 ){
				return false;
			}
		}

		return true;
	}

	/**
	 * qm[h̉͂s܂B
	 * @param  String v
	 * @param  String [UID
	 * @exception ConclusionParseException ͒ɎsOꍇ
	 */
	private void makeChildObject(String strSentence,String strUserID, DataAccess objDataAccess ) 
			throws ConclusionParseException
	{
		ConclusionData objChildData = new ConclusionData( strSentence, strUserID, objDataAccess );

		if ( isPrimitive(strSentence) != true ){
			//v~eBułȂꍇAm[hIuWFNg𐶐p[X
			ConclusionNode objChildNode = new ConclusionNode( objChildData );
			objChildNode.parse();
			if ( mvecChildList == null ){
				mvecChildList = new Vector();
			}
			mvecChildList.add( objChildNode );
		}
		else{
			//v~eBȕꍇ
			ConclusionPrimitive objChildPrimitive = new ConclusionPrimitive( objChildData );
			objChildPrimitive.parse();
			if ( mvecChildList == null ){
				mvecChildList = new Vector();
			}
			mvecChildList.add( objChildPrimitive );
		}
		return;
	}



}


