/////////////////////////////////////////////////////////////////
//Copyright (C) 2005 NTT CORPORATION.
//
//	XMO擾ėpNX
//
//		ύX
//			2005.02.03  VK쐬  Katsuhiko.Sakurai(UNITEC)
//
//	@\
//
//	̃NXXMO擾ėpNXłB
//
////////////////////////////////////////////////////////////////
package jp.co.ntt.lms.lo.progress.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.Base.XMSBaseClient;
import jp.co.ntt.lms.xmo.GroupAndPeople.GroupAndPeopleClient;
import jp.co.ntt.lms.xmo.Groups.GroupsClient;
import jp.co.ntt.lms.xmo.Groups.GroupsData;
import jp.co.ntt.lms.xmo.Lo.LoClient;
import jp.co.ntt.lms.xmo.Lo.LoData;
import jp.co.ntt.lms.xmo.LoRelation.LoRelationClient;
import jp.co.ntt.lms.xmo.People.PeopleClient;

/**
 * XMO擾ėpNXłB
 * 
 * @author Katsuhiko Sakurai (UNITEC)
 * @version 1.0
 */
public final class XMOInformationGetter {
	
	/**
	 * w肳ꂽLOIDLO擾܂B
	 * 
	 * @param loID LoID
	 * @return LoClient Lo 
	 * @throws Exception
	 */
	public static LoClient getLO( String loID ) throws Exception {
		
		LoClient loClient = new LoClient();

		// LOIDݒ肷
		loClient.setWhereLoID( loID );
		
		// s
		if( loClient.select() == false ) return null;

		// ʂ̎擾
		if( loClient.next() == false ) return null;
		
		return loClient;
	}
	
	/**
	 * w肳ꂽqLOIDLOKw擾܂B
	 * 
	 * @param childLOID qLoID
	 * @return LoRelationClient LoKw
	 * @throws Exception
	 */
	public static LoRelationClient getLORelation( String childLOID ) throws Exception {
		
		LoRelationClient relationClient = new LoRelationClient();

		// LOIDݒ肷
		relationClient.setWhereChildID( childLOID );
		
		// s
		if( relationClient.select() == false ) return null;

		// ʂ̎擾
		if( relationClient.next() == false ) return null;
		
		return relationClient;
	}

	/**
	 * w肳ꂽ[UID烆[U擾܂B
	 * 
	 * @param userID [UID
	 * @return PeopleClient [U
	 * @throws Exception
	 */
	public static PeopleClient getPeople( String userID ) throws Exception {
		
		PeopleClient client = new PeopleClient();

		// UserIDݒ肷
		client.setWhereUserID( userID );
		
		// s
		if( client.select() == false ) {
			return null;
		}

		// ʂ̎擾
		if( client.next() == false ) return null;
		
		return client;
	}
	
	/**
	 * w肳ꂽO[vIDO[v擾܂B
	 * 
	 * @param groupID O[vID
	 * @return GroupsClient O[v
	 * @throws Exception
	 */
	public static GroupsClient getGroup( String groupID ) throws Exception {
		
		GroupsClient client = new GroupsClient();

		// UserIDݒ肷
		client.setWhereGroupID( groupID );
		
		// s
		if( client.select() == false ) {
			return null;
		}

		// ʂ̎擾
		if( client.next() == false ) return null;
		
		return client;
	}
	
	/**
	 * w肳ꂽLOID̐eLO̒Ŏw胆[UɃATCĂLOID擾܂B
	 * 
	 * @param loID LOID
	 * @param userID [UID
	 * @param assignType ATC
	 *     AssignmentsClient.NON_TYPE    :: ATC^CvwȂ
	 *     AssignmentsClient.LEARN_TYPE  :: wKATCĂ
	 *     AssignmentsClient.MANAGE_TYPE :: ǗATCĂ
	 * @return String LOID
	 */
	public static String getAssignedParentLOID(String loID, String userID, int assignType ) throws Exception {
	
		// `FbNtO
		boolean isAuth = false;

		// ΏLÕXg擾܂B
		// XMSBasegpāA[UgpłLOXg擾܂B
		XMSBaseClient baseClient = new XMSBaseClient();
		if( baseClient.searchRootLoList( userID, assignType ) == false ) {
			throw new XMOException( baseClient.getMessage() );
		}

		LoData[] rootLOs = baseClient.getRootLoList();
		// ̂LOIDXg쐬B
		List authLOList = new ArrayList();
		for( int i = 0; i < rootLOs.length; i++ ) {
			authLOList.add( rootLOs[i].getLoID() );
		}

		// wLOID̃pX擾܂B
		// QLOID̃pX擾
		LoRelationClient loRelation = new LoRelationClient();
		if( loRelation.searchPath(loID) == false ) {
			// pX܂Ȃꍇ
			throw new XMOException( loRelation.getMessage() );
		}

		// pXɌ`FbNsB
		while( loRelation.next() ) {
			String[] path = loRelation.getPath();
			for( int i = 0; i < path.length; i++ ) {

				// ΃ATCĂIDԂ
				if( authLOList.contains( path[i] ) ) return path[i];
			}
		}

		// Ȃ΋󕶎Ԃ
		return "";
	}

	/**
	 * w肳ꂽ[UɃATCĂ郋[gLOXg擾܂B
	 * 
	 * @param userID [UID
	 * @return List [gLOXg
	 * @throws XMOException
	 * @throws Exception
	 */
	public static List getRootLoList( String userID ) throws XMOException, Exception {
		// ATC^CvwȂ
		return XMOInformationGetter.getRootLoList(userID, 0);
	}
	
	/**
	 * w肳ꂽ[UɃATCĂLÕ[gXg擾܂B
	 * 
	 * @param userID [UID
	 * @param assignType ATCʁ@0:wȂ 1:wK@2:Ǘ
	 * @return List [gLOXg
	 * @throws XMOException
	 * @throws Exception
	 */
	public static List getRootLoList( String userID, int assignType ) throws XMOException, Exception {

		XMSBaseClient xmsBaseClient = new XMSBaseClient();
	
		// [gLOXg(ǗATCĂ̂)
		if( xmsBaseClient.searchRootLoList(userID, assignType) == false ) {
			throw new XMOException( xmsBaseClient.getMessageData() );
		}

		// ܂ꍇ
		return new ArrayList(Arrays.asList(xmsBaseClient.getRootLoList()));
	}

	/**
	 * w肳ꂽ[UɃATCĂO[ṽ[gXg擾܂B
	 * 
	 * @param userID [UID
	 * @return List [gO[vXg
	 * @throws XMOException
	 * @throws Exception
	 */
	public static List getRootGroupIDList( String userID ) throws XMOException, Exception {

		XMSBaseClient xmsBaseClient = new XMSBaseClient();
	
		// [gLOXg(ǗATCĂ̂)
		if( xmsBaseClient.searchRootGroupList(userID) == false ) {
			throw new XMOException( xmsBaseClient.getMessageData() );
		}
		
		GroupsData[] groupData = xmsBaseClient.getRootGroupList();
		ArrayList list = new ArrayList();
		
		for(int i=0; i<groupData.length; i++) {
			list.add(groupData[i].getGroupID());
		}

		return list;
	}

	/**
	 * w肳ꂽ[UEO[v̎qO[vE[ŨXg擾܂B
	 * 
	 * @param parentID eO[vE[UID
	 * @return List qO[vE[UXg
	 * @throws Exception
	 */
	public static List getChildGroupIDList(String parentID) throws Exception {
		
		GroupAndPeopleClient groupAndPeopleClient = new GroupAndPeopleClient();
		groupAndPeopleClient.setParentID( parentID );
		
		if( groupAndPeopleClient.select() == false ) return null;
		
		ArrayList list = new ArrayList();
		while(groupAndPeopleClient.next()){
			list.add( groupAndPeopleClient.getChildID() );
		}

		return list;
	}
}
