/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	XMSBase T[oNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo.Base;

import java.rmi.registry.Registry;
import java.rmi.registry.LocateRegistry;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.*;
import java.sql.*;

// XMS2 API
import jp.co.ntt.lms.lo.LoConstant;
import jp.co.ntt.lms.xmo.*;
import jp.co.ntt.lms.xmo.util.DebugLog;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.Method.MethodClient;
import jp.co.ntt.lms.xmo.Method.MethodData;
import jp.co.ntt.lms.xmo.Groups.*;
import jp.co.ntt.lms.xmo.GroupAndPeople.*;
import jp.co.ntt.lms.xmo.RoleAssignments.*;
import jp.co.ntt.lms.xmo.Roles.*;
import jp.co.ntt.lms.xmo.Lo.*;
import jp.co.ntt.lms.xmo.LoRelation.*;
import jp.co.ntt.lms.xmo.Assignments.*;
import jp.co.ntt.lms.xmo.Base.Gui.*;

/**
 * Base(XMS_B)̃T[oNXłB<BR>
 * XMSBaseC^tF[XA[gIuWFNgƂē삵܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class XMSBase extends UnicastRemoteObject
	implements XMO, XMSBaseMessage, XMSBaseTable, XMOPropertyDef
{

	//////////////////////////////////////////////////////////////////
	// \bh`
	//////////////////////////////////////////////////////////////////
	/** XMOEntryo^ */
	private static final String METHOD1 = "insert";
	/** XMOEntryXV */
	private static final String METHOD2 = "update";
	/** XMOEntry폜 */
	private static final String METHOD3 = "delete";
	/** XMOEntry */
	private static final String METHOD4 = "select";
	/** [gO[vXg\bhł */
	private static final String METHOD5 = "searchRootGroupList";
	/** [gLOXg\bhł */
	private static final String METHOD6 = "searchRootLoList";
	/** {ʂ̕\f[^\bhł */
	private static final String METHOD7 = "selectBaseDisplay";
	//	ADD 2005/03/25 START Koji Umehara [\bhǗǉ]
	/** [g\bhXg\bhł */
	private static final String METHOD8 = "searchRootMethodList";
	//	ADD 2005/03/25 END Koji Umehara [\bhǗǉ]

	/** [gIuWFNgQƗpWXg */
	private static Registry registry = null;

	/** VXeVbg_E\bh */
	private static final String METHOD10 = "shutdown";

	/**
	 * f[^ANZXNXێ܂
	 */
	private XMSBaseDataAccess pobjDataAccess = null;

	/**
	 * XMOT[õT[ôێ܂
	 */
	private String pstrXmoServerName = "rover";

	/**
	 * XMSBasê̖ێ܂
	 */
	private String pstrXmsBaseName = "jp.co.ntt.lms.base.XMSBase";

	// NtO
	private boolean isLaunch = false;

	/**
	 * RXgN^<BR>
	 * NX̏s܂
	 */
	public XMSBase() throws Exception {
		// [gIuWFNgGNX|[g
		// java.rmi.server.UnicastRemoteObject 
		// Ȃ̃RXgN^Ăяo
		super();

		// f[^ANZXNX̃CX^X
		pobjDataAccess = new XMSBaseDataAccess();

		// 
		init();
	}

	/**
	 * s܂
	 */
	public void init() throws Exception {
		// NX̃CX^X
		Environment objEnvironment = new Environment();
		// XMOT[ô̎擾
		pstrXmoServerName = objEnvironment.getServerName();
		// XMSBasê̎擾
		pstrXmsBaseName = objEnvironment.getBaseName();

		if( registry == null ) {
			// RMIWXgXMSBaseo^܂B
			registry = LocateRegistry.getRegistry(new Integer( objEnvironment.getXmoRegistryPort() ).intValue());
			registry.rebind("//" + pstrXmoServerName + "/" + pstrXmsBaseName, this);
		}
	}

	/*
	 * j[ꗗԂ܂
	 * @return Vector j[ꗗ
	 */
	public Vector getMenuList(Hashtable htbParam) {
		Vector vecMenuList = new Vector();
		try {
			XMSBaseEnv objEnv = XMSBaseEnv.getInstance();
			vecMenuList = objEnv.getMenuList();
		}
		catch( Exception e ) {
			return new Vector();
		}
		return vecMenuList;
	}

	/**
	 * \bhꗗԂ܂
	 * @return Vector
	 */
	public Vector getMethodList() {
		Vector vecMethod = new Vector();
		vecMethod.add( METHOD1 );
		vecMethod.add( METHOD2 );
		vecMethod.add( METHOD3 );
		vecMethod.add( METHOD4 );
		return vecMethod;
	}

	/**
	 * ftHgj[Ԃ܂
	 * @return MenuData
	 */
	public MenuData getDefaultMenu() {
		return null;
	}

	/**
	 * NmFiSXMŐNtrueA܂NłfalseԂBj
	 * @return boolean SXMONFtrueASXMONFfalse
	 */
	public boolean isLaunch() {
		return isLaunch;
	}

	/**
	 * XMOŒ`ꂽA\bh̃NCAg̓ɂȂ郁\bhłB
	 * @param strMethodName s郁\bhw肵܂
	 * @param htData \bhŎsp[^w肵܂<BR>
	 *               ȂKvȃL[ƒl͊eDAȌ\bh̐QƂĉB
	 * @retunr Object ߂li܂܂Ȗ߂lɑΉ邽Object^ƂĂ܂)<BR>
	 *                󂯎葤ł͓K؂ȒlɃLXgKv܂B
	 */
	public Object execute( String strMethodName, Hashtable htData ) {

		Object objReturn = null;

		if( strMethodName.equals( METHOD1 ) ) {
			objReturn = insertEntry( htData );
		}
		else if( strMethodName.equals( METHOD2 ) ) {
			objReturn = updateEntry( htData );
		}
		else if( strMethodName.equals( METHOD3 ) ) {
			objReturn = deleteEntry( htData );
		}
		else if( strMethodName.equals( METHOD4 ) ) {
			objReturn = selectEntry( htData );
		}
		else if( strMethodName.equals( METHOD5 ) ) {
			objReturn = searchRootGroupList( htData );
		}
		else if( strMethodName.equals( METHOD6 ) ) {
			objReturn = searchRootLoList( htData );
		}
		else if( strMethodName.equals( METHOD7 ) ) {
			objReturn = selectBaseDisplay( htData );
		}
		else if( strMethodName.equals( METHOD8 ) ) {
			objReturn = searchRootMethodList( htData );
		}
		else if( strMethodName.equals( METHOD10 ) ) {
			shutdown( htData );
		}

		return objReturn;
	}

	/*
	 * XMOEntrye[u֓o^s܂B<BR>
	 * ȉ̃p[^`FbNsAׂOK̏ꍇ
	 * DAO̓o^\bhs܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             MEMBER_SHIP_ID          lXID
	 *             MATERIAL_ID             R|[lgID
	 *             STUDY_START_DATE        Jn
	 *             END_DATE                I
	 *             READ                    wK
	 *             MAKE_CONTENTS           쐬
	 *             COPY_AUTHORITY          쐬
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[ĕԂ܂)
	 */
	private Vector insertEntry( Hashtable htData ) {
		Vector vecReturn = new Vector();

		MessageData objMessage = null;
		// o^̃p[^`FbNs܂
		String strMessage = insertCheck( htData );
		if( strMessage.equals( "" ) ) {
			try {
				pobjDataAccess.insertEntry( htData );
			}
			catch( XMOException xe ) {
				objMessage = xe.getMessageData();
			}
		}
		else {
			objMessage = getMessageData( strMessage );
			DebugLog.write( this.getClass(), objMessage.getMessage(), DebugLog.HIGHT );
		}
		vecReturn.add( objMessage );
		return vecReturn;
	}

	/**
	 * XMOEntrye[u֍XVs܂B<BR>
	 * ȉ̃p[^`FbNsAׂOK̏ꍇ
	 * DAO̍XV\bhs܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[ĕԂ܂)
	 */
	private Vector updateEntry( Hashtable htData ) {
		Vector vecReturn = new Vector();

		MessageData objMessage = null;
		// XṼp[^`FbNs܂
		String strMessage = updateCheck( htData );
		if( strMessage.equals( "" ) ) {
			try {
				pobjDataAccess.updateEntry( htData );
			}
			catch( XMOException xe ) {
				objMessage = xe.getMessageData();
			}
		}
		else {
			objMessage = getMessageData( strMessage );
			DebugLog.write( this.getClass(), objMessage.getMessage(), DebugLog.HIGHT );
		}

		vecReturn.add( objMessage );
		return vecReturn;
	}

	/**
	 * XMOEntrye[u֍폜s܂B<BR>
	 * ȉ̃p[^`FbNsAׂOK̏ꍇ
	 * DAO̍폜\bhs܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 폜
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[ĕԂ܂)
	 */
	private Vector deleteEntry( Hashtable htData ) {
		Vector vecReturn = new Vector();

		MessageData objMessage = null;
		try {
			pobjDataAccess.deleteEntry( htData );
		}
		catch( XMOException xe ) {
			objMessage = xe.getMessageData();
		}
		vecReturn.add( objMessage );
		return vecReturn;
	}

	/**
	 * XMOEntrye[u֌s܂B<BR>
	 * ȉ̃p[^`FbNsAׂOK̏ꍇ
	 * DAǑ\bhs܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[AQԖڈڍs
	 *                      AssignmentsDataNXi[ĕԂ܂B)
	 */
	private Vector selectEntry( Hashtable htData ) {
		Vector vecResult = new Vector();

		MessageData objMessage = null;
		try {
			vecResult = pobjDataAccess.selectEntry( htData );
		}
		catch( XMOException xe ) {
			objMessage = xe.getMessageData();
		}

		vecResult.add( 0, objMessage );

		return vecResult;
	}

	/**
	 * w肳ꂽ[UID̃[g\O[vXg܂B<BR>
	 * XMOIDw肵ꍇ́AXMOIDɊ܂܂O[v݂̂܂B<BR>
	 * XMOIDnull̏ꍇ́A^Ă邷ׂẴO[v܂B<BR>
	 * ܂Aꂽʂ2d\h~dg݂ɂȂĂ܂B<BR>
	 * 2d\h~Ƃ͂ƂΈȉ̂悤ȏꍇłB<BR>
	 * <PRE>
	 *        |\GR1
	 *        |   |\GR11
	 *        |       |\GR111
	 *        |\GR2
	 *            |\GR21
	 *
	 *    L̂悤ȃO[vc[ŌʂAGR1, GR111, GR2ƂȂꍇAc[
	 *    ʂ̈ʒuɂGR111͌ʂ폜܂B
	 * </PRE>
	 * @param htData p[^
	 */
	public Vector searchRootGroupList( Hashtable htData ) {
		MessageData objMessage = null;
		DataAccess objDataAccess = new DataAccess();

		try {
			// [UID̎擾
			String strUserID = (String)htData.get( USER_ID );
			// p[^`FbN
			if( strUserID == null ) {
				throw new XMOException( getMessageData( PARAM_WAR ) );
			}

			// XMOID̎擾
			String[] strXmoID = (String[])htData.get( XMO_ID );

			objDataAccess.trans();

			// XMOIDw肳Ăꍇ́AXMOIDŎgpłRolesID擾܂B
			String[] strRolesIDList = null;

			if( strXmoID != null ) {
				// XMOIDw肳ĂꍇA[UɊ蓖ĂĂ錠ŁA
				// w肳ꂽXMOgpłRolesID擾܂B
				RolesClient objRoles = new RolesClient();
				// gUNV̋L
				objRoles.setConnectionIndex( objDataAccess.getConnectionIndex() );

				Vector vecInput = new Vector();
				for( int i = 0; i < strXmoID.length; i++ ) {
					vecInput.add(strXmoID[i]);
				}

				if ( !objRoles.searchRoleIdFromFunc( vecInput ) ){
					throw new XMOException( objRoles.getMessageData() );
				}

				strRolesIDList = objRoles.getRoleIdList();
			}

			// [UIDL[ɂČ胆[UɊ蓖ĂĂO[vIDXg擾܂
			RoleAssignmentsClient objRoleAss = new RoleAssignmentsClient();
			// gUNV̋L
			objRoleAss.setConnectionIndex( objDataAccess.getConnectionIndex() );
			// [UIDɕt܂
			objRoleAss.setWhereUserID( strUserID );
			// Assign_idOrderBy
			objRoleAss.setOrderByRoleAssID();

			// s܂B
			if( !objRoleAss.select() ) {
				throw new XMOException( objRoleAss.getMessageData() );
			}

			// }[Wp̃xN^[pӂ܂
			Vector vecMarge = new Vector();

			GroupAndPeopleClient objGandP = new GroupAndPeopleClient();
			Vector vecGroupList = new Vector();
			// ʂ̎擾
			while( objRoleAss.next() ) {
				// O[vi[܂
				String strGroupID = objRoleAss.getGroupID();

				// XMOIDw̍ꍇRoleIDŎ擾ei荞݂܂B
				if( strRolesIDList != null ) {
					String strRoleID = objRoleAss.getRoleID();
					boolean blIsExitRole = false;
					for( int i = 0; i < strRolesIDList.length; i++ ) {
						if( strRoleID.equals( strRolesIDList[i] ) ) {
							blIsExitRole = true;
							break;
						}
					}
					if( !blIsExitRole ) {
						// RoleID݂Ȃꍇ͈ȉ̏sȂB
						continue;
					}
				}

				// }[W`FbNs܂
				if( vecMarge.contains( strGroupID ) ) {
					// łɑ݂ꍇ͈ȉ͍̏sȂ
					continue;
				}

				// }[WpxN^[ɃO[vIDZbg܂
				vecMarge.add( strGroupID );

				// O[v擾܂
				GroupsClient objGroups = new GroupsClient();

				// O[vIDɕt܂
				objGroups.setWhereGroupID( strGroupID );
				// 
				if( !objGroups.select() ) {
					throw new XMOException( objGroups.getMessageData() );
				}

				if( objGroups.next() ) {
					GroupsData objGroupsData = objGroups.getGroupsData();
					// 擾O[v̐eO[vID擾܂
					objGandP.clear();
					// gUNV̋L
					objGandP.setConnectionIndex( objDataAccess.getConnectionIndex() );
					// qIDɐeID擾
					objGandP.setWhereChildID( strGroupID );
					// 
					if( !objGandP.select() ) {
						throw new XMOException( objGandP.getMessageData() );
					}

					// ܂猟ʂeID擾
					// O[v͐eЂƂȂ߁A[v͈
					if( objGandP.next() ) {
						objGroupsData.setParentID( objGandP.getParentID() );
					}
					// O[vxN^[Ɋi[܂
					vecGroupList.add( objGroupsData );
				}

			}

			// ʂ2d\O[v폜܂
			filterDuplicateGroup(vecGroupList);

			objDataAccess.commit();

			GroupsData[] objGroupsList = new GroupsData[vecGroupList.size()];
			vecGroupList.copyInto( objGroupsList );

			Vector vecReturn = new Vector();
			vecReturn.add( objMessage );
			vecReturn.add( objGroupsList );

			return vecReturn;
		}
		catch( XMOException xe ) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			objMessage = xe.getMessageData();
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}
		catch( SQLException se ) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			objMessage = getMessageData( DB_ERR );
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}
		catch(Exception e) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			objMessage = getMessageData( SYSTEM_ERR );
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}
	}

	/**
	 * w肳ꂽ[UID̃[g\LOXg܂B<BR>
	 * intAssignTypeŎw肳ꂽATC^Cv̌s܂B<BR>
	 * <PRE>
	 *     NON_TYPE    :: ATC^CvwȂ
	 *     LEARN_TYPE  :: wKATCĂ
	 *     MANAGE_TYPE :: ǗATCĂ
	 * </PRE>
	 * ܂Aꂽʂ2d\h~dg݂ɂȂĂ܂B<BR>
	 * @param htData p[^
	 */
	public Vector searchRootLoList( Hashtable htData ) {
		return searchRootLoMethodList( htData, false );
	}
	
	//	ADD 2005/03/25 START Koji Umehara [\bhǗǉ]
	/**
	 * w肳ꂽ[UID̃[g\郁\bhXg܂B<BR>
	 * intAssignTypeŎw肳ꂽATC^Cv̌s܂B<BR>
	 * <PRE>
	 *     NON_TYPE    :: ATC^CvwȂ
	 *     LEARN_TYPE  :: wKATCĂ
	 *     MANAGE_TYPE :: ǗATCĂ
	 * </PRE>
	 * @param htData p[^
	 */
	public Vector searchRootMethodList( Hashtable htData ) {
		return searchRootLoMethodList( htData, true );
	}
	//	ADD 2005/03/25 START Koji Umehara [\bhǗǉ]

	/**
	 * w肳ꂽ[UID̃[g\LO܂̓\bhXg܂B<BR>
	 * intAssignTypeŎw肳ꂽATC^Cv̌s܂B<BR>
	 * <PRE>
	 *     NON_TYPE    :: ATC^CvwȂ
	 *     LEARN_TYPE  :: wKATCĂ
	 *     MANAGE_TYPE :: ǗATCĂ
	 * </PRE>
	 * ܂AblnAllowDuplicatetOfalsȅꍇA
	 * ꂽʂ2d\h~dg݂ɂȂĂ܂B<BR>
	 * 2d\h~Ƃ͂ƂΈȉ̂悤ȏꍇłB<BR>
	 * <PRE>
	 *        |\LO1
	 *        |   |\LO11
	 *        |       |\LO111
	 *        |\LO2
	 *            |\LO21
	 *
	 *    L̂悤ȃO[vc[ŌʂALO1, LO111, LO2ƂȂꍇAc[
	 *    ʂ̈ʒuɂGR111͌ʂ폜܂B
	 * </PRE>
	 * @param htData p[^
	 * @param blnMethodFlag false:LOXg/true:\bhXg
	 */
	public Vector searchRootLoMethodList( Hashtable htData, boolean blnMethodFlag ) {
		MessageData objMessage = null;
		DataAccess objDataAccess = new DataAccess();

		try {
			// [UID̎擾
			String strUserID = (String)htData.get( USER_ID );
			// p[^`FbN
			if( strUserID == null ) {
				throw new XMOException( getMessageData( PARAM_WAR ) );
			}

			// ATC^Cv̎擾
			int intAssignType = ((Integer)htData.get( ASSIGN_TYPE )).intValue();
			
			//	ADD 2005/03/27 START Koji Umehara [\bhǗǉ]
			// 2d\tO̎擾
			boolean blnAllowDuplicate = true;
			if ( htData.containsKey( ALLOW_DUPLICATE ) ) {
				blnAllowDuplicate = ((Boolean)htData.get( ALLOW_DUPLICATE )).booleanValue();
			}
			//	ADD 2005/03/27 END Koji Umehara [\bhǗǉ]

			objDataAccess.trans();

			// O[vƐlXMOgpāAMemberShipID擾B
			GroupAndPeopleClient objGroupAndPeople = new GroupAndPeopleClient();
			// gUNV̋L
			objGroupAndPeople.setConnectionIndex( objDataAccess.getConnectionIndex() );
			// qIDL[ɂăo[VbvID擾
			objGroupAndPeople.setWhereChildID( strUserID );

			// 
			if( !objGroupAndPeople.select() ) {
				throw new XMOException( objGroupAndPeople.getMessageData() );
			}

			// ʂ̎擾
			String strMemberShipID = "";
			Vector vecLoList = new Vector();
			while( objGroupAndPeople.next() ) {
				strMemberShipID = objGroupAndPeople.getMemberShipID();

				// o[VbvIDL[ɂĊ蓖ĂĂ鋳ނ擾܂
				AssignmentsClient objAssignments = new AssignmentsClient();

				// gUNV̋L
				objAssignments.setConnectionIndex( objDataAccess.getConnectionIndex() );
				// Ƀo[VbvIDt
				objAssignments.setWhereMemberShipID( strMemberShipID );
				
				//	ADD 2005/03/25 START Koji Umehara [\bhǗǉ]
				// Ƀ\bhtOt
				objAssignments.setWhereMethodFlag( blnMethodFlag );
				//	ADD 2005/03/25 END Koji Umehara [\bhǗǉ]
				
				switch( intAssignType ) {
					case LEARN_TYPE:
						// ɊwKATCt
						objAssignments.setWhereLearnAuthority();
						break;
					case MANAGE_TYPE:
						// ɊǗATCt
						objAssignments.setWhereManagementAuthority();
						break;
				}
				// Assign_idOrderBy
				objAssignments.setOrderByAssignmentsID();

				// 
				if( !objAssignments.select() ) {
					throw new XMOException( objAssignments.getMessageData() );
				}

				int intCounter = 0;
				// ʂ̎擾
				while( objAssignments.next() ) {
					// JE^[Abv
					intCounter++;
					String strMaterialID = objAssignments.getMaterialID();

					// }eAIDL[ɂāALO̐eID擾
					LoRelationClient objLoRelation = new LoRelationClient();

					// gUNV̋L
					objLoRelation.setConnectionIndex( objDataAccess.getConnectionIndex() );
					// ̕t
					objLoRelation.setmaterialID( strMaterialID );

					// 
					if( !objLoRelation.select() ) {
						throw new XMOException( objLoRelation.getMessageData() );
					}

					// ʂ̎擾
					if( objLoRelation.next() ) {
						String strLoID = objLoRelation.getChildID();
						String strParentLoID = objLoRelation.getParentID();
						if( blnMethodFlag ) {
							// LOIDLo擾
							MethodClient objLo = new MethodClient();

							// gUNV̋L
							objLo.setConnectionIndex( objDataAccess.getConnectionIndex() );
							// ̕t
							objLo.setWhereLoID( strLoID );

							// 
							if( !objLo.select() ) {
								throw new XMOException( objLo.getMessageData() );
							}

							// ʂ̎擾
							if( objLo.next() ) {
								MethodData objLoData = objLo.getMethodData();
								objLoData.setParentID( strParentLoID );
								vecLoList.add( objLoData );
							}
						} else {
							// LOIDLo擾
							LoClient objLo = new LoClient();

							// gUNV̋L
							objLo.setConnectionIndex( objDataAccess.getConnectionIndex() );
							// ̕t
							objLo.setWhereLoID( strLoID );

							// 
							if( !objLo.select() ) {
								throw new XMOException( objLo.getMessageData() );
							}

							// ʂ̎擾
							if( objLo.next() ) {
								LoData objLoData = objLo.getLoData();
								objLoData.setParentID( strParentLoID );
								vecLoList.add( objLoData );
							}
						}
					}
				}
			}

			// ʂ2d\LO폜܂
			if( blnAllowDuplicate ) {	//	ADD 2005/03/27 Koji Umehara [\bhǗǉ]
				filterDuplicateLo(vecLoList);
			}
			
			//LOr[ɂāA\bh̔zɂLOɂĂ
			//\ȂB
			if (!blnMethodFlag)
			{
				filterMethodDescendant(vecLoList);
			}

			objDataAccess.commit();

			Vector vecReturn = new Vector();
			vecReturn.add( objMessage );

			if( blnMethodFlag ) {
				MethodData[] objLoList = new MethodData[vecLoList.size()];
				vecLoList.copyInto( objLoList );
				vecReturn.add( objLoList );
			} else {
				LoData[] objLoList = new LoData[vecLoList.size()];
				vecLoList.copyInto( objLoList );
				vecReturn.add( objLoList );
			}

			return vecReturn;
		}
		catch( XMOException xe ) {
			xe.printStackTrace();
			try { objDataAccess.rollback(); } catch(Exception te) {}
			objMessage = xe.getMessageData();
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}
		catch( SQLException se ) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			objMessage = getMessageData( DB_ERR );
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}
		catch(Exception e) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			objMessage = getMessageData( SYSTEM_ERR );
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}
	}
	
	/**
	 * LO\bh̔zLȌꍇɁA`FbNXg폜B
	 * 
	 * @param vecLoList `FbNXg
	 * @throws XMOException
	 */
	private void filterMethodDescendant(Vector vecLoList)
		throws XMOException
	{
		MethodClient client;
		try
		{
			client = new MethodClient();
		}
		catch (Exception e)
		{
			DebugLog.write( XMSBase.class, e, DebugLog.HIGHT );
			throw new XMOException(e.getMessage());
		}
		
		boolean result = false;
		for( int i = vecLoList.size() - 1; i >= 0; i-- )
		{
			LoData objData = (LoData)vecLoList.get(i);
			
			//ReiɂẮA\tB^ȂB(w肳Ă邱ƂȂ̂ŁB)
			if (objData.getLoType().equals(LoConstant.LO_TYPE_CONTAINER))
			{
				continue;
			}
			
			result = false;
			
			client.clear();
			client.setWhereString(MethodClient.METHODLOID, "=", objData.getLoID());
			try
			{
				client.select();
				if (client.next())
				{
					result = true;
				}
			}
			catch (Exception e)
			{
				DebugLog.write( XMSBase.class, e, DebugLog.HIGHT );
				throw new XMOException(e.getMessage());
			}
			
			if(result)
			{
				// LOList폜
				vecLoList.remove(i);
			}
		}
		client = null;
	}

	/**
	 * Group@Qd\`FbN\bh
	 * @param vecGroupsList `FbNXg
	 * @exception XMOException
	 */
	private void filterDuplicateGroup( Vector vecGroupsList )
		throws XMOException
	{

		Hashtable htbPath = new Hashtable();
		// LOIDƃpX̑ΉHashtableɊi[
		for( int i = 0; i < vecGroupsList.size(); i++ ) {
			GroupsData objData = (GroupsData)vecGroupsList.get(i);
			String strGroupID = objData.getGroupID();
			Vector vecPathList = new Vector();
			try {
				// LOIDɃpX擾
				GroupAndPeopleClient objReltaion = new GroupAndPeopleClient();
				if( !objReltaion.searchPath(strGroupID) ) {
					throw new XMOException( objReltaion.getMessageData() );
				}

				while( objReltaion.next() ) {
					vecPathList.add( objReltaion.getPath() );
				}
				htbPath.put( objData, vecPathList );
			}
			catch( Exception ex ) {
				throw new XMOException( getMessageData( SYSTEM_ERR ) );
			}
		}

		// 2d`FbN
		Hashtable htbDelGroups = new Hashtable(); // pHashtable
		Enumeration en = htbPath.keys();
		while(en.hasMoreElements()) {
			GroupsData objData = (GroupsData)en.nextElement();
			for( int i = 0; i < vecGroupsList.size(); i++ ) {
				GroupsData objTempData = (GroupsData)vecGroupsList.get(i);
				if( objData == objTempData ) {
					// QƂꍇ͉Ȃ
					continue;
				}
				if( htbDelGroups.containsKey( objTempData ) ) {
					// łɔpLOɓo^Ă̂ŉȂ
					continue;
				}
				Vector vecPathList = (Vector)htbPath.get(objTempData);
				if( isContainsPath( objData.getGroupID(), vecPathList ) ) {
					// GroupsIDpXɊ܂܂Ăꍇ͔pHashtableɊi[
					htbDelGroups.put( objTempData, "DELETE" );
				}
			}
		}

		// pHashtableɊi[ĂGroupsDatavecGroupsList菜
		Enumeration delEn = htbDelGroups.keys();
		while( delEn.hasMoreElements() ) {
			GroupsData objData = (GroupsData)delEn.nextElement();
			vecGroupsList.remove( objData );
		}
	}

	/**
	 * LO@Qd\`FbN\bh
	 * @param vecLoList `FbNXg
	 * @exception XMOException
	 */
	private void filterDuplicateLo( Vector vecLoList )
		throws XMOException
	{

		Hashtable htbPath = new Hashtable();
		Vector vecMarge = new Vector();
		// LOIDƃpX̑ΉHashtableɊi[
		for( int i = vecLoList.size() - 1; i >= 0; i-- ) {
			LoData objData = (LoData)vecLoList.get(i);
			// }[W(LOID݂ꍇ͉Ȃ)
			if( vecMarge.contains( objData.getLoID() ) ) {
				// LOList폜
				vecLoList.remove(i);
				continue;
			}
			else {
				vecMarge.add( objData.getLoID() );
			}
			String strLoID = objData.getLoID();
			Vector vecPathList = new Vector();
			try {
				// LOIDɃpX擾
				LoRelationClient objReltaion = new LoRelationClient();
				if( !objReltaion.searchPath(strLoID) ) {
					throw new XMOException( objReltaion.getMessageData() );
				}

				while( objReltaion.next() ) {
					vecPathList.add( objReltaion.getPath() );
				}
				htbPath.put( objData, vecPathList );
			}
			catch( Exception ex ) {
				throw new XMOException( getMessageData( SYSTEM_ERR ) );
			}
		}

		// 2d`FbN
		Hashtable htbDelLo = new Hashtable(); // pHashtable
		Enumeration en = htbPath.keys();
		while(en.hasMoreElements()) {
			LoData objData = (LoData)en.nextElement();
			for( int i = 0; i < vecLoList.size(); i++ ) {
				LoData objTempData = (LoData)vecLoList.get(i);
				if( objData == objTempData ) {
					// QƂꍇ͉Ȃ
					continue;
				}
				if( htbDelLo.containsKey( objTempData ) ) {
					// łɔpLOɓo^Ă̂ŉȂ
					continue;
				}
				Vector vecPathList = (Vector)htbPath.get(objTempData);
				if( isContainsPath( objData.getLoID(), vecPathList ) ) {
					// LoIDpXɊ܂܂Ăꍇ͔pHashtableɊi[
					htbDelLo.put( objTempData, "DELETE" );
				}
			}
		}

		// pHashtableɊi[ĂLoDatavecLoList菜
		Enumeration delEn = htbDelLo.keys();
		while( delEn.hasMoreElements() ) {
			LoData objData = (LoData)delEn.nextElement();
			vecLoList.remove( objData );
		}
	}

	/**
	 * ֐<BR>
	 * pXɃ^[QbgID܂܂Ă邩ǂ𔻒f
	 * @param strTargetID ^[QbgID
	 * @param vecPathList pXXgigString[])
	 * @return boolean true: ܂܂ false: ܂܂Ȃ
	 */
	private boolean isContainsPath( String strTargetID, Vector vecPathList ) {
		for( int i = 0; i < vecPathList.size(); i++ ) {
			String[] strTempPath = (String[])vecPathList.get(i);
			for( int j = 0; j < strTempPath.length; j++ ) {
				if( strTargetID.equals( strTempPath[j] ) ) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FIEL_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

	/**
	 * f[^x[Xڑ̏s܂
	 */
	public void initDB()
		throws Exception
	{
		// NX̃CX^X
		Environment objEnvironment = new Environment();

		// DBڑ
		String strDBDriver = "";
		String strConStr = "";
		String strDBUser = "";
		String strDBPass = "";
		int intPoolCount = 0;
		int intRetryCount = 0;
		int intWaitTime = 0;

		try {
			// v[̎擾
			intPoolCount = new Integer( objEnvironment.getPoolCount() ).intValue();
			// gC񐔂̎擾
			intRetryCount = new Integer( objEnvironment.getRetryCount() ).intValue();
			// ҂Ԃ̎擾
			intWaitTime = new Integer( objEnvironment.getWaitTime() ).intValue();

			// JDBChCo[擾܂
			strDBDriver = objEnvironment.getDBDriver();
			// ڑ擾܂
			strConStr = objEnvironment.getDBConStr();
			// DB[U擾܂
			strDBUser = objEnvironment.getDBUser();
			// DBpX[h擾܂
			strDBPass = objEnvironment.getDBPass();
		}
		catch( Exception e ) {
			DebugLog.write( XMSBaseStart.class, "DBڑ̎擾Ɏs܂B", DebugLog.HIGHT );
			DebugLog.write( XMSBaseStart.class, e, DebugLog.HIGHT );
			throw e;
		}

		// RlNV̊m
		DBConnector.init(	strDBDriver,
							strConStr,
							strDBUser,
							strDBPass,
							intPoolCount,
							intRetryCount,
							intWaitTime
							);

	}

	/**
	 * XMŐNs܂
	 * @param strClassName NNX
	 */
	public void startXMO( String strClassName ) {

		// wKуOQƌ̏ꍇ̓_~[NXȂ̂ŃCX^X͐Ȃ
		if( strClassName.equals( LEARN_XMO ) || strClassName.equals( LOG_XMO ) ) {
			return;
		}

		// NX̃CX^X̐
		Object objXMO = null;
		try {
			objXMO = newInstance( strClassName );

DebugLog.write( this.getClass(), "Load " +  strClassName + " start!!", DebugLog.ROW );
		}
		catch( Exception e ) {
			// @pending NX̃CX^X擾łȂƂ̏
			return;
		}
		// 擾NXRMIɓo^܂
		if( objXMO != null && objXMO instanceof XMO ) {
			Remote objRemote = (Remote)objXMO;
			try {
				// Bind
				registry.rebind( "//" + pstrXmoServerName + "/" + strClassName, objRemote );
DebugLog.write( this.getClass(), "Bind "  + "//" + pstrXmoServerName + "/" + strClassName, DebugLog.ROW );
DebugLog.write( this.getClass(), "Load " + strClassName +  " Completed!! ", DebugLog.ROW );
			}
			catch( Exception e ) {
				// oChs̏
				DebugLog.write( this.getClass(), "Bind failed!!", DebugLog.HIGHT );
				DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			}
		}
		else if( objXMO == null ) {
			// @pending NXXMOłȂƂ̏
			DebugLog.write( this.getClass(), "o^ĂXMO܂łB", DebugLog.HIGHT );
			DebugLog.write( this.getClass(), "    classname: " + strClassName, DebugLog.HIGHT );
		}
		else {
			// @pending NXXMOłȂƂ̏
			DebugLog.write( this.getClass(), "o^ĂNXXMOł͂܂B", DebugLog.HIGHT );
			DebugLog.write( this.getClass(), "    classname: " + strClassName, DebugLog.HIGHT );
		}
	}

	/**
	 * o^Ă邷ׂĂXMŐNs܂
	 */
	public void startXMOs() {

		// T[oœ삷NCAgNXT[o̐ݒɂ܂
		XMOClient.setServerSide();

		// XMOꗗ擾āARMIregistarɓo^
		Vector vecXmoList = new Vector();
		String strMessage = "";
		try {
			// ̑gݗāij
			Hashtable htbParam = new Hashtable();
			vecXmoList = pobjDataAccess.selectEntry( htbParam );
		}
		catch( XMOException xe ) {
			strMessage = xe.getMessage();
			xe.printStackTrace();
		}
		// NNX}[WpVectorpӂ
		Vector vecMarge = new Vector();
		// ʂ̃CfbNXOɂ̓bZ[Wf[^Ă̂ŁAP烋[v
		for( int i = 0; i < vecXmoList.size(); i++ ) {
			// XMOIDXMȌڍ׏擾
			XMOEntryData objData = (XMOEntryData)vecXmoList.get(i);
			// NtO̎擾
			String strOnFlg = objData.getXmoOnFlg();
			// NX̎擾
			String strClassName = objData.getClassName();

			if( strClassName != null && !strClassName.equals( "" ) ) {
				if( !vecMarge.contains( strClassName ) ) {
					vecMarge.add( strClassName );
					// XMON܂
					startXMO( strClassName );
				}
			}
		}

		// o^Ă邷ׂĂXMŐNtrueݒ肷B
		isLaunch = true;

	}

	/**
	 * VXeVbg_Ep̃\bhł<BR>
	 * ʏ̋ƖNXĂяo邱Ƃ͂܂B<BR>
	 * KXMSShutDownNXĂ΂܂B
	 */
	private void shutdown( Hashtable htbParam ) {
		try {
			// RlNV̐ؒf
			DBConnector.getInstance().close();
		}
		catch( Exception e ) {
		}
DebugLog.write( this.getClass(), "################ System Shutdown !!! ##############", DebugLog.HIGHT );
		// VXeExit
		System.exit(0);
	}


	/**
	 * NXNX̃CX^X擾֐
	 * @param strClassName pbP[W܂ރNX
	 * @return Object CX^XꂽIuWFNg
	 * @exception Exception NXȂƂ
	 */
	private static Object newInstance( String strClassName )
		throws Exception
	{
		Class c = Class.forName( strClassName );
		Object obj = c.newInstance();
		return obj;
	}

	/**
	 * o^̃p[^`FbNs܂<BR>
	 * ȉ̃p[^̃`FbNs܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             XMO_ID                  XMOID
	 *             XMO_NAME                O
	 *             XMO_OUT_LINE            Tv
	 *             XMO_URI                 URI
	 *             XMO_ON_FLG              ғtO
	 *             CLASS_NAME_F            NX
	 *             TREE_VIEW_TIPE          c[r[^Cv
	 *             INI_MENU                j[
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htbParam p[^
	 * @return String G[̓G[ԍ OK̂Ƃ͋󕶎Ԃ܂
	 */
	private String insertCheck( Hashtable htbParam ) {

		String strMessage = "";
		String strCheck = "";

		// XMOID̃`FbN(K{`FbN)
		strCheck = (String)htbParam.get( XMO_ID );
		strMessage = XMSBaseCheck.checkXmoID( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// Õ`FbN(K{`FbN)
		strCheck = (String)htbParam.get( XMO_NAME );
		strMessage = XMSBaseCheck.checkXmoName( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// Tṽ`FbN(K{`FbN)
		strCheck = (String)htbParam.get( XMO_OUT_LINE );
		strMessage = XMSBaseCheck.checkXmoOutLine( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// URĨ`FbN(K{`FbN)
		strCheck = (String)htbParam.get( XMO_URI );
		strMessage = XMSBaseCheck.checkXmoUri( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// ғtÕ`FbN(K{`FbN)
		strCheck = (String)htbParam.get( XMO_ON_FLG );
		strMessage = XMSBaseCheck.checkXmoOnFlg( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// NX̃`FbN(K{`FbN)
		strCheck = (String)htbParam.get( CLASS_NAME_F );
		strMessage = XMSBaseCheck.checkClassName( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// c[r[^Cṽ`FbN(K{`FbN)
		strCheck = (String)htbParam.get( TREE_VIEW_TIPE );
		strMessage = XMSBaseCheck.checkTreeViewType( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// j[̂̃`FbN(K{`FbN)
		strCheck = (String)htbParam.get( INI_MENU );
		strMessage = XMSBaseCheck.checkIniMenu( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// Dx̃`FbN(K{`FbNL)
		strCheck = (String)htbParam.get( PRIORITY );
		strMessage = XMSBaseCheck.checkPriority( strCheck, true );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// 펞͋󕶎Ԃ
		return "";
	}

	/**
	 * o^̃p[^`FbNs܂<BR>
	 * ȉ̃p[^̃`FbNs܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             XMO_ID                  XMOID
	 *             XMO_NAME                O
	 *             XMO_OUT_LINE            Tv
	 *             XMO_URI                 URI
	 *             XMO_ON_FLG              ғtO
	 *             CLASS_NAME_F            NX
	 *             TREE_VIEW_TIPE          c[r[^Cv
	 *             INI_MENU                j[
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htbParam p[^
	 * @return String G[̓G[ԍ OK̂Ƃ͋󕶎Ԃ܂
	 */
	private String updateCheck( Hashtable htbParam ) {

		String strMessage = "";
		String strCheck = "";

		// XMO_ID̃`FbN
		strCheck = (String)htbParam.get( XMO_ID );
		strMessage = XMSBaseCheck.checkXmoID( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// Õ`FbN
		strCheck = (String)htbParam.get( XMO_NAME );
		strMessage = XMSBaseCheck.checkXmoName( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// Tṽ`FbN
		strCheck = (String)htbParam.get( XMO_OUT_LINE );
		strMessage = XMSBaseCheck.checkXmoOutLine( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// URĨ`FbN
		strCheck = (String)htbParam.get( XMO_URI );
		strMessage = XMSBaseCheck.checkXmoUri( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// ғtÕ`FbN
		strCheck = (String)htbParam.get( XMO_ON_FLG );
		strMessage = XMSBaseCheck.checkXmoOnFlg( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// NX̃`FbN
		strCheck = (String)htbParam.get( CLASS_NAME_F );
		strMessage = XMSBaseCheck.checkClassName( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// c[r[^Cṽ`FbN
		strCheck = (String)htbParam.get( TREE_VIEW_TIPE );
		strMessage = XMSBaseCheck.checkTreeViewType( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// j[̂̃`FbN
		strCheck = (String)htbParam.get( INI_MENU );
		strMessage = XMSBaseCheck.checkIniMenu( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// Dx̃`FbN
		strCheck = (String)htbParam.get( PRIORITY );
		strMessage = XMSBaseCheck.checkPriority( strCheck, false );
		if( !strMessage.equals( "" ) ) {
			return strMessage;
		}

		// 펞͋󕶎Ԃ
		return "";
	}


	/**
	 * w肳ꂽeIDz̏{ʂɕ\ƂĕԂ܂
	 * @param htData p[^i[Hashtable
	 * @return Vector 
	 */
	private Vector selectBaseDisplay( Hashtable htData ) {

		// eID
		String strParentID = null;
		// ^Cv
		int intType = 0;

		// ʕ\NX
		BaseDisplayData[] objDisplayList = null;

		DataAccess objDataAccess = new DataAccess();

		try {
			try {
				// eID擾܂
				strParentID = (String)htData.get(PARENT_ID);
				// ^Cv擾܂
				intType = ((Integer)htData.get(PROCCESS_TYPE)).intValue();
			}
			catch(ClassCastException ce) {
				// G[
				MessageData objMessage = getMessageData(PARAM_WAR);
				throw new XMOException(objMessage);
			}
			// p[^`FbN
			if( strParentID == null ) {
				// G[
				MessageData objMessage = getMessageData(PARAM_WAR);
				throw new XMOException(objMessage);
			}
			// ^Cv`FbN
			if( !(intType == GROUP_TYPE || intType == LO_TYPE) ) {
				// G[
				MessageData objMessage = getMessageData(PARAM_WAR);
				throw new XMOException(objMessage);
			}

			objDataAccess.trans();

			if( intType == GROUP_TYPE ) {
				objDisplayList = pobjDataAccess.getGroupDisplay(strParentID, objDataAccess);
			}
			else {
				objDisplayList = pobjDataAccess.getLoDisplay(strParentID, objDataAccess);
			}

			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			DebugLog.write(this.getClass(), xe, DebugLog.HIGHT);
			Vector vecReturn = new Vector();
			vecReturn.add( xe.getMessage() );
			return vecReturn;
		}
		catch( SQLException se ) {
			try { objDataAccess.rollback(); } catch(Exception te) {}
			DebugLog.write( this.getClass(), se, DebugLog.HIGHT );
			MessageData objMessage = getMessageData( DB_ERR );
			Vector vecErr = new Vector();
			vecErr.add( objMessage );
			return vecErr;
		}

		// ɏIȂ̂ŔẑPԖڂnulli[ĕԂB
		Vector vecReturn = new Vector();
		vecReturn.add(null);
		// QԖڂɕ\zi[B
		vecReturn.add(objDisplayList);
		return vecReturn;
	}



}

