/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	ꊇo^ XMO T[oNX
//			ύX
//				2004.01.08	VK쐬	񞊒q
//
package jp.co.ntt.lms.xmo.LumpInsert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.MenuData;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.XMO;
import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.XMOPropertyDef;
import jp.co.ntt.lms.xmo.Message.MessageClient;
import jp.co.ntt.lms.xmo.util.FileControl;
import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * ꊇo^ XMO T[oNXłB<BR>
 * XMO{\bhANCAg̈ꊇo^
 * vꂼ̏s܂B<BR>
 * RMIT[oƂē삷邽RemoteC^tF[XłXMOC^tF[XA
 * iIȋNԂmۂ邽java.rmi.server.UnicastRemoteObjectNXp܂B
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class LumpInsert extends UnicastRemoteObject
	implements XMO, LumpInsertParam, LumpInsertMessage
{

	//////////////////////////////////////////////////////////////////
	// \bh`
	//////////////////////////////////////////////////////////////////
	/** ꊇo^\bhł */
	private static final String METHOD1 = "insert";	// ꊇo^

	/** Abv[h\bhł */
	private static final String METHOD2 = "upload";	// Abv[h


	/** ꊇo^t@C擾\bhł */
	private static final String METHOD3 = "getFileList";	// Xg擾


	/** [M̂P񂠂̑M擾郁\bh */
	private static final String METHOD4 = "getSendMailCount";
	/**
	 * qlh߂llL[FG[bZ[WB
	 */
	private static final String KEY_ERROR_MESSAGE = "errormessage";

	/**
	 * qlh߂llL[FMB
	 */
	private static final String KEY_SEND_MAIL_COUNT = "sendMailCount";

	/**
	 * RXgN^łB<BR>
	 */
	public LumpInsert() throws RemoteException {
		// [gIuWFNgGNX|[g
		// java.rmi.server.UnicastRemoteObject 
		// Ȃ̃RXgN^Ăяo
		super();
	}

	/**
	 * j[ꗗԂ܂
	 * @return Vector j[ꗗ
	 */
	public Vector getMenuList(Hashtable htbParam) {
		Vector vecMenuList = new Vector();
		try {
			LumpInsertEnv objEnv = LumpInsertEnv.getInstance();
			vecMenuList = objEnv.getMenuList();
		}
		catch( Exception e ) {
			return new Vector();
		}
		return vecMenuList;
	}

	/**
	 * \bhꗗԂ܂
	 * @return Vector
	 */
	public Vector getMethodList() {
		Vector vecMethod = new Vector();
		vecMethod.add( METHOD1 );
		vecMethod.add( METHOD2 );
		vecMethod.add( METHOD3 );
		vecMethod.add( METHOD4 );
		return vecMethod;
	}

	/**
	 * ftHgj[Ԃ܂
	 * @return MenuData
	 */
	public MenuData getDefaultMenu() {
		return null;
	}

	/**
	 * XMOŒ`ꂽA\bh̃NCAg̓ɂȂ郁\bhłB
	 * @param strMethodName s郁\bhw肵܂
	 * @param htData \bhŎsp[^w肵܂<BR>
	 *               ȂKvȃL[ƒl͊eDAȌ\bh̐QƂĉB
	 * @retunr Object ߂li܂܂Ȗ߂lɑΉ邽Object^ƂĂ܂)<BR>
	 *                󂯎葤ł͓K؂ȒlɃLXgKv܂B
	 */
	public Object execute( String strMethodName, Hashtable htData ) {

		Object objReturn = null;

		if( strMethodName.equals( METHOD1 ) ) {
			objReturn = insert( htData );
		}

		if(strMethodName.equals(METHOD2))
		{
			objReturn = uploadLumpFile(htData);
		}

		if(strMethodName.equals(METHOD3))
		{
			objReturn = getLumpFileList();
		}

		else if( strMethodName.equals( METHOD4 ) )
		{
			objReturn = getSendMailCount( htData );
		}
		return objReturn;
	}

	/**
	 * NmFiKtrueԂj
	 * @return boolean KtrueԂ܂
	 */
	public boolean isLaunch() {
		return true;
	}

	/**
	 * ꊇo^s܂B<BR>
	 * @param htData o^
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[ĕԂ܂)
	 */
	private Vector insert( Hashtable htData ) {
		Vector vecReturn = new Vector();

		String strFileName = (String)htData.get( LUMP_FILENAME );
		String strMailFlag = (String)htData.get( MAIL_FLG );
		String strLumpRootGroup = (String)htData.get( LUMP_GROUP_ROOT );
		String strLumpXML = (String)htData.get(LUMP_XML);

		MessageData objMessage = null;

		//ꊇo^[UXg̍쐬
		Vector vctUserList = new Vector();

		// gUNVǗf[^ANZXNX
		DataAccess objDataAccess = new DataAccess();

		try
		{
			// p[^`FbN
			// t@C܂XMLǂ炩͕K{
			if( strFileName == null && strLumpXML == null ) {
				// @LOG >err >1
				DebugLog.write( this.getClass(), "ꊇo^:insert() t@C܂XML͕K{p[^łB", DebugLog.HIGHT );
				throw new XMOException( PARAM_WAR );
			}

			// o^O[vIDw̏ꍇ̓[gw肷B
			if( strLumpRootGroup == null ) {
				strLumpRootGroup = XMOPropertyDef.ROOT_GROUPID;
			}

			// fBNg擾
			LumpInsertEnv objEnv = LumpInsertEnv.getInstance();
			String strDir        = objEnv.getLumpDir();						// LumpFileDisplayFile.jspƓlɂ

			// p[^Ńt@Cw肳Ăꍇ̓t@Cǂݍ
			if( strFileName != null ) {
				// t@CǍ
				File objFile             = new File(strDir + "/" + strFileName);
				FileInputStream objFis   = new FileInputStream(objFile);
				InputStreamReader objIsr = new InputStreamReader(objFis,"Windows-31J");
				BufferedReader objBr      = new BufferedReader(objIsr);

				StringBuffer strBuf      = new StringBuffer();

				while(true)
				{
					String strLine = objBr.readLine();
					if(strLine == null)
					{
						break;
					}
					strBuf.append(strLine);
				}

				objBr.close();
				objIsr.close();
				objFis.close();

				// ꊇo^XML
				strLumpXML = strBuf.toString();
			}
DebugLog.write( this.getClass(), "ꊇo^XMLo::\n " + strLumpXML, DebugLog.ROW );

			// [MtO̔
			boolean blMailFlag = (strMailFlag != null && strMailFlag.equals("true") ? true : false );

			LumpParser objParser = new LumpParser( strLumpRootGroup );
			LumpTree objTree = objParser.parse(strLumpXML, blMailFlag);

			objTree.setUserList( vctUserList );
			// gUNV̊Jn
			objDataAccess.trans();

			objTree.insert(strLumpRootGroup, objDataAccess);

			// R~bg
			objDataAccess.commit();

			// O[v邢̓[U[PłG[Ȃ
			LumpGroupAndPeople objTop = objTree.getTop();
			if(objTop.isFail())
			{
				throw new XMOException(INSERT_WAR);
			}

			// IbZ[W쐬
			objMessage = getMessageData( INSERT_COMPLETE );

		}
		catch(XMOException xe)
		{
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ){}

			DebugLog.write(this.getClass(), xe, DebugLog.HIGHT);
			objMessage = xe.getMessageData();
			if(objMessage == null)
			{
				// bZ[WIuWFNg
				objMessage     = getMessageData(xe.getMsgNum());
			}
		}
		catch( FileNotFoundException nfe ) {
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ){}
			DebugLog.write(this.getClass(), nfe, DebugLog.HIGHT);
			objMessage = getMessageData( FILE_NOT_FOUND_WAR );
		}
		catch( IOException ie ) {
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ){}
			DebugLog.write(this.getClass(), ie, DebugLog.HIGHT);
			objMessage = getMessageData( FILE_ACCESS_ERR );
		}
		catch( SQLException se ) {
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ){}
			// @LOG >err >1
			DebugLog.write(this.getClass(), se, DebugLog.HIGHT);
			// f[^x[XG[X[
			objMessage = getMessageData( DB_ERR );
		}
		catch(Exception e)
		{
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ){}
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			objMessage = getMessageData( SYSTEM_ERR );
		}

		// bZ[Wf[^IuWFNg̍쐬
		vecReturn.add( objMessage );
		vecReturn.add( vctUserList );
		return vecReturn;
	}

	/**
	 * Abv[hs܂B<BR>
	 * @param htData Abv[h
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[ĕԂ܂)
	 */
	private Vector uploadLumpFile(Hashtable htData )
	{
		Vector vecReturn = new Vector();
		MessageData objMessage = null;
		String strFileName = "";
		String strLumpFile = (String)htData.get(LUMP_FILE);
		String strLumpLogin = (String)htData.get(LUMP_LOGIN);
		String strLumpRootGroup = (String)htData.get( LUMP_GROUP_ROOT );

		//	XML̏ꍇ̓G[Ԃ
		if(strLumpFile.equals( "" )) {
			// bZ[WIuWFNg
			objMessage = getMessageData( SAVE_WAR );
			vecReturn.add( objMessage );
			vecReturn.add(strFileName);
			return vecReturn;
		}
		try
		{
			LumpParser objParser = new LumpParser( strLumpRootGroup );
			strFileName = objParser.save(strLumpFile, strLumpLogin);

			// bZ[Wf[^IuWFNg̍쐬
			objMessage = getMessageData( UPLOAD_COMPLETE );
		}
		catch(XMOException xe)
		{
			DebugLog.write(this.getClass(), xe, DebugLog.HIGHT);
			objMessage = xe.getMessageData();
			if(objMessage == null)
			{
				// bZ[WIuWFNg
				objMessage     = getMessageData(xe.getMsgNum());
			}
		}
		catch(Exception e)
		{
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			// VXeG[
			objMessage = getMessageData( SYSTEM_ERR );
		}

		vecReturn.add( objMessage );
		vecReturn.add(strFileName);
		return vecReturn;
	}

	/**
	 * ꊇo^Xg擾s܂B<BR>
	 * @return Vector ʁiz̐擪MessageDataIuWFNgi[ĕԂ܂)
	 */
	private Vector getLumpFileList()
	{
		Vector vecReturn = new Vector();
		MessageData objMessage = null;
		String[] strList = null;
		try
		{
			// wtH_ꊇo^t@Cꗗ擾
			LumpInsertEnv objEnv = LumpInsertEnv.getInstance();
			String strDir        = objEnv.getLumpDir();
			File objFile         = new File(strDir);
			FileControl objFc    = new FileControl();
			strList              = objFc.getFileList(strDir, 1);
		}
		catch(Exception e)
		{
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
			objMessage = getMessageData(FILE_ACCESS_ERR);
		}

		// bZ[Wf[^IuWFNg̍쐬
		objMessage = getMessageData( GETLIST_COMPLETE );
		vecReturn.add( objMessage );
		vecReturn.add(strList);

		return vecReturn;
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			MessageClient objMessageClient = new MessageClient( MSG_FIEL_PATH, MSG_FILE_NAME );
			objMessage = objMessageClient.getMessageData( strMessageID );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}

	/**
	 * [M̂P񂠂̑M擾B
	 * @param htbParam p[^EnbVe[uB
	 * @return M܂̓G[bZ[W܂MapB
	 * ȉ̃L[|l̑gݍ킹̂ꂩ߂B<br>
	 * <table border="1">
	 *	<tr>
	 *		<td>L[</td><td>^</td><td>e</td>
	 *	</tr>
	 *	<tr>
	 *		<td>KEY_ERROR_MESSAGE</td><td>String</td><td>G[bZ[W</td>
	 *	</tr>
	 *	<tr>
	 *		<td>KEY_SEND_MAIL_COUNT</td><td>Integer</td><td>M</td>
	 *	</tr>
	 * </table>
	 * @see #KEY_ERROR_MESSAGE
	 * @see #KEY_SEND_MAIL_COUNT
	 * @see Integer
	 */
	private Map getSendMailCount( Hashtable htbParam ) {
		// ̃\bh̖߂l
		Map returnValue = null;

		// ATCgϐNX 
		LumpInsertEnv objEnv = null;
		// M
		Integer sendMailCount = null;
		String  strSendMailCount = null;
		
		try {
			returnValue = new HashMap();
			// ATCgϐNX擾
			objEnv = LumpInsertEnv.getInstance();
			//ꊇM擾
			strSendMailCount = objEnv.getSendMailCount();
			// l
			sendMailCount = new Integer(strSendMailCount);
			// ߂lɊi[
			returnValue.put(KEY_SEND_MAIL_COUNT, sendMailCount);
		} catch (Exception e) {
			// ÓAbZ[Wi[
			DebugLog.write(this.getClass(), e,DebugLog.HIGHT);
			returnValue.put(KEY_ERROR_MESSAGE, e.getMessage());
		}
		return returnValue;	
	}
}

