//
// \bhǗXMO f[^ANZXNX
//		ύX
//			2005.03.28	VK쐬	 ~ _i
//
package jp.co.ntt.lms.xmo.Method;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.lang.StringEscapeUtils;

import jp.co.ntt.lms.lo.LOException;
import jp.co.ntt.lms.toeic650.common.TOEIC650CommonConst;
import jp.co.ntt.lms.xmo.DataAccess;
import jp.co.ntt.lms.xmo.Environment;
import jp.co.ntt.lms.xmo.MessageData;
import jp.co.ntt.lms.xmo.XMOException;
import jp.co.ntt.lms.xmo.Message.Message;
import jp.co.ntt.lms.xmo.Method.MethodData;
import jp.co.ntt.lms.xmo.util.ChangeEncode;
import jp.co.ntt.lms.xmo.util.DebugLog;


/**
 * \bh ǗXMO f[^ANZXNXłB<BR>
 * ̃NX̓\bhe[uւ̓o^ACA폜As܂B<BR>
 * DataAccessNXgpAo^ACA폜APʂ
 * gUNVǗs܂B
 * @author ~ _i
 * @version 0.0.0.1 2005.03.28
 */
public class MethodDataAccess
	implements MethodTable, MethodMessage
{

	/**
	 * RXgN^łB<BR>
	 */
	public MethodDataAccess() {
	}
	
	/**
	 * \bhe[u֌s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized Vector select( Hashtable htData )
		throws XMOException
	{
		// O[vf[^null̂Ƃ
		if( htData == null ) {
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// s\bh
			vecReturn = selectAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector selectAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		Vector vecReturn = new Vector();

		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			
			// ATCtO("1"Ȃtrue)
			boolean blnAssignFlag = ( htbParam.containsKey( ASSIGNFLAG_KEY ) ) ? ((Boolean)htbParam.get( ASSIGNFLAG_KEY )).booleanValue() : false;
			
			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			if( !blnAssignFlag ) {
				// ʏ팟̏ꍇ
				sbSQL.append( "SELECT * FROM " + TABLE_NAME + " INNER JOIN " + LO_TABLE_NAME + " ON Method.LOID=LO.RealLOID" );
			} else {
				// ATC̏ꍇ
				String strUserID = ( htbParam.containsKey( USERID_KEY ) ) ? (String)htbParam.get( USERID_KEY ) : "";
				if( strUserID.equals( "" ) ) {
					
				}
				int intAssignType = ( htbParam.containsKey( ASSIGNTYPE_KEY ) ) ? ((Integer)htbParam.get( ASSIGNTYPE_KEY )).intValue() : NON_TYPE;
				String strAssignTypeConditon = "";
				switch( intAssignType ) {
				case LEARN_TYPE:	// ɊwKATCt
					strAssignTypeConditon = "AND learn_authority='1' ";
					break;
				case MANAGE_TYPE:	// ɊǗATCt
					strAssignTypeConditon = "AND management_authority='1' ";
					break;
				}
				sbSQL.append( "SELECT * FROM GroupAndPeople INNER JOIN Assignments ON " );
				sbSQL.append( "(GroupAndPeople.memberShipID=Assignments.memberShipID " );
				sbSQL.append( "AND GroupAndPeople.childID='" + StringEscapeUtils.escapeSql(strUserID) + "' AND method_flag='1' " + strAssignTypeConditon );
				sbSQL.append( ") INNER JOIN LoRelation ON (Assignments.materialID=LoRelation.materialID) " );
				sbSQL.append( "INNER JOIN LO ON LoRelation.childID=LO.LOID " );
				sbSQL.append( "INNER JOIN Method ON LO.RealLOID=Method.LOID " );
			}
			
			// ̎擾
			String strCondition = (String)htbParam.get( CONDITION_KEY );
			if( strCondition != null ) {
				sbSQL.append( strCondition );
			}
			String strOrderBy = (String)htbParam.get( ORDER_BY );
			if( strOrderBy != null ) {
				sbSQL.append( strOrderBy );
			} else {
				//SQLServeȑꍇ
				if(objEnv.getDBType().equals( Environment.DB_SQLSERVER )){
					sbSQL.append(" ORDER BY CONVERT(INT,SUBSTRING(LO.LOID, 3, { fn LENGTH(LO.LOID) })) ");
				//Oraclȅꍇ
				}else if(objEnv.getDBType().equals( Environment.DB_ORACLE )){
					sbSQL.append(" ORDER BY TO_NUMBER(SUBSTR(LO.LOID, 3, LENGTH(LO.LOID))) ");
				//PostgreSQL̏ꍇ
				}else if(objEnv.getDBType().equals( Environment.DB_POSTGRE )){
					sbSQL.append(" ORDER BY TO_NUMBER(SUBSTR(LO.LOID, 3, LENGTH(LO.LOID)),'9999999999') ");
				}
			}

			ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
			while(rs.next()) {
				String strLoID = ChangeEncode.setChar( rs.getString( LO_ID ) );
				String strLoType = ChangeEncode.setChar( rs.getString( LO_TYPE ) );
				String strLoTytle = ChangeEncode.setChar( rs.getString( LO_TYTLE ) );
				String strLoExplanation = ChangeEncode.setChar( rs.getString( LO_EXPLANATION ) );
				String strLoVersion = ChangeEncode.setChar( rs.getString( LO_VERSION ) );
				String strRealLOID = ChangeEncode.setChar( rs.getString( REAL_LOID ) );
				String strConclusion = ChangeEncode.setChar( rs.getString( CONCLUSION ) );
			   String strMentorEmailAddress = ChangeEncode.setChar( rs.getString( MENTOR_EMAIL_ADDRESS ) );
				String strDeleteFlag = ChangeEncode.setChar( rs.getString( DELETE_FLAG ) );
				String strForeignID = ChangeEncode.setChar( rs.getString( FOREIGN_ID ) );
				String strKeyWord = ChangeEncode.setChar( rs.getString( KEYWORD ) );
				String strPrere = ChangeEncode.setChar( rs.getString( PRERE ) );
				String strMethodLOID = ChangeEncode.setChar( rs.getString( METHODLOID ));
				String strLOURL = ChangeEncode.setChar( rs.getString( LOURL ));
				boolean blnParallelFlag = (rs.getString( PARALLELFLAG ) != null && rs.getString( PARALLELFLAG ).equals("1") );
				Date dtDateStart;
				try {
					dtDateStart = rs.getDate( STARTDATE );
				} catch( Exception e ) {
					DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
					dtDateStart = null;
				}
				Date dtDateEnd;
				try {
					dtDateEnd = rs.getDate( ENDDATE );
				} catch( Exception e ) {
					DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
					dtDateEnd = null;
				}
				int intPreiodNum;
				try {
					intPreiodNum = Integer.parseInt( rs.getString( PERIODNUM ) );
				} catch( NumberFormatException e ) {
					intPreiodNum = 0;
				}
				boolean blnBeforeLearnFlag = (rs.getString( BEFORELEARNFLAG ) != null && rs.getString( BEFORELEARNFLAG ).equals("1") );
				boolean blnAfterLearnFlag = (rs.getString( AFTERLEARNFLAG ) != null && rs.getString( AFTERLEARNFLAG ).equals("1") );
				MethodData objData = new MethodData();
				objData.setLoID( strLoID );
				objData.setLoType( strLoType );
				objData.setLoTytle( strLoTytle );
				objData.setLoexplanation( strLoExplanation );
				objData.setLoVersion( strLoVersion );
				objData.setRealLOID( strRealLOID );
				objData.setConclusion( strConclusion );
				objData.setDeleteFlag( strDeleteFlag );
				objData.setForeignID( strForeignID );
				objData.setKeyWord( strKeyWord );
				objData.setPrere( strPrere );
				objData.setMentorEmail( strMentorEmailAddress );
				objData.setMethodLOID( strMethodLOID );
				objData.setParallelFlag( blnParallelFlag );
				objData.setDateStart( dtDateStart );
				objData.setDateEnd( dtDateEnd );
				objData.setPeriodNum( intPreiodNum );
				objData.setBeforeLearnFlag( blnBeforeLearnFlag );
				objData.setAfterLearnFlag( blnAfterLearnFlag );
				objData.setLOUrl(strLOURL);
				vecReturn.add( objData );
			}
		}
		catch(Exception ex)
		{

		}
		return vecReturn;

	}
	
	/**
	 * Methode[u֓o^s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * Ȃe[u̎L[ȊOȗꍇ͏ȗtB[hɂ
	 * Nullli[܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             LOID                    LoID
	 *             METHODLOID              \bhLOID
	 *             PARALLELFLAG            z̕я tO
	 *             STARTDATE               Jnt
	 *             ENDDATE                 I\t
	 *             PERIODNUM               
	 *             BEFORELEARNFLAG         vtOwK\tO
	 *             AFTERLEARNFLAG          vtwK\tO
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData o^
	 * @exception LOException f[^x[XG[ꍇ
	 */
	synchronized public void insert( Hashtable htData )
		throws LOException
	{
		// ]f[^null̂Ƃ
		if( htData == null ) {
			// p[^G[X[
			throw new LOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();

			// o^s܂
			insertAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}

		return;
	}

	/**
	 * o^s\bhłB<BR>
	 * ̃e[uɓo^sAGroupAndPeopleǗXMO
	 * ɐeq֌Wo^܂B
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam o^
	 * @exception LOException p[^G[ꍇ
	 * @exception SQLException DBG[ꍇ
	 */
	private void insertAction( Hashtable htbParam, DataAccess objDataAccess )
		throws SQLException, LOException
	{
		String strLoID = (String)htbParam.get( LO_ID );
		if( strLoID != null ) {
			// R[hɑ݂ꍇ͗O𔭐B
			if( objDataAccess.isExit(htbParam, LO_ID, TABLE_NAME) ) {
				throw new LOException( getMessageData( EXIST_RECORD_WAR ) );
			}
		}
		
		// o^p̃f[^Zbg܂
		Hashtable htbData = getData( htbParam );
		// o^pSQL𐶐܂
		String strSQL = objDataAccess.getInsertSQL(htbData);
		// o^s
		objDataAccess.execute( strSQL );
	}
	
	/**
	 * Methode[u֍XVs܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB<BR>
	 * ȗtB[h͍XV܂B
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             LOID                    LoID
	 *             METHODLOID              \bhLOID
	 *             PARALLELFLAG            z̕я tO
	 *             STARTDATE               Jnt
	 *             ENDDATE                 I\t
	 *             PERIODNUM               
	 *             BEFORELEARNFLAG         vtOwK\tO
	 *             AFTERLEARNFLAG          vtwK\tO
	 *             LOURL                   URL
	 *          ---------------------------------------------
	 *             CONDITION_KEY           XV
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData XV
	 * @exception LOException f[^x[XG[ꍇ
	 */
	synchronized public void update( Hashtable htData )
		throws LOException, XMOException
	{
		// f[^null̂Ƃ
		if( htData == null ) {
			// p[^G[X[
			throw new LOException( getMessageData( PARAM_WAR ) );
		}

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {

			// gUNVJn
			objDataAccess.trans();

			// XVs܂
			updateAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}

		return;
	}

	/**
	 * XVs\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam XV
	 * @exception LOException DBG[ꍇ
	 * @exception SQLException DBG[ꍇ
	 */
	private void updateAction( Hashtable htbParam, DataAccess objDataAccess  )
		throws SQLException, LOException, XMOException
	{
		///////////////////////////////////////////////////////
		// XVΏۃR[h̑݃`FbNs܂
		///////////////////////////////////////////////////////
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			if( !objDataAccess.isExit( strCondition ) ) {
				throw new LOException( getMessageData( NOEXIST_RECORD_WAR ) );
			}
		}
		// XV郌R[h擾܂
		Vector vecSelect = selectAction( htbParam, objDataAccess );
		// o^p̃f[^Zbg܂
		Hashtable htbData = getData( htbParam );
		
		String strSQL = objDataAccess.getUpdateSQL(htbData);
		// ̐ݒ
		if( strCondition != null ) {
			strSQL += strCondition;
		}
		
		// o^s
		objDataAccess.execute( strSQL );
	}
	
	/**
	 * Methode[u֍폜s܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 * 	@@@@@@DELETE_LOID             폜ΏۂLOID
	 *          ---------------------------------------------
	 *             CONDITION_KEY           폜
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 폜
	 * @return String (Iꍇ̂)
	 * @exception LOException f[^x[XG[ꍇ
	 */
	synchronized public void delete( Hashtable htData )
		throws LOException
	{
		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans();
			// 폜s\bhs܂
			deleteAction( htData, objDataAccess );
			// R~bg
			objDataAccess.commit();
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new LOException( getMessageData( DB_ERR ) );
		}
		return;
	}

	/**
	 * 폜s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 폜
	 * @exception LOException p[^G[ꍇ
	 * @exception SQLException DBG[ꍇ
	 * MOD 2005/02/25 START
	 */
	synchronized public void deleteAction( Hashtable htbParam, DataAccess objDataAccess )
		throws LOException, SQLException
	{
		///////////////////////////////////////////////////////
		// 폜ΏۃR[h̑݃`FbNs܂
		///////////////////////////////////////////////////////
		String strCondition = (String)htbParam.get( CONDITION_KEY );
		if( strCondition != null ) {
			if( !objDataAccess.isExit( strCondition ) ) {
				throw new LOException( getMessageData( NOEXIST_RECORD_WAR ) );
			}
		}

		// LOLoge[uf[^폜pSQL̑gݗ
		StringBuffer sbSQL = new StringBuffer();
		sbSQL.append( "DELETE FROM " );
		sbSQL.append( TABLE_NAME );
		if (strCondition != null) {
			sbSQL.append( " " );
			sbSQL.append( strCondition );
		}

		// SQLs
		objDataAccess.execute( sbSQL.toString() );
	}
	
	/**
	 * o^AXṼf[^gݗĂ܂
	 * @param htData
	 * @return Hashtable
	 */
	private Hashtable getData( Hashtable htbParam ) {
		Hashtable htbData = new Hashtable();
		putData( htbData, htbParam, LO_ID );
		putData( htbData, htbParam, METHODLOID );
		putData( htbData, htbParam, PARALLELFLAG );
		putData( htbData, htbParam, STARTDATE );
		putData( htbData, htbParam, ENDDATE );
		putData( htbData, htbParam, PERIODNUM );
		putData( htbData, htbParam, BEFORELEARNFLAG );
		putData( htbData, htbParam, AFTERLEARNFLAG );
		putData( htbData, htbParam, LOURL );		
		return htbData;
	}

	/**
	 * SHashtableɒǉ郁\bhł
	 */
	private void putData( Hashtable htbData,  Hashtable htbParam, String strKey ) {
		String strValue = (String)htbParam.get( strKey );
		if( strValue != null ) {
			htbData.put( strKey, strValue );
		}
	}

	/**
	 * bZ[WIuWFNg쐬܂
	 * @param strMessageID bZ[WID
	 * @return MessageData bZ[WIuWFNg OnullԂ܂
	 */
	private MessageData getMessageData( String strMessageID) {
		MessageData objMessage = null;
		try {
			objMessage = Message.getInstance().getMessageData( strMessageID, MSG_FILE_PATH, MSG_FILE_NAME );
		}
		catch( Exception e ) {

		}
		return objMessage;
	}
	
//	ADD 2005/05/16 START Koji Umehara [toeic650]
	/**
	 * JEZXPW[擾܂B<BR>
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             CONDITION_KEY           
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized Vector getCounselSchedule( Hashtable htData )
		throws XMOException
	{
		// O[vf[^null̂Ƃ
		if( htData == null ) {
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// s\bh
			vecReturn = getCounselScheduleAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * JEZXPW[擾s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector getCounselScheduleAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{

		Vector vecReturn = new Vector();

		try{
			//XMS.init@C[hNX̃CX^X
			Environment objEnv=new Environment();
			
			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			String strUserID = ( htbParam.containsKey( USERID_KEY ) ) ? (String)htbParam.get( USERID_KEY ) : "";
			if( strUserID.equals( "" ) ) {
				// [U[IDȂG[
				DebugLog.write( this.getClass(), "[U[ID܂B", DebugLog.HIGHT );
				return vecReturn;
			}
			sbSQL.append( "SELECT * FROM GroupAndPeople INNER JOIN Assignments ON " );
			sbSQL.append( "(GroupAndPeople.memberShipID=Assignments.memberShipID " );
			sbSQL.append( "AND GroupAndPeople.childID='" + StringEscapeUtils.escapeSql(strUserID) + "' AND method_flag='1' AND learn_authority='1' " );
			sbSQL.append( ") INNER JOIN LoRelation ON (Assignments.materialID=LoRelation.materialID) " );
			sbSQL.append( "INNER JOIN LO ON LoRelation.childID=LO.LOID " );
			sbSQL.append( "INNER JOIN Method ON LO.RealLOID=Method.LOID AND KeyWord='" + TOEIC650CommonConst.LO_TYPE_KEY_OnlineCounseling + "' " );
			sbSQL.append( "ORDER BY Method.start_date " );
			
			ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
			while(rs.next()) {
				String strLoID = ChangeEncode.setChar( rs.getString( LO_ID ) );
				String strLoType = ChangeEncode.setChar( rs.getString( LO_TYPE ) );
				String strMethodLOID = ChangeEncode.setChar( rs.getString( METHODLOID ));
				Date dtDateStart = null;
				try {
					dtDateStart = rs.getDate( STARTDATE );
				} catch( Exception e ) {
					DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
				}
				Date dtDateEnd = null;
				try {
					dtDateEnd = rs.getDate( ENDDATE );
				} catch( Exception e ) {
					DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
				}
				Date dtStudyStart = null;
				try {
					dtStudyStart = rs.getTimestamp( OPENING_DATE );
				} catch( Exception e ) {
					DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
				}
				SimpleDateFormat objFormat = new SimpleDateFormat("yyyyNMdHm");
				Date dtStudyEnd = null;
				try {
					dtStudyEnd = rs.getTimestamp( MethodTable.CLOSING_DATE );
				} catch( Exception e ) {
					DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
				}
				Hashtable htData = new Hashtable();
				htData.put(LO_ID, strLoID);
				htData.put(LO_TYPE, strLoType);
				htData.put(METHODLOID, strMethodLOID);
				htData.put(STARTDATE, dtDateStart);
				htData.put(ENDDATE, dtDateEnd);
				htData.put(OPENING_DATE, dtStudyStart);
				htData.put(CLOSING_DATE, dtStudyEnd);

				vecReturn.add( htData );
			}
		}
		catch(Exception ex)
		{
			DebugLog.write( this.getClass(), ex.getMessage(), DebugLog.HIGHT );
		}
		return vecReturn;

	}
	
	/**
	 * w肳ꂽ\bhz̃\bhꗗ擾܂B<BR>
	 * ATCĂ邩ǂ͍l܂B
	 * ȉ̏HashtableɊi[ēnĂB
	 * <PRE>
	 *             key                     
	 *          ---------------------------------------------
	 *             LO_ID                   eLOID
	 *             CONDITION_KEY           
	 *             ORDER_BY                \[g
	 *          ---------------------------------------------
	 * </PRE>
	 * @param htData 
	 * @return String (Iꍇ̂)
	 * @exception XMOException f[^x[XG[ꍇ
	 */
	public synchronized Vector getChildMethodList( Hashtable htData )
		throws XMOException
	{
		// O[vf[^null̂Ƃ
		if( htData == null ) {
			throw new XMOException( getMessageData( PARAM_WAR ) );
		}

		// ߂l
		Vector vecReturn = new Vector();

		// f[^ANZXNXCX^X܂
		DataAccess objDataAccess = new DataAccess(TABLE_NAME);
		try {
			// gUNVJn
			objDataAccess.trans( htData );

			// s\bh
			vecReturn = getChildMethodListAction( htData, objDataAccess );

			// R~bg
			objDataAccess.commit();
		}
		catch( XMOException xe ) {
			DebugLog.write( this.getClass(), xe, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			throw xe;
		}
		catch( SQLException e ) {
			DebugLog.write( this.getClass(), e, DebugLog.HIGHT );
			// [obN
			try { objDataAccess.rollback(); } catch( Exception ex ) {}
			// f[^x[XG[ݒ
			throw new XMOException( getMessageData( DB_ERR ) );
		}

		return vecReturn;
	}

	/**
	 * w肵\bhz̃\bhꗗ擾s\bhłB<BR>
	 * p[^̃`FbNуgUNV̊Ǘ
	 * ʃ\bhōsĂB<BR>
	 * @param htbParam 
	 * @return Vector 
	 * @exception XMOException XMOƎG[
	 * @exception SQLException DBG[ꍇ
	 */
	private Vector getChildMethodListAction( Hashtable htbParam, DataAccess objDataAccess )
		throws XMOException, SQLException
	{
		Vector vecReturn = new Vector();

		try{
			
			// eLOID̎擾
			String strLOID = ( htbParam.containsKey( LO_ID ) ) ? (String)htbParam.get( LO_ID ) : "";
			if( strLOID.equals( "" ) ) {
				// LOIDȂG[
				return vecReturn;
			}
			// SQL̑gݗ
			StringBuffer sbSQL = new StringBuffer();
			sbSQL.append( "SELECT * FROM LORelation " );
			sbSQL.append( "INNER JOIN LO ON LoRelation.parentID='" + StringEscapeUtils.escapeSql(strLOID) + "' AND LoRelation.childID=LO.LOID " );
			sbSQL.append( "INNER JOIN Method ON LO.RealLOID=Method.LOID " );
			
			// ̎擾
			String strCondition = (String)htbParam.get( CONDITION_KEY );
			if( strCondition != null ) {
				sbSQL.append( strCondition );
			}
			String strOrderBy = (String)htbParam.get( ORDER_BY );
			if( strOrderBy != null ) {
				sbSQL.append( strOrderBy );
			} else {
				//XMS.init@C[hNX̃CX^X
				Environment objEnv=new Environment();
				//SQLServeȑꍇ
				if(objEnv.getDBType().equals( Environment.DB_SQLSERVER )){
					sbSQL.append(" ORDER BY CONVERT(INT,SUBSTRING(LO.LOID, 3, { fn LENGTH(LO.LOID) })) ");
				//Oraclȅꍇ
				}else if(objEnv.getDBType().equals( Environment.DB_ORACLE )){
					sbSQL.append(" ORDER BY TO_NUMBER(SUBSTR(LO.LOID, 3, LENGTH(LO.LOID))) ");
				//PostgreSQL̏ꍇ
				}else if(objEnv.getDBType().equals( Environment.DB_POSTGRE )){
					sbSQL.append(" ORDER BY TO_NUMBER(SUBSTR(LO.LOID, 3, LENGTH(LO.LOID)),'9999999999') ");
				}
				objEnv = null;
			}

			// NGs
			ResultSet rs = objDataAccess.executeQuery(sbSQL.toString());
			vecReturn = makeMethodDataFromResultSet(rs);
		}
		catch(Exception ex)
		{
			DebugLog.write( this.getClass(), ex.getMessage(), DebugLog.HIGHT );
		}
		return vecReturn;
	}
	
	/**
	 * UgZbg烁\bhf[^Xg𐶐ăxN^[ŕԂ\bhłB<BR>
	 * @param ResultSet rs UgZbg
	 * @return Vector \bhXg
	 * @throws Exception
	 */
	private Vector makeMethodDataFromResultSet( ResultSet rs ) 
		throws Exception
	{
		Vector vecReturn = new Vector();
		Environment env = new Environment();
		
		while(rs.next()) {
			String strLoID = ChangeEncode.setChar( env, rs.getString( LO_ID ));
			String strLoType = ChangeEncode.setChar( env, rs.getString( LO_TYPE ));
			String strLoTytle = ChangeEncode.setChar( env, rs.getString( LO_TYTLE ) );
			String strLoExplanation = ChangeEncode.setChar( env, rs.getString( LO_EXPLANATION ) );
			String strLoVersion = ChangeEncode.setChar( env, rs.getString( LO_VERSION ) );
			String strRealLOID = ChangeEncode.setChar( env, rs.getString( REAL_LOID ));
			String strConclusion = ChangeEncode.setChar( env, rs.getString( CONCLUSION ) );
			String strMentorEmailAddress = ChangeEncode.setChar( env, rs.getString( MENTOR_EMAIL_ADDRESS ) );
			String strDeleteFlag = ChangeEncode.setChar( env, rs.getString( DELETE_FLAG ));
			String strForeignID = ChangeEncode.setChar( env, rs.getString( FOREIGN_ID ) );
			String strKeyWord = ChangeEncode.setChar( env, rs.getString( KEYWORD ) );
			String strPrere = ChangeEncode.setChar( env, rs.getString( PRERE ) );
			String strMethodLOID = ChangeEncode.setChar( env, rs.getString( METHODLOID ));
			String strLOURL = ChangeEncode.setChar( env, rs.getString( LOURL ));
			boolean blnParallelFlag = (rs.getString( PARALLELFLAG ) != null && rs.getString( PARALLELFLAG ).equals("1") );
			Date dtDateStart;
			try {
				dtDateStart = rs.getDate( STARTDATE );
			} catch( Exception e ) {
				DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
				dtDateStart = null;
			}
			Date dtDateEnd;
			try {
				dtDateEnd = rs.getDate( ENDDATE );
			} catch( Exception e ) {
				DebugLog.write( this.getClass(), e.getMessage(), DebugLog.HIGHT );
				dtDateEnd = null;
			}
			int intPreiodNum;
			try {
				intPreiodNum = Integer.parseInt( rs.getString( PERIODNUM ) );
			} catch( NumberFormatException e ) {
				intPreiodNum = 0;
			}
			boolean blnBeforeLearnFlag = (rs.getString( BEFORELEARNFLAG ) != null && rs.getString( BEFORELEARNFLAG ).equals("1") );
			boolean blnAfterLearnFlag = (rs.getString( AFTERLEARNFLAG ) != null && rs.getString( AFTERLEARNFLAG ).equals("1") );
			MethodData objData = new MethodData();
			objData.setLoID( strLoID );
			objData.setLoType( strLoType );
			objData.setLoTytle( strLoTytle );
			objData.setLoexplanation( strLoExplanation );
			objData.setLoVersion( strLoVersion );
			objData.setRealLOID( strRealLOID );
			objData.setConclusion( strConclusion );
			objData.setDeleteFlag( strDeleteFlag );
			objData.setForeignID( strForeignID );
			objData.setKeyWord( strKeyWord );
			objData.setPrere( strPrere );
			objData.setMentorEmail( strMentorEmailAddress );
			objData.setMethodLOID( strMethodLOID );
			objData.setParallelFlag( blnParallelFlag );
			objData.setDateStart( dtDateStart );
			objData.setDateEnd( dtDateEnd );
			objData.setPeriodNum( intPreiodNum );
			objData.setBeforeLearnFlag( blnBeforeLearnFlag );
			objData.setAfterLearnFlag( blnAfterLearnFlag );
			objData.setLOUrl( strLOURL );
			vecReturn.add( objData );
		}

		return vecReturn;
	}
	
//	ADD 2005/05/16 END Koji Umehara [toeic650]

}
