/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/

//
//	XMO ݒt@C[hNX
//	ύX
//		2004.01.08 VK쐬      񞊒q
//
package jp.co.ntt.lms.xmo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

import jp.co.ntt.lms.xmo.util.DebugLog;

/**
 * XMO ݒt@C[hNXłB<BR>
 * @author T.Nijou
 * @version 0.0.0.1 2004/01/08
 */
public class XMOEnvironment {

	/** vpeBt@Cێ܂ */
	protected Properties objProperty = null;

	// vpeB`
	/** j[^Cg */
	public static final String MENU_TITLE = "menu_title";
	/** j[ACR */
	public static final String MENU_ICON = "menu_icon";
	/** j[URL */
	public static final String MENU_URL = "menu_url";
	/** |bvAbv */
	public static final String POPUP_TYPE = "popup_type";

	/** [ev[gfBNgpX */
	public static final String SEND_MAIL_TEMP_DIR = "send_mail_template_dir";

	/**
	 * RXgN^ł
	 * @exception XMOException
	 */
	protected XMOEnvironment(String strFileName) {
		try {
			init(strFileName);
		} catch (Exception e) {
			DebugLog.write(this.getClass(), "t@C̓ǂݍ݃G[:: " + strFileName, DebugLog.HIGHT);
			DebugLog.write(this.getClass(), e, DebugLog.HIGHT);
		}
	}

	/**
	 * t@Cǂݍ݂܂
	 */
	protected void init(String strFileName) throws Exception {
		// NXPʂ̔rsB
		synchronized (this.getClass()) {
			//	̏sĂȂ̂
			//	t@Cǂݍ
			if (objProperty == null) {
				objProperty = loadProperty(strFileName);
			}
		}
	}

	/**
	 * L[ɃvpeBl擾܂
	 * @param strPropertyName
	 */
	protected String getProperty(String strPropertyName) throws Exception {

		if (objProperty == null) {
			return null;
		}

		String strValue;
		strValue = objProperty.getProperty(strPropertyName);
		if (strValue == null) {
			String errMessage = strPropertyName + " not found.";
			throw new XMOException(errMessage);
		}

		return strValue;

	}

	protected Properties loadProperty(String strFileName) throws Exception {

		Properties objProperty = null;

		//	t@CIuWFNg̎擾
		InputStream objFile = this.getClass().getResourceAsStream(strFileName);
		if (objFile != null) {
			objProperty = new Properties();
			try {
				objProperty.load(objFile);
			} catch (IOException Ex) {
				throw Ex;
			} finally {
				//	t@CN[Y
				try {
					objFile.close();
				} catch (Exception e) {
				}
			}
		}

		return objProperty;
	}

	/**
	 * j[̎擾s܂
	 * @return Vector j[f[^Xg
	 */
	public Vector getMenuList() throws Exception {
		if (objProperty == null) {
			return new Vector();
		}
		Enumeration e = objProperty.propertyNames();
		Vector vecSort = new Vector();
		Hashtable htbMenu = new Hashtable();

		while (e.hasMoreElements()) {
			String strMenu = (String) e.nextElement();
			int intMenuIndex = strMenu.indexOf(MENU_TITLE);
			if (intMenuIndex >= 0) {
				// No擾
				String strNo =
					strMenu.substring(intMenuIndex + MENU_TITLE.length(), strMenu.length());

				Integer objNo = new Integer(strNo);

				String strTitle = objProperty.getProperty(MENU_TITLE + strNo);
				String strIcon = objProperty.getProperty(MENU_ICON + strNo);
				String strURL = objProperty.getProperty(MENU_URL + strNo);
				String strPopupType = objProperty.getProperty(POPUP_TYPE + strNo);
				if (strPopupType == null) {
					strPopupType = "";
				}
				MenuData objData = new MenuData();
				objData.setTitle(strTitle);
				objData.setIcon(strIcon);
				objData.setURL(strURL);
				objData.setPopupType(strPopupType);

				vecSort.add(objNo);
				htbMenu.put(objNo, objData);

			}
		}

		// \[gs
		Collections.sort(vecSort);

		Vector vecMenuList = new Vector();

		for (int i = 0; i < vecSort.size(); i++) {
			vecMenuList.add((MenuData) htbMenu.get(vecSort.get(i)));
		}
		return vecMenuList;
	}
	/**
	 * ݒt@C胁[ev[gfBNgpX擾܂B<BR>
	 * @return strSendMailDir [ev[gfBNgpX
	 */
	public String getSendMailDir() throws Exception {
		String strSendMailDir = getProperty(SEND_MAIL_TEMP_DIR);
		Hashtable htbMacro = new Hashtable();
		htbMacro.put(Environment.SYSTEM_DIR, new Environment().getSystemDir());
		strSendMailDir = Environment.expand(strSendMailDir, htbMacro);
		return strSendMailDir;
	}

// vpeB̖̂擾郁\bhǉB

	/**
	 * ݒt@CɋLڂĂvpeB̂߂܂B<br>
	 * vpeB(String)vfƂSet߂܂B
	 * vpeBPݒ肳ĂȂꍇ́AvfOSet߂܂B
	 * ̃\bh߂SetɕύXE폜sĂA
	 * ̃NX̓ɂ͉e܂B
	 * 
	 * @return ݒt@CɋLڂĂvpeB̂vfƂSetB
	 */
	public final Set getPropertyNames() {
		Set names = null;
		names = new TreeSet();
		if ( objProperty != null ) {
			names.addAll( this.objProperty.keySet() );
		}
		return names;
	}
}
