/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * f[^x[X̏ɂă[Uɓ͊mF߂ANVNXB<br>
 *
 * @author T.Nishiki
 */
public class ConfirmDbInitializeAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(ConfirmDbInitializeAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * XLbv܂Bfalse߂܂B
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return false߂܂B
	 */
	public boolean isSkipped(InstallerValues values) {
		return false;
	}

	/**
	 * f[^x[X̏ɂă[Uɓ͊mF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ConfirmDbInitializeValueIuWFNg߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see ConfirmDbInitializeValue
	 */
	public InstallerActionValue action(InstallerValues values)
			throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");

		// ̓f[^
		ConfirmDbInitializeValue inputValue = null;
		try {
			// ^Cg\
			InstallerUiUtil.outputMessageAsTitle(
				values, "ConfirmDbInitializeAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * Temporaryݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ͂ꂽeConfirmDbInitializeValueƂĖ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ConfirmDbInitializeValue readInputValue(InstallerValues values)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues)");

		ConfirmDbInitializeValue inputValue = null;
		try {
			inputValue = new ConfirmDbInitializeValue();
			// =================================================================
			// f[^x[XmF
			boolean confirmInitialize = InstallerUiUtil.askUserConfirm(
				values, "ConfirmDbInitializeAction.prompt.confirmInitialize" );
			inputValue.setConfirmInitialize(confirmInitialize);
			// =================================================================
			// f[^x[XmFꍇAڑ[U^pX[h
			if (confirmInitialize) {
				// =============================================================
				// f[^x[XǗ҃[U
				String dbaUser = null;
				while (true) {
					dbaUser = InstallerUiUtil.askUserInput(
						values, "ConfirmDbInitializeAction.prompt.dbaUser" );
					// 
					if (InstallerCheckUtil.isEmptyViolation(
							dbaUser, values,
							"ConfirmDbInitializeAction.error.dbaUser.empty")) {
						continue;
					}
					break;
				}
				inputValue.setDbaUser(dbaUser);
				// =============================================================
				// f[^x[XǗ҃[U^pX[h
				String dbaPassword = InstallerUiUtil.askUserInput(
					values, "ConfirmDbInitializeAction.prompt.dbaPassword" );
				inputValue.setDbaPassword(dbaPassword);
				// =============================================================
				// f[^x[XƎ̓
				String[] extendPropertiesNames
					= values.getDbExtendPropetyName();
				Properties extendProperties = new Properties();
				for (int i = 0; i < extendPropertiesNames.length; i++) {
					String extendPropertyName = extendPropertiesNames[i];
					String targetName = values.getMessage(extendPropertyName);
					Object[] messageParams = new Object[] {
						targetName
					};
					String extendPropertyValue
						= InstallerUiUtil.askUserInput(
							values, "db.extend.prompt", messageParams, null);
					extendProperties.setProperty(
						extendPropertyName, extendPropertyValue);
				}
				inputValue.setExtendProperties(extendProperties);
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, ConfirmDbInitializeValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, ConfirmDbInitializeValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"ConfirmDbInitializeAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// f[^x[XmF
			InstallerUiUtil.outputConfirm(values,
				"ConfirmDbInitializeAction.confirm.confirmInitialize",
				InstallerUiUtil.convertBoolToConfirmString(
					inputValue.isConfirmInitialize()));
			// =================================================================
			// f[^x[XmFꍇAڑ[U^pX[h
			if (inputValue.isConfirmInitialize()) {
				// =============================================================
				// f[^x[XǗ҃[U
				InstallerUiUtil.outputConfirm(values,
					"ConfirmDbInitializeAction.confirm.dbaUser",
					inputValue.getDbaUser());
				// =============================================================
				// f[^x[XǗ҃[U^pX[h
				InstallerUiUtil.outputConfirm(values,
					"ConfirmDbInitializeAction.confirm.dbaPassword",
					inputValue.getDbaPassword());
			}
			// =================================================================
			// f[^x[XƎ̓
			Properties extendProperties = inputValue.getExtendProperties();
			Iterator nameIterator = extendProperties.keySet().iterator();
			while (nameIterator.hasNext()) {
				String propertyNameKey = (String)nameIterator.next();
				String propertyValue
					= extendProperties.getProperty(propertyNameKey);
				InstallerUiUtil.outputConfirm(values,
					propertyNameKey, propertyValue);
			}
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "ConfirmDbInitializeAction.confirm" );
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, ConfirmDbInitializeValue)",
			confirm);
		return confirm;
	}
}
