/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;

/**
 * [ݒt@C̏ڂɂē͂߂ANVNXB
 * @author T.Nishiki
 */
public class MailInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(MailInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * XLbvȂ̂false߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return false߂܂B
	 */
	public boolean isSkipped(InstallerValues values) {
		return false;
	}

	/**
	 * [ݒt@C̏ڂɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return MailInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see MailInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");
		// ̓f[^
		MailInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			MailInputValue defaultValue = getDefaultValue(values);
			// ^Cg̕\
			InstallerUiUtil.outputMessageAsTitle(
				values, "MailInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * }l[Wݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeMailInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private MailInputValue readInputValue(
			InstallerValues values, MailInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues," + defaultValue + ")");

		MailInputValue inputValue = null;
		try {
			inputValue = new MailInputValue();
			// =================================================================
			// SMTPzXg
			String smtpHost = InstallerUiUtil.askUserInput(values,
					"MailInputAction.prompt.smtpHost",
					defaultValue.getSmtpHost());
			inputValue.setSmtpHost(smtpHost);
			// =================================================================
			// SMTP|[gԍ
			String smtpPort = InstallerUiUtil.askUserInput(values,
					"MailInputAction.prompt.smtpPort",
					defaultValue.getSmtpPort());
			inputValue.setSmtpPort(smtpPort);
			// =================================================================
			// M[AhX
			String mailFrom = InstallerUiUtil.askUserInput(values,
					"MailInputAction.prompt.mailFrom",
					defaultValue.getMailFrom());
			inputValue.setMailFrom(mailFrom);
			// =================================================================
			// TCgǗ҃[AhX
			String administratorMail = InstallerUiUtil.askUserInput(values,
					"MailInputAction.prompt.siteAdministratorMail",
					defaultValue.getSiteAdministratorMail());
			inputValue.setSiteAdministratorMail(administratorMail);
			// =================================================================
			// TCgǗp[AhX
			String siteMailerMail = InstallerUiUtil.askUserInput(values,
					"MailInputAction.prompt.siteMailerMail",
					defaultValue.getSiteMailerMail());
			inputValue.setSiteMailerMail(siteMailerMail);
			// =================================================================
			// wvfXNp[AhX
			String helpdeskMail = InstallerUiUtil.askUserInput(values,
					"MailInputAction.prompt.helpdeskMail",
					defaultValue.getHelpdeskMail());
			inputValue.setHelpdeskMail(helpdeskMail);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues,MailInputValue)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, MailInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, MailInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"MailInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// SMTPzXg
			InstallerUiUtil.outputConfirm(values,
				"MailInputAction.confirm.smtpHost",
				inputValue.getSmtpHost());
			// SMTP|[gԍ
			InstallerUiUtil.outputConfirm(values,
				"MailInputAction.confirm.smtpPort",
				inputValue.getSmtpPort());
			// M[AhX
			InstallerUiUtil.outputConfirm(values,
				"MailInputAction.confirm.mailFrom",
				inputValue.getMailFrom());
			// TCgǗҗp[AhX
			InstallerUiUtil.outputConfirm(values,
				"MailInputAction.confirm.siteAdministratorMail",
				inputValue.getSiteAdministratorMail());
			// TCgǗ҃[AhX
			InstallerUiUtil.outputConfirm(values,
				"MailInputAction.confirm.siteMailerMail",
				inputValue.getSiteMailerMail());
			// wvfXNE[AhX
			InstallerUiUtil.outputConfirm(values,
				"MailInputAction.confirm.helpdeskMail",
				inputValue.getHelpdeskMail());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "MailInputAction.confirm" );
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, MailInputValue)", confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglMailInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private MailInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		MailInputValue defaultValue = null;
		try {
			defaultValue = new MailInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
						values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			// =================================================================
			// SMTPzXg
			String smtpHost = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								MailInputValue.KEY_SMTP_HOST);
			defaultValue.setSmtpHost(smtpHost);
			// =================================================================
			// SMTP|[gԍ
			String smtpPort = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								MailInputValue.KEY_SMTP_PORT);
			defaultValue.setSmtpPort(smtpPort);
			// =================================================================
			// M[AhX
			String mailFrom = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								MailInputValue.KEY_MAIL_FROM);
			defaultValue.setMailFrom(mailFrom);
			// =================================================================
			// TCgǗҗp[AhX
			String siteAdministratorMail
				= InstallerPropertiesUtil.determineInitialValue(
					existProperties, resourceProperties,
					MailInputValue.KEY_SITE_ADMINISTRATOR_MAIL);
			defaultValue.setSiteAdministratorMail(siteAdministratorMail);
			// =================================================================
			// TCgǗp[AhX
			String siteMailerMail
				= InstallerPropertiesUtil.determineInitialValue(
					existProperties, resourceProperties,
					MailInputValue.KEY_SITE_MAILER_MAIL);
			defaultValue.setSiteMailerMail(siteMailerMail);
			// =================================================================
			// f[^x[XEGR[h
			String helpdeskMail = InstallerPropertiesUtil.determineInitialValue(
								existProperties, resourceProperties,
								MailInputValue.KEY_HELPDESK_MAIL);
			defaultValue.setHelpdeskMail(helpdeskMail);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
