/*
̃t@C̒ǵANTT I[v\[XCZX@o[W 1.0iu{
_vƂj̓Kp󂯂܂B
{_炵ȂÃt@CgpĂ͂Ȃ܂B
{_̃Rs[́Âtqkł܂B
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

{_ɊÂЕz\tgEFÁÂ܂܁Âَ͖
ނ̕ۏ؂ȂŁAЕz܂B{_ɊÂyѐ𗥂
̕ɂẮA{_QƂĂB

uIWiR[hv́A NTT Cyber Space Laboratories Code łB 
uIWiR[hv́uJҁv́A{dMdbЂłB  
{dMdbЂɂn삳ꂽ́ACopyright (C) 2004 
{dMdb łB
SĂ̌ۂ܂B 
uRgr[^vF_____________________________________ 


The contents of this file are subject to the NTT Opensource License
Version 1.0 (the License); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
yzzTCgURLz http://www.oss.ecl.ntt.co.jp/lms/

Software distributed under the License is distributed on an AS IS
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NTT Cyber Space Laboratories Code .

The Initial Developer of the Original Code is NIPPON TELEGRAPH AND 
TELEPHONE CORPORATION.
Portions created by the NIPPON TELEGRAPH AND TELEPHONE CORPORATION 
are Copyright (C) 2004 NIPPON TELEGRAPH AND TELEPHONE CORPORATION. 
All Rights Reserved.

Contributor(s) ______________________________________.
*/
package jp.co.ntt.lms.installer.lms;

import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;

import jp.co.ntt.lms.installer.core.InstallerAction;
import jp.co.ntt.lms.installer.core.InstallerActionValue;
import jp.co.ntt.lms.installer.core.InstallerException;
import jp.co.ntt.lms.installer.core.InstallerValues;
import jp.co.ntt.lms.installer.core.util.InstallerCheckUtil;
import jp.co.ntt.lms.installer.core.util.InstallerPropertiesUtil;
import jp.co.ntt.lms.installer.core.util.InstallerUiUtil;
import jp.co.ntt.lms.installer.util.FileUtil;
import jp.co.ntt.lms.installer.util.LoggerUtil;
import jp.co.ntt.lms.installer.util.StringUtil;

/**
 * SCORMݒt@C̏ڂɂē͂߂ANVNXB
 * @author T.Nishiki
 */
public class ScormInputAction implements InstallerAction {
	/**
	 * Oo̓IuWFNgB
	 */
	private static Logger _logger;

	/**
	 * X^eBbNECjVCUB
	 */
	static {
		_logger = LoggerUtil.getLogger(ScormInputAction.class);
	}

	/**
	 * ANVXLbv邩肵܂B<br>
	 * SelectLoActionł̓͂ɊÂ肵܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return LOIPerceptionIĂȂtrue߂܂B
	 * @throws InstallerException ̌ƂȂ擾ɎsꍇB
	 * @see SelectLoAction
	 */
	public boolean isSkipped(InstallerValues values)
			throws InstallerException {
		LoggerUtil.methodHead(_logger, "isSkipped(InstallerValues)");

		boolean skipped = false;
		try {
			// LOISCORM𖢑IɂĂꂢtrueB
			skipped = (values.getOptionLOSelected(
					ScormInputValue.KEY_LO) == false);
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		LoggerUtil.methodTail(_logger, "isSkipped(InstallerValues)", skipped);
		return skipped;
	}

	/**
	 * ScormT[oݒt@C̏ڂɂḗEmF߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ScormInputValue߂܂B
	 * @throws InstallerException sɗOꍇB
	 * @see ScormInputValue
	 */
	public InstallerActionValue action(InstallerValues values)
		throws InstallerException {

		LoggerUtil.methodHead(_logger, "action(InstallerValues)");

		// ̓f[^
		ScormInputValue inputValue = null;
		try {
			// ̓f[^iftHgf[^ƂĎgpj
			ScormInputValue defaultValue = getDefaultValue(values);
			// ^Cg\
			InstallerUiUtil.outputMessageAsTitle(
				values, "ScormInputAction.welcome");

			while (true) {
				// ͎s
				inputValue = readInputValue(values, defaultValue);
				// ͊mF
				if (confirmInputValue(values, inputValue) == true) {
					// ͊mFς񂾏ꍇAw肳ꂽfBNg
					// 쐬ΏۂƂēo^B
					File dir = new File(inputValue.getMaterialInstallPath());
					values.addMadeDirectory(dir);
					break;
				}
			}
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger, "action(InstallerValues)", inputValue);
		return inputValue;
	}


	/**
	 * }l[Wݒt@C̏ڂɂē͂߂܂B<br>
	 *
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param defaultValue ftHglB
	 * @return ͂ꂽeScormInputValueƂĖ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ScormInputValue readInputValue(
			InstallerValues values, ScormInputValue defaultValue)
			throws InstallerException {
		LoggerUtil.methodHead(_logger,
			"readInputValue(InstallerValues)");

		ScormInputValue inputValue = null;
		try {
			inputValue = new ScormInputValue();
			////////////////////////////////////////////////////////////////////
			// T[oݒ
			// =================================================================
			// =================================================================
			// ftHg̃T[o擾
			String[] defaultServerNames = defaultValue.getServerNames();
			// =================================================================
			// T[o
			int serverNumber = 0;
			do {
				serverNumber = InstallerUiUtil.askUserInputInteger(
						values,	"ScormInputAction.prompt.serverNumber");
			} while (serverNumber <= 0);
			// =================================================================
			// T[o̐
			for (int i = 0; i < serverNumber ; i++) {
				// =============================================================
				// zXg
				String defaultServerName = null;
				if (i < defaultServerNames.length) {
					defaultServerName = defaultServerNames[i];
				}
				String serverName = null;
				while (true) {
					serverName = InstallerUiUtil.askUserInput(values,
							"ScormInputAction.prompt.serverName",
							defaultServerName);
					// 
					if (InstallerCheckUtil.isEmptyViolation(serverName, values,
							"ScormInputAction.error.serverName.empty")) {
						continue;
					}
					break;
				}
				inputValue.addServerName(serverName);
			}
			////////////////////////////////////////////////////////////////////
			// |[gԍ
			String defaultServerPort = defaultValue.getServerPort();
			String serverPort = InstallerUiUtil.askUserInput(values,
					"ScormInputAction.prompt.serverPort",
					defaultServerPort);
			inputValue.setServerPort(serverPort);
			////////////////////////////////////////////////////////////////////
			// AvP[Vx[XURI
			String defaultServerName = defaultValue.getApplicationBaseURI();
			String applicationBaseURI = null;
			while (true) {
				applicationBaseURI = InstallerUiUtil.askUserInput(values,
						"ScormInputAction.prompt.applicationBaseURI",
						defaultServerName);
				// 
				if (InstallerCheckUtil.isEmptyViolation(
						applicationBaseURI, values,
						"ScormInputAction.error.applicationBaseURI.empty")) {
					continue;
				}
				break;
			}
			inputValue.setApplicationBaseURI(applicationBaseURI);
			////////////////////////////////////////////////////////////////////
			// ފi[fBNg
			String materialInstallPath = null;
			while (true) {
				materialInstallPath = InstallerUiUtil.askUserInput(
						values,
						"ScormInputAction.prompt.materialInstallPath",
						defaultValue.getMaterialInstallPath());
				// 
				if (InstallerCheckUtil.isEmptyViolation(
						materialInstallPath, values,
						"ScormInputAction.error.materialInstallPath.empty")) {
					continue;
				}
				// fBNg`FbN
				if (InstallerCheckUtil.isFilePath(
						materialInstallPath, values,
						"ScormInputAction.error.materialInstallPath.file")) {
					continue;
				}
				break;
			}
			inputValue.setMaterialInstallPath(materialInstallPath);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"readInputValue(InstallerValues)", inputValue);
		return inputValue;
	}

	/**
	 * ͂e\A[UɊmF߂܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @param inputValue ͂ꂽe
	 * @return ͂ꂽeɃ[UmFƂꂽꍇtrueA
	 *          ƂȂꍇfalse߂܂B
	 * @throws InstallerException ɃG[ꍇB
	 */
	private boolean confirmInputValue(
			InstallerValues values, ScormInputValue inputValue)
			throws InstallerException {

		LoggerUtil.methodHead(_logger,
			"confirmInputValue(InstallerValues, ScormInputValue)");
		boolean confirm = false;
		try {
			InstallerUiUtil.outputConfirmTitle(values,
				"ScormInputAction.confirm.title");
			// =================================================================
			// ͓e̕\
			// =================================================================
			// SCORMzXg
			String[] serverNames = inputValue.getServerNames();
			for ( int i = 0; i < serverNames.length; i++ ) {
				Object[] messageParams = new Object[] {
					new Integer(i + 1)
				};
				InstallerUiUtil.outputConfirm(values,
					"ScormInputAction.confirm.serverName",
					messageParams,
					serverNames[i]);
			}
			// =================================================================
			// T[o|[gԍ
			InstallerUiUtil.outputConfirm(values,
				"ScormInputAction.confirm.serverPort",
				inputValue.getServerPort());
			// =================================================================
			// AvP[VURI
			InstallerUiUtil.outputConfirm(values,
				"ScormInputAction.confirm.applicationBaseURI",
				inputValue.getApplicationBaseURI());
			// =================================================================
			// ފi[fBNg
			InstallerUiUtil.outputConfirm(values,
				"ScormInputAction.confirm.materialInstallPath",
				inputValue.getMaterialInstallPath());
			// =================================================================
			// [UmF
			confirm = InstallerUiUtil.askUserConfirm(
				values, "ScormInputAction.confirm" );
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}

		LoggerUtil.methodTail(_logger,
			"confirmInputValue(InstallerValues, ScormInputValue)", confirm);
		return confirm;
	}

	/**
	 * ̃f[^A͍ڂ̃ftHgl擾܂B<br>
	 * @param values CXg[ʃf[^EIuWFNgB
	 * @return ftHglScormInputValuě`Ŗ߂܂B
	 * @throws InstallerException sɗOꍇB
	 */
	private ScormInputValue getDefaultValue(InstallerValues values)
			throws InstallerException {
		// \bhJnO
		LoggerUtil.methodHead(_logger,
			"getDefaultValue(InstallerValues)");

		ScormInputValue defaultValue = null;
		try {
			defaultValue = new ScormInputValue();
			////////////////////////////////////////////////////////////////////
			// vpeB̎擾
			// =================================================================
			// ̓e
			File existFile = values.getFileOnSystem(
					defaultValue.getTargetFileKey());
			Properties existProperties
				= FileUtil.loadAsProperties(existFile);
			// =================================================================
			// \[Xi{j̓e
			Properties resourceProperties
				= InstallerPropertiesUtil.load(
					values, defaultValue.getTargetFileKey());
			////////////////////////////////////////////////////////////////////
			// ftHgl̐ݒ
			// =================================================================
			// zXg
			for (int i = 0; true; i++) {
				// ̏擾Aݒ肳ĂȂΏIB
				String existServerName = existProperties.getProperty(
					ScormInputValue.KEY_PREFIX_SERVER_NAME + (i + 1));
				if (StringUtil.isEmpty(existServerName)) {
					break;
				}
				String serverName
					= InstallerPropertiesUtil.determineInitialValue(
						existProperties, resourceProperties,
						ScormInputValue.KEY_PREFIX_SERVER_NAME + (i + 1));
				defaultValue.addServerName(serverName);
			}
			// =================================================================
			// |[gԍƃAvP[VURI
			String startServerUrl
				= InstallerPropertiesUtil.determineInitialValue(
					existProperties, resourceProperties,
					ScormInputValue.KEY_START_SERVER_URL);

			String serverPort = "";
			String applicationBaseURI = "";
			// ốAt@Cƃ\[XɍقƂ̂
			if (StringUtil.isEmpty(startServerUrl) == false) {
				try {
					// vgȐ
					int protocolPos = startServerUrl.indexOf(
						ScormInputValue.START_SERVER_URL_HOST_PART);
					if (protocolPos >= 0) {
						startServerUrl
							= startServerUrl.substring(
							protocolPos
							+ ScormInputValue.START_SERVER_URL_HOST_PART
								.length());
					}
					// pX̒AvP[Vx[XpX𒊏o
					int servletNamePos = startServerUrl.indexOf(
							ScormInputValue.START_SERVER_URL_SERVLET_PART);
					if (servletNamePos >= 0) {
						startServerUrl
							= startServerUrl.substring(
								0, servletNamePos);
					}
					// XbV̈ʒuŃ|[gԍƃAvP[VURI𕪂
					int firstSlashPos = startServerUrl.indexOf("/");
					if (firstSlashPos == 0) {
						applicationBaseURI = startServerUrl;
						serverPort = ScormInputValue.DEFAULT_PORT_HTTP;
					}
					else {
						applicationBaseURI
							= startServerUrl.substring(firstSlashPos);
						serverPort
							= startServerUrl.substring(1, firstSlashPos);
					}
				}
				catch (Exception e) {
					serverPort = "";
					applicationBaseURI = "";
				}
			}
			defaultValue.setServerPort(serverPort);
			defaultValue.setApplicationBaseURI(applicationBaseURI);
			// =================================================================
			// ފi[fBNg
			String materialInstallPath
				= InstallerPropertiesUtil.determineInitialValue(
					existProperties, resourceProperties,
					ScormInputValue.KEY_MATERIAL_INSTALL_PATH);
			defaultValue.setMaterialInstallPath(materialInstallPath);
		}
		catch (InstallerException e) {
			throw e;
		}
		catch (Exception e) {
			LoggerUtil.throwable(_logger, e);
			throw new InstallerException(e);
		}
		// \bhIO
		LoggerUtil.methodTail(_logger,
			"getDefaultValue(InstallerValues)", defaultValue);
		return defaultValue;
	}
}
